/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.communication;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import net.grinder.common.UncheckedInterruptedException;
import net.grinder.communication.ResourcePool;
import net.grinder.util.ListenerSupport;

final class ResourcePoolImplementation
implements ResourcePool {
    private static final int PURGE_FREQUENCY = 1000;
    private final Object m_reservableFreedMutex = new Object();
    private final Object m_reserveAllMutex = new Object();
    private final Object m_reservablesMutex = new Object();
    private List<Reservable> m_reservables = new ArrayList<Reservable>();
    private int m_lastReservable = 0;
    private int m_nextPurge = 0;
    private final ListenerSupport<ResourcePool.Listener> m_listeners = new ListenerSupport();

    public ResourcePoolImplementation() {
        this.m_reservables.add(new Sentinel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResourcePool.Closeable add(final ResourcePool.Resource resource) {
        ResourceWrapper resourceWrapper = new ResourceWrapper(resource);
        Object object = this.m_reservablesMutex;
        synchronized (object) {
            this.m_reservables.add(resourceWrapper);
        }
        this.m_listeners.apply(new ListenerSupport.Informer<ResourcePool.Listener>(){

            @Override
            public void inform(ResourcePool.Listener l) {
                l.resourceAdded(resource);
            }
        });
        return resourceWrapper;
    }

    @Override
    public ResourcePool.Reservation reserveNext() {
        Object object = this.m_reservablesMutex;
        synchronized (object) {
            Reservable reservable;
            this.purgeZombieResources();
            do {
                if (++this.m_lastReservable < this.m_reservables.size()) continue;
                this.m_lastReservable = 0;
            } while (!(reservable = this.m_reservables.get(this.m_lastReservable)).reserve());
            return reservable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Reservable> reserveAll() {
        Object object = this.m_reserveAllMutex;
        synchronized (object) {
            ArrayList<Reservable> reserveList;
            ArrayList<Reservable> result;
            Object object2 = this.m_reservablesMutex;
            synchronized (object2) {
                this.purgeZombieResources();
                result = new ArrayList<Reservable>(this.m_reservables.size());
                reserveList = new ArrayList<Reservable>(this.m_reservables);
            }
            while (reserveList.size() > 0) {
                ListIterator iterator = reserveList.listIterator(reserveList.size());
                while (iterator.hasPrevious()) {
                    Reservable reservable = (Reservable)iterator.previous();
                    if (reservable.isSentinel()) {
                        iterator.remove();
                        continue;
                    }
                    if (reservable.reserve()) {
                        result.add(reservable);
                        iterator.remove();
                        continue;
                    }
                    if (!reservable.isClosed()) continue;
                    iterator.remove();
                }
                if (reserveList.size() <= 0) continue;
                Object object3 = this.m_reservableFreedMutex;
                synchronized (object3) {
                    try {
                        this.m_reservableFreedMutex.wait(1000L);
                    }
                    catch (InterruptedException e) {
                        throw new UncheckedInterruptedException(e);
                    }
                }
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeCurrentResources() {
        Reservable[] reservablesClone;
        Object object = this.m_reservablesMutex;
        synchronized (object) {
            reservablesClone = this.m_reservables.toArray(new Reservable[this.m_reservables.size()]);
        }
        for (int i = 0; i < reservablesClone.length; ++i) {
            reservablesClone[i].close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int countActive() {
        int result = 0;
        Object object = this.m_reservablesMutex;
        synchronized (object) {
            for (Reservable reservable : this.m_reservables) {
                if (reservable.isClosed() || reservable.isSentinel()) continue;
                ++result;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgeZombieResources() {
        Object object = this.m_reservablesMutex;
        synchronized (object) {
            if (++this.m_nextPurge > 1000) {
                this.m_nextPurge = 0;
                ArrayList<Reservable> newReservables = new ArrayList<Reservable>(this.m_reservables.size());
                for (Reservable reservable : this.m_reservables) {
                    if (reservable.isClosed()) continue;
                    newReservables.add(reservable);
                }
                this.m_reservables = newReservables;
                this.m_lastReservable = 0;
            }
        }
    }

    @Override
    public void addListener(ResourcePool.Listener listener) {
        this.m_listeners.add(listener);
    }

    private final class ResourceWrapper
    implements Reservable {
        private final ResourcePool.Resource m_resource;
        private boolean m_busy = false;
        private boolean m_closed;

        public ResourceWrapper(ResourcePool.Resource resource) {
            this.m_resource = resource;
        }

        @Override
        public boolean isSentinel() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean reserve() {
            ResourceWrapper resourceWrapper = this;
            synchronized (resourceWrapper) {
                if (this.m_busy || this.m_closed) {
                    return false;
                }
                this.m_busy = true;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void free() {
            boolean stateChanged;
            Object object = this;
            synchronized (object) {
                stateChanged = this.m_busy;
                this.m_busy = false;
            }
            if (stateChanged) {
                object = ResourcePoolImplementation.this.m_reservableFreedMutex;
                synchronized (object) {
                    ResourcePoolImplementation.this.m_reservableFreedMutex.notifyAll();
                }
            }
        }

        @Override
        public ResourcePool.Resource getResource() {
            return this.m_resource;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            boolean stateChanged;
            Object object = this;
            synchronized (object) {
                boolean bl = stateChanged = !this.m_closed;
                if (stateChanged) {
                    this.m_busy = false;
                    this.m_closed = true;
                    this.m_resource.close();
                }
            }
            if (stateChanged) {
                ListenerSupport.Informer<ResourcePool.Listener> informer;
                object = ResourcePoolImplementation.this.m_reservableFreedMutex;
                synchronized (object) {
                    ResourcePoolImplementation.this.m_reservableFreedMutex.notifyAll();
                }
                try {
                    informer = new ListenerSupport.Informer<ResourcePool.Listener>(){

                        @Override
                        public void inform(ResourcePool.Listener l) {
                            l.resourceClosed(ResourceWrapper.this.m_resource);
                        }
                    };
                }
                catch (Exception e) {
                    try {
                        throw e;
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (InterruptedException interruptedException) {
                        throw new UncheckedInterruptedException(interruptedException);
                    }
                    catch (Exception exception) {
                        throw new AssertionError((Object)exception);
                    }
                }
                ResourcePoolImplementation.this.m_listeners.apply(informer);
            }
        }

        @Override
        public synchronized boolean isClosed() {
            return this.m_closed;
        }
    }

    private static final class Sentinel
    implements Reservable {
        private Sentinel() {
        }

        @Override
        public boolean isSentinel() {
            return true;
        }

        @Override
        public boolean reserve() {
            return true;
        }

        @Override
        public ResourcePool.Resource getResource() {
            return null;
        }

        @Override
        public void free() {
        }

        @Override
        public void close() {
        }

        @Override
        public boolean isClosed() {
            return false;
        }
    }

    private static interface Reservable
    extends ResourcePool.Reservation {
        public boolean reserve();
    }
}

