/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.communication;

import net.grinder.communication.CommunicationException;
import net.grinder.communication.Message;
import net.grinder.communication.MessageQueue;
import net.grinder.communication.QueuedSender;
import net.grinder.communication.Sender;

public final class QueuedSenderDecorator
implements QueuedSender {
    private final Sender m_delegate;
    private final MessageQueue m_messageQueue = new MessageQueue(false);

    public QueuedSenderDecorator(Sender delegate) {
        this.m_delegate = delegate;
    }

    @Override
    public void send(Message message) throws CommunicationException {
        this.m_messageQueue.queue(message);
    }

    @Override
    public void flush() throws CommunicationException {
        for (Message message : this.m_messageQueue.drainMessages()) {
            this.m_delegate.send(message);
        }
    }

    @Override
    public void shutdown() {
        this.m_messageQueue.shutdown();
        this.m_delegate.shutdown();
    }
}

