/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.communication;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import net.grinder.common.UncheckedInterruptedException;
import net.grinder.communication.CommunicationException;
import net.grinder.communication.Message;

final class MessageQueue {
    private final BlockingQueue<Serializable> m_queue = new LinkedBlockingQueue<Serializable>();
    private final boolean m_passExceptions;
    private volatile boolean m_shutdown;
    private static final Serializable SHUTDOWN_MESSAGE = new Serializable(){};

    public MessageQueue(boolean passExceptions) {
        this.m_passExceptions = passExceptions;
    }

    public void queue(Message message) throws ShutdownException {
        this.checkIfShutdown();
        this.m_queue.add(message);
    }

    public void queue(Exception exception) throws ShutdownException {
        if (!this.m_passExceptions) {
            throw new AssertionError((Object)"This MessageQueue does not allow Exceptions to be queued");
        }
        this.checkIfShutdown();
        this.m_queue.add(exception);
    }

    public Message dequeue(boolean block) throws CommunicationException {
        Serializable result;
        this.checkIfShutdown();
        if (block) {
            try {
                result = this.m_queue.take();
            }
            catch (InterruptedException e) {
                throw new UncheckedInterruptedException(e);
            }
        } else {
            result = (Serializable)this.m_queue.poll();
        }
        if (result == SHUTDOWN_MESSAGE) {
            this.shutdown();
            this.checkIfShutdown();
        }
        if (this.m_passExceptions && result instanceof Exception) {
            Exception e = (Exception)result;
            throw new CommunicationException(e.getMessage(), e);
        }
        return (Message)result;
    }

    public void shutdown() {
        this.m_shutdown = true;
        this.m_queue.clear();
        this.m_queue.offer(SHUTDOWN_MESSAGE);
    }

    public void checkIfShutdown() throws ShutdownException {
        if (this.m_shutdown) {
            throw new ShutdownException("ThreadSafeQueue shutdown");
        }
    }

    public List<Message> drainMessages() throws ShutdownException {
        this.checkIfShutdown();
        ArrayList contents = new ArrayList(this.m_queue.size());
        this.m_queue.drainTo(contents);
        ArrayList<Message> result = new ArrayList<Message>(contents.size());
        for (Serializable c : contents) {
            if (c == SHUTDOWN_MESSAGE) {
                this.shutdown();
                this.checkIfShutdown();
            }
            if (!(c instanceof Message)) continue;
            result.add((Message)c);
        }
        return result;
    }

    public static final class ShutdownException
    extends CommunicationException {
        ShutdownException(String s) {
            super(s);
        }
    }
}

