/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.communication;

import java.util.concurrent.ExecutorService;
import net.grinder.communication.CommunicationException;
import net.grinder.communication.Message;
import net.grinder.communication.Receiver;
import net.grinder.communication.Sender;
import net.grinder.util.thread.ExecutorFactory;
import net.grinder.util.thread.InterruptibleRunnable;
import net.grinder.util.thread.InterruptibleRunnableAdapter;

public final class MessagePump {
    private final ExecutorService m_executor;
    private final Receiver m_receiver;
    private final Sender m_sender;
    private final int m_numberOfThreads;
    private volatile boolean m_shutdownTriggered = false;

    public MessagePump(Receiver receiver, Sender sender, int numberOfThreads) {
        this.m_receiver = receiver;
        this.m_sender = sender;
        this.m_numberOfThreads = numberOfThreads;
        this.m_executor = ExecutorFactory.createThreadPool("Message pump", numberOfThreads);
    }

    public void start() {
        for (int i = 0; i < this.m_numberOfThreads; ++i) {
            this.m_executor.submit(new InterruptibleRunnableAdapter(new MessagePumpRunnable()));
        }
    }

    public void shutdown() {
        if (!this.m_shutdownTriggered) {
            this.m_shutdownTriggered = true;
            this.m_receiver.shutdown();
            this.m_sender.shutdown();
            this.m_executor.shutdownNow();
        }
    }

    private class MessagePumpRunnable
    implements InterruptibleRunnable {
        private MessagePumpRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void interruptibleRun() {
            try {
                while (!MessagePump.this.m_executor.isShutdown()) {
                    Message message = MessagePump.this.m_receiver.waitForMessage();
                    if (message == null) {
                        MessagePump.this.shutdown();
                        continue;
                    }
                    MessagePump.this.m_sender.send(message);
                }
            }
            catch (CommunicationException communicationException) {
            }
            finally {
                MessagePump.this.shutdown();
            }
        }
    }
}

