/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.communication;

import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import net.grinder.communication.CommunicationException;
import net.grinder.communication.SocketWrapper;
import net.grinder.util.TimeAuthority;

final class IdleAwareSocketWrapper
extends SocketWrapper {
    private final TimeAuthority m_timeAuthority;
    private long m_idleStart;

    public IdleAwareSocketWrapper(Socket socket, TimeAuthority timeAuthority) throws CommunicationException {
        super(socket);
        this.m_timeAuthority = timeAuthority;
        this.m_idleStart = -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasData(long inactiveClientTimeOut) throws IOException {
        InputStream inputStream;
        if (this.isClosed()) {
            throw new IOException("Socket is closed");
        }
        InputStream inputStream2 = inputStream = this.getInputStream();
        synchronized (inputStream2) {
            if (inputStream.available() > 0) {
                this.m_idleStart = -1L;
                return true;
            }
            long now = this.m_timeAuthority.getTimeInMilliseconds();
            if (this.m_idleStart == -1L) {
                this.m_idleStart = now;
            } else if (this.m_idleStart + inactiveClientTimeOut < now) {
                this.close();
            }
            return false;
        }
    }
}

