/*
 * Decompiled with CFR 0.152.
 */
package net.grinder;

import net.grinder.common.GrinderException;
import net.grinder.console.ConsoleFoundation;
import net.grinder.console.common.Resources;
import net.grinder.console.common.ResourcesImplementation;
import net.grinder.util.AbstractMainClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Console
extends AbstractMainClass {
    private static final String USAGE = "  java " + Console.class.getName() + " [-headless]" + "\n" + "\n  -headless                    Don't use a graphical user interface.";
    private final ConsoleFoundation m_consoleFoundation;

    private Console(String[] args, Resources resources, Logger logger) throws GrinderException {
        super(logger, USAGE);
        boolean headless = false;
        for (int i = 0; i < args.length; ++i) {
            if (!"-headless".equalsIgnoreCase(args[i])) {
                throw this.barfUsage();
            }
            headless = true;
        }
        this.m_consoleFoundation = new ConsoleFoundation(resources, logger, headless);
    }

    private void run() {
        this.m_consoleFoundation.run();
    }

    public static void main(String[] args) {
        ResourcesImplementation resources = new ResourcesImplementation("net.grinder.console.common.resources.Console");
        Logger logger = LoggerFactory.getLogger((String)resources.getString("shortTitle"));
        try {
            Console console = new Console(args, resources, logger);
            console.run();
        }
        catch (AbstractMainClass.LoggedInitialisationException e) {
            System.exit(1);
        }
        catch (GrinderException e) {
            logger.error("Could not initialise", (Throwable)e);
            System.exit(2);
        }
        System.exit(0);
    }
}

