/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.console.swingui;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.swing.SwingUtilities;
import net.grinder.console.common.ErrorHandler;
import net.grinder.console.swingui.SwingDispatcherFactory;

final class SwingDispatcherFactoryImplementation
implements SwingDispatcherFactory {
    private final ErrorHandler m_errorHandler;

    public SwingDispatcherFactoryImplementation(ErrorHandler errorHandler) {
        this.m_errorHandler = errorHandler;
    }

    @Override
    public <T> T create(Class<T> clazz, final T delegate) {
        InvocationHandler invocationHandler = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, final Method method, final Object[] args) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            method.invoke(delegate, args);
                        }
                        catch (InvocationTargetException e) {
                            SwingDispatcherFactoryImplementation.this.m_errorHandler.handleException(e.getCause());
                        }
                        catch (IllegalArgumentException e) {
                            throw new AssertionError((Object)e);
                        }
                        catch (IllegalAccessException e) {
                            throw new AssertionError((Object)e);
                        }
                    }
                });
                return null;
            }
        };
        Class<?> delegateClass = delegate.getClass();
        return (T)Proxy.newProxyInstance(delegateClass.getClassLoader(), new Class[]{clazz}, invocationHandler);
    }
}

