/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.console.swingui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class JOptionPaneDialog
extends JDialog {
    public JOptionPaneDialog(JFrame frame, String title, boolean modal, JOptionPane optionPane) {
        super(frame, title, modal);
        this.setOptionPane(optionPane);
    }

    public JOptionPaneDialog(JDialog dialog, String title, boolean modal, JOptionPane optionPane) {
        super(dialog, title, modal);
        this.setOptionPane(optionPane);
    }

    private void setOptionPane(final JOptionPane optionPane) {
        this.setDefaultCloseOperation(0);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)optionPane, "Center");
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
        this.addWindowListener(new WindowAdapter(){
            private boolean m_gotFocus = false;

            @Override
            public void windowClosing(WindowEvent e) {
                optionPane.setValue(null);
            }

            @Override
            public void windowActivated(WindowEvent e) {
                if (!this.m_gotFocus) {
                    optionPane.selectInitialValue();
                    this.m_gotFocus = true;
                }
            }
        });
        optionPane.addPropertyChangeListener(new PropertyChangeListener(){
            private boolean m_disable = false;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (JOptionPaneDialog.this.isVisible() && e.getSource() == optionPane && !this.m_disable && (e.getPropertyName().equals("value") || e.getPropertyName().equals("inputValue"))) {
                    Cursor oldCursor = JOptionPaneDialog.this.getCursor();
                    JOptionPaneDialog.this.setCursor(Cursor.getPredefinedCursor(3));
                    try {
                        if (JOptionPaneDialog.this.shouldClose()) {
                            JOptionPaneDialog.this.setVisible(false);
                            JOptionPaneDialog.this.dispose();
                        }
                    }
                    finally {
                        this.m_disable = true;
                        optionPane.setValue(null);
                        this.m_disable = false;
                        JOptionPaneDialog.this.setCursor(oldCursor);
                    }
                }
            }
        });
        optionPane.setValue(null);
    }

    protected boolean shouldClose() {
        return true;
    }
}

