/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.console.swingui;

import java.awt.Toolkit;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

class IntegerField
extends JTextField {
    private static final Toolkit s_toolkit = Toolkit.getDefaultToolkit();
    private static final double s_log10 = Math.log(10.0);
    private final int m_minimumValue;
    private final int m_maximumValue;

    private static int log10(long x) {
        return (int)(Math.log(x) / s_log10 + 1.0E-10);
    }

    private static int maxFieldWidth(int minimumValue, int maximumValue) {
        long min = minimumValue < 0 ? (long)(10 * -minimumValue) : (long)minimumValue;
        long max = maximumValue < 0 ? (long)(10 * -maximumValue) : (long)maximumValue;
        return IntegerField.log10(Math.max(Math.abs(min), Math.abs(max))) + 1;
    }

    public IntegerField(int minimumValue, int maximumValue) {
        super(IntegerField.maxFieldWidth(minimumValue, maximumValue));
        if (minimumValue > maximumValue) {
            throw new IllegalArgumentException("Minimum value exceeds maximum value");
        }
        this.m_minimumValue = minimumValue;
        this.m_maximumValue = maximumValue;
        this.setValue(this.m_minimumValue);
        this.setDocument(new FormattedDocument());
    }

    public int getValue() {
        try {
            return Integer.parseInt(this.getText());
        }
        catch (NumberFormatException e) {
            return this.m_minimumValue;
        }
    }

    public void setValue(int value) {
        if (value < this.m_minimumValue || value > this.m_maximumValue) {
            throw new IllegalArgumentException("Value out of bounds");
        }
        this.setText(Integer.toString(value));
    }

    public void addChangeListener(final ChangeListener listener) {
        this.getDocument().addDocumentListener(new DocumentListener(){

            private void notifyChangeListener() {
                listener.stateChanged(new ChangeEvent(this));
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.notifyChangeListener();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.notifyChangeListener();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.notifyChangeListener();
            }
        });
    }

    public class FormattedDocument
    extends PlainDocument {
        @Override
        public void insertString(int offset, String string, AttributeSet attributeSet) throws BadLocationException {
            String currentText = super.getText(0, this.getLength());
            String result = currentText.substring(0, offset) + string + currentText.substring(offset);
            if (IntegerField.this.m_minimumValue >= 0 || !"-".equals(result)) {
                try {
                    int x = Integer.parseInt(result);
                    if (x < IntegerField.this.m_minimumValue || x > IntegerField.this.m_maximumValue) {
                        s_toolkit.beep();
                        return;
                    }
                }
                catch (NumberFormatException e) {
                    s_toolkit.beep();
                    return;
                }
            }
            super.insertString(offset, string, attributeSet);
        }
    }
}

