/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.console.swingui;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.SystemColor;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import net.grinder.console.common.ConsoleException;
import net.grinder.console.common.Resources;
import net.grinder.console.editor.Buffer;
import net.grinder.console.editor.EditorModel;

class EditorControls {
    private final JPanel m_panel;

    public EditorControls(final Resources resources, final EditorModel editorModel, Font labelFont, JToolBar editorToolBar) throws ConsoleException {
        editorToolBar.setFloatable(false);
        editorToolBar.setAlignmentX(0.0f);
        final Font noFileTitleFont = labelFont;
        final Font unmodifiedFileTitleFont = noFileTitleFont.deriveFont(1);
        final Font modifiedFileTitleFont = noFileTitleFont.deriveFont(3);
        final JLabel label = new JLabel();
        label.setForeground(SystemColor.textHighlight);
        editorModel.addListener((EditorModel.Listener)new EditorModel.AbstractListener(){

            public void bufferStateChanged(Buffer buffer) {
                Buffer selectedBuffer = editorModel.getSelectedBuffer();
                if (selectedBuffer == null) {
                    label.setText(resources.getString("editor.title"));
                    label.setFont(noFileTitleFont);
                } else if (buffer.equals(selectedBuffer)) {
                    label.setText(buffer.getDisplayName());
                    label.setFont(buffer.isDirty() ? modifiedFileTitleFont : unmodifiedFileTitleFont);
                }
            }
        });
        this.m_panel = new JPanel(){

            @Override
            public Dimension getPreferredSize() {
                Dimension mySize = super.getPreferredSize();
                Dimension parentSize = this.getParent().getSize();
                mySize.width = parentSize.width - 4;
                return mySize;
            }
        };
        this.m_panel.setLayout(new BoxLayout(this.m_panel, 0));
        this.m_panel.add(editorToolBar);
        this.m_panel.add(Box.createHorizontalGlue());
        this.m_panel.add(label);
        this.m_panel.setBorder(BorderFactory.createEmptyBorder());
    }

    public JComponent getComponent() {
        return this.m_panel;
    }
}

