/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.console.swingui;

import java.awt.Color;
import java.io.IOException;
import java.io.Writer;
import java.util.Set;
import javax.swing.table.AbstractTableModel;
import net.grinder.common.Test;
import net.grinder.console.common.Resources;
import net.grinder.console.model.ModelTestIndex;
import net.grinder.console.model.SampleModel;
import net.grinder.console.model.SampleModelViews;
import net.grinder.console.swingui.Colours;
import net.grinder.console.swingui.SwingDispatcherFactory;
import net.grinder.console.swingui.Table;
import net.grinder.statistics.ExpressionView;
import net.grinder.statistics.StatisticExpression;
import net.grinder.statistics.StatisticsSet;
import net.grinder.statistics.StatisticsView;

abstract class DynamicStatisticsTableModel
extends AbstractTableModel
implements SampleModel.Listener,
Table.TableModel,
SampleModelViews.Listener {
    private final SampleModel m_model;
    private final SampleModelViews m_modelViews;
    private final Resources m_resources;
    private final String m_testString;
    private final String m_testColumnString;
    private final String m_testDescriptionColumnString;
    private ModelTestIndex m_lastModelTestIndex;
    private StatisticsView m_statisticsView;
    private ExpressionView[] m_columnViews;
    private String[] m_columnLabels;

    protected DynamicStatisticsTableModel(SampleModel model, SampleModelViews modelViews, Resources resources, SwingDispatcherFactory swingDispatcherFactory) {
        this.m_model = model;
        this.m_modelViews = modelViews;
        this.m_resources = resources;
        this.m_testString = this.m_resources.getString("table.test.label") + ' ';
        this.m_testColumnString = this.m_resources.getString("table.testColumn.label");
        this.m_testDescriptionColumnString = this.m_resources.getString("table.descriptionColumn.label");
        this.m_model.addModelListener((SampleModel.Listener)swingDispatcherFactory.create(SampleModel.Listener.class, this));
        this.m_modelViews.addListener((SampleModelViews.Listener)swingDispatcherFactory.create(SampleModelViews.Listener.class, this));
        this.resetTests();
    }

    protected abstract StatisticsSet getStatistics(int var1);

    protected final SampleModel getModel() {
        return this.m_model;
    }

    protected final SampleModelViews getModelViews() {
        return this.m_modelViews;
    }

    protected final synchronized ModelTestIndex getLastModelTestIndex() {
        return this.m_lastModelTestIndex;
    }

    public synchronized void addColumns(StatisticsView statisticsView) {
        this.m_statisticsView.add(statisticsView);
        int originalNumberOfColumns = this.m_columnViews.length;
        ExpressionView[] newViews = this.m_statisticsView.getExpressionViews();
        if (newViews.length != originalNumberOfColumns) {
            this.m_columnViews = newViews;
            this.m_columnLabels = new String[this.m_columnViews.length];
            for (int i = 0; i < this.m_columnLabels.length; ++i) {
                String resource = this.m_resources.getString("statistic." + this.m_columnViews[i].getDisplayName().replaceAll("\\s+", "_"), false);
                this.m_columnLabels[i] = resource != null ? resource : this.m_columnViews[i].getDisplayName();
            }
            this.fireTableStructureChanged();
        }
    }

    public void newStatisticExpression(ExpressionView statisticExpression) {
        StatisticsView statisticsView = new StatisticsView();
        statisticsView.add(statisticExpression);
        this.addColumns(statisticsView);
    }

    public final void stateChanged() {
        this.fireTableRowsUpdated(0, this.getRowCount());
    }

    public final synchronized void newSample() {
        this.fireTableRowsUpdated(0, this.getRowCount());
    }

    public final synchronized void newTests(Set<Test> newTests, ModelTestIndex modelTestIndex) {
        this.m_lastModelTestIndex = modelTestIndex;
        this.fireTableDataChanged();
    }

    public final synchronized void resetTests() {
        this.m_lastModelTestIndex = new ModelTestIndex();
    }

    public synchronized void resetStatisticsViews() {
        this.m_statisticsView = new StatisticsView();
        this.m_columnViews = new ExpressionView[0];
        this.m_columnLabels = new String[0];
    }

    @Override
    public final synchronized int getColumnCount() {
        return 2 + this.m_columnLabels.length;
    }

    @Override
    public final synchronized String getColumnName(int column) {
        switch (column) {
            case 0: {
                return this.m_testColumnString;
            }
            case 1: {
                return this.m_testDescriptionColumnString;
            }
        }
        return this.m_columnLabels[column - 2];
    }

    @Override
    public synchronized int getRowCount() {
        return this.m_lastModelTestIndex.getNumberOfTests();
    }

    @Override
    public synchronized Object getValueAt(int row, int column) {
        if (column == 0) {
            return this.m_testString + this.m_lastModelTestIndex.getTest(row).getNumber();
        }
        if (column == 1) {
            return this.m_lastModelTestIndex.getTest(row).getDescription();
        }
        return this.getDynamicField(this.getStatistics(row), column - 2);
    }

    protected synchronized String getDynamicField(StatisticsSet statistics, int dynamicColumn) {
        if (dynamicColumn < this.m_columnViews.length) {
            StatisticExpression expression = this.m_columnViews[dynamicColumn].getExpression();
            if (expression.isDouble()) {
                double value = expression.getDoubleValue(statistics);
                if (Double.isNaN(value)) {
                    return "";
                }
                return this.getModelViews().getNumberFormat().format(value);
            }
            return String.valueOf(expression.getLongValue(statistics));
        }
        return "?";
    }

    @Override
    public boolean isBold(int row, int column) {
        return column == 3 && this.getModelViews().getTestStatisticsQueries().getNumberOfErrors(this.getStatistics(row)) > 0L;
    }

    @Override
    public Color getForeground(int row, int column) {
        return this.isBold(row, column) ? Colours.RED : null;
    }

    @Override
    public Color getBackground(int row, int column) {
        return this.getStatistics(row).isComposite() ? Colours.LIGHT_GREY : null;
    }

    public synchronized void write(Writer writer, String columnDelimiter, String lineDelimeter) throws IOException {
        int numberOfRows = this.getRowCount();
        int numberOfColumns = this.getColumnCount();
        writer.write(this.m_testColumnString);
        writer.write(columnDelimiter);
        writer.write(this.m_testDescriptionColumnString);
        writer.write(columnDelimiter);
        for (int dynamicColumn = 0; dynamicColumn < numberOfColumns - 2; ++dynamicColumn) {
            writer.write(this.m_columnLabels[dynamicColumn]);
            writer.write(columnDelimiter);
        }
        writer.write(lineDelimeter);
        for (int row = 0; row < numberOfRows; ++row) {
            for (int column = 0; column < numberOfColumns; ++column) {
                Object o = this.getValueAt(row, column);
                writer.write(o != null ? o.toString() : "");
                writer.write(columnDelimiter);
            }
            writer.write(lineDelimeter);
        }
    }
}

