/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.console.swingui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import net.grinder.console.common.Resources;

abstract class CustomAction
extends AbstractAction {
    protected static final String SET_ACTION_PROPERTY = "setAction";
    public static final String ROLLOVER_ICON = "RolloverIcon";
    public static final String RELEVANT_TO_SELECTION = "RelevantToSelection";
    private final String m_key;
    private final Set<AbstractButton> m_buttonsWithRegisteredListeners = new HashSet<AbstractButton>();

    protected CustomAction(Resources resources, String key) {
        this(resources, key, false);
    }

    protected CustomAction(Resources resources, String key, boolean isDialogAction) {
        ImageIcon rolloverImageIcon;
        ImageIcon imageIcon;
        String tip;
        this.m_key = key;
        String label = resources.getString(this.m_key + ".label", false);
        if (label != null) {
            if (isDialogAction) {
                this.putValue("Name", label + "...");
            } else {
                this.putValue("Name", label);
            }
        }
        if ((tip = resources.getString(this.m_key + ".tip", false)) != null) {
            this.putValue("ShortDescription", tip);
        }
        if ((imageIcon = resources.getImageIcon(this.m_key + ".image")) != null) {
            this.putValue("SmallIcon", imageIcon);
        }
        if ((rolloverImageIcon = resources.getImageIcon(this.m_key + ".rollover-image")) != null) {
            this.putValue(ROLLOVER_ICON, rolloverImageIcon);
        }
    }

    public final String getKey() {
        return this.m_key;
    }

    public final void registerButton(final AbstractButton button) {
        if (!this.m_buttonsWithRegisteredListeners.contains(button)) {
            this.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    if (e.getPropertyName().equals(CustomAction.SET_ACTION_PROPERTY)) {
                        CustomAction newAction = (CustomAction)e.getNewValue();
                        button.setAction(newAction);
                        newAction.registerButton(button);
                    }
                }
            });
            this.m_buttonsWithRegisteredListeners.add(button);
        }
    }

    public void setRelevantToSelection(boolean b) {
        this.putValue(RELEVANT_TO_SELECTION, b);
    }

    public boolean isRelevantToSelection() {
        Boolean b = (Boolean)this.getValue(RELEVANT_TO_SELECTION);
        return b != null && b != false;
    }
}

