/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.console.swingui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Image;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import net.grinder.common.Closer;
import net.grinder.common.GrinderException;
import net.grinder.common.GrinderProperties;
import net.grinder.common.UncheckedInterruptedException;
import net.grinder.console.ConsoleFoundation;
import net.grinder.console.common.ConsoleException;
import net.grinder.console.common.ErrorHandler;
import net.grinder.console.common.Resources;
import net.grinder.console.communication.ProcessControl;
import net.grinder.console.distribution.AgentCacheState;
import net.grinder.console.distribution.FileChangeWatcher;
import net.grinder.console.distribution.FileDistribution;
import net.grinder.console.distribution.FileDistributionHandler;
import net.grinder.console.editor.Buffer;
import net.grinder.console.editor.EditorModel;
import net.grinder.console.editor.TextSource;
import net.grinder.console.model.ConsoleProperties;
import net.grinder.console.model.SampleListener;
import net.grinder.console.model.SampleModel;
import net.grinder.console.model.SampleModelViews;
import net.grinder.console.swingui.BufferTreeModel;
import net.grinder.console.swingui.Colours;
import net.grinder.console.swingui.CumulativeStatisticsTableModel;
import net.grinder.console.swingui.CustomAction;
import net.grinder.console.swingui.CustomJButton;
import net.grinder.console.swingui.Editor;
import net.grinder.console.swingui.EditorControls;
import net.grinder.console.swingui.ErrorDialogHandler;
import net.grinder.console.swingui.FileTree;
import net.grinder.console.swingui.FileTreeModel;
import net.grinder.console.swingui.FrameBounds;
import net.grinder.console.swingui.LabelledGraph;
import net.grinder.console.swingui.LookAndFeel;
import net.grinder.console.swingui.MnemonicHeuristics;
import net.grinder.console.swingui.OptionalConfirmDialog;
import net.grinder.console.swingui.OptionsDialogHandler;
import net.grinder.console.swingui.ProcessStatusTableModel;
import net.grinder.console.swingui.SampleStatisticsTableModel;
import net.grinder.console.swingui.SamplingControlPanel;
import net.grinder.console.swingui.SwingDispatcherFactoryImplementation;
import net.grinder.console.swingui.Table;
import net.grinder.console.swingui.TestGraphPanel;
import net.grinder.statistics.StatisticsSet;
import net.grinder.util.Directory;
import net.grinder.util.FileContents;
import net.grinder.util.thread.Condition;
import org.slf4j.Logger;

public final class ConsoleUI
implements ConsoleFoundation.UI {
    private final LookAndFeel m_lookAndFeel;
    private final ActionTable m_actionTable = new ActionTable();
    private final CloseFileAction m_closeFileAction;
    private final StartAction m_startAction;
    private final ExitAction m_exitAction;
    private final StopAction m_stopAction;
    private final SaveFileAction m_saveFileAction;
    private final SaveFileAsAction m_saveFileAsAction;
    private final DistributeFilesAction m_distributeFilesAction;
    private final Resources m_resources;
    private final ConsoleProperties m_properties;
    private final SampleModel m_model;
    private final SampleModelViews m_sampleModelViews;
    private final ProcessControl m_processControl;
    private final FileDistribution m_fileDistribution;
    private final EditorModel m_editorModel;
    private final JFrame m_frame;
    private final FrameBounds m_frameBounds;
    private final JLabel m_stateLabel;
    private final SamplingControlPanel m_samplingControlPanel;
    private final ErrorHandler m_errorHandler;
    private final OptionalConfirmDialog m_optionalConfirmDialog;
    private final Font m_titleLabelFont;
    private final CumulativeStatisticsTableModel m_cumulativeTableModel;

    public ConsoleUI(Resources resources, ConsoleProperties consoleProperties, SampleModel model, SampleModelViews sampleModelViews, ProcessControl processControl, FileDistribution fileDistribution, Logger logger) throws ConsoleException {
        Image logoImage;
        this.m_resources = resources;
        this.m_properties = consoleProperties;
        this.m_model = model;
        this.m_sampleModelViews = sampleModelViews;
        this.m_processControl = processControl;
        this.m_fileDistribution = fileDistribution;
        this.m_frame = new JFrame(this.m_resources.getString("title"));
        ErrorDialogHandler errorDialogHandler = new ErrorDialogHandler(this.m_frame, this.m_resources, logger);
        this.m_errorHandler = new SwingDispatcherFactoryImplementation(null).create(ErrorHandler.class, errorDialogHandler);
        SwingDispatcherFactoryImplementation swingDispatcherFactory = new SwingDispatcherFactoryImplementation(this.m_errorHandler);
        this.m_lookAndFeel = new LookAndFeel(this.m_properties, swingDispatcherFactory);
        errorDialogHandler.registerWithLookAndFeel(this.m_lookAndFeel);
        this.m_editorModel = new EditorModel(this.m_resources, (TextSource.Factory)new Editor.TextSourceFactory(), this.m_fileDistribution.getAgentCacheState(), (FileChangeWatcher)this.m_fileDistribution);
        this.m_editorModel.setExternalEditor(this.m_properties.getExternalEditorCommand(), this.m_properties.getExternalEditorArguments());
        this.m_editorModel.setSelectedPropertiesFile(this.m_properties.getPropertiesFile());
        this.m_properties.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("grinder.console.externalEditorCommand") || e.getPropertyName().equals("grinder.console.externalEditorArguments")) {
                    ConsoleUI.this.m_editorModel.setExternalEditor(ConsoleUI.this.m_properties.getExternalEditorCommand(), ConsoleUI.this.m_properties.getExternalEditorArguments());
                } else if (e.getPropertyName().equals("grinder.console.propertiesFile")) {
                    ConsoleUI.this.m_editorModel.setSelectedPropertiesFile(ConsoleUI.this.m_properties.getPropertiesFile());
                }
            }
        });
        this.m_optionalConfirmDialog = new OptionalConfirmDialog(this.m_frame, this.m_resources, this.m_properties);
        this.m_closeFileAction = new CloseFileAction();
        this.m_exitAction = new ExitAction();
        this.m_startAction = new StartAction();
        this.m_stopAction = new StopAction();
        this.m_saveFileAction = new SaveFileAction();
        this.m_saveFileAsAction = new SaveFileAsAction();
        this.m_distributeFilesAction = new DistributeFilesAction();
        this.m_actionTable.add(this.m_closeFileAction);
        this.m_actionTable.add(this.m_exitAction);
        this.m_actionTable.add(this.m_startAction);
        this.m_actionTable.add(this.m_stopAction);
        this.m_actionTable.add(this.m_saveFileAsAction);
        this.m_actionTable.add(this.m_distributeFilesAction);
        this.m_actionTable.add(new AboutAction(this.m_resources.getImageIcon("logo.image")));
        this.m_actionTable.add(new ChooseDirectoryAction());
        this.m_actionTable.add(new StartProcessesAction());
        this.m_actionTable.add(new NewFileAction());
        this.m_actionTable.add(new OptionsAction());
        this.m_actionTable.add(new ResetProcessesAction());
        this.m_actionTable.add(new SaveFileAction());
        this.m_actionTable.add(new SaveResultsAction());
        this.m_actionTable.add(new StopProcessesAction());
        this.m_stateLabel = new JLabel();
        this.stateChanged();
        this.m_samplingControlPanel = new SamplingControlPanel(this.m_resources);
        JPanel controlAndTotalPanel = this.createControlAndTotalPanel();
        JTabbedPane tabbedPane = new JTabbedPane();
        TestGraphPanel graphPanel = new TestGraphPanel(tabbedPane, this.m_model, this.m_sampleModelViews, this.m_resources, swingDispatcherFactory);
        graphPanel.resetTests();
        JScrollPane graphTabPane = new JScrollPane(graphPanel, 20, 31);
        graphTabPane.setBorder(BorderFactory.createEmptyBorder());
        tabbedPane.addTab(this.m_resources.getString("graphTab.title"), this.m_resources.getImageIcon("graphTab.image"), graphTabPane, this.m_resources.getString("graphTab.tip"));
        this.m_titleLabelFont = new JLabel().getFont().deriveFont(2);
        this.m_cumulativeTableModel = new CumulativeStatisticsTableModel(this.m_model, this.m_sampleModelViews, this.m_resources, swingDispatcherFactory);
        JScrollPane cumulativeTablePane = new JScrollPane(new Table(this.m_cumulativeTableModel));
        cumulativeTablePane.setBorder(this.createTitledBorder("cumulativeTable.label"));
        cumulativeTablePane.setMinimumSize(new Dimension(100, 60));
        SampleStatisticsTableModel sampleModel = new SampleStatisticsTableModel(this.m_model, this.m_sampleModelViews, this.m_resources, swingDispatcherFactory);
        JScrollPane sampleTablePane = new JScrollPane(new Table(sampleModel));
        sampleTablePane.setBorder(this.createTitledBorder("sampleTable.label"));
        sampleTablePane.setMinimumSize(new Dimension(100, 60));
        JSplitPane resultsPane = new JSplitPane(0, cumulativeTablePane, sampleTablePane);
        resultsPane.setOneTouchExpandable(true);
        resultsPane.setResizeWeight(1.0);
        resultsPane.setBorder(BorderFactory.createEmptyBorder());
        tabbedPane.addTab(this.m_resources.getString("resultsTab.title"), this.m_resources.getImageIcon("resultsTab.image"), resultsPane, this.m_resources.getString("resultsTab.tip"));
        ProcessStatusTableModel processStatusModel = new ProcessStatusTableModel(this.m_resources, this.m_processControl, swingDispatcherFactory);
        JScrollPane processStatusPane = new JScrollPane(new Table(processStatusModel));
        processStatusPane.setBorder(this.createTitledBorder("processStatusTableTab.tip"));
        tabbedPane.addTab(this.m_resources.getString("processStatusTableTab.title"), this.m_resources.getImageIcon("processStatusTableTab.image"), processStatusPane, this.m_resources.getString("processStatusTableTab.tip"));
        JToolBar editorToolBar = new JToolBar();
        new ToolBarAssembler(editorToolBar, true).populate("editor.toolbar");
        Font editorSmallFont = this.m_titleLabelFont.deriveFont(0).deriveFont(this.m_titleLabelFont.getSize2D() * 0.8f);
        EditorControls editorControls = new EditorControls(this.m_resources, this.m_editorModel, editorSmallFont, editorToolBar);
        Editor editor = new Editor(this.m_editorModel, this.m_saveFileAction);
        final FileTreeModel fileTreeModel = new FileTreeModel(this.m_editorModel, this.m_fileDistribution.getDistributionFileFilter(), this.m_properties.getDistributionDirectory().getFile());
        this.m_properties.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("grinder.console.scriptDistributionDirectory")) {
                    fileTreeModel.setRootDirectory(ConsoleUI.this.m_properties.getDistributionDirectory().getFile());
                }
            }
        });
        this.m_fileDistribution.addFileChangedListener((FileChangeWatcher.FileChangedListener)swingDispatcherFactory.create(FileChangeWatcher.FileChangedListener.class, new FileTreeModel.RefreshChangedDirectoriesListener(fileTreeModel)));
        JPopupMenu fileTreePopupMenu = new JPopupMenu();
        FileTree fileTree = new FileTree(this.m_resources, this.getErrorHandler(), this.m_editorModel, new BufferTreeModel(this.m_editorModel), fileTreeModel, editorSmallFont, fileTreePopupMenu, this.m_properties);
        CustomAction[] fileTreeActions = fileTree.getActions();
        for (int i = 0; i < fileTreeActions.length; ++i) {
            this.m_actionTable.add(fileTreeActions[i]);
        }
        new PopupMenuAssembler(fileTreePopupMenu).populate("editor.filetree.popupmenu");
        JPanel editorPanel = new JPanel();
        editorPanel.setLayout(new FlowLayout(1, 0, 0));
        editorPanel.add(editorControls.getComponent());
        editorPanel.add(editor.getComponent());
        JToolBar fileTreeToolBar = new JToolBar();
        new ToolBarAssembler(fileTreeToolBar, true).populate("filetree.toolbar");
        fileTreeToolBar.setFloatable(false);
        fileTreeToolBar.setAlignmentX(0.0f);
        JComponent fileTreeComponent = fileTree.getComponent();
        fileTreeComponent.setAlignmentX(0.0f);
        fileTreeComponent.setPreferredSize(new Dimension(200, 100));
        JPanel fileTreeControlPanel = new JPanel();
        fileTreeControlPanel.setLayout(new BoxLayout(fileTreeControlPanel, 1));
        fileTreeControlPanel.setBorder(BorderFactory.createEmptyBorder());
        fileTreeControlPanel.add(fileTreeToolBar);
        fileTreeControlPanel.add(fileTreeComponent);
        JSplitPane scriptPane = new JSplitPane(1, fileTreeControlPanel, editorPanel);
        scriptPane.setOneTouchExpandable(true);
        scriptPane.setBorder(BorderFactory.createEmptyBorder());
        tabbedPane.addTab(this.m_resources.getString("scriptTab.title"), this.m_resources.getImageIcon("scriptTab.image"), scriptPane, this.m_resources.getString("scriptTab.tip"));
        JPanel contentPanel = new JPanel(new BorderLayout());
        contentPanel.add((Component)controlAndTotalPanel, "West");
        contentPanel.add((Component)tabbedPane, "Center");
        JPanel toolBarPanel = new JPanel(new BorderLayout());
        JToolBar mainToolBar = new JToolBar();
        new ToolBarAssembler(mainToolBar, false).populate("main.toolbar");
        toolBarPanel.add((Component)mainToolBar, "North");
        toolBarPanel.add((Component)contentPanel, "Center");
        this.m_frame.setDefaultCloseOperation(0);
        this.m_frame.addWindowListener(new WindowCloseAdapter());
        Container topLevelPane = this.m_frame.getContentPane();
        JMenuBar menuBar = new JMenuBar();
        new MenuBarAssembler(menuBar).populate("menubar");
        topLevelPane.add((Component)menuBar, "North");
        topLevelPane.add((Component)toolBarPanel, "Center");
        ImageIcon logoIcon = this.m_resources.getImageIcon("logo.image");
        if (logoIcon != null && (logoImage = logoIcon.getImage()) != null) {
            this.m_frame.setIconImage(logoImage);
        }
        this.m_model.addModelListener((SampleModel.Listener)swingDispatcherFactory.create(SampleModel.Listener.class, new SampleModel.AbstractListener(){

            public void stateChanged() {
                ConsoleUI.this.stateChanged();
            }
        }));
        this.m_lookAndFeel.addListener(new LookAndFeelListener());
        this.m_frameBounds = new FrameBounds(this.m_properties, this.m_frame);
        this.m_frameBounds.restore();
        resultsPane.setDividerLocation(resultsPane.getMaximumDividerLocation());
        this.m_frame.setVisible(true);
    }

    private TitledBorder createTitledBorder(String titleResource) {
        TitledBorder border = BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), this.m_resources.getString(titleResource));
        border.setTitleFont(this.m_titleLabelFont);
        border.setTitleColor(SystemColor.textInactiveText);
        border.setTitleJustification(3);
        return border;
    }

    private JPanel createControlAndTotalPanel() {
        final LabelledGraph totalGraph = new LabelledGraph(this.m_resources.getString("totalGraph.title"), this.m_resources, SystemColor.window, this.m_model.getTPSExpression(), this.m_model.getPeakTPSExpression(), this.m_sampleModelViews.getTestStatisticsQueries());
        final JLabel tpsLabel = new JLabel();
        tpsLabel.setFont(new Font("helvetica", 3, 40));
        tpsLabel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        this.m_model.addTotalSampleListener(new SampleListener(){
            private final String m_suffix;
            {
                this.m_suffix = ' ' + ConsoleUI.this.m_resources.getString("tps.units");
            }

            public void update(StatisticsSet intervalStatistics, StatisticsSet cumulativeStatistics) {
                NumberFormat format = ConsoleUI.this.m_sampleModelViews.getNumberFormat();
                tpsLabel.setText(format.format(ConsoleUI.this.m_model.getTPSExpression().getDoubleValue(intervalStatistics)) + this.m_suffix);
                totalGraph.add(intervalStatistics, cumulativeStatistics, format);
            }
        });
        CustomJButton stateButton = new CustomJButton();
        stateButton.setBorderPainted(true);
        ((AbstractButton)stateButton).setAction(this.m_stopAction);
        stateButton.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.m_stopAction.registerButton(stateButton);
        this.m_stateLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 0));
        JPanel statePanel = new JPanel();
        statePanel.setLayout(new BoxLayout(statePanel, 0));
        statePanel.add(stateButton);
        statePanel.add(this.m_stateLabel);
        statePanel.setAlignmentX(0.0f);
        this.m_samplingControlPanel.add(Box.createRigidArea(new Dimension(0, 40)));
        this.m_samplingControlPanel.add(statePanel);
        this.m_samplingControlPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        this.m_samplingControlPanel.setProperties(this.m_properties);
        JPanel controlAndTotalPanel = new JPanel();
        controlAndTotalPanel.setLayout(new BoxLayout(controlAndTotalPanel, 1));
        this.m_samplingControlPanel.setAlignmentX(0.0f);
        tpsLabel.setAlignmentX(0.0f);
        totalGraph.setAlignmentX(0.0f);
        controlAndTotalPanel.add(this.m_samplingControlPanel);
        controlAndTotalPanel.add(Box.createRigidArea(new Dimension(0, 100)));
        controlAndTotalPanel.add(tpsLabel);
        controlAndTotalPanel.add(Box.createRigidArea(new Dimension(0, 20)));
        controlAndTotalPanel.add(totalGraph);
        JPanel hackToFixLayout = new JPanel();
        hackToFixLayout.add(controlAndTotalPanel);
        return hackToFixLayout;
    }

    private void stateChanged() {
        SampleModel.State state = this.m_model.getState();
        this.m_stateLabel.setText(state.getDescription());
        switch (state.getValue()) {
            case Recording: {
                this.m_stateLabel.setForeground(Colours.DARK_GREEN);
                break;
            }
            case Stopped: {
                this.m_stateLabel.setForeground(Colours.DARK_RED);
                this.m_stopAction.stopped();
                break;
            }
            default: {
                this.m_stateLabel.setForeground(SystemColor.controlText);
            }
        }
    }

    public ErrorHandler getErrorHandler() {
        return this.m_errorHandler;
    }

    private final class DistributeFilesAction
    extends CustomAction {
        private final Condition m_cacheStateCondition;

        DistributeFilesAction() {
            super(ConsoleUI.this.m_resources, "distribute-files");
            this.m_cacheStateCondition = new Condition();
            AgentCacheState agentCacheState = ConsoleUI.this.m_fileDistribution.getAgentCacheState();
            agentCacheState.addListener(new PropertyChangeListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void propertyChange(PropertyChangeEvent ignored) {
                    DistributeFilesAction.this.setEnabled(DistributeFilesAction.this.shouldEnable());
                    Condition condition = DistributeFilesAction.this.m_cacheStateCondition;
                    synchronized (condition) {
                        DistributeFilesAction.this.m_cacheStateCondition.notifyAll();
                    }
                }
            });
            this.setEnabled(this.shouldEnable());
        }

        private boolean shouldEnable() {
            return ConsoleUI.this.m_fileDistribution.getAgentCacheState().getOutOfDate();
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            this.distribute(null);
        }

        public void distribute(final Runnable onCompletionCallback) {
            final FileDistributionHandler distributionHandler = ConsoleUI.this.m_fileDistribution.getHandler();
            final ProgressMonitor progressMonitor = new ProgressMonitor(ConsoleUI.this.m_frame, this.getValue("Name"), "", 0, 100);
            progressMonitor.setMillisToDecideToPopup(0);
            progressMonitor.setMillisToPopup(0);
            Runnable distributionRunnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    while (!progressMonitor.isCanceled()) {
                        try {
                            FileDistributionHandler.Result result = distributionHandler.sendNextFile();
                            if (result == null) break;
                            progressMonitor.setProgress(result.getProgressInCents());
                            progressMonitor.setNote(result.getFileName());
                        }
                        catch (FileContents.FileContentsException e) {
                            e.printStackTrace();
                        }
                    }
                    progressMonitor.close();
                    if (onCompletionCallback != null) {
                        Condition condition = DistributeFilesAction.this.m_cacheStateCondition;
                        synchronized (condition) {
                            for (int i = 0; i < 5 && DistributeFilesAction.this.shouldEnable(); ++i) {
                                DistributeFilesAction.this.m_cacheStateCondition.waitNoInterrruptException(1000L);
                            }
                        }
                        SwingUtilities.invokeLater(onCompletionCallback);
                    }
                }
            };
            new Thread(distributionRunnable).start();
        }
    }

    private final class ChooseDirectoryAction
    extends CustomAction {
        private final JFileChooser m_fileChooser;

        ChooseDirectoryAction() {
            super(ConsoleUI.this.m_resources, "choose-directory", true);
            this.m_fileChooser = new JFileChooser(".");
            this.m_fileChooser.setDialogTitle(ConsoleUI.this.m_resources.getString("choose-directory.tip"));
            this.m_fileChooser.setFileSelectionMode(1);
            this.m_fileChooser.setSelectedFile(ConsoleUI.this.m_properties.getDistributionDirectory().getFile());
            ConsoleUI.this.m_lookAndFeel.addListener(new LookAndFeel.ComponentListener(this.m_fileChooser));
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            try {
                String title = MnemonicHeuristics.removeMnemonicMarkers(ConsoleUI.this.m_resources.getString("choose-directory.label"));
                if (this.m_fileChooser.showDialog(ConsoleUI.this.m_frame, title) == 0) {
                    Directory directory = new Directory(this.m_fileChooser.getSelectedFile());
                    File file = directory.getFile();
                    if (!file.exists()) {
                        if (JOptionPane.showConfirmDialog(ConsoleUI.this.m_frame, ConsoleUI.this.m_resources.getString("createDirectory.text"), file.toString(), 0) == 1) {
                            return;
                        }
                        directory.create();
                    }
                    ConsoleProperties properties = ConsoleUI.this.m_properties;
                    properties.setAndSaveDistributionDirectory(directory);
                }
            }
            catch (IOException e) {
                UncheckedInterruptedException.ioException((IOException)e);
                ConsoleUI.this.getErrorHandler().handleException((Throwable)e);
            }
            catch (GrinderException e) {
                ConsoleUI.this.getErrorHandler().handleException((Throwable)e);
            }
        }
    }

    private final class StopProcessesAction
    extends CustomAction {
        StopProcessesAction() {
            super(ConsoleUI.this.m_resources, "stop-processes");
            ConsoleUI.this.m_processControl.addProcessStatusListener((ProcessControl.Listener)new EnableIfAgentsConnected(this));
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            try {
                int chosen = ConsoleUI.this.m_optionalConfirmDialog.show(ConsoleUI.this.m_resources.getString("stopProcessesConfirmation.text"), (String)this.getValue("Name"), 2, "stopProcessesAsk");
                if (chosen != 0 && chosen != 999) {
                    return;
                }
            }
            catch (GrinderException e) {
                ConsoleUI.this.getErrorHandler().handleException((Throwable)e);
                return;
            }
            ConsoleUI.this.m_processControl.stopAgentAndWorkerProcesses();
        }
    }

    private final class ResetProcessesAction
    extends CustomAction {
        ResetProcessesAction() {
            super(ConsoleUI.this.m_resources, "reset-processes");
            ConsoleUI.this.m_processControl.addProcessStatusListener((ProcessControl.Listener)new EnableIfAgentsConnected(this));
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            ConsoleProperties properties = ConsoleUI.this.m_properties;
            try {
                int chosen = ConsoleUI.this.m_optionalConfirmDialog.show(ConsoleUI.this.m_resources.getString("resetConsoleWithProcessesConfirmation.text"), (String)this.getValue("Name"), 1, "resetConsoleWithProcessesAsk");
                switch (chosen) {
                    case 0: {
                        properties.setResetConsoleWithProcesses(true);
                        break;
                    }
                    case 1: {
                        properties.setResetConsoleWithProcesses(false);
                        break;
                    }
                    case 999: {
                        break;
                    }
                    default: {
                        return;
                    }
                }
            }
            catch (GrinderException e) {
                ConsoleUI.this.getErrorHandler().handleException((Throwable)e);
                return;
            }
            if (properties.getResetConsoleWithProcesses()) {
                ConsoleUI.this.m_model.reset();
                ConsoleUI.this.m_sampleModelViews.resetStatisticsViews();
            }
            ConsoleUI.this.m_processControl.resetWorkerProcesses();
        }
    }

    private class StartProcessesAction
    extends CustomAction {
        StartProcessesAction() {
            super(ConsoleUI.this.m_resources, "start-processes");
            ConsoleUI.this.m_processControl.addProcessStatusListener((ProcessControl.Listener)new EnableIfAgentsConnected(this));
        }

        @Override
        public void actionPerformed(final ActionEvent event) {
            try {
                File propertiesFile = ConsoleUI.this.m_editorModel.getSelectedPropertiesFile();
                if (propertiesFile == null) {
                    int chosen = ConsoleUI.this.m_optionalConfirmDialog.show(ConsoleUI.this.m_resources.getString("propertiesNotSetConfirmation.text"), (String)this.getValue("Name"), 2, "propertiesNotSetAsk");
                    if (chosen != 0 && chosen != 999) {
                        return;
                    }
                    ConsoleUI.this.m_processControl.startWorkerProcesses(new GrinderProperties());
                } else {
                    int chosen;
                    if (ConsoleUI.this.m_editorModel.isABufferDirty() && (chosen = ConsoleUI.this.m_optionalConfirmDialog.show(ConsoleUI.this.m_resources.getString("startWithUnsavedBuffersConfirmation.text"), (String)this.getValue("Name"), 2, "startWithUnsavedBuffersAsk")) != 0 && chosen != 999) {
                        return;
                    }
                    if (ConsoleUI.this.m_fileDistribution.getAgentCacheState().getOutOfDate()) {
                        chosen = ConsoleUI.this.m_optionalConfirmDialog.show(ConsoleUI.this.m_resources.getString("cachesOutOfDateConfirmation.text"), (String)this.getValue("Name"), 2, "distributeOnStartAsk");
                        if (chosen != 0 && chosen != 999) {
                            return;
                        }
                        ConsoleUI.this.m_distributeFilesAction.distribute(new Runnable(){

                            @Override
                            public void run() {
                                StartProcessesAction.this.actionPerformed(event);
                            }
                        });
                        return;
                    }
                    ConsoleUI.this.m_processControl.startWorkerProcessesWithDistributedFiles(ConsoleUI.this.m_properties.getDistributionDirectory(), new GrinderProperties(propertiesFile));
                }
            }
            catch (GrinderException e) {
                ConsoleUI.this.getErrorHandler().handleException((Throwable)e);
            }
        }
    }

    private class EnableIfAgentsConnected
    implements ProcessControl.Listener {
        private final Action m_action;

        EnableIfAgentsConnected(Action action) {
            this.m_action = action;
            this.enableOrDisable();
        }

        public final void update(ProcessControl.ProcessReports[] processStatuses) {
            this.enableOrDisable();
        }

        protected final void enableOrDisable() {
            this.m_action.setEnabled(this.shouldEnable());
        }

        protected boolean shouldEnable() {
            return ConsoleUI.this.m_processControl.getNumberOfLiveAgents() > 0;
        }
    }

    private final class CloseFileAction
    extends CustomAction {
        public CloseFileAction() {
            super(ConsoleUI.this.m_resources, "close-file");
            ConsoleUI.this.m_editorModel.addListener((EditorModel.Listener)new EditorModel.AbstractListener(){

                public void bufferStateChanged(Buffer ignored) {
                    CloseFileAction.this.setEnabled(CloseFileAction.this.shouldEnable());
                }
            });
            this.setEnabled(this.shouldEnable());
        }

        private boolean shouldEnable() {
            return ConsoleUI.this.m_editorModel.getSelectedBuffer() != null;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            this.closeBuffer(ConsoleUI.this.m_editorModel.getSelectedBuffer());
        }

        boolean closeBuffer(Buffer buffer) {
            if (buffer != null) {
                while (buffer.isDirty()) {
                    String confirmationMessage = MessageFormat.format(ConsoleUI.this.m_resources.getString("saveModifiedBufferConfirmation.text"), buffer.getDisplayName());
                    int chosen = JOptionPane.showConfirmDialog(ConsoleUI.this.m_frame, confirmationMessage, (String)this.getValue("Name"), 1);
                    if (chosen == 0) {
                        try {
                            if (buffer.getFile() != null) {
                                buffer.save();
                                continue;
                            }
                            ConsoleUI.this.m_saveFileAsAction.saveBufferAs(buffer);
                            continue;
                        }
                        catch (GrinderException e) {
                            ConsoleUI.this.getErrorHandler().handleException((Throwable)e);
                            return false;
                        }
                    }
                    if (chosen == 1) break;
                    return false;
                }
                ConsoleUI.this.m_editorModel.closeBuffer(buffer);
            }
            return true;
        }
    }

    private final class SaveFileAsAction
    extends CustomAction {
        private final JFileChooser m_fileChooser;

        public SaveFileAsAction() {
            super(ConsoleUI.this.m_resources, "save-file-as", true);
            this.m_fileChooser = new JFileChooser(".");
            ConsoleUI.this.m_editorModel.addListener((EditorModel.Listener)new EditorModel.AbstractListener(){

                public void bufferStateChanged(Buffer ignored) {
                    SaveFileAsAction.this.setEnabled(SaveFileAsAction.this.shouldEnable());
                }
            });
            this.setEnabled(this.shouldEnable());
            this.m_fileChooser.setDialogTitle(MnemonicHeuristics.removeMnemonicMarkers(ConsoleUI.this.m_resources.getString("save-file-as.label")));
            final String pythonFilesText = ConsoleUI.this.m_resources.getString("scripts.label");
            this.m_fileChooser.addChoosableFileFilter(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return ConsoleUI.this.m_editorModel.isScriptFile(file) || file.isDirectory();
                }

                @Override
                public String getDescription() {
                    return pythonFilesText;
                }
            });
            ConsoleUI.this.m_lookAndFeel.addListener(new LookAndFeel.ComponentListener(this.m_fileChooser));
        }

        private boolean shouldEnable() {
            return ConsoleUI.this.m_editorModel.getSelectedBuffer() != null;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            try {
                this.saveBufferAs(ConsoleUI.this.m_editorModel.getSelectedBuffer());
            }
            catch (ConsoleException e) {
                ConsoleUI.this.getErrorHandler().handleException((Throwable)e);
            }
        }

        void saveBufferAs(Buffer buffer) throws ConsoleException {
            File currentFile = buffer.getFile();
            Directory distributionDirectory = ConsoleUI.this.m_properties.getDistributionDirectory();
            if (currentFile != null) {
                this.m_fileChooser.setSelectedFile(currentFile);
            } else {
                this.m_fileChooser.setCurrentDirectory(distributionDirectory.getFile());
            }
            if (this.m_fileChooser.showSaveDialog(ConsoleUI.this.m_frame) != 0) {
                return;
            }
            File file = this.m_fileChooser.getSelectedFile();
            if (!distributionDirectory.isParentOf(file) && JOptionPane.showConfirmDialog(ConsoleUI.this.m_frame, ConsoleUI.this.m_resources.getString("saveOutsideOfDistributionConfirmation.text"), (String)this.getValue("Name"), 0) == 1) {
                return;
            }
            if (!file.equals(currentFile)) {
                Buffer oldBuffer = ConsoleUI.this.m_editorModel.getBufferForFile(file);
                if (oldBuffer != null) {
                    ArrayList<String> messages = new ArrayList<String>();
                    messages.add(ConsoleUI.this.m_resources.getString("ignoreExistingBufferConfirmation.text"));
                    if (oldBuffer.isDirty()) {
                        messages.add(ConsoleUI.this.m_resources.getString("existingBufferHasUnsavedChanges.text"));
                    }
                    if (!oldBuffer.isUpToDate()) {
                        messages.add(ConsoleUI.this.m_resources.getString("existingBufferOutOfDate.text"));
                    }
                    messages.add(ConsoleUI.this.m_resources.getString("ignoreExistingBufferConfirmation2.text"));
                    if (JOptionPane.showConfirmDialog(ConsoleUI.this.m_frame, messages.toArray(), file.toString(), 0) == 1) {
                        return;
                    }
                    ConsoleUI.this.m_editorModel.closeBuffer(oldBuffer);
                } else if (file.exists() && JOptionPane.showConfirmDialog(ConsoleUI.this.m_frame, ConsoleUI.this.m_resources.getString("overwriteConfirmation.text"), file.toString(), 0) == 1) {
                    return;
                }
            } else if (!buffer.isUpToDate() && JOptionPane.showConfirmDialog(ConsoleUI.this.m_frame, ConsoleUI.this.m_resources.getString("outOfDateOverwriteConfirmation.text"), buffer.getFile().toString(), 0) == 1) {
                return;
            }
            buffer.save(file);
        }
    }

    private final class SaveFileAction
    extends CustomAction {
        public SaveFileAction() {
            super(ConsoleUI.this.m_resources, "save-file");
            ConsoleUI.this.m_editorModel.addListener((EditorModel.Listener)new EditorModel.AbstractListener(){

                public void bufferStateChanged(Buffer ignored) {
                    SaveFileAction.this.setEnabled(SaveFileAction.this.shouldEnable());
                }
            });
            this.setEnabled(this.shouldEnable());
        }

        private boolean shouldEnable() {
            Buffer buffer = ConsoleUI.this.m_editorModel.getSelectedBuffer();
            return buffer != null && buffer.isDirty();
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            try {
                Buffer buffer = ConsoleUI.this.m_editorModel.getSelectedBuffer();
                if (buffer.getFile() != null) {
                    if (!buffer.isUpToDate() && JOptionPane.showConfirmDialog(ConsoleUI.this.m_frame, ConsoleUI.this.m_resources.getString("outOfDateOverwriteConfirmation.text"), buffer.getFile().toString(), 0) == 1) {
                        return;
                    }
                    buffer.save();
                } else {
                    ConsoleUI.this.m_saveFileAsAction.saveBufferAs(buffer);
                }
            }
            catch (ConsoleException e) {
                ConsoleUI.this.getErrorHandler().handleException((Throwable)e);
            }
        }
    }

    private final class NewFileAction
    extends CustomAction {
        public NewFileAction() {
            super(ConsoleUI.this.m_resources, "new-file");
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            ConsoleUI.this.m_editorModel.selectNewBuffer();
        }
    }

    private final class StopAction
    extends CustomAction {
        StopAction() {
            super(ConsoleUI.this.m_resources, "stop");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ConsoleUI.this.m_model.stop();
            this.stopped();
        }

        public void stopped() {
            this.firePropertyChange("setAction", null, ConsoleUI.this.m_startAction);
        }
    }

    private final class StartAction
    extends CustomAction {
        StartAction() {
            super(ConsoleUI.this.m_resources, "start");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ConsoleUI.this.m_model.start();
            this.firePropertyChange("setAction", null, ConsoleUI.this.m_stopAction);
        }
    }

    private final class ExitAction
    extends CustomAction {
        ExitAction() {
            super(ConsoleUI.this.m_resources, "exit");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.exit();
        }

        void exit() {
            try {
                ConsoleUI.this.m_frameBounds.store();
            }
            catch (ConsoleException e) {
                ConsoleUI.this.getErrorHandler().handleException((Throwable)e);
            }
            Buffer[] buffers = ConsoleUI.this.m_editorModel.getBuffers();
            for (int i = 0; i < buffers.length; ++i) {
                if (ConsoleUI.this.m_closeFileAction.closeBuffer(buffers[i])) continue;
                return;
            }
            System.exit(0);
        }
    }

    private final class AboutAction
    extends CustomAction {
        private final ImageIcon m_logoIcon;

        AboutAction(ImageIcon logoIcon) {
            super(ConsoleUI.this.m_resources, "about", true);
            this.m_logoIcon = logoIcon;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Resources resources = ConsoleUI.this.m_resources;
            String title = MnemonicHeuristics.removeMnemonicMarkers(resources.getString("about.label"));
            String aboutText = resources.getStringFromFile("about.text", true);
            JEditorPane htmlPane = new JEditorPane("text/html", aboutText);
            htmlPane.setEditable(false);
            htmlPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            htmlPane.setBackground(new JLabel().getBackground());
            JScrollPane contents = new JScrollPane(htmlPane, 20, 31){

                @Override
                public Dimension getPreferredSize() {
                    Dimension d = super.getPreferredSize();
                    d.width = 500;
                    d.height = 400;
                    return d;
                }
            };
            htmlPane.setCaretPosition(0);
            JOptionPane.showMessageDialog(ConsoleUI.this.m_frame, contents, title, -1, this.m_logoIcon);
        }
    }

    private final class OptionsAction
    extends CustomAction {
        private final OptionsDialogHandler m_optionsDialogHandler;

        OptionsAction() {
            super(ConsoleUI.this.m_resources, "options", true);
            this.m_optionsDialogHandler = new OptionsDialogHandler(ConsoleUI.this.m_frame, ConsoleUI.this.m_lookAndFeel, ConsoleUI.this.m_properties, ConsoleUI.this.m_resources){

                @Override
                protected void setNewOptions(ConsoleProperties newOptions) {
                    ConsoleUI.this.m_properties.set(newOptions);
                    ConsoleUI.this.m_samplingControlPanel.refresh();
                }
            };
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            this.m_optionsDialogHandler.showDialog(ConsoleUI.this.m_properties);
        }
    }

    private final class SaveResultsAction
    extends CustomAction {
        private final JFileChooser m_fileChooser;
        private final JCheckBox m_saveTotalsCheckBox;

        SaveResultsAction() {
            super(ConsoleUI.this.m_resources, "save-results", true);
            this.m_fileChooser = new JFileChooser(".");
            this.m_fileChooser.setDialogTitle(MnemonicHeuristics.removeMnemonicMarkers(ConsoleUI.this.m_resources.getString("save-results.label")));
            this.m_fileChooser.setSelectedFile(new File(ConsoleUI.this.m_resources.getString("default.filename")));
            this.m_saveTotalsCheckBox = new JCheckBox(ConsoleUI.this.m_resources.getString("saveResults.includeTotals.label"));
            this.m_saveTotalsCheckBox.setSelected(ConsoleUI.this.m_properties.getSaveTotalsWithResults());
            this.m_fileChooser.setAccessory(this.m_saveTotalsCheckBox);
            ConsoleUI.this.m_lookAndFeel.addListener(new LookAndFeel.ComponentListener(this.m_fileChooser));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent event) {
            block9: {
                FileWriter writer;
                block8: {
                    if (this.m_fileChooser.showSaveDialog(ConsoleUI.this.m_frame) != 0) break block9;
                    File file = this.m_fileChooser.getSelectedFile();
                    if (file.exists() && JOptionPane.showConfirmDialog(ConsoleUI.this.m_frame, ConsoleUI.this.m_resources.getString("overwriteConfirmation.text"), file.toString(), 0) == 1) {
                        return;
                    }
                    writer = null;
                    try {
                        writer = new FileWriter(file);
                        String lineSeparator = System.getProperty("line.separator");
                        if (this.m_saveTotalsCheckBox.isSelected()) {
                            ConsoleUI.this.m_cumulativeTableModel.write(writer, "\t", lineSeparator);
                            break block8;
                        }
                        ConsoleUI.this.m_cumulativeTableModel.writeWithoutTotals(writer, "\t", lineSeparator);
                    }
                    catch (IOException e) {
                        try {
                            UncheckedInterruptedException.ioException((IOException)e);
                            ConsoleUI.this.getErrorHandler().handleErrorMessage(e.getMessage(), ConsoleUI.this.m_resources.getString("fileError.title"));
                        }
                        catch (Throwable throwable) {
                            Closer.close(writer);
                            throw throwable;
                        }
                        Closer.close((Writer)writer);
                    }
                }
                Closer.close((Writer)writer);
                try {
                    ConsoleUI.this.m_properties.setSaveTotalsWithResults(this.m_saveTotalsCheckBox.isSelected());
                }
                catch (ConsoleException e) {
                    ConsoleUI.this.getErrorHandler().handleException((Throwable)e);
                }
            }
        }
    }

    private final class WindowCloseAdapter
    extends WindowAdapter {
        private WindowCloseAdapter() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            ConsoleUI.this.m_exitAction.exit();
        }
    }

    private static class ActionTable {
        private final Map<String, CustomAction> m_map = new HashMap<String, CustomAction>();

        private ActionTable() {
        }

        public void add(CustomAction action) {
            this.m_map.put(action.getKey(), action);
        }

        public void setAction(AbstractButton button, String actionKey) {
            CustomAction action = this.m_map.get(actionKey);
            if (action != null) {
                button.setAction(action);
                action.registerButton(button);
            } else {
                System.err.println("Action '" + actionKey + "' not found");
                button.setEnabled(false);
            }
        }
    }

    private final class ToolBarAssembler
    extends ListTokeniserTemplate {
        private final boolean m_small;

        protected ToolBarAssembler(JComponent component, boolean small) {
            super(component);
            this.m_small = small;
        }

        @Override
        protected void dash() {
            ((JToolBar)this.getComponent()).addSeparator();
        }

        @Override
        protected void token(String key) {
            CustomJButton button = new CustomJButton();
            if (this.m_small) {
                button.setBorder(BorderFactory.createEmptyBorder());
            }
            this.getComponent().add(button);
            ConsoleUI.this.m_actionTable.setAction(button, key);
        }
    }

    private final class MenuBarAssembler
    extends ListTokeniserTemplate {
        protected MenuBarAssembler(JComponent component) {
            super(component);
            new MnemonicHeuristics(component);
        }

        @Override
        protected void greaterThan() {
            this.getComponent().add(Box.createHorizontalGlue());
        }

        @Override
        protected void token(String key) {
            JMenu menu = new JMenu(ConsoleUI.this.m_resources.getString(key + ".menu.label"));
            new MenuAssembler(menu).populate(key + ".menu");
            this.getComponent().add(menu);
        }
    }

    private final class PopupMenuAssembler
    extends AbstractMenuAssembler {
        protected PopupMenuAssembler(JPopupMenu component) {
            super(component);
            component.addContainerListener(new ContainerAdapter(){

                @Override
                public void componentAdded(ContainerEvent e) {
                    if (e.getChild() instanceof JMenuItem) {
                        final JMenuItem menuItem = (JMenuItem)e.getChild();
                        menuItem.setVisible(((CustomAction)menuItem.getAction()).isRelevantToSelection());
                        menuItem.getAction().addPropertyChangeListener(new PropertyChangeListener(){

                            @Override
                            public void propertyChange(PropertyChangeEvent evt) {
                                if (evt.getPropertyName().equals("RelevantToSelection")) {
                                    menuItem.setVisible(((CustomAction)menuItem.getAction()).isRelevantToSelection());
                                }
                            }
                        });
                    }
                }
            });
        }

        @Override
        protected void dash() {
            ((JPopupMenu)this.getComponent()).addSeparator();
        }
    }

    private final class MenuAssembler
    extends AbstractMenuAssembler {
        protected MenuAssembler(JMenu component) {
            super(component);
        }

        @Override
        protected void dash() {
            ((JMenu)this.getComponent()).addSeparator();
        }
    }

    private abstract class AbstractMenuAssembler
    extends ListTokeniserTemplate {
        protected AbstractMenuAssembler(JComponent component) {
            super(component);
            new MnemonicHeuristics(component);
        }

        @Override
        protected void token(String menuItemKey) {
            final JMenuItem menuItem = new JMenuItem(){

                @Override
                public Dimension getPreferredSize() {
                    Dimension d = super.getPreferredSize();
                    d.height = (int)((double)d.height * 0.9);
                    return d;
                }
            };
            ConsoleUI.this.m_actionTable.setAction(menuItem, menuItemKey);
            final Icon icon = menuItem.getIcon();
            final Icon rolloverIcon = (Icon)menuItem.getAction().getValue("RolloverIcon");
            menuItem.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    menuItem.setIcon(menuItem.isArmed() ? rolloverIcon : icon);
                }
            });
            this.getComponent().add(menuItem);
        }
    }

    private abstract class ListTokeniserTemplate {
        private final JComponent m_component;

        protected ListTokeniserTemplate(JComponent component) {
            this.m_component = component;
        }

        public void populate(String key) {
            String tokens = ConsoleUI.this.m_resources.getString(key);
            ArrayList<Object> tokenList = Collections.list(new StringTokenizer(tokens));
            for (Object e : tokenList) {
                if ("-".equals(e)) {
                    this.dash();
                    continue;
                }
                if (">".equals(e)) {
                    this.greaterThan();
                    continue;
                }
                this.token((String)e);
            }
        }

        protected final JComponent getComponent() {
            return this.m_component;
        }

        protected void dash() {
        }

        protected void greaterThan() {
        }

        protected abstract void token(String var1);
    }

    private final class LookAndFeelListener
    extends LookAndFeel.ComponentListener {
        private LookAndFeelListener() {
            super(ConsoleUI.this.m_frame);
        }

        @Override
        public void lookAndFeelChanged() {
            ConsoleUI.this.m_frame.setVisible(false);
            try {
                ConsoleUI.this.m_frameBounds.store();
            }
            catch (ConsoleException e) {
                ConsoleUI.this.getErrorHandler().handleException((Throwable)e);
            }
            super.lookAndFeelChanged();
            ConsoleUI.this.m_frameBounds.restore();
            ConsoleUI.this.m_frame.setVisible(true);
        }
    }
}

