/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.console.swingui;

import java.io.File;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import net.grinder.console.editor.Buffer;
import net.grinder.console.editor.EditorModel;
import net.grinder.console.swingui.FileTree;
import net.grinder.util.WeakValueHashMap;

final class BufferTreeModel
implements TreeModel {
    private final EditorModel m_editorModel;
    private final Object m_rootNode = new Object();
    private final EventListenerList m_listeners = new EventListenerList();
    private final WeakValueHashMap<Buffer, BufferNode> m_buffersToNodes = new WeakValueHashMap();
    private BufferNode[] m_bufferNodes = new BufferNode[0];

    BufferTreeModel(EditorModel editorModel) {
        this.m_editorModel = editorModel;
        this.m_editorModel.addListener((EditorModel.Listener)new EditorModel.AbstractListener(){

            public void bufferAdded(Buffer buffer) {
                BufferTreeModel.this.bufferListChanged();
            }

            public void bufferRemoved(Buffer buffer) {
                BufferTreeModel.this.bufferListChanged();
            }
        });
        this.bufferListChanged();
    }

    private void bufferListChanged() {
        Buffer[] buffers = this.m_editorModel.getBuffers();
        this.m_bufferNodes = new BufferNode[buffers.length];
        this.m_buffersToNodes.clear();
        for (int i = 0; i < buffers.length; ++i) {
            this.m_bufferNodes[i] = new BufferNode(buffers[i]);
            this.m_buffersToNodes.put((Object)buffers[i], (Object)this.m_bufferNodes[i]);
        }
        this.fireTreeStructureChanged();
    }

    @Override
    public Object getRoot() {
        return this.m_rootNode;
    }

    @Override
    public Object getChild(Object parent, int index) {
        if (parent.equals(this.getRoot()) && index >= 0 && index < this.m_bufferNodes.length) {
            return this.m_bufferNodes[index];
        }
        return null;
    }

    @Override
    public int getChildCount(Object parent) {
        if (parent.equals(this.getRoot())) {
            return this.m_bufferNodes.length;
        }
        return 0;
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (parent == null || child == null) {
            return -1;
        }
        if (parent.equals(this.getRoot())) {
            for (int i = 0; i < this.m_bufferNodes.length; ++i) {
                if (!child.equals(this.m_bufferNodes[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public boolean isLeaf(Object node) {
        BufferNode bufferNode;
        return node instanceof BufferNode && (bufferNode = (BufferNode)node).belongsToModel(this);
    }

    @Override
    public void addTreeModelListener(TreeModelListener listener) {
        this.m_listeners.add(TreeModelListener.class, listener);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener listener) {
        this.m_listeners.remove(TreeModelListener.class, listener);
    }

    private void fireTreeStructureChanged() {
        Object[] listeners = this.m_listeners.getListenerList();
        TreeModelEvent event = new TreeModelEvent((Object)this, new Object[]{this.getRoot()});
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            ((TreeModelListener)listeners[i + 1]).treeStructureChanged(event);
        }
    }

    private void fireTreeNodesChanged(TreePath path) {
        Object[] listeners = this.m_listeners.getListenerList();
        TreeModelEvent event = new TreeModelEvent((Object)this, path);
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            ((TreeModelListener)listeners[i + 1]).treeNodesChanged(event);
        }
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        this.fireTreeNodesChanged(path);
    }

    public void bufferChanged(Buffer buffer) {
        BufferNode node = (BufferNode)this.m_buffersToNodes.get((Object)buffer);
        if (node != null) {
            this.valueForPathChanged(node.getPath(), node);
        }
    }

    public final class BufferNode
    implements FileTree.Node {
        private final Buffer m_buffer;
        private final TreePath m_path;

        protected BufferNode(Buffer buffer) {
            this.m_buffer = buffer;
            this.m_path = new TreePath(new Object[]{BufferTreeModel.this.getRoot(), this});
        }

        public String toString() {
            return this.m_buffer.getDisplayName();
        }

        @Override
        public Buffer getBuffer() {
            return this.m_buffer;
        }

        @Override
        public TreePath getPath() {
            return this.m_path;
        }

        @Override
        public File getFile() {
            return this.getBuffer().getFile();
        }

        @Override
        public boolean canOpen() {
            return true;
        }

        boolean belongsToModel(BufferTreeModel model) {
            return BufferTreeModel.this == model;
        }
    }
}

