/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.tools.tcpproxy;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import net.grinder.common.GrinderBuild;
import net.grinder.util.html.HTMLDocument;
import net.grinder.util.html.HTMLElement;

final class HTTPResponse {
    private String m_status = "500 Internal Server Error";
    private final Map<String, String> m_responseHeaders = new HashMap<String, String>();
    private final StringBuilder m_responseBody = new StringBuilder();

    public HTTPResponse() {
        this.setHeader("Proxy-agent", GrinderBuild.getName());
    }

    public void setHeader(String key, String value) {
        this.m_responseHeaders.put(key, value);
    }

    public void setStatus(String status) {
        this.m_status = status;
    }

    public void setMessage(String title, HTMLElement text) {
        this.setHeader("Content-Type", "text/html");
        this.setHeader("Connection", "close");
        HTMLDocument document = new HTMLDocument();
        document.getHead().addElement("title").addText(title);
        document.getBody().addElement("h1").addText(title);
        document.getBody().addText(text.toHTML());
        document.getBody().addElement("hr");
        document.getBody().addText(GrinderBuild.getName());
        document.getBody().addElement("br");
        document.getBody().addText(new Date().toString());
        this.m_responseBody.append(document.toHTML());
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("HTTP/1.0 ");
        result.append(this.m_status);
        result.append("\r\n");
        for (Map.Entry<String, String> header : this.m_responseHeaders.entrySet()) {
            result.append(header.getKey());
            result.append(": ");
            result.append(header.getValue());
            result.append("\r\n");
        }
        result.append("\r\n");
        result.append((CharSequence)this.m_responseBody);
        return result.toString();
    }
}

