/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.tools.tcpproxy;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.grinder.common.GrinderBuild;
import net.grinder.common.UncheckedInterruptedException;
import net.grinder.tools.tcpproxy.AbstractFilterDecorator;
import net.grinder.tools.tcpproxy.AbstractTCPProxyEngine;
import net.grinder.tools.tcpproxy.ConnectionDetails;
import net.grinder.tools.tcpproxy.EndPoint;
import net.grinder.tools.tcpproxy.HTTPMethodAbsoluteURIFilterDecorator;
import net.grinder.tools.tcpproxy.HTTPMethodRelativeURIFilterDecorator;
import net.grinder.tools.tcpproxy.HTTPResponse;
import net.grinder.tools.tcpproxy.TCPProxyFilter;
import net.grinder.tools.tcpproxy.TCPProxySSLSocketFactory;
import net.grinder.tools.tcpproxy.TCPProxySocketFactoryImplementation;
import net.grinder.tools.tcpproxy.VerboseConnectException;
import net.grinder.util.StreamCopier;
import net.grinder.util.html.HTMLElement;
import net.grinder.util.thread.InterruptibleRunnable;
import org.slf4j.Logger;

public final class HTTPProxyTCPProxyEngine
extends AbstractTCPProxyEngine {
    private static final long s_connectTimeout = Long.getLong("tcpproxy.connecttimeout", 5000L);
    private final Pattern m_httpConnectPattern;
    private final Pattern m_httpsConnectPattern;
    private final DelegateSSLEngine m_delegateSSLEngine;
    private final Thread m_delegateSSLEngineThread;
    private final EndPoint m_chainedHTTPProxy;
    private final EndPoint m_proxyAddress;

    public HTTPProxyTCPProxyEngine(TCPProxySSLSocketFactory sslSocketFactory, TCPProxyFilter requestFilter, TCPProxyFilter responseFilter, PrintWriter output, Logger logger, EndPoint localEndPoint, boolean useColour, int timeout, EndPoint chainedHTTPProxy, EndPoint chainedHTTPSProxy) throws IOException, PatternSyntaxException {
        super(new TCPProxySocketFactoryImplementation(), requestFilter, responseFilter, output, logger, localEndPoint, useColour, timeout);
        this.m_proxyAddress = localEndPoint;
        this.m_chainedHTTPProxy = chainedHTTPProxy;
        this.m_httpConnectPattern = Pattern.compile("^([A-Z]+)[ \\t]+http://([^/:]+):?(\\d*)/.*\r\n\r\n", 32);
        this.m_httpsConnectPattern = Pattern.compile("^CONNECT[ \\t]+([^:]+):(\\d+).*\r\n\r\n", 32);
        this.m_delegateSSLEngine = new DelegateSSLEngine(sslSocketFactory, this.getRequestFilter(), this.getResponseFilter(), output, logger, useColour, chainedHTTPSProxy);
        this.m_delegateSSLEngineThread = new Thread((Runnable)this.m_delegateSSLEngine, "Delegate HTTPS engine");
    }

    @Override
    public void run() {
        this.m_delegateSSLEngineThread.start();
        byte[] buffer = new byte[40960];
        block6: while (!this.isStopped()) {
            Socket localSocket;
            try {
                localSocket = this.accept();
            }
            catch (IOException e) {
                UncheckedInterruptedException.ioException((IOException)e);
                this.logIOException(e);
                continue;
            }
            try {
                BufferedInputStream in = new BufferedInputStream(localSocket.getInputStream(), buffer.length);
                in.mark(buffer.length);
                int time = 0;
                while (true) {
                    if ((long)time < s_connectTimeout && in.available() == 0) {
                        HTTPProxyTCPProxyEngine.sleep(10);
                        time += 10;
                        continue;
                    }
                    boolean timeout = in.available() == 0;
                    in.reset();
                    int bytesRead = in.available() > 0 ? in.read(buffer) : 0;
                    String bufferAsString = new String(buffer, 0, bytesRead, "US-ASCII");
                    if (timeout) {
                        HTMLElement message = new HTMLElement();
                        message.addElement("p").addText("Failed to determine proxy destination.");
                        if (bufferAsString.length() > 0) {
                            HTMLElement paragraph1 = message.addElement("p");
                            paragraph1.addText("Do not type TCPProxy address into your browser. ");
                            paragraph1.addText("The browser proxy settings should be set to the TCPProxy address (");
                            paragraph1.addElement("code").addText(this.m_proxyAddress.toString());
                            paragraph1.addText("), and you should type the address of the target server into the browser.");
                            message.addElement("p").addText("Text of received message follows:");
                            message.addElement("p").addElement("pre").addElement("blockquote").addText(bufferAsString);
                        } else {
                            message.addElement("p").addText("Client opened connection but sent no bytes.");
                        }
                        this.sendHTTPErrorResponse(message, "400 Bad Request", localSocket.getOutputStream());
                        localSocket.close();
                        continue block6;
                    }
                    Matcher httpConnectMatcher = this.m_httpConnectPattern.matcher(bufferAsString);
                    Matcher httpsConnectMatcher = this.m_httpsConnectPattern.matcher(bufferAsString);
                    if (httpConnectMatcher.find()) {
                        in.reset();
                        new AbstractTCPProxyEngine.StreamThread(new HTTPProxyStreamDemultiplexer(in, localSocket, EndPoint.clientEndPoint(localSocket)), "HTTPProxyStreamDemultiplexer for " + localSocket, in).start();
                        continue block6;
                    }
                    if (httpsConnectMatcher.find()) {
                        EndPoint remoteEndPoint = new EndPoint(httpsConnectMatcher.group(1), Integer.parseInt(httpsConnectMatcher.group(2)));
                        OutputStream out = localSocket.getOutputStream();
                        this.m_delegateSSLEngine.prepareNewConnection(in, out, EndPoint.clientEndPoint(localSocket), remoteEndPoint);
                        Socket sslProxySocket = this.getSocketFactory().createClientSocket(this.m_delegateSSLEngine.getListenEndPoint());
                        new AbstractTCPProxyEngine.StreamThread(new StreamCopier(4096, true).getInterruptibleRunnable((InputStream)in, sslProxySocket.getOutputStream()), "Copy to proxy engine for " + remoteEndPoint, in).start();
                        new AbstractTCPProxyEngine.StreamThread(new StreamCopier(4096, true).getInterruptibleRunnable(sslProxySocket.getInputStream(), out), "Copy from proxy engine for " + remoteEndPoint, sslProxySocket.getInputStream()).start();
                        continue block6;
                    }
                    if (bytesRead == buffer.length) break;
                }
                while (in.available() > 0) {
                    in.read(buffer);
                }
                HTMLElement message = new HTMLElement();
                message.addElement("p").addText("Buffer overflow - failed to match HTTP message after " + buffer.length + " bytes");
                this.sendHTTPErrorResponse(message, "400 Bad Request", localSocket.getOutputStream());
            }
            catch (IOException e) {
                UncheckedInterruptedException.ioException((IOException)e);
                this.logIOException(e);
                try {
                    localSocket.close();
                }
                catch (IOException closeException) {
                    throw new AssertionError((Object)closeException);
                }
            }
        }
    }

    @Override
    public void stop() {
        super.stop();
        this.m_delegateSSLEngine.stop();
        try {
            this.m_delegateSSLEngineThread.join();
        }
        catch (InterruptedException e) {
            throw new UncheckedInterruptedException(e);
        }
    }

    private void sendHTTPErrorResponse(HTMLElement message, String status, OutputStream outputStream) throws IOException {
        this.getLogger().error(message.toText());
        HTTPResponse response = new HTTPResponse();
        response.setStatus(status);
        response.setMessage(status, message);
        outputStream.write(response.toString().getBytes("US-ASCII"));
    }

    private static void sleep(int milliseconds) {
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException e) {
            throw new UncheckedInterruptedException(e);
        }
    }

    private static final class DelegateSSLEngine
    extends AbstractTCPProxyEngine {
        private final TCPProxySSLSocketFactory m_sslSocketFactory;
        private final Pattern m_httpsProxyResponsePattern;
        private final ProxySSLContextFactory m_proxySSLContextFactory;
        private final BlockingQueue<ConnectionState> m_nextConnection = new SynchronousQueue<ConnectionState>();

        DelegateSSLEngine(TCPProxySSLSocketFactory sslSocketFactory, TCPProxyFilter requestFilter, TCPProxyFilter responseFilter, PrintWriter output, Logger logger, boolean useColour, EndPoint chainedHTTPSProxy) throws IOException {
            super(sslSocketFactory, requestFilter, responseFilter, output, logger, new EndPoint(InetAddress.getByName(null), 0), useColour, 0);
            this.m_sslSocketFactory = sslSocketFactory;
            this.m_httpsProxyResponsePattern = Pattern.compile("^HTTP.*? (\\d+) .*", 32);
            this.m_proxySSLContextFactory = chainedHTTPSProxy != null ? new HTTPSProxyContextFactory(chainedHTTPSProxy) : new SimpleContextFactory();
        }

        public void prepareNewConnection(BufferedInputStream in, OutputStream out, EndPoint clientEndPoint, EndPoint remoteEndPoint) throws IOException {
            this.getLogger().debug("prepareNewConnection for {} -> {}", (Object)clientEndPoint, (Object)remoteEndPoint);
            ProxySSLContext proxySSLContext = this.m_proxySSLContextFactory.prepareConnection(in, out);
            try {
                this.m_nextConnection.put(new ConnectionState(clientEndPoint, remoteEndPoint, proxySSLContext));
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException(e.getMessage());
            }
        }

        @Override
        public void run() {
            while (true) {
                Socket localSocket;
                ConnectionState connection;
                try {
                    connection = this.m_nextConnection.take();
                }
                catch (InterruptedException e1) {
                    throw new UncheckedInterruptedException(e1);
                }
                try {
                    localSocket = this.accept();
                }
                catch (IOException e) {
                    UncheckedInterruptedException.ioException((IOException)e);
                    if (this.isStopped()) break;
                    this.logIOException(e);
                    continue;
                }
                EndPoint clientEndPoint = connection.getClientEndPoint();
                EndPoint remoteEndPoint = connection.getRemoteEndPoint();
                ProxySSLContext proxySSLContext = connection.getProxySSLContext();
                this.getLogger().debug("Creating connection threads for {} -> {}", (Object)clientEndPoint, (Object)remoteEndPoint);
                try {
                    this.launchThreadPair(localSocket, proxySSLContext.createProxyClientSocket(remoteEndPoint), clientEndPoint, remoteEndPoint, true);
                    proxySSLContext.sendResponse();
                    this.getLogger().debug("Flushed response to {}", (Object)clientEndPoint);
                }
                catch (IOException e) {
                    UncheckedInterruptedException.ioException((IOException)e);
                    if (this.isStopped()) break;
                    this.logIOException(e);
                    try {
                        localSocket.close();
                    }
                    catch (IOException closeException) {
                        throw new AssertionError((Object)closeException);
                    }
                }
            }
        }

        @Override
        public void stop() {
            super.stop();
            this.m_nextConnection.offer(new ConnectionState(null, null, null));
        }

        private final class HTTPSProxyContextFactory
        implements ProxySSLContextFactory {
            private final EndPoint m_httpsProxy;

            public HTTPSProxyContextFactory(EndPoint chainedHTTPSProxy) {
                this.m_httpsProxy = chainedHTTPSProxy;
            }

            @Override
            public ProxySSLContext prepareConnection(BufferedInputStream in, final OutputStream out) throws IOException {
                Socket socket;
                in.reset();
                try {
                    socket = new Socket(this.m_httpsProxy.getHost(), this.m_httpsProxy.getPort());
                }
                catch (ConnectException e) {
                    throw new VerboseConnectException(e, "HTTPS proxy " + this.m_httpsProxy);
                }
                do {
                    String statusCode;
                    BufferedOutputStream proxyRequest = new BufferedOutputStream(socket.getOutputStream());
                    byte[] buffer = new byte[1024];
                    InputStream proxyResponse = socket.getInputStream();
                    while (in.available() > 0) {
                        int n = in.read(buffer);
                        if (n <= 0) continue;
                        ((OutputStream)proxyRequest).write(buffer, 0, n);
                    }
                    ((OutputStream)proxyRequest).flush();
                    int i = 0;
                    while ((long)i < s_connectTimeout && proxyResponse.available() == 0) {
                        HTTPProxyTCPProxyEngine.sleep(10);
                        i += 10;
                    }
                    if (proxyResponse.available() == 0) {
                        throw new IOException("HTTPS proxy " + this.m_httpsProxy + " failed to respond after " + s_connectTimeout + " ms");
                    }
                    ByteArrayOutputStream responseBytes = new ByteArrayOutputStream();
                    while (proxyResponse.available() > 0) {
                        int n = proxyResponse.read(buffer);
                        if (n <= 0) continue;
                        responseBytes.write(buffer, 0, n);
                    }
                    final byte[] bytesRead = responseBytes.toByteArray();
                    String bufferAsString = new String(bytesRead, "US-ASCII");
                    Matcher statusCodeMatcher = DelegateSSLEngine.this.m_httpsProxyResponsePattern.matcher(bufferAsString);
                    if (statusCodeMatcher.find() && "200".equals(statusCode = statusCodeMatcher.group(1))) {
                        return new ProxySSLContext(){

                            @Override
                            public void sendResponse() throws IOException {
                                out.write(bytesRead);
                                out.flush();
                            }

                            @Override
                            public Socket createProxyClientSocket(EndPoint remoteEndPoint) throws IOException {
                                return DelegateSSLEngine.this.m_sslSocketFactory.createClientSocket(socket, remoteEndPoint);
                            }
                        };
                    }
                    DelegateSSLEngine.this.getLogger().debug("Non-200 response from delegate HTTPS proxy, returning to browser\n{}", (Object)bufferAsString);
                    out.write(bytesRead);
                    out.flush();
                    int i2 = 0;
                    while ((long)i2 < s_connectTimeout && in.available() == 0) {
                        HTTPProxyTCPProxyEngine.sleep(10);
                        i2 += 10;
                    }
                } while (in.available() != 0);
                throw new IOException("Timed out waiting for browser after " + s_connectTimeout + " ms");
            }
        }

        private final class SimpleContextFactory
        implements ProxySSLContextFactory {
            private SimpleContextFactory() {
            }

            @Override
            public ProxySSLContext prepareConnection(BufferedInputStream in, final OutputStream out) throws IOException {
                return new ProxySSLContext(){

                    @Override
                    public void sendResponse() throws IOException {
                        StringBuilder response = new StringBuilder();
                        response.append("HTTP/1.0 200 OK\r\n");
                        response.append("Proxy-agent: The Grinder/");
                        response.append(GrinderBuild.getVersionString());
                        response.append("\r\n");
                        response.append("\r\n");
                        out.write(response.toString().getBytes());
                        out.flush();
                    }

                    @Override
                    public Socket createProxyClientSocket(EndPoint remoteEndPoint) throws IOException {
                        return DelegateSSLEngine.this.getSocketFactory().createClientSocket(remoteEndPoint);
                    }
                };
            }
        }
    }

    private static class ConnectionState {
        private final EndPoint m_clientEndPoint;
        private final EndPoint m_remoteEndPoint;
        private final ProxySSLContext m_proxySSLContext;

        public ConnectionState(EndPoint clientEndPoint, EndPoint remoteEndPoint, ProxySSLContext proxySSLContext) {
            this.m_clientEndPoint = clientEndPoint;
            this.m_remoteEndPoint = remoteEndPoint;
            this.m_proxySSLContext = proxySSLContext;
        }

        public EndPoint getClientEndPoint() {
            return this.m_clientEndPoint;
        }

        public EndPoint getRemoteEndPoint() {
            return this.m_remoteEndPoint;
        }

        public ProxySSLContext getProxySSLContext() {
            return this.m_proxySSLContext;
        }
    }

    private static interface ProxySSLContextFactory {
        public ProxySSLContext prepareConnection(BufferedInputStream var1, OutputStream var2) throws IOException;
    }

    private static interface ProxySSLContext {
        public void sendResponse() throws IOException;

        public Socket createProxyClientSocket(EndPoint var1) throws IOException;
    }

    private final class HTTPProxyStreamDemultiplexer
    implements InterruptibleRunnable {
        private final InputStream m_in;
        private final Socket m_localSocket;
        private final EndPoint m_clientEndPoint;
        private final Map<String, AbstractTCPProxyEngine.OutputStreamFilterTee> m_remoteStreamMap = new HashMap<String, AbstractTCPProxyEngine.OutputStreamFilterTee>();
        private AbstractTCPProxyEngine.OutputStreamFilterTee m_lastRemoteStream;

        HTTPProxyStreamDemultiplexer(InputStream in, Socket localSocket, EndPoint clientEndPoint) {
            this.m_in = in;
            this.m_localSocket = localSocket;
            this.m_clientEndPoint = clientEndPoint;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void interruptibleRun() {
            byte[] buffer = new byte[40960];
            try {
                int bytesRead;
                while ((bytesRead = this.m_in.read(buffer)) != -1) {
                    String bytesReadAsString = new String(buffer, 0, bytesRead, "US-ASCII");
                    Matcher matcher = HTTPProxyTCPProxyEngine.this.m_httpConnectPattern.matcher(bytesReadAsString);
                    if (matcher.find()) {
                        String remoteHost = matcher.group(2);
                        int remotePort = 80;
                        try {
                            remotePort = Integer.parseInt(matcher.group(3));
                        }
                        catch (NumberFormatException e) {
                            // empty catch block
                        }
                        EndPoint remoteEndPoint = new EndPoint(remoteHost, remotePort);
                        String key = remoteEndPoint.toString();
                        this.m_lastRemoteStream = this.m_remoteStreamMap.get(key);
                        if (this.m_lastRemoteStream == null) {
                            AbstractFilterDecorator requestFilter;
                            Socket remoteSocket;
                            if (HTTPProxyTCPProxyEngine.this.m_chainedHTTPProxy != null) {
                                remoteSocket = HTTPProxyTCPProxyEngine.this.getSocketFactory().createClientSocket(HTTPProxyTCPProxyEngine.this.m_chainedHTTPProxy);
                                requestFilter = new HTTPMethodAbsoluteURIFilterDecorator(new HTTPMethodRelativeURIFilterDecorator(HTTPProxyTCPProxyEngine.this.getRequestFilter()), remoteEndPoint);
                            } else {
                                remoteSocket = HTTPProxyTCPProxyEngine.this.getSocketFactory().createClientSocket(remoteEndPoint);
                                requestFilter = new HTTPMethodRelativeURIFilterDecorator(HTTPProxyTCPProxyEngine.this.getRequestFilter());
                            }
                            ConnectionDetails connectionDetails = new ConnectionDetails(this.m_clientEndPoint, remoteEndPoint, false);
                            this.m_lastRemoteStream = new AbstractTCPProxyEngine.OutputStreamFilterTee(connectionDetails, remoteSocket.getOutputStream(), requestFilter, HTTPProxyTCPProxyEngine.this.getRequestColour());
                            this.m_lastRemoteStream.connectionOpened();
                            this.m_remoteStreamMap.put(key, this.m_lastRemoteStream);
                            new AbstractTCPProxyEngine.FilteredStreamThread(remoteSocket.getInputStream(), new AbstractTCPProxyEngine.OutputStreamFilterTee(connectionDetails.getOtherEnd(), this.m_localSocket.getOutputStream(), HTTPProxyTCPProxyEngine.this.getResponseFilter(), HTTPProxyTCPProxyEngine.this.getResponseColour()));
                        }
                    } else if (this.m_lastRemoteStream == null) {
                        throw new AssertionError((Object)"No last stream");
                    }
                    this.m_lastRemoteStream.handle(buffer, bytesRead);
                }
            }
            catch (IOException e) {
                UncheckedInterruptedException.ioException((IOException)e);
                String description = HTTPProxyTCPProxyEngine.this.logIOException(e);
                HTMLElement message = new HTMLElement();
                message.addElement("p").addText(description);
                try {
                    HTTPProxyTCPProxyEngine.this.sendHTTPErrorResponse(message, "502 Bad Gateway", this.m_localSocket.getOutputStream());
                }
                catch (IOException e2) {
                    UncheckedInterruptedException.ioException((IOException)e2);
                }
            }
            finally {
                for (AbstractTCPProxyEngine.OutputStreamFilterTee s : this.m_remoteStreamMap.values()) {
                    s.connectionClosed();
                }
                try {
                    this.m_localSocket.close();
                }
                catch (IOException e) {
                    UncheckedInterruptedException.ioException((IOException)e);
                }
            }
        }
    }
}

