/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.tools.tcpproxy;

import java.io.PrintWriter;
import net.grinder.tools.tcpproxy.ConnectionDetails;
import net.grinder.tools.tcpproxy.TCPProxyFilter;

public class EchoFilter
implements TCPProxyFilter {
    private final PrintWriter m_out;

    public EchoFilter(PrintWriter output) {
        this.m_out = output;
    }

    @Override
    public byte[] handle(ConnectionDetails connectionDetails, byte[] buffer, int bytesRead) throws TCPProxyFilter.FilterException {
        StringBuilder stringBuffer = new StringBuilder();
        boolean inHex = false;
        for (int i = 0; i < bytesRead; ++i) {
            int value = buffer[i] & 0xFF;
            if (value == 13 || value == 10 || value >= 32 && value <= 126) {
                if (inHex) {
                    stringBuffer.append(']');
                    inHex = false;
                }
                stringBuffer.append((char)value);
                continue;
            }
            if (!inHex) {
                stringBuffer.append('[');
                inHex = true;
            }
            if (value <= 15) {
                stringBuffer.append("0");
            }
            stringBuffer.append(Integer.toHexString(value).toUpperCase());
        }
        this.m_out.println("------ " + connectionDetails + " ------");
        this.m_out.println(stringBuffer);
        return null;
    }

    @Override
    public void connectionOpened(ConnectionDetails connectionDetails) {
        this.m_out.println("--- " + connectionDetails + " opened --");
    }

    @Override
    public void connectionClosed(ConnectionDetails connectionDetails) {
        this.m_out.println("--- " + connectionDetails + " closed --");
    }
}

