/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.plugin.http.tcpproxyfilter;

import HTTPClient.Codecs;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public final class XSLTHelper {
    private static int s_indentLevel;
    private static String s_indentString;

    XSLTHelper() {
        throw new UnsupportedOperationException();
    }

    public static String formatTime(String iso8601) throws ParseException {
        Date date = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss").parse(iso8601);
        return DateFormat.getDateTimeInstance().format(date);
    }

    public static String quoteForPython(String value) {
        if (value == null) {
            return "None";
        }
        StringBuilder result = new StringBuilder();
        String quotes = XSLTHelper.pythonQuotes(value);
        result.append(quotes).append(XSLTHelper.escape(value, false)).append(quotes);
        return result.toString();
    }

    private static String pythonQuotes(String s) {
        return s.indexOf("\n") > -1 || s.indexOf("\r") > -1 ? "'''" : "'";
    }

    public static String quoteEOLEscapedStringForPython(String value) {
        if (value == null) {
            return "None";
        }
        StringBuilder result = new StringBuilder();
        String quotes = XSLTHelper.pythonQuotes(value);
        result.append(quotes).append(XSLTHelper.escape(value, true)).append(quotes);
        return result.toString();
    }

    public static String quoteForClojure(String value) {
        if (value == null) {
            return "nil";
        }
        StringBuilder result = new StringBuilder();
        result.append('\"').append(XSLTHelper.escape(value, false)).append('\"');
        return result.toString();
    }

    public static String quoteEOLEscapedStringForClojure(String value) {
        if (value == null) {
            return "nil";
        }
        StringBuilder result = new StringBuilder();
        result.append('\"').append(XSLTHelper.escape(value, true)).append('\"');
        return result.toString();
    }

    public static String summariseAsLine(String value, int maximumCharacters) {
        StringBuilder result = new StringBuilder(value.length());
        if (value.length() > maximumCharacters) {
            result.append(value.substring(0, maximumCharacters));
            result.append("...");
        } else {
            result.append(value);
        }
        for (int i = 0; i < result.length(); ++i) {
            char c = result.charAt(i);
            if (c == '\t') {
                result.replace(i, i + 1, "\\t");
                continue;
            }
            if (c == '\r') {
                result.replace(i, i + 1, "\\r");
                continue;
            }
            if (c == '\n') {
                result.replace(i, i + 1, "\\n");
                continue;
            }
            if (!Character.isISOControl(c)) continue;
            result.setCharAt(i, '.');
        }
        return result.toString();
    }

    public static String escape(String value) {
        return XSLTHelper.escape(value, false);
    }

    private static String escape(String value, boolean preserveEOLQuotes) {
        int valueLength = value.length();
        StringBuilder result = new StringBuilder(valueLength);
        block6: for (int i = 0; i < valueLength; ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '\\': {
                    char nextCharacter;
                    if (preserveEOLQuotes && i + 1 < valueLength && ((nextCharacter = value.charAt(i + 1)) == 'n' || nextCharacter == 'r')) {
                        result.append(c);
                        continue block6;
                    }
                    result.append('\\');
                    result.append(c);
                    continue block6;
                }
                case '\"': 
                case '\'': {
                    result.append('\\');
                    result.append(c);
                    continue block6;
                }
                case '\n': {
                    if (preserveEOLQuotes) continue block6;
                    result.append(c);
                    continue block6;
                }
                case '\r': {
                    if (preserveEOLQuotes) continue block6;
                    result.append("\\r");
                    continue block6;
                }
                default: {
                    result.append(c);
                }
            }
        }
        return result.toString();
    }

    public static String indent() {
        StringBuilder result = new StringBuilder(Math.max(0, s_indentString.length() * s_indentLevel));
        for (int i = 0; i < s_indentLevel; ++i) {
            result.append(s_indentString);
        }
        return result.toString();
    }

    public static String newLine() {
        return "\n";
    }

    public static String newLineAndIndent() {
        return XSLTHelper.newLine() + XSLTHelper.indent();
    }

    public static String changeIndent(int indentChange) {
        s_indentLevel += indentChange;
        return "";
    }

    public static String resetIndent() {
        s_indentLevel = 0;
        return "";
    }

    public static String base64ToPython(String base64String) {
        byte[] base64 = base64String.getBytes();
        StringBuilder result = new StringBuilder(base64.length * 2);
        result.append('\"');
        if (base64.length > 0) {
            byte[] bytes = Codecs.base64Decode((byte[])base64);
            for (int i = 0; i < bytes.length; ++i) {
                int b;
                if (i > 0 && i % 16 == 0) {
                    result.append('\"');
                    result.append(XSLTHelper.newLineAndIndent());
                    result.append('\"');
                }
                int n = b = bytes[i] < 0 ? 256 + bytes[i] : bytes[i];
                if (b <= 15) {
                    result.append("\\x0");
                } else {
                    result.append("\\x");
                }
                result.append(Integer.toHexString(b).toUpperCase());
            }
        }
        result.append('\"');
        return result.toString();
    }

    public static String base64ToClojure(String base64String) {
        byte[] base64 = base64String.getBytes();
        StringBuilder result = new StringBuilder(base64.length * 2);
        result.append('[');
        if (base64.length > 0) {
            byte[] bytes = Codecs.base64Decode((byte[])base64);
            for (int i = 0; i < bytes.length; ++i) {
                int b;
                if (i % 16 == 0) {
                    if (i > 0) {
                        result.append(XSLTHelper.newLineAndIndent());
                    }
                } else {
                    result.append(" ");
                }
                int n = b = bytes[i] < 0 ? 256 + bytes[i] : bytes[i];
                if (b <= 15) {
                    result.append("0x0");
                } else {
                    result.append("0x");
                }
                result.append(Integer.toHexString(b).toUpperCase());
            }
        }
        result.append(']');
        return result.toString();
    }

    public static void setIndentString(String indentString) {
        s_indentString = indentString;
    }

    static {
        s_indentString = "  ";
    }
}

