/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.plugin.http.tcpproxyfilter;

import java.util.regex.Pattern;
import net.grinder.plugin.http.tcpproxyfilter.RegularExpressions;

public final class RegularExpressionsImplementation
implements RegularExpressions {
    private final Pattern m_basicAuthorizationHeaderPattern;
    private final Pattern m_headerPattern;
    private final Pattern m_messageBodyPattern;
    private final Pattern m_requestLinePattern = Pattern.compile("^([A-Z]+)[ \\t]+(?:https?://[^/]+)?(.+)[ \\t]+HTTP/\\d.\\d[ \\t]*\\r?\\n", 9);
    private final Pattern m_responseLinePattern = Pattern.compile("^HTTP/\\d.\\d[ \\t]+(\\d+)[ \\t]+(.*)[ \\t]*\\r?\\n");
    private final Pattern m_lastPathElementPathPattern;
    private final Pattern m_hrefURIPattern;
    private final Pattern m_inputPattern;
    private final Pattern m_hiddenInputPattern;

    public RegularExpressionsImplementation() {
        this.m_messageBodyPattern = Pattern.compile("\\r\\n\\r\\n(.*)", 32);
        this.m_headerPattern = Pattern.compile("^([^:\\r\\n]*)[ \\t]*:[ \\t]*(.*?)\\r?\\n", 9);
        this.m_basicAuthorizationHeaderPattern = Pattern.compile("^Authorization[ \\t]*:[ \\t]*Basic[ \\t]+([a-zA-Z0-9+/]*=*).*?\\r?\\n", 9);
        this.m_lastPathElementPathPattern = Pattern.compile("^[^\\?#]*/([^\\?;#]*)");
        this.m_hrefURIPattern = Pattern.compile("href[ \\t]*=[ \\t]*['\"]([^'\"]*)['\"]");
        this.m_inputPattern = Pattern.compile("<\\s*input\\s+.*?/?>", 34);
        this.m_hiddenInputPattern = Pattern.compile("<\\s*input\\s+.*?type\\s*=\\s*[\"']\\s*hidden\\s*[\"'].*?/?>", 34);
    }

    @Override
    public Pattern getRequestLinePattern() {
        return this.m_requestLinePattern;
    }

    @Override
    public Pattern getResponseLinePattern() {
        return this.m_responseLinePattern;
    }

    @Override
    public Pattern getMessageBodyPattern() {
        return this.m_messageBodyPattern;
    }

    @Override
    public Pattern getHeaderPattern() {
        return this.m_headerPattern;
    }

    @Override
    public Pattern getBasicAuthorizationHeaderPattern() {
        return this.m_basicAuthorizationHeaderPattern;
    }

    @Override
    public Pattern getLastPathElementPathPattern() {
        return this.m_lastPathElementPathPattern;
    }

    @Override
    public Pattern getHyperlinkURIPattern() {
        return this.m_hrefURIPattern;
    }

    @Override
    public Pattern getInputPattern() {
        return this.m_inputPattern;
    }

    @Override
    public Pattern getHiddenInputPattern() {
        return this.m_hiddenInputPattern;
    }
}

