/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.plugin.http.tcpproxyfilter;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.grinder.plugin.http.tcpproxyfilter.HTTPRecordingResultProcessor;
import net.grinder.plugin.http.xml.HttpRecordingDocument;
import org.slf4j.Logger;

public class ProcessHTTPRecordingWithXSLT
implements HTTPRecordingResultProcessor {
    public static final String STYLESHEET_NAME_PROPERTY = "transformHTTPRecordingToScript";
    private final TransformerFactory m_transformerFactory = TransformerFactory.newInstance();
    private final InputStream m_styleSheetInputStream;
    private final PrintWriter m_output;
    private final Logger m_logger;

    private ProcessHTTPRecordingWithXSLT(InputStream styleSheetInputStream, PrintWriter output, Logger logger) {
        this.m_styleSheetInputStream = styleSheetInputStream;
        this.m_output = output;
        this.m_logger = logger;
        this.m_transformerFactory.setErrorListener(new LoggingErrorListener());
    }

    public ProcessHTTPRecordingWithXSLT(PrintWriter output, Logger logger) {
        this(BuiltInStyleSheet.Jython, output, logger);
    }

    public ProcessHTTPRecordingWithXSLT(BuiltInStyleSheet styleSheet, PrintWriter output, Logger logger) {
        this(styleSheet.open(), output, logger);
    }

    public ProcessHTTPRecordingWithXSLT(StyleSheetFile styleSheet, PrintWriter output, Logger logger) {
        this(styleSheet.open(), output, logger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(HttpRecordingDocument result) throws IOException {
        try {
            Transformer transformer = this.m_transformerFactory.newTransformer(new StreamSource(this.m_styleSheetInputStream));
            transformer.setErrorListener(this.m_transformerFactory.getErrorListener());
            transformer.transform(new StAXSource(result.newXMLStreamReader()), new StreamResult(this.m_output));
            this.m_output.println();
        }
        catch (TransformerException transformerException) {
        }
        finally {
            this.m_styleSheetInputStream.close();
        }
    }

    public static final class StyleSheetFile {
        private final InputStream m_inputStream;

        public StyleSheetFile(File file) throws FileNotFoundException {
            this.m_inputStream = new FileInputStream(file);
        }

        InputStream open() {
            return this.m_inputStream;
        }
    }

    public static enum BuiltInStyleSheet {
        TraditionalJython("resources/httpToJythonScriptOldInstrumentation.xsl"),
        Jython("resources/httpToJythonScript.xsl"),
        Clojure("resources/httpToClojureScript.xsl");

        private final String m_resourceName;

        private BuiltInStyleSheet(String resourceName) {
            this.m_resourceName = resourceName;
        }

        InputStream open() {
            return ((Object)((Object)this)).getClass().getResourceAsStream(this.m_resourceName);
        }
    }

    private final class LoggingErrorListener
    implements ErrorListener {
        private LoggingErrorListener() {
        }

        private void logTransformerException(TransformerException e) {
            StringBuilder message = new StringBuilder(e.getMessage());
            if (e.getLocationAsString() != null) {
                message.append(" at ").append(e.getLocationAsString());
            }
            ProcessHTTPRecordingWithXSLT.this.m_logger.error(message.toString());
        }

        @Override
        public void warning(TransformerException e) throws TransformerException {
            this.logTransformerException(e);
        }

        @Override
        public void error(TransformerException e) throws TransformerException {
            this.logTransformerException(e);
            throw e;
        }

        @Override
        public void fatalError(TransformerException e) throws TransformerException {
            this.logTransformerException(e);
            throw e;
        }
    }
}

