/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.plugin.http.tcpproxyfilter;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.grinder.plugin.http.tcpproxyfilter.HTTPRecordingParameters;

public class ParametersFromProperties
implements HTTPRecordingParameters {
    private static final String COMMON_HEADERS = "Accept,Accept-Charset,Accept-Encoding,Accept-Language,Cache-Control,Faces-Request,faces-request,Referer,User-Agent";
    private static final String MIRRORED_HEADERS = "Content-Type,Content-type,If-Modified-Since,If-None-Match";
    private final Set<String> m_commonHeaders = new HashSet<String>();
    private final Set<String> m_mirroredHeaders = new HashSet<String>();

    private static List<String> parseHeaders(String s) {
        return Arrays.asList(s.split("\\s*,\\s*"));
    }

    public ParametersFromProperties() {
        String commonHeaders = System.getProperty("HTTPPlugin.commonHeaders", COMMON_HEADERS);
        String mirroredHeaders = System.getProperty("HTTPPlugin.mirroredHeaders", MIRRORED_HEADERS);
        String additionalHeaders = System.getProperty("HTTPPlugin.additionalHeaders", "");
        this.m_commonHeaders.addAll(ParametersFromProperties.parseHeaders(commonHeaders));
        this.m_commonHeaders.addAll(ParametersFromProperties.parseHeaders(additionalHeaders));
        this.m_mirroredHeaders.addAll(this.m_commonHeaders);
        this.m_mirroredHeaders.addAll(ParametersFromProperties.parseHeaders(mirroredHeaders));
    }

    @Override
    public int getTestNumberOffset() {
        String value = System.getProperty("HTTPPlugin.initialTest");
        if (value != null) {
            return Integer.parseInt(value);
        }
        return 0;
    }

    @Override
    public boolean isCommonHeader(String headerName) {
        return this.m_commonHeaders.contains(headerName);
    }

    @Override
    public boolean isMirroredHeader(String headerName) {
        return this.m_mirroredHeaders.contains(headerName);
    }
}

