/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.plugin.http.tcpproxyfilter;

import HTTPClient.ParseException;
import HTTPClient.URI;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.grinder.common.GrinderBuild;
import net.grinder.plugin.http.tcpproxyfilter.HTTPRecording;
import net.grinder.plugin.http.tcpproxyfilter.HTTPRecordingParameters;
import net.grinder.plugin.http.tcpproxyfilter.HTTPRecordingResultProcessor;
import net.grinder.plugin.http.tcpproxyfilter.IntGenerator;
import net.grinder.plugin.http.tcpproxyfilter.RegularExpressions;
import net.grinder.plugin.http.xml.BaseURIType;
import net.grinder.plugin.http.xml.CommonHeadersType;
import net.grinder.plugin.http.xml.HTTPRecordingType;
import net.grinder.plugin.http.xml.HeaderType;
import net.grinder.plugin.http.xml.HeadersType;
import net.grinder.plugin.http.xml.HttpRecordingDocument;
import net.grinder.plugin.http.xml.PageType;
import net.grinder.plugin.http.xml.ParsedURIPartType;
import net.grinder.plugin.http.xml.RelativeURIType;
import net.grinder.plugin.http.xml.RequestType;
import net.grinder.plugin.http.xml.ResponseType;
import net.grinder.plugin.http.xml.TokenReferenceType;
import net.grinder.plugin.http.xml.TokenType;
import net.grinder.tools.tcpproxy.ConnectionDetails;
import net.grinder.tools.tcpproxy.EndPoint;
import net.grinder.util.Pair;
import net.grinder.util.http.URIParser;
import org.apache.xmlbeans.XmlObject;
import org.picocontainer.Disposable;
import org.slf4j.Logger;

public class HTTPRecordingImplementation
implements HTTPRecording,
Disposable {
    private final HTTPRecordingParameters m_parameters;
    private final HttpRecordingDocument m_recordingDocument = HttpRecordingDocument.Factory.newInstance();
    private final Logger m_logger;
    private final HTTPRecordingResultProcessor m_resultProcessor;
    private final RegularExpressions m_regularExpressions;
    private final URIParser m_uriParser;
    private final IntGenerator m_bodyFileIDGenerator = new IntGenerator();
    private final BaseURLMap m_baseURLMap = new BaseURLMap();
    private final RequestList m_requestList = new RequestList();
    private final TokenMap m_tokenMap = new TokenMap();
    private long m_lastResponseTime = 0L;

    public HTTPRecordingImplementation(HTTPRecordingParameters parameters, HTTPRecordingResultProcessor resultProcessor, Logger logger, RegularExpressions regularExpressions, URIParser uriParser) {
        this.m_parameters = parameters;
        this.m_resultProcessor = resultProcessor;
        this.m_logger = logger;
        this.m_regularExpressions = regularExpressions;
        this.m_uriParser = uriParser;
        HTTPRecordingType.Metadata httpRecording = this.m_recordingDocument.addNewHttpRecording().addNewMetadata();
        httpRecording.setVersion("The Grinder " + GrinderBuild.getVersionString());
        httpRecording.setTime(Calendar.getInstance());
        httpRecording.setTestNumberOffset(this.m_parameters.getTestNumberOffset());
    }

    @Override
    public HTTPRecordingParameters getParameters() {
        return this.m_parameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RequestType addRequest(ConnectionDetails connectionDetails, String method, String relativeURI) {
        String element;
        String unescapedURI;
        RequestType request = this.m_requestList.add();
        request.setTime(Calendar.getInstance());
        HTTPRecordingImplementation hTTPRecordingImplementation = this;
        synchronized (hTTPRecordingImplementation) {
            long time;
            if (this.m_lastResponseTime > 0L && (time = System.currentTimeMillis() - this.m_lastResponseTime) > 10L) {
                request.setSleepTime(time);
            }
            this.m_lastResponseTime = 0L;
        }
        request.addNewHeaders();
        request.setMethod(RequestType.Method.Enum.forString((String)method));
        try {
            unescapedURI = URI.unescape((String)relativeURI, null);
        }
        catch (ParseException e) {
            unescapedURI = relativeURI;
        }
        Matcher lastPathElementMatcher = this.m_regularExpressions.getLastPathElementPathPattern().matcher(unescapedURI);
        String description = lastPathElementMatcher.find() ? ((element = lastPathElementMatcher.group(1)).trim().length() != 0 ? method + " " + element : method + " /") : method + " " + relativeURI;
        request.setDescription(description);
        RelativeURIType uri = request.addNewUri();
        uri.setUnparsed(unescapedURI);
        uri.setExtends(this.m_baseURLMap.getBaseURL(connectionDetails.isSecure() ? BaseURIType.Scheme.HTTPS : BaseURIType.Scheme.HTTP, connectionDetails.getRemoteEndPoint()).getUriId());
        final ParsedURIPartType parsedPath = uri.addNewPath();
        final ParsedURIPartType parsedQueryString = uri.addNewQueryString();
        final String[] fragment = new String[1];
        this.m_uriParser.parse(relativeURI, new URIParser.AbstractParseListener(){

            @Override
            public boolean path(String path) {
                parsedPath.addText(path);
                return true;
            }

            @Override
            public boolean pathParameterNameValue(String name, String value) {
                HTTPRecordingImplementation.this.setTokenReference(name, value, parsedPath.addNewTokenReference());
                return true;
            }

            @Override
            public boolean queryString(String queryString) {
                parsedQueryString.addText(queryString);
                return true;
            }

            @Override
            public boolean queryStringNameValue(String name, String value) {
                HTTPRecordingImplementation.this.setTokenReference(name, value, parsedQueryString.addNewTokenReference());
                return true;
            }

            @Override
            public boolean fragment(String theFragment) {
                fragment[0] = theFragment;
                return true;
            }
        });
        if (parsedQueryString.getTokenReferenceArray().length == 0 && parsedQueryString.getTextArray().length == 0) {
            uri.unsetQueryString();
        }
        if (fragment[0] != null) {
            uri.setFragment(fragment[0]);
        }
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markLastResponseTime() {
        HTTPRecordingImplementation hTTPRecordingImplementation = this;
        synchronized (hTTPRecordingImplementation) {
            this.m_lastResponseTime = System.currentTimeMillis();
        }
    }

    @Override
    public void setTokenReference(String name, String value, TokenReferenceType tokenReference) {
        this.m_tokenMap.add(name, value, tokenReference);
    }

    @Override
    public String getLastValueForToken(String name) {
        return this.m_tokenMap.getLastValue(name);
    }

    @Override
    public boolean tokenReferenceExists(String name, String source) {
        return this.m_tokenMap.exists(name, source);
    }

    @Override
    public File createBodyDataFileName() {
        return new File("http-data-" + this.m_bodyFileIDGenerator.next() + ".dat");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        HttpRecordingDocument result;
        HttpRecordingDocument httpRecordingDocument = this.m_recordingDocument;
        synchronized (httpRecordingDocument) {
            result = (HttpRecordingDocument)this.m_recordingDocument.copy();
        }
        HTTPRecordingType httpRecording = result.getHttpRecording();
        this.m_requestList.record(httpRecording);
        XmlObject[] requestXmlObjects = httpRecording.selectPath("declare namespace ns='http://grinder.sourceforge.net/tcpproxy/http/1.0';$this//ns:request");
        ArrayList<RequestType> requests = new ArrayList<RequestType>(requestXmlObjects.length);
        for (XmlObject o : requestXmlObjects) {
            requests.add((RequestType)o);
        }
        this.extractCommonHeaders(requests, httpRecording);
        CommonHeadersType[] commonHeaders = httpRecording.getCommonHeadersArray();
        ArrayList<HeadersType> defaultHeaderSources = new ArrayList<HeadersType>(commonHeaders.length);
        for (CommonHeadersType header : commonHeaders) {
            defaultHeaderSources.add((HeadersType)header);
        }
        for (RequestType request : requests) {
            HeadersType headers = request.getHeaders();
            if (headers.isSetExtends()) continue;
            defaultHeaderSources.add(headers);
        }
        Set<Pair<String, String>> defaultHeaders = HTTPRecordingImplementation.findSharedHeaders(defaultHeaderSources);
        if (defaultHeaders.size() > 0) {
            ArrayList<CommonHeadersType> newCommonHeaders = new ArrayList<CommonHeadersType>(commonHeaders.length + 1);
            CommonHeadersType defaultHeadersXML = CommonHeadersType.Factory.newInstance();
            defaultHeadersXML.setHeadersId("defaultHeaders");
            newCommonHeaders.add(defaultHeadersXML);
            for (Pair<String, String> defaultHeader : defaultHeaders) {
                HeaderType header = defaultHeadersXML.addNewHeader();
                header.setName((String)defaultHeader.getFirst());
                header.setValue((String)defaultHeader.getSecond());
            }
            String emptyCommonHeadersID = null;
            for (CommonHeadersType headers : commonHeaders) {
                HTTPRecordingImplementation.removeDefaultHeaders(defaultHeaders, defaultHeadersXML.getHeadersId(), (HeadersType)headers);
                if (headers.sizeOfHeaderArray() == 0) {
                    assert (emptyCommonHeadersID == null);
                    emptyCommonHeadersID = headers.getHeadersId();
                    continue;
                }
                newCommonHeaders.add(headers);
            }
            httpRecording.setCommonHeadersArray(newCommonHeaders.toArray(new CommonHeadersType[newCommonHeaders.size()]));
            for (RequestType request : requests) {
                HeadersType headers = request.getHeaders();
                if (!headers.isSetExtends()) {
                    HTTPRecordingImplementation.removeDefaultHeaders(defaultHeaders, defaultHeadersXML.getHeadersId(), headers);
                    continue;
                }
                if (!headers.getExtends().equals(emptyCommonHeadersID)) continue;
                headers.setExtends(defaultHeadersXML.getHeadersId());
            }
        }
        try {
            this.m_resultProcessor.process(result);
        }
        catch (IOException e) {
            this.m_logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void extractCommonHeaders(List<RequestType> requests, HTTPRecordingType httpRecording) {
        IdentityHashMap<RequestType, Pair> parsedRequests = new IdentityHashMap<RequestType, Pair>();
        HashMap<String, Integer> commonHeadersCountByValue = new HashMap<String, Integer>();
        HashMap<String, CommonHeadersType> uniqueCommonHeaders = new HashMap<String, CommonHeadersType>();
        for (RequestType request : requests) {
            CommonHeadersType theCommonHeaders;
            CommonHeadersType commonHeaders = CommonHeadersType.Factory.newInstance();
            HeadersType uncommonHeaders = HeadersType.Factory.newInstance();
            XmlObject[] children = request.getHeaders().selectPath("./*");
            for (int i = 0; i < children.length; ++i) {
                if (children[i] instanceof HeaderType) {
                    HeaderType header = (HeaderType)children[i];
                    if (this.m_parameters.isCommonHeader(header.getName())) {
                        commonHeaders.addNewHeader().set((XmlObject)header);
                        continue;
                    }
                    uncommonHeaders.addNewHeader().set((XmlObject)header);
                    continue;
                }
                uncommonHeaders.addNewAuthorization().set(children[i]);
            }
            String key = Arrays.asList(commonHeaders.getHeaderArray()).toString();
            CommonHeadersType existing = (CommonHeadersType)uniqueCommonHeaders.get(key);
            if (existing != null) {
                theCommonHeaders = existing;
            } else {
                uniqueCommonHeaders.put(key, commonHeaders);
                theCommonHeaders = commonHeaders;
            }
            parsedRequests.put(request, Pair.of((Object)theCommonHeaders, (Object)uncommonHeaders));
            Integer count = (Integer)commonHeadersCountByValue.get(key);
            int oldCount = count != null ? count : 0;
            commonHeadersCountByValue.put(key, oldCount + 1);
        }
        IntGenerator idGenerator = new IntGenerator();
        for (RequestType request : requests) {
            Pair pair = (Pair)parsedRequests.get(request);
            CommonHeadersType commonHeaders = (CommonHeadersType)pair.getFirst();
            HeadersType uncommonHeaders = (HeadersType)pair.getSecond();
            String key = Arrays.asList(commonHeaders.getHeaderArray()).toString();
            if (commonHeaders.sizeOfHeaderArray() <= 0 || (Integer)commonHeadersCountByValue.get(key) <= 1) continue;
            if (commonHeaders.getHeadersId() == null) {
                commonHeaders.setHeadersId("headers" + idGenerator.next());
                httpRecording.addNewCommonHeaders().set((XmlObject)commonHeaders);
            }
            uncommonHeaders.setExtends(commonHeaders.getHeadersId());
            request.setHeaders(uncommonHeaders);
        }
    }

    private static Set<Pair<String, String>> findSharedHeaders(List<HeadersType> headersList) {
        if (headersList.size() < 2) {
            return Collections.emptySet();
        }
        HeaderType[] oneHeaders = headersList.remove(headersList.size() - 1).getHeaderArray();
        HashSet<Pair<String, String>> sharedHeaders = new HashSet<Pair<String, String>>(oneHeaders.length);
        for (HeaderType header : oneHeaders) {
            sharedHeaders.add((Pair<String, String>)Pair.of((Object)header.getName(), (Object)header.getValue()));
        }
        for (HeadersType headers : headersList) {
            HeaderType[] h = headers.getHeaderArray();
            HashSet<Pair<String, String>> sharedHeadersCopy = new HashSet<Pair<String, String>>(sharedHeaders);
            for (int j = 0; j < h.length; ++j) {
                String name = h[j].getName();
                String value = h[j].getValue();
                sharedHeadersCopy.remove(Pair.of((Object)name, (Object)value));
            }
            sharedHeaders.removeAll(sharedHeadersCopy);
        }
        return sharedHeaders;
    }

    private static void removeDefaultHeaders(Set<Pair<String, String>> defaultHeaders, String defaultHeadersID, HeadersType headers) {
        HeaderType[] headersArray = headers.getHeaderArray();
        ArrayList<Integer> defaultHeaderIndexes = new ArrayList<Integer>(defaultHeaders.size());
        for (int i = headersArray.length - 1; i >= 0; --i) {
            if (!defaultHeaders.contains(Pair.of((Object)headersArray[i].getName(), (Object)headersArray[i].getValue()))) continue;
            defaultHeaderIndexes.add(i);
        }
        assert (defaultHeaderIndexes.size() == defaultHeaders.size());
        Iterator i$ = defaultHeaderIndexes.iterator();
        while (i$.hasNext()) {
            int index = (Integer)i$.next();
            headers.removeHeader(index);
        }
        headers.setExtends(defaultHeadersID);
    }

    private static final class TokenLastValuePair {
        private final TokenType m_token;
        private final Set<String> m_sources = new HashSet<String>();
        private String m_lastValue;

        public TokenLastValuePair(TokenType token) {
            this.m_token = token;
        }

        public TokenType getToken() {
            return this.m_token;
        }

        public void setLastValue(String lastValue) {
            this.m_lastValue = lastValue;
        }

        public String getLastValue() {
            return this.m_lastValue;
        }

        public void addSource(String source) {
            this.m_sources.add(source);
        }

        public boolean hasAReferenceWithSource(String source) {
            return this.m_sources.contains(source);
        }
    }

    private final class TokenMap {
        private final Map<String, TokenLastValuePair> m_map = new HashMap<String, TokenLastValuePair>();
        private final Map<String, Integer> m_uniqueTokenIDs = new HashMap<String, Integer>();

        private TokenMap() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(String name, String value, TokenReferenceType tokenReference) {
            TokenLastValuePair tokenValuePair;
            Map<String, TokenLastValuePair> map = this.m_map;
            synchronized (map) {
                TokenLastValuePair existing = this.m_map.get(name);
                if (existing == null) {
                    TokenType newToken;
                    HttpRecordingDocument httpRecordingDocument = HTTPRecordingImplementation.this.m_recordingDocument;
                    synchronized (httpRecordingDocument) {
                        newToken = HTTPRecordingImplementation.this.m_recordingDocument.getHttpRecording().addNewToken();
                    }
                    StringBuilder tokenID = new StringBuilder();
                    tokenID.append("token_");
                    for (int i = 0; i < name.length(); ++i) {
                        char c = name.charAt(i);
                        if (!(c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9') && c != '_') continue;
                        tokenID.append(c);
                    }
                    String partToken = tokenID.toString();
                    Integer existingValue = this.m_uniqueTokenIDs.get(partToken);
                    if (existingValue != null) {
                        tokenID.append(existingValue);
                        this.m_uniqueTokenIDs.put(partToken, existingValue + 1);
                    } else {
                        this.m_uniqueTokenIDs.put(partToken, 2);
                    }
                    newToken.setTokenId(tokenID.toString());
                    newToken.setName(name);
                    tokenValuePair = new TokenLastValuePair(newToken);
                    this.m_map.put(name, tokenValuePair);
                } else {
                    tokenValuePair = existing;
                }
            }
            tokenReference.setTokenId(tokenValuePair.getToken().getTokenId());
            if (!value.equals(tokenValuePair.getLastValue())) {
                tokenReference.setNewValue(value);
                tokenValuePair.setLastValue(value);
            }
            tokenValuePair.addSource(tokenReference.getSource());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getLastValue(String name) {
            TokenLastValuePair existing;
            Map<String, TokenLastValuePair> map = this.m_map;
            synchronized (map) {
                existing = this.m_map.get(name);
            }
            return existing != null ? existing.getLastValue() : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean exists(String name, String source) {
            TokenLastValuePair existing;
            Map<String, TokenLastValuePair> map = this.m_map;
            synchronized (map) {
                existing = this.m_map.get(name);
            }
            return existing != null && existing.hasAReferenceWithSource(source);
        }
    }

    private final class RequestList {
        private final List<RequestType> m_requests = new ArrayList<RequestType>();
        private final Pattern m_resourcePathPattern = Pattern.compile(".*(?:\\.css|\\.gif|\\.ico|\\.jpe?g|\\.js|\\.png)(?:\\?.*)?$", 2);

        private RequestList() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public RequestType add() {
            RequestType request = RequestType.Factory.newInstance();
            List<RequestType> list = this.m_requests;
            synchronized (list) {
                this.m_requests.add(request);
            }
            return request;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void record(HTTPRecordingType httpRecording) {
            List<RequestType> list = this.m_requests;
            synchronized (list) {
                HTTPRecordingImplementation.this.m_logger.debug("Recording {} requests", (Object)this.m_requests.size());
                String lastBaseURI = null;
                boolean lastResponseWasRedirect = false;
                PageType currentPage = null;
                for (RequestType request : this.m_requests) {
                    ResponseType response = request.getResponse();
                    if (response == null) {
                        HTTPRecordingImplementation.this.m_logger.debug("Skipping due to no response: {}", (Object)request);
                        continue;
                    }
                    HttpRecordingDocument httpRecordingDocument = HTTPRecordingImplementation.this.m_recordingDocument;
                    synchronized (httpRecordingDocument) {
                        if (!request.getUri().getExtends().equals(lastBaseURI) || request.isSetBody() || !this.m_resourcePathPattern.matcher(request.getUri().getUnparsed()).matches() && !lastResponseWasRedirect || currentPage == null) {
                            currentPage = httpRecording.addNewPage();
                        }
                        lastBaseURI = request.getUri().getExtends();
                        switch (response.getStatusCode()) {
                            case 301: 
                            case 302: 
                            case 307: {
                                lastResponseWasRedirect = true;
                                request.setAnnotation("Expecting " + response.getStatusCode() + " '" + response.getReasonPhrase() + "'");
                                break;
                            }
                            default: {
                                lastResponseWasRedirect = false;
                            }
                        }
                        currentPage.addNewRequest().set((XmlObject)request);
                    }
                }
            }
        }
    }

    private final class BaseURLMap {
        private final Map<String, BaseURIType> m_map = new HashMap<String, BaseURIType>();
        private final IntGenerator m_idGenerator = new IntGenerator();

        private BaseURLMap() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public BaseURIType getBaseURL(BaseURIType.Scheme.Enum scheme, EndPoint endPoint) {
            String key = scheme.toString() + "://" + endPoint;
            Map<String, BaseURIType> map = this.m_map;
            synchronized (map) {
                BaseURIType result;
                BaseURIType existing = this.m_map.get(key);
                if (existing != null) {
                    return existing;
                }
                HttpRecordingDocument httpRecordingDocument = HTTPRecordingImplementation.this.m_recordingDocument;
                synchronized (httpRecordingDocument) {
                    result = HTTPRecordingImplementation.this.m_recordingDocument.getHttpRecording().addNewBaseUri();
                }
                result.setUriId("url" + this.m_idGenerator.next());
                result.setScheme(scheme);
                result.setHost(endPoint.getHost());
                result.setPort(endPoint.getPort());
                this.m_map.put(key, result);
                return result;
            }
        }
    }
}

