/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.plugin.http.tcpproxyfilter;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.grinder.plugin.http.tcpproxyfilter.ConnectionHandler;
import net.grinder.plugin.http.tcpproxyfilter.ConnectionHandlerFactory;
import net.grinder.plugin.http.tcpproxyfilter.HTTPFilterEventListener;
import net.grinder.tools.tcpproxy.ConnectionDetails;
import org.picocontainer.Disposable;

public final class ConnectionCache
implements HTTPFilterEventListener,
Disposable {
    private final ConnectionHandlerFactory m_connectionHandlerFactory;
    private final Map<ConnectionDetails, ConnectionHandler> m_handlers = Collections.synchronizedMap(new HashMap());

    public ConnectionCache(ConnectionHandlerFactory connectionHandlerFactory) {
        this.m_connectionHandlerFactory = connectionHandlerFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open(ConnectionDetails connectionDetails) {
        Map<ConnectionDetails, ConnectionHandler> map = this.m_handlers;
        synchronized (map) {
            if (this.m_handlers.containsKey(connectionDetails)) {
                throw new IllegalArgumentException("Connection " + connectionDetails + " already opened");
            }
            this.m_handlers.put(connectionDetails, this.m_connectionHandlerFactory.create(connectionDetails));
        }
    }

    @Override
    public void request(ConnectionDetails connectionDetails, byte[] buffer, int bytesRead) {
        ConnectionHandler handler = this.m_handlers.get(connectionDetails);
        if (handler == null) {
            throw new IllegalArgumentException("Unknown connection " + connectionDetails);
        }
        handler.handleRequest(buffer, bytesRead);
    }

    @Override
    public void response(ConnectionDetails connectionDetails, byte[] buffer, int bytesRead) {
        ConnectionHandler handler = this.m_handlers.get(connectionDetails.getOtherEnd());
        if (handler == null) {
            throw new IllegalArgumentException("Unknown connection " + connectionDetails);
        }
        handler.handleResponse(buffer, bytesRead);
    }

    @Override
    public void close(ConnectionDetails connectionDetails) {
        ConnectionHandler handler = this.m_handlers.remove(connectionDetails);
        if (handler == null) {
            throw new IllegalArgumentException("Unknown connection " + connectionDetails);
        }
        handler.requestFinished();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Map<ConnectionDetails, ConnectionHandler> map = this.m_handlers;
        synchronized (map) {
            for (ConnectionHandler handler : this.m_handlers.values()) {
                handler.requestFinished();
            }
        }
    }
}

