/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.plugin.http;

import HTTPClient.Codecs;
import HTTPClient.HTTPResponse;
import HTTPClient.NVPair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.grinder.common.GrinderException;
import net.grinder.plugin.http.HTTPPluginThreadState;
import net.grinder.plugin.http.HTTPUtilities;
import net.grinder.plugin.http.tcpproxyfilter.RegularExpressions;
import net.grinder.plugin.http.tcpproxyfilter.RegularExpressionsImplementation;
import net.grinder.plugininterface.PluginProcessContext;
import net.grinder.util.AttributeStringParser;
import net.grinder.util.AttributeStringParserImplementation;
import net.grinder.util.http.URIParser;
import net.grinder.util.http.URIParserImplementation;

class HTTPUtilitiesImplementation
implements HTTPUtilities {
    private final URIParser m_uriParser = new URIParserImplementation();
    private final RegularExpressions m_regularExpressions = new RegularExpressionsImplementation();
    private final AttributeStringParser m_attributeStringParser = new AttributeStringParserImplementation();
    private final ThreadLocal<ParsedBody> m_parsedBodyThreadLocal = new ThreadLocal();
    private final NameValue[] m_emptyNameValues = new NameValue[0];
    private final PluginProcessContext m_processContext;

    public HTTPUtilitiesImplementation(PluginProcessContext processContext) {
        this.m_processContext = processContext;
    }

    @Override
    public NVPair basicAuthorizationHeader(String userID, String password) {
        return new NVPair("Authorization", "Basic " + Codecs.base64Encode((String)(userID + ":" + password)));
    }

    @Override
    public HTTPResponse getLastResponse() throws GrinderException {
        HTTPPluginThreadState threadState = (HTTPPluginThreadState)this.m_processContext.getPluginThreadListener();
        return threadState.getLastResponse();
    }

    @Override
    public String valueFromLocationURI(final String tokenName) throws GrinderException {
        String location;
        HTTPResponse response = this.getLastResponse();
        if (response == null) {
            return "";
        }
        try {
            location = response.getHeader("Location");
        }
        catch (Exception e) {
            throw new AssertionError((Object)("HTTPResponse not initialised (" + e + ")"));
        }
        final String[] result = new String[]{""};
        if (location != null) {
            this.m_uriParser.parse(location, new URIParser.AbstractParseListener(){

                @Override
                public boolean pathParameterNameValue(String name, String value) {
                    if (name.equals(tokenName)) {
                        result[0] = value;
                        return false;
                    }
                    return true;
                }

                @Override
                public boolean queryStringNameValue(String name, String value) {
                    if (name.equals(tokenName)) {
                        result[0] = value;
                        return false;
                    }
                    return true;
                }
            });
        }
        return result[0];
    }

    @Override
    public String valueFromBodyInput(String tokenName) throws GrinderException {
        return this.valueFromBodyInput(tokenName, null);
    }

    @Override
    public String valueFromBodyInput(String tokenName, String afterText) throws GrinderException {
        HTTPResponse response = this.getLastResponse();
        if (response == null) {
            return "";
        }
        return this.getParsedBody(response).valueFromBodyInput(tokenName, afterText);
    }

    @Override
    public List<String> valuesFromBodyInput(String tokenName) throws GrinderException {
        return this.valuesFromBodyInput(tokenName, null);
    }

    @Override
    public List<String> valuesFromBodyInput(String tokenName, String afterText) throws GrinderException {
        HTTPResponse response = this.getLastResponse();
        if (response == null) {
            return Collections.emptyList();
        }
        return this.getParsedBody(response).valuesFromBodyInput(tokenName, afterText);
    }

    @Override
    public String valueFromHiddenInput(String tokenName) throws GrinderException {
        return this.valueFromHiddenInput(tokenName, null);
    }

    @Override
    public String valueFromHiddenInput(String tokenName, String afterText) throws GrinderException {
        HTTPResponse response = this.getLastResponse();
        if (response == null) {
            return "";
        }
        return this.getParsedBody(response).valueFromHiddenInput(tokenName, afterText);
    }

    @Override
    public List<String> valuesFromHiddenInput(String tokenName) throws GrinderException {
        return this.valuesFromHiddenInput(tokenName, null);
    }

    @Override
    public List<String> valuesFromHiddenInput(String tokenName, String afterText) throws GrinderException {
        HTTPResponse response = this.getLastResponse();
        if (response == null) {
            return Collections.emptyList();
        }
        return this.getParsedBody(response).valuesFromHiddenInput(tokenName, afterText);
    }

    @Override
    public String valueFromBodyURI(String tokenName) throws GrinderException {
        return this.valueFromBodyURI(tokenName, null);
    }

    @Override
    public String valueFromBodyURI(String tokenName, String afterText) throws GrinderException {
        HTTPResponse response = this.getLastResponse();
        if (response == null) {
            return "";
        }
        return this.getParsedBody(response).valueFromBodyURI(tokenName, afterText);
    }

    @Override
    public List<String> valuesFromBodyURI(String tokenName) throws GrinderException {
        return this.valuesFromBodyURI(tokenName, null);
    }

    @Override
    public List<String> valuesFromBodyURI(String tokenName, String afterText) throws GrinderException {
        HTTPResponse response = this.getLastResponse();
        if (response == null) {
            return Collections.emptyList();
        }
        return this.getParsedBody(response).valuesFromBodyURI(tokenName, afterText);
    }

    private ParsedBody getParsedBody(HTTPResponse response) {
        ParsedBody original = this.m_parsedBodyThreadLocal.get();
        if (original != null && original.isValidForResponse(response)) {
            return original;
        }
        ParsedBody newParsedBody = new ParsedBody(response);
        this.m_parsedBodyThreadLocal.set(newParsedBody);
        return newParsedBody;
    }

    private final class BodyURIMatchList
    extends AbstractMatchList {
        public BodyURIMatchList(String body) {
            super(HTTPUtilitiesImplementation.this.m_regularExpressions.getHyperlinkURIPattern(), body);
        }

        @Override
        protected NameValue[] parseMatch() {
            final ArrayList result = new ArrayList();
            String uri = this.getMatcher().group(1);
            HTTPUtilitiesImplementation.this.m_uriParser.parse(uri, new URIParser.AbstractParseListener(){

                @Override
                public boolean pathParameterNameValue(String name, String value) {
                    result.add(new NameValue(name, value));
                    return true;
                }

                @Override
                public boolean queryStringNameValue(String name, String value) {
                    result.add(new NameValue(name, value));
                    return true;
                }
            });
            return result.toArray(new NameValue[result.size()]);
        }
    }

    private final class InputMatchList
    extends AbstractMatchList {
        public InputMatchList(Pattern pattern, String body) {
            super(pattern, body);
        }

        @Override
        protected NameValue[] parseMatch() {
            AttributeStringParser.AttributeMap map = HTTPUtilitiesImplementation.this.m_attributeStringParser.parse(this.getMatcher().group());
            String name = map.get("name");
            String value = map.get("value");
            if (name != null && value != null) {
                return new NameValue[]{new NameValue(name, value)};
            }
            return HTTPUtilitiesImplementation.this.m_emptyNameValues;
        }
    }

    private static abstract class AbstractMatchList
    implements MatchList {
        private final String m_body;
        private final Matcher m_matcher;
        private final CachedValueMap m_cache = new CachedValueMap();

        public AbstractMatchList(Pattern pattern, String body) {
            this.m_body = body;
            this.m_matcher = pattern.matcher(body);
        }

        @Override
        public String getMatchValue(String tokenName, String afterText) {
            int startFrom = this.getStartFrom(afterText);
            if (startFrom == -1) {
                return "";
            }
            CachedMatchList cachedValueList = this.m_cache.get(tokenName);
            Match match = this.getMatch(cachedValueList, tokenName, startFrom);
            return match != null ? match.getValue() : "";
        }

        @Override
        public List<String> getMatchValues(String tokenName, String afterText) {
            int startFrom = this.getStartFrom(afterText);
            if (startFrom == -1) {
                return Collections.emptyList();
            }
            CachedMatchList cachedValueList = this.m_cache.get(tokenName);
            ArrayList<String> result = new ArrayList<String>();
            Match match;
            while ((match = this.getMatch(cachedValueList, tokenName, startFrom)) != null) {
                result.add(match.getValue());
                startFrom = match.getPosition() + 1;
            }
            return result;
        }

        private Match getMatch(CachedMatchList cachedValueList, String tokenName, int startFrom) {
            Match existingMatch = cachedValueList.getMatchFrom(startFrom);
            if (existingMatch != null) {
                return existingMatch;
            }
            Match result = null;
            while (result == null && this.m_matcher.find()) {
                NameValue[] nameValueArray = this.parseMatch();
                int matchPosition = this.m_matcher.start();
                for (int i = 0; i < nameValueArray.length; ++i) {
                    String name = nameValueArray[i].getName();
                    Match match = new Match(matchPosition, nameValueArray[i].getValue());
                    if (name.equals(tokenName)) {
                        cachedValueList.addMatch(match);
                        if (result != null || matchPosition < startFrom) continue;
                        result = match;
                        continue;
                    }
                    this.m_cache.get(name).addMatch(match);
                }
            }
            return result;
        }

        private int getStartFrom(String text) {
            return text == null ? 0 : this.m_body.indexOf(text);
        }

        protected final Matcher getMatcher() {
            return this.m_matcher;
        }

        protected abstract NameValue[] parseMatch();
    }

    private static class CachedValueMap {
        private final Map<String, CachedMatchList> m_map = new HashMap<String, CachedMatchList>();

        private CachedValueMap() {
        }

        public CachedMatchList get(String tokenName) {
            CachedMatchList existing = this.m_map.get(tokenName);
            if (existing != null) {
                return existing;
            }
            CachedMatchList newCachedValueList = new CachedMatchList();
            this.m_map.put(tokenName, newCachedValueList);
            return newCachedValueList;
        }
    }

    private static interface MatchList {
        public String getMatchValue(String var1, String var2);

        public List<String> getMatchValues(String var1, String var2);
    }

    private static class CachedMatchList {
        private final List<Match> m_matchesByPosition = new ArrayList<Match>();
        private int m_lastPosition = -1;

        private CachedMatchList() {
        }

        public void addMatch(Match match) {
            this.m_matchesByPosition.add(match);
            this.m_lastPosition = match.getPosition();
        }

        public Match getMatchFrom(int startFrom) {
            if (this.m_lastPosition >= startFrom) {
                for (Match match : this.m_matchesByPosition) {
                    if (match.getPosition() < startFrom) continue;
                    return match;
                }
            }
            return null;
        }
    }

    private static final class Match {
        private final int m_position;
        private final String m_value;

        public Match(int position, String value) {
            this.m_position = position;
            this.m_value = value;
        }

        public int getPosition() {
            return this.m_position;
        }

        public String getValue() {
            return this.m_value;
        }
    }

    private static final class NameValue {
        private final String m_name;
        private final String m_value;

        public NameValue(String name, String value) {
            this.m_name = name;
            this.m_value = value;
        }

        public String getName() {
            return this.m_name;
        }

        public String getValue() {
            return this.m_value;
        }
    }

    private final class ParsedBody {
        private final HTTPResponse m_response;
        private final String m_body;
        private final MatchList m_bodyInputMatchList;
        private final MatchList m_hiddenInputMatchList;
        private final MatchList m_bodyURIMatchList;

        public ParsedBody(HTTPResponse response) {
            this.m_response = response;
            try {
                this.m_body = response.getText();
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
            this.m_bodyInputMatchList = new InputMatchList(HTTPUtilitiesImplementation.this.m_regularExpressions.getInputPattern(), this.m_body);
            this.m_hiddenInputMatchList = new InputMatchList(HTTPUtilitiesImplementation.this.m_regularExpressions.getHiddenInputPattern(), this.m_body);
            this.m_bodyURIMatchList = new BodyURIMatchList(this.m_body);
        }

        public boolean isValidForResponse(HTTPResponse response) {
            return this.m_response.equals(response);
        }

        public String valueFromBodyInput(String tokenName, String afterText) {
            return this.m_bodyInputMatchList.getMatchValue(tokenName, afterText);
        }

        public List<String> valuesFromBodyInput(String tokenName, String afterText) {
            return this.m_bodyInputMatchList.getMatchValues(tokenName, afterText);
        }

        public String valueFromHiddenInput(String tokenName, String afterText) {
            return this.m_hiddenInputMatchList.getMatchValue(tokenName, afterText);
        }

        public List<String> valuesFromHiddenInput(String tokenName, String afterText) {
            return this.m_hiddenInputMatchList.getMatchValues(tokenName, afterText);
        }

        public String valueFromBodyURI(String tokenName, String afterText) {
            return this.m_bodyURIMatchList.getMatchValue(tokenName, afterText);
        }

        public List<String> valuesFromBodyURI(String tokenName, String afterText) {
            return this.m_bodyURIMatchList.getMatchValues(tokenName, afterText);
        }
    }
}

