/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.plugin.http;

import HTTPClient.NVPair;
import java.net.InetAddress;
import java.net.UnknownHostException;
import net.grinder.plugin.http.HTTPPluginConnection;
import net.grinder.plugin.http.URLException;

final class HTTPPluginConnectionDefaults
implements HTTPPluginConnection {
    private boolean m_followRedirects = false;
    private boolean m_useCookies = true;
    private boolean m_useContentEncoding = false;
    private boolean m_useTransferEncoding = false;
    private boolean m_useAuthorizationModule = false;
    private NVPair[] m_defaultHeaders = new NVPair[0];
    private int m_timeout = 0;
    private String m_proxyHost;
    private int m_proxyPort;
    private boolean m_verifyServerDistinguishedName = false;
    private InetAddress m_localAddress;
    private int m_slowClientTargetBPS;
    private static final HTTPPluginConnectionDefaults s_defaultConnectionDefaults = new HTTPPluginConnectionDefaults();

    HTTPPluginConnectionDefaults() {
    }

    @Override
    public synchronized void setFollowRedirects(boolean followRedirects) {
        this.m_followRedirects = followRedirects;
    }

    synchronized boolean getFollowRedirects() {
        return this.m_followRedirects;
    }

    @Override
    public synchronized void setUseCookies(boolean useCookies) {
        this.m_useCookies = useCookies;
    }

    synchronized boolean getUseCookies() {
        return this.m_useCookies;
    }

    @Override
    public synchronized void setUseContentEncoding(boolean useContentEncoding) {
        this.m_useContentEncoding = useContentEncoding;
    }

    synchronized boolean getUseContentEncoding() {
        return this.m_useContentEncoding;
    }

    @Override
    public synchronized void setUseTransferEncoding(boolean useTransferEncoding) {
        this.m_useTransferEncoding = useTransferEncoding;
    }

    synchronized boolean getUseAuthorizationModule() {
        return this.m_useAuthorizationModule;
    }

    @Override
    public synchronized void setUseAuthorizationModule(boolean b) {
        this.m_useAuthorizationModule = b;
    }

    synchronized boolean getUseTransferEncoding() {
        return this.m_useTransferEncoding;
    }

    @Override
    public synchronized void setDefaultHeaders(NVPair[] defaultHeaders) {
        this.m_defaultHeaders = defaultHeaders;
    }

    synchronized NVPair[] getDefaultHeaders() {
        return this.m_defaultHeaders;
    }

    @Override
    public synchronized void setTimeout(int timeout) {
        this.m_timeout = timeout;
    }

    synchronized int getTimeout() {
        return this.m_timeout;
    }

    @Override
    public synchronized void setVerifyServerDistinguishedName(boolean b) {
        this.m_verifyServerDistinguishedName = b;
    }

    synchronized boolean getVerifyServerDistinguishedName() {
        return this.m_verifyServerDistinguishedName;
    }

    @Override
    public synchronized void setProxyServer(String host, int port) {
        this.m_proxyHost = host;
        this.m_proxyPort = port;
    }

    synchronized String getProxyHost() {
        return this.m_proxyHost;
    }

    synchronized int getProxyPort() {
        return this.m_proxyPort;
    }

    @Override
    public synchronized void setLocalAddress(String localAddress) throws URLException {
        try {
            this.m_localAddress = InetAddress.getByName(localAddress);
        }
        catch (UnknownHostException e) {
            throw new URLException(e.getMessage(), e);
        }
    }

    synchronized InetAddress getLocalAddress() {
        return this.m_localAddress;
    }

    @Override
    public synchronized void setBandwidthLimit(int targetBPS) {
        this.m_slowClientTargetBPS = targetBPS;
    }

    synchronized int getBandwidthLimit() {
        return this.m_slowClientTargetBPS;
    }

    public static HTTPPluginConnectionDefaults getConnectionDefaults() {
        return s_defaultConnectionDefaults;
    }

    @Override
    public void close() {
    }
}

