/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.console.swingui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.grinder.common.Test;
import net.grinder.console.common.Resources;
import net.grinder.console.model.ModelTestIndex;
import net.grinder.console.model.SampleListener;
import net.grinder.console.model.SampleModel;
import net.grinder.console.model.SampleModelViews;
import net.grinder.console.swingui.LabelledGraph;
import net.grinder.console.swingui.SwingDispatcherFactory;
import net.grinder.statistics.StatisticsSet;

public class TestGraphPanel
extends JPanel
implements SampleModel.Listener {
    private final JComponent m_parentComponent;
    private final BorderLayout m_borderLayout = new BorderLayout();
    private final FlowLayout m_flowLayout = new FlowLayout(0);
    private final JLabel m_logoLabel;
    private final Dimension m_preferredSize = new Dimension();
    private final SampleModel m_model;
    private final SampleModelViews m_sampleModelViews;
    private final Resources m_resources;
    private final SwingDispatcherFactory m_swingDispatcherFactory;
    private final String m_testLabel;
    private final Map<Test, JComponent> m_components = new HashMap<Test, JComponent>();

    TestGraphPanel(JComponent parentComponent, SampleModel model, SampleModelViews sampleModelViews, Resources resources, SwingDispatcherFactory swingDispatcherFactory) {
        this.m_parentComponent = parentComponent;
        this.m_model = model;
        this.m_sampleModelViews = sampleModelViews;
        this.m_resources = resources;
        this.m_swingDispatcherFactory = swingDispatcherFactory;
        this.m_testLabel = this.m_resources.getString("graph.test.label") + " ";
        this.m_model.addModelListener((SampleModel.Listener)swingDispatcherFactory.create(SampleModel.Listener.class, this));
        this.m_model.addTotalSampleListener(new SampleListener(){

            public void update(StatisticsSet intervalStatistics, StatisticsSet cumulativeStatistics) {
                LabelledGraph.resetPeak();
            }
        });
        this.m_logoLabel = new JLabel(this.m_resources.getImageIcon("logo-large.image"));
    }

    public void stateChanged() {
    }

    public final void newSample() {
    }

    public final void resetTests() {
        this.m_components.clear();
        this.removeAll();
        this.setLayout(this.m_borderLayout);
        this.add((Component)this.m_logoLabel, "Center");
        this.invalidate();
    }

    public void newTests(Set<Test> newTests, ModelTestIndex modelTestIndex) {
        this.remove(this.m_logoLabel);
        this.setLayout(this.m_flowLayout);
        for (Test test : newTests) {
            String description = test.getDescription();
            String label = this.m_testLabel + test.getNumber() + (description != null ? " (" + description + ")" : "");
            final LabelledGraph testGraph = new LabelledGraph(label, this.m_resources, this.m_model.getTPSExpression(), this.m_model.getPeakTPSExpression(), this.m_sampleModelViews.getTestStatisticsQueries());
            this.m_model.addSampleListener(test, (SampleListener)this.m_swingDispatcherFactory.create(SampleListener.class, new SampleListener(){

                public void update(StatisticsSet intervalStatistics, StatisticsSet cumulativeStatistics) {
                    testGraph.add(intervalStatistics, cumulativeStatistics, TestGraphPanel.this.m_sampleModelViews.getNumberFormat());
                }
            }));
            this.m_components.put(test, testGraph);
        }
        int numberOfTests = modelTestIndex.getNumberOfTests();
        for (int i = 0; i < numberOfTests; ++i) {
            this.add(this.m_components.get(modelTestIndex.getTest(i)));
        }
        this.m_preferredSize.width = -1;
        this.validate();
    }

    @Override
    public final Dimension getPreferredSize() {
        if (this.m_components.size() == 0) {
            return super.getPreferredSize();
        }
        Insets parentComponentInsets = this.m_parentComponent.getInsets();
        int preferredWidth = this.m_parentComponent.getWidth() - parentComponentInsets.left - parentComponentInsets.right;
        if (this.m_preferredSize.width == preferredWidth) {
            return this.m_preferredSize;
        }
        this.m_preferredSize.width = preferredWidth;
        int n = this.getComponentCount();
        int hgap = this.m_flowLayout.getHgap();
        Insets insets = this.getInsets();
        int fudgeFactor = 6;
        if (n > 0) {
            int componentWidth = this.getComponent(0).getWidth();
            int componentHeight = this.getComponent(0).getHeight();
            int numberAcross = -1;
            for (int availableWidth = preferredWidth - insets.left - insets.right - hgap + 6; componentWidth > 0 && availableWidth > 0; availableWidth -= hgap) {
                ++numberAcross;
                availableWidth -= componentWidth;
            }
            if (numberAcross > 0) {
                int numberDown = (n + numberAcross - 1) / numberAcross;
                this.m_preferredSize.height = numberDown * componentHeight + (numberDown - 1) * this.m_flowLayout.getVgap();
            }
        }
        return this.m_preferredSize;
    }
}

