/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.console.swingui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import net.grinder.common.GrinderException;
import net.grinder.console.common.ConsoleException;
import net.grinder.console.common.Resources;
import net.grinder.console.model.ConsoleProperties;
import net.grinder.console.swingui.CustomAction;
import net.grinder.console.swingui.ErrorDialogHandler;
import net.grinder.console.swingui.IntegerField;
import net.grinder.console.swingui.JOptionPaneDialog;
import net.grinder.console.swingui.LookAndFeel;
import net.grinder.console.swingui.SamplingControlPanel;

abstract class OptionsDialogHandler {
    private final JFrame m_parentFrame;
    private final LookAndFeel m_lookAndFeel;
    private final Resources m_resources;
    private final UIManager.LookAndFeelInfo[] m_installedLookAndFeels;
    private final ConsoleProperties m_properties;
    private final JTextField m_consoleHost = new JTextField();
    private final IntegerField m_consolePort = new IntegerField(1, 65535);
    private final JTextField m_httpHost = new JTextField();
    private final IntegerField m_httpPort = new IntegerField(1, 65535);
    private final SamplingControlPanel m_samplingControlPanel;
    private final JSlider m_sfSlider = new JSlider(1, 6, 1);
    private final JCheckBox m_resetConsoleWithProcessesCheckBox;
    private final JComboBox m_lookAndFeelComboBox;
    private final JOptionPaneDialog m_dialog;
    private final JTextField m_externalEditorCommand = new JTextField(20);
    private final JTextField m_externalEditorArguments = new JTextField(20);

    public OptionsDialogHandler(JFrame parentFrame, LookAndFeel lookAndFeel, ConsoleProperties properties, Resources resources) {
        this.m_parentFrame = parentFrame;
        this.m_lookAndFeel = lookAndFeel;
        this.m_resources = resources;
        this.m_installedLookAndFeels = lookAndFeel.getInstalledLookAndFeels();
        this.m_properties = new ConsoleProperties(properties);
        JPanel addressLabelPanel = new JPanel(new GridLayout(0, 1, 0, 1));
        addressLabelPanel.add(new JLabel(this.m_resources.getString("consoleHost.label")));
        addressLabelPanel.add(new JLabel(this.m_resources.getString("consolePort.label")));
        addressLabelPanel.add(new JLabel(this.m_resources.getString("httpHost.label")));
        addressLabelPanel.add(new JLabel(this.m_resources.getString("httpPort.label")));
        JPanel addressFieldPanel = new JPanel(new GridLayout(0, 1, 0, 1));
        addressFieldPanel.add(this.m_consoleHost);
        addressFieldPanel.add(this.m_consolePort);
        addressFieldPanel.add(this.m_httpHost);
        addressFieldPanel.add(this.m_httpPort);
        JPanel addressPanel = new JPanel();
        addressPanel.setLayout(new BoxLayout(addressPanel, 0));
        addressPanel.add(addressLabelPanel);
        addressPanel.add(Box.createHorizontalStrut(5));
        addressPanel.add(addressFieldPanel);
        JPanel communicationTab = new JPanel(new BorderLayout());
        communicationTab.add((Component)addressPanel, "North");
        communicationTab.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_samplingControlPanel = new SamplingControlPanel(this.m_resources);
        JPanel samplingControlTab = new JPanel(new BorderLayout());
        samplingControlTab.add((Component)this.m_samplingControlPanel, "North");
        samplingControlTab.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_sfSlider.setMajorTickSpacing(1);
        this.m_sfSlider.setPaintLabels(true);
        this.m_sfSlider.setSnapToTicks(true);
        Dimension d = this.m_sfSlider.getPreferredSize();
        d.width = 0;
        this.m_sfSlider.setPreferredSize(d);
        JPanel sfPanel = new JPanel(new GridLayout(0, 2));
        sfPanel.add(new JLabel(this.m_resources.getString("significantFigures.label")));
        sfPanel.add(this.m_sfSlider);
        JPanel editorLabelPanel = new JPanel(new GridLayout(0, 1, 0, 1));
        editorLabelPanel.add(new JLabel(this.m_resources.getString("externalEditorCommand.label")));
        editorLabelPanel.add(new JLabel(this.m_resources.getString("externalEditorArguments.label")));
        JPanel editorFieldPanel = new JPanel(new GridLayout(0, 1, 0, 1));
        JPanel commandPanel = new JPanel(new BorderLayout());
        commandPanel.add(this.m_externalEditorCommand);
        JButton chooseExternalEditorButton = new JButton();
        chooseExternalEditorButton.setAction(new ChooseCommandAction());
        commandPanel.add((Component)chooseExternalEditorButton, "East");
        editorFieldPanel.add(commandPanel);
        editorFieldPanel.add(this.m_externalEditorArguments);
        JPanel editorPanel = new JPanel();
        editorPanel.setLayout(new BoxLayout(editorPanel, 0));
        editorPanel.add(editorLabelPanel);
        editorPanel.add(Box.createHorizontalStrut(5));
        editorPanel.add(editorFieldPanel);
        JPanel editorTab = new JPanel(new BorderLayout());
        editorTab.add((Component)editorPanel, "North");
        editorTab.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_resetConsoleWithProcessesCheckBox = new JCheckBox(this.m_resources.getString("resetConsoleWithProcesses.label"));
        JPanel checkBoxPanel = new JPanel();
        checkBoxPanel.add(this.m_resetConsoleWithProcessesCheckBox);
        String[] lookAndFeelLabels = new String[this.m_installedLookAndFeels.length];
        for (int i = 0; i < this.m_installedLookAndFeels.length; ++i) {
            lookAndFeelLabels[i] = this.m_installedLookAndFeels[i].getName();
        }
        this.m_lookAndFeelComboBox = new JComboBox<String>(lookAndFeelLabels);
        JPanel lookAndFeelPanel = new JPanel(new GridLayout(0, 2));
        lookAndFeelPanel.add(new JLabel(this.m_resources.getString("lookAndFeel.label")));
        lookAndFeelPanel.add(this.m_lookAndFeelComboBox);
        JPanel miscellaneousPanel = new JPanel();
        miscellaneousPanel.setLayout(new BoxLayout(miscellaneousPanel, 1));
        miscellaneousPanel.add(sfPanel);
        miscellaneousPanel.add(checkBoxPanel);
        miscellaneousPanel.add(lookAndFeelPanel);
        JPanel miscellaneousTab = new JPanel(new FlowLayout(0));
        miscellaneousTab.add(miscellaneousPanel);
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab(this.m_resources.getString("options.communicationTab.title"), null, communicationTab, this.m_resources.getString("options.communicationTab.tip"));
        tabbedPane.addTab(this.m_resources.getString("options.samplingTab.title"), null, samplingControlTab, this.m_resources.getString("options.samplingTab.tip"));
        tabbedPane.addTab(this.m_resources.getString("options.editorTab.title"), null, editorTab, this.m_resources.getString("options.editorTab.tip"));
        tabbedPane.addTab(this.m_resources.getString("options.miscellaneousTab.title"), null, miscellaneousTab, this.m_resources.getString("options.miscellaneousTab.tip"));
        final Object[] options = new Object[]{this.m_resources.getString("options.ok.label"), this.m_resources.getString("options.cancel.label"), this.m_resources.getString("options.save.label")};
        final JOptionPane optionPane = new JOptionPane(tabbedPane, -1, 0, null, options);
        this.m_samplingControlPanel.setProperties(this.m_properties);
        this.m_dialog = new JOptionPaneDialog(this.m_parentFrame, this.m_resources.getString("options.label"), true, optionPane){

            @Override
            protected boolean shouldClose() {
                Object value = optionPane.getValue();
                if (value == options[1]) {
                    return true;
                }
                try {
                    OptionsDialogHandler.this.setProperties(OptionsDialogHandler.this.m_properties);
                }
                catch (ConsoleException e) {
                    new ErrorDialogHandler(OptionsDialogHandler.this.m_dialog, OptionsDialogHandler.this.m_resources, null).handleException(e);
                    return false;
                }
                if (value == options[2]) {
                    try {
                        OptionsDialogHandler.this.m_properties.save();
                    }
                    catch (GrinderException e) {
                        Throwable cause = e.getCause();
                        String messsage = (cause != null ? cause : e).getMessage();
                        new ErrorDialogHandler(OptionsDialogHandler.this.m_dialog, OptionsDialogHandler.this.m_resources, null).handleErrorMessage(messsage, OptionsDialogHandler.this.m_resources.getString("fileError.title"));
                        return false;
                    }
                }
                OptionsDialogHandler.this.setNewOptions(OptionsDialogHandler.this.m_properties);
                return true;
            }
        };
        this.m_lookAndFeel.addListener(new LookAndFeel.ComponentListener(this.m_dialog){

            @Override
            public void lookAndFeelChanged() {
                super.lookAndFeelChanged();
                OptionsDialogHandler.this.m_dialog.pack();
            }
        });
        this.m_dialog.pack();
    }

    private void setProperties(ConsoleProperties properties) throws ConsoleException {
        properties.setConsoleHost(this.m_consoleHost.getText());
        properties.setConsolePort(this.m_consolePort.getValue());
        properties.setHttpHost(this.m_httpHost.getText());
        properties.setHttpPort(this.m_httpPort.getValue());
        properties.setExternalEditorCommand(new File(this.m_externalEditorCommand.getText()));
        properties.setExternalEditorArguments(this.m_externalEditorArguments.getText());
        properties.setSignificantFigures(this.m_sfSlider.getValue());
        properties.setResetConsoleWithProcesses(this.m_resetConsoleWithProcessesCheckBox.isSelected());
        int lookAndFeelIndex = this.m_lookAndFeelComboBox.getSelectedIndex();
        if (lookAndFeelIndex > -1) {
            properties.setLookAndFeel(this.m_installedLookAndFeels[lookAndFeelIndex].getClassName());
        }
    }

    public void showDialog(ConsoleProperties initialProperties) {
        this.m_properties.set(initialProperties);
        this.m_consoleHost.setText(this.m_properties.getConsoleHost());
        this.m_consolePort.setValue(this.m_properties.getConsolePort());
        this.m_httpHost.setText(this.m_properties.getHttpHost());
        this.m_httpPort.setValue(this.m_properties.getHttpPort());
        File externalEditor = this.m_properties.getExternalEditorCommand();
        this.m_externalEditorCommand.setText(externalEditor != null ? externalEditor.getAbsolutePath() : "");
        this.m_externalEditorArguments.setText(this.m_properties.getExternalEditorArguments());
        this.m_sfSlider.setValue(this.m_properties.getSignificantFigures());
        this.m_resetConsoleWithProcessesCheckBox.setSelected(this.m_properties.getResetConsoleWithProcesses());
        String currentLookAndFeel = this.m_properties.getLookAndFeel();
        int currentLookAndFeelIndex = -1;
        if (currentLookAndFeel != null) {
            for (int i = 0; i < this.m_installedLookAndFeels.length; ++i) {
                if (!currentLookAndFeel.equals(this.m_installedLookAndFeels[i].getClassName())) continue;
                currentLookAndFeelIndex = i;
            }
        }
        this.m_lookAndFeelComboBox.setSelectedIndex(currentLookAndFeelIndex);
        this.m_samplingControlPanel.refresh();
        this.m_dialog.setLocationRelativeTo(this.m_parentFrame);
        SwingUtilities.updateComponentTreeUI(this.m_dialog);
        this.m_dialog.setVisible(true);
    }

    protected abstract void setNewOptions(ConsoleProperties var1);

    private final class ChooseCommandAction
    extends CustomAction {
        private final JFileChooser m_fileChooser;

        ChooseCommandAction() {
            super(OptionsDialogHandler.this.m_resources, null, true);
            this.m_fileChooser = new JFileChooser(".");
            this.putValue("Name", "...");
            this.m_fileChooser.setDialogTitle(OptionsDialogHandler.this.m_resources.getString("choose-external-editor.label"));
            this.m_fileChooser.setSelectedFile(OptionsDialogHandler.this.m_properties.getExternalEditorCommand());
            OptionsDialogHandler.this.m_lookAndFeel.addListener(new LookAndFeel.ComponentListener(this.m_fileChooser));
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            String buttonText = OptionsDialogHandler.this.m_resources.getString("choose-external-editor.label");
            if (this.m_fileChooser.showDialog(OptionsDialogHandler.this.m_parentFrame, buttonText) == 0) {
                OptionsDialogHandler.this.m_externalEditorCommand.setText(this.m_fileChooser.getSelectedFile().getAbsolutePath());
            }
        }
    }
}

