/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.console.swingui;

import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import net.grinder.console.common.DisplayMessageConsoleException;
import net.grinder.console.common.Resources;
import net.grinder.console.model.ConsoleProperties;
import net.grinder.util.BooleanProperty;

final class OptionalConfirmDialog {
    private final JFrame m_frame;
    private final Resources m_resources;
    private final ConsoleProperties m_properties;
    public static final int DONT_ASK_OPTION = 999;

    public OptionalConfirmDialog(JFrame frame, Resources resources, ConsoleProperties properties) {
        this.m_frame = frame;
        this.m_resources = resources;
        this.m_properties = properties;
    }

    public int show(String message, String title, int optionType, String askPropertyName) throws BooleanProperty.PropertyException, DisplayMessageConsoleException {
        BooleanProperty askProperty = new BooleanProperty((Object)this.m_properties, askPropertyName);
        if (!askProperty.get()) {
            return 999;
        }
        JCheckBox dontAskMeAgainCheckBox = new JCheckBox(this.m_resources.getString("dontAskMeAgain.text"));
        dontAskMeAgainCheckBox.setAlignmentX(1.0f);
        Object[] messageArray = new Object[]{message, new JLabel(), dontAskMeAgainCheckBox};
        int chosen = JOptionPane.showConfirmDialog(this.m_frame, messageArray, title, optionType);
        if (chosen != 2 && chosen != -1) {
            try {
                askProperty.set(!dontAskMeAgainCheckBox.isSelected());
            }
            catch (BooleanProperty.PropertyException e) {
                Throwable cause = e.getCause();
                if (cause instanceof DisplayMessageConsoleException) {
                    throw (DisplayMessageConsoleException)cause;
                }
                throw e;
            }
        }
        return chosen;
    }
}

