/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.console.swingui;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JMenu;
import javax.swing.SwingUtilities;

final class MnemonicHeuristics {
    private final Heuristic[] m_heuristics = new Heuristic[]{new FirstCharacterHeuristic(), new UpperCaseHeuristic(), new ConsonantHeuristic(), new LetterOrDigitHeuristic()};
    private final MnemonicMap m_existingMnemonics = new MnemonicMap();
    private final MnemonicChangedListener m_mnemonicChangedListener = new MnemonicChangedListener();
    private final TextChangedListener m_textChangedListener = new TextChangedListener();

    public MnemonicHeuristics(Container theContainer) {
        Container container = theContainer instanceof JMenu ? ((JMenu)theContainer).getPopupMenu() : theContainer;
        Component[] existingComponents = container.getComponents();
        for (int i = 0; i < existingComponents.length; ++i) {
            if (!(existingComponents[i] instanceof AbstractButton)) continue;
            AbstractButton button = (AbstractButton)existingComponents[i];
            this.m_mnemonicChangedListener.add(button);
            this.m_textChangedListener.add(button);
            this.setMnemonic(button);
        }
        container.addContainerListener(new ContainerListener(){

            @Override
            public void componentAdded(ContainerEvent e) {
                if (e.getChild() instanceof AbstractButton) {
                    AbstractButton button = (AbstractButton)e.getChild();
                    MnemonicHeuristics.this.m_mnemonicChangedListener.add(button);
                    MnemonicHeuristics.this.m_textChangedListener.add(button);
                    MnemonicHeuristics.this.setMnemonic(button);
                }
            }

            @Override
            public void componentRemoved(ContainerEvent e) {
                Component button = e.getChild();
                MnemonicHeuristics.this.m_mnemonicChangedListener.remove(button);
                MnemonicHeuristics.this.m_textChangedListener.remove(e.getChild());
            }
        });
    }

    private void setMnemonic(final AbstractButton button) {
        int existingMnemonic = button.getMnemonic();
        if (existingMnemonic != 0) {
            this.m_existingMnemonics.add(existingMnemonic, button);
            return;
        }
        String text = button.getText();
        if (text == null) {
            return;
        }
        this.m_textChangedListener.remove(button);
        button.setText(MnemonicHeuristics.removeMnemonicMarkers(text));
        this.m_textChangedListener.add(button);
        int underscore = text.indexOf(95);
        int numberOfUnderscores = 0;
        while (underscore >= 0 && underscore < text.length() - 1) {
            int explicitMnemonic = this.toKey(text.charAt(underscore + 1), false);
            AbstractButton existingExplicit = this.m_existingMnemonics.getExplicit(explicitMnemonic);
            if (explicitMnemonic != 0 && existingExplicit == null || existingExplicit == button) {
                AbstractButton oldButton = this.m_existingMnemonics.remove(explicitMnemonic);
                button.setMnemonic(explicitMnemonic);
                final int index = underscore - numberOfUnderscores;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        button.setDisplayedMnemonicIndex(index);
                    }
                });
                this.m_existingMnemonics.addExplicit(explicitMnemonic, button);
                if (oldButton != null && oldButton != button) {
                    oldButton.setMnemonic(0);
                    this.setMnemonic(oldButton);
                }
                return;
            }
            underscore = text.indexOf(95, underscore + 1);
            ++numberOfUnderscores;
        }
        for (int i = 0; i < this.m_heuristics.length; ++i) {
            int result = this.m_heuristics[i].apply(button.getText());
            if (result == 0) continue;
            button.setMnemonic(result);
            this.m_existingMnemonics.add(result, button);
            return;
        }
    }

    private int toKey(char c, boolean filterExisting) {
        char upper = Character.toUpperCase(c);
        if (!(filterExisting && this.m_existingMnemonics.contains(upper) || !KeyEvent.getKeyText(upper).equals(String.valueOf(upper)))) {
            return upper;
        }
        return 0;
    }

    private int toKey(char c) {
        return this.toKey(c, true);
    }

    public static String removeMnemonicMarkers(String s) {
        return s.replaceAll("_", "");
    }

    private static class MnemonicMap {
        private final Map<Integer, ButtonWrapper> m_map = new HashMap<Integer, ButtonWrapper>();

        private MnemonicMap() {
        }

        public void add(int mnemonic, AbstractButton button) {
            this.m_map.put(mnemonic, new ButtonWrapper(button, false));
        }

        public void addExplicit(int mnemonic, AbstractButton button) {
            this.m_map.put(mnemonic, new ButtonWrapper(button, true));
        }

        public AbstractButton getExplicit(int mnemonic) {
            ButtonWrapper wrapper = this.m_map.get(mnemonic);
            if (wrapper != null && wrapper.isExplicit()) {
                return wrapper.getButton();
            }
            return null;
        }

        public AbstractButton remove(int mnemonic) {
            ButtonWrapper wrapper = this.m_map.remove(mnemonic);
            return wrapper != null ? wrapper.getButton() : null;
        }

        public AbstractButton remove(int mnemonic, AbstractButton button) {
            ButtonWrapper wrapper = this.m_map.get(mnemonic);
            if (wrapper != null && wrapper.getButton() == button) {
                return this.remove(mnemonic);
            }
            return null;
        }

        public boolean contains(int mnemonic) {
            return this.m_map.containsKey(mnemonic);
        }

        private static class ButtonWrapper {
            private final AbstractButton m_button;
            private final boolean m_isExplicit;

            public ButtonWrapper(AbstractButton button, boolean explicitMnemonic) {
                this.m_button = button;
                this.m_isExplicit = explicitMnemonic;
            }

            public AbstractButton getButton() {
                return this.m_button;
            }

            public boolean isExplicit() {
                return this.m_isExplicit;
            }
        }
    }

    private class ConsonantHeuristic
    extends LetterOrDigitHeuristic {
        private ConsonantHeuristic() {
        }

        @Override
        protected boolean matches(char c) {
            return super.matches(c) && c != 'a' && c != 'e' && c != 'i' && c != 'o' && c != 'u';
        }
    }

    private class LetterOrDigitHeuristic
    extends AbstractEarliestMatchHeuristic {
        private LetterOrDigitHeuristic() {
        }

        @Override
        protected boolean matches(char c) {
            return Character.isLetterOrDigit(c);
        }
    }

    private class UpperCaseHeuristic
    extends AbstractEarliestMatchHeuristic {
        private UpperCaseHeuristic() {
        }

        @Override
        protected boolean matches(char c) {
            return Character.isUpperCase(c);
        }
    }

    private abstract class AbstractEarliestMatchHeuristic
    implements Heuristic {
        private AbstractEarliestMatchHeuristic() {
        }

        @Override
        public int apply(String text) {
            char[] characters = text.toCharArray();
            for (int i = 0; i < characters.length; ++i) {
                int result;
                if (!this.matches(characters[i]) || (result = MnemonicHeuristics.this.toKey(characters[i])) == 0) continue;
                return result;
            }
            return 0;
        }

        protected abstract boolean matches(char var1);
    }

    private class FirstCharacterHeuristic
    implements Heuristic {
        private FirstCharacterHeuristic() {
        }

        @Override
        public int apply(String text) {
            return text.length() > 0 ? MnemonicHeuristics.this.toKey(text.charAt(0)) : 0;
        }
    }

    private static interface Heuristic {
        public int apply(String var1);
    }

    private final class TextChangedListener
    extends AbstractPropertyListener {
        public TextChangedListener() {
            super("text");
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            AbstractButton button = (AbstractButton)evt.getSource();
            MnemonicHeuristics.this.m_existingMnemonics.remove(button.getMnemonic(), button);
            button.setMnemonic(0);
            MnemonicHeuristics.this.setMnemonic(button);
        }
    }

    private final class MnemonicChangedListener
    extends AbstractPropertyListener {
        public MnemonicChangedListener() {
            super("mnemonic");
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            MnemonicHeuristics.this.m_existingMnemonics.remove((Integer)evt.getOldValue(), (AbstractButton)evt.getSource());
        }
    }

    private abstract class AbstractPropertyListener
    implements PropertyChangeListener {
        private final String m_property;

        protected AbstractPropertyListener(String property) {
            this.m_property = property;
        }

        public void add(Component component) {
            component.addPropertyChangeListener(this.m_property, this);
        }

        public void remove(Component component) {
            component.removePropertyChangeListener(this.m_property, this);
        }
    }
}

