/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.console.swingui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;

class Graph
extends JComponent {
    private final double[] m_values;
    private double m_maximum = 0.0;
    private int m_cursor = 0;
    private Color m_color;
    private final int[] m_polygonX;
    private final int[] m_polygonY;
    private boolean m_recalculate = true;

    Graph(int numberOfValues) {
        this.m_values = new double[numberOfValues];
        this.m_polygonX = new int[2 * this.m_values.length + 2];
        this.m_polygonY = new int[2 * this.m_values.length + 2];
        this.setPreferredSize(new Dimension(200, 100));
    }

    public void add(double newValue) {
        this.m_values[this.m_cursor] = newValue;
        if (++this.m_cursor >= this.m_values.length) {
            this.m_cursor = 0;
        }
        this.m_recalculate = true;
        this.repaint();
    }

    public void setColor(Color color) {
        this.m_color = color;
    }

    public void setMaximum(double maximum) {
        this.m_maximum = maximum;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        graphics.setColor(this.m_color);
        if (this.m_recalculate) {
            double xScale = (double)this.getWidth() / (double)this.m_values.length;
            for (int i = 0; i <= this.m_values.length; ++i) {
                int x;
                this.m_polygonX[2 * i] = x = (int)((double)i * xScale);
                this.m_polygonX[2 * i + 1] = x;
            }
            double yScale = this.m_maximum > 0.0 ? (double)this.getHeight() / this.m_maximum : 0.0;
            int cursor = this.m_cursor;
            for (int i = 0; i < this.m_values.length; ++i) {
                int y = (int)((this.m_maximum - this.m_values[cursor]) * yScale);
                if (y == 0 && this.m_maximum > this.m_values[cursor]) {
                    y = 1;
                }
                this.m_polygonY[2 * i + 1] = y;
                this.m_polygonY[2 * i + 2] = y;
                if (++cursor < this.m_values.length) continue;
                cursor = 0;
            }
            this.m_polygonY[0] = (int)(this.m_maximum * yScale);
            this.m_polygonY[2 * this.m_values.length + 1] = this.m_polygonY[0];
            this.m_recalculate = false;
        }
        graphics.fillPolygon(this.m_polygonX, this.m_polygonY, 2 * this.m_values.length + 2);
    }
}

