/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.console.swingui;

import java.awt.Color;
import java.io.IOException;
import java.io.Writer;
import net.grinder.console.common.Resources;
import net.grinder.console.model.SampleModel;
import net.grinder.console.model.SampleModelViews;
import net.grinder.console.swingui.Colours;
import net.grinder.console.swingui.DynamicStatisticsTableModel;
import net.grinder.console.swingui.SwingDispatcherFactory;
import net.grinder.statistics.StatisticsSet;

final class CumulativeStatisticsTableModel
extends DynamicStatisticsTableModel {
    private boolean m_includeTotals = true;
    private final String m_totalString;

    public CumulativeStatisticsTableModel(SampleModel model, SampleModelViews sampleModelViews, Resources resources, SwingDispatcherFactory swingDispatcherFactory) {
        super(model, sampleModelViews, resources, swingDispatcherFactory);
        this.m_totalString = resources.getString("table.total.label");
        this.resetStatisticsViews();
    }

    @Override
    public synchronized void resetStatisticsViews() {
        super.resetStatisticsViews();
        this.addColumns(this.getModelViews().getCumulativeStatisticsView());
    }

    @Override
    protected StatisticsSet getStatistics(int row) {
        return this.getLastModelTestIndex().getCumulativeStatistics(row);
    }

    @Override
    public synchronized int getRowCount() {
        return super.getRowCount() + (this.m_includeTotals ? 1 : 0);
    }

    @Override
    public synchronized Object getValueAt(int row, int column) {
        if (row < this.getLastModelTestIndex().getNumberOfTests()) {
            return super.getValueAt(row, column);
        }
        switch (column) {
            case 0: {
                return this.m_totalString;
            }
            case 1: {
                return "";
            }
        }
        return this.getDynamicField(this.getModel().getTotalCumulativeStatistics(), column - 2);
    }

    @Override
    public boolean isBold(int row, int column) {
        if (row < this.getLastModelTestIndex().getNumberOfTests()) {
            return super.isBold(row, column);
        }
        return true;
    }

    @Override
    public Color getForeground(int row, int column) {
        if (row < this.getLastModelTestIndex().getNumberOfTests()) {
            return super.getForeground(row, column);
        }
        if (column == 3 && this.getModelViews().getTestStatisticsQueries().getNumberOfErrors(this.getModel().getTotalCumulativeStatistics()) > 0L) {
            return Colours.RED;
        }
        return null;
    }

    @Override
    public Color getBackground(int row, int column) {
        if (row < this.getLastModelTestIndex().getNumberOfTests()) {
            return super.getBackground(row, column);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void writeWithoutTotals(Writer writer, String columnDelimiter, String lineDelimeter) throws IOException {
        try {
            this.m_includeTotals = false;
            super.write(writer, columnDelimiter, lineDelimeter);
        }
        finally {
            this.m_includeTotals = true;
        }
    }
}

