/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.tools.tcpproxy;

import HTTPClient.HTTPConnection;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import javax.net.ServerSocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import net.grinder.common.Closer;
import net.grinder.common.SSLContextFactory;
import net.grinder.tools.tcpproxy.EndPoint;
import net.grinder.tools.tcpproxy.TCPProxySSLSocketFactory;
import net.grinder.tools.tcpproxy.VerboseConnectException;
import net.grinder.util.InsecureSSLContextFactory;

public final class TCPProxySSLSocketFactoryImplementation
implements TCPProxySSLSocketFactory {
    private final ServerSocketFactory m_serverSocketFactory;
    private final SSLSocketFactory m_clientSocketFactory;

    public TCPProxySSLSocketFactoryImplementation(File keyStoreFile, char[] keyStorePassword, String keyStoreType) throws IOException, GeneralSecurityException, SSLContextFactory.SSLContextFactoryException {
        this(new FileInputStream(keyStoreFile), keyStoreType != null ? keyStoreType : KeyStore.getDefaultType(), keyStorePassword);
    }

    public TCPProxySSLSocketFactoryImplementation() throws IOException, GeneralSecurityException, SSLContextFactory.SSLContextFactoryException {
        this(TCPProxySSLSocketFactoryImplementation.class.getResourceAsStream("resources/default.keystore"), "jks", "passphrase".toCharArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TCPProxySSLSocketFactoryImplementation(InputStream keyStoreInputStream, String keyStoreType, char[] keyStorePassword) throws IOException, GeneralSecurityException, SSLContextFactory.SSLContextFactoryException {
        try {
            InsecureSSLContextFactory sslContextFactory = new InsecureSSLContextFactory(keyStoreInputStream, keyStorePassword, keyStoreType);
            SSLContext sslContext = sslContextFactory.getSSLContext();
            this.m_clientSocketFactory = sslContext.getSocketFactory();
            this.m_serverSocketFactory = sslContext.getServerSocketFactory();
        }
        finally {
            Closer.close((InputStream)keyStoreInputStream);
        }
    }

    @Override
    public ServerSocket createServerSocket(EndPoint localEndPoint, int timeout) throws IOException {
        SSLServerSocket socket = (SSLServerSocket)this.m_serverSocketFactory.createServerSocket(localEndPoint.getPort(), 50, InetAddress.getByName(localEndPoint.getHost()));
        socket.setSoTimeout(timeout);
        socket.setEnabledCipherSuites(socket.getSupportedCipherSuites());
        socket.setEnabledProtocols(socket.getSupportedProtocols());
        return socket;
    }

    @Override
    public Socket createClientSocket(EndPoint remoteEndPoint) throws IOException {
        SSLSocket socket;
        try {
            socket = (SSLSocket)this.m_clientSocketFactory.createSocket(remoteEndPoint.getHost(), remoteEndPoint.getPort());
        }
        catch (ConnectException e) {
            throw new VerboseConnectException(e, "SSL end point " + remoteEndPoint);
        }
        socket.setEnabledCipherSuites(HTTPConnection.getSSLCipherSuites());
        socket.setEnabledProtocols(HTTPConnection.getSSLProtocols());
        return socket;
    }

    @Override
    public Socket createClientSocket(Socket existingSocket, EndPoint remoteEndPoint) throws IOException {
        SSLSocket socket = (SSLSocket)this.m_clientSocketFactory.createSocket(existingSocket, remoteEndPoint.getHost(), remoteEndPoint.getPort(), true);
        socket.setEnabledCipherSuites(HTTPConnection.getSSLCipherSuites());
        socket.setEnabledProtocols(HTTPConnection.getSSLProtocols());
        return socket;
    }
}

