/*
 * Decompiled with CFR 0.152.
 */
package net.grinder;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.grinder.plugin.http.tcpproxyfilter.ConnectionCache;
import net.grinder.plugin.http.tcpproxyfilter.ConnectionHandlerFactoryImplementation;
import net.grinder.plugin.http.tcpproxyfilter.HTTPRecordingImplementation;
import net.grinder.plugin.http.tcpproxyfilter.HTTPRequestFilter;
import net.grinder.plugin.http.tcpproxyfilter.HTTPResponseFilter;
import net.grinder.plugin.http.tcpproxyfilter.ParametersFromProperties;
import net.grinder.plugin.http.tcpproxyfilter.ProcessHTTPRecordingWithXSLT;
import net.grinder.plugin.http.tcpproxyfilter.RegularExpressionsImplementation;
import net.grinder.tools.tcpproxy.CommentSourceImplementation;
import net.grinder.tools.tcpproxy.CompositeFilter;
import net.grinder.tools.tcpproxy.ConnectionDetails;
import net.grinder.tools.tcpproxy.EchoFilter;
import net.grinder.tools.tcpproxy.EndPoint;
import net.grinder.tools.tcpproxy.HTTPProxyTCPProxyEngine;
import net.grinder.tools.tcpproxy.NullFilter;
import net.grinder.tools.tcpproxy.PortForwarderTCPProxyEngine;
import net.grinder.tools.tcpproxy.TCPProxyConsole;
import net.grinder.tools.tcpproxy.TCPProxyEngine;
import net.grinder.tools.tcpproxy.TCPProxyFilter;
import net.grinder.tools.tcpproxy.TCPProxySSLSocketFactoryImplementation;
import net.grinder.tools.tcpproxy.TCPProxySocketFactory;
import net.grinder.util.AbstractMainClass;
import net.grinder.util.AttributeStringParserImplementation;
import net.grinder.util.SimpleStringEscaper;
import net.grinder.util.http.URIParserImplementation;
import org.picocontainer.ComponentFactory;
import org.picocontainer.ComponentMonitor;
import org.picocontainer.DefaultPicoContainer;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.behaviors.Caching;
import org.picocontainer.monitors.ConsoleComponentMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TCPProxy
extends AbstractMainClass {
    private static final String USAGE = "  java " + TCPProxy.class.getName() + " <options>" + "\n\n" + "Commonly used options:" + "\n  [-http [jython|clojure|<stylesheet>]]" + "\n                               See below." + "\n  [-console]                   Display the console." + "\n  [-requestfilter <filter>]    Add a request filter." + "\n  [-responsefilter <filter>]   Add a response filter." + "\n  [-localhost <host name/ip>]  Default is localhost." + "\n  [-localport <port>]          Default is 8001." + "\n  [-keystore <file>]           Key store details for" + "\n  [-keystorepassword <pass>]   SSL certificates." + "\n  [-keystoretype <type>]       Default is JSSE dependent." + "\n\n" + "Other options:" + "\n  [-properties <file>]         Properties to pass to the filters." + "\n  [-remotehost <host name>]    Default is localhost." + "\n  [-remoteport <port>]         Default is 7001." + "\n  [-timeout <seconds>]         Proxy engine timeout." + "\n  [-httpproxy <host> <port>]   Route via HTTP/HTTPS proxy." + "\n  [-httpsproxy <host> <port>]  Override -httpproxy settings for" + "\n                               HTTPS." + "\n  [-ssl]                       Use SSL when port forwarding." + "\n  [-colour]                    Be pretty on ANSI terminals." + "\n  [-component <class>]         Register a component class with" + "\n                               the filter PicoContainer." + "\n  [-debug]                     Make PicoContainer chatty." + "\n\n" + "<filter> is the name of a class that implements " + TCPProxyFilter.class.getName() + " or one of NONE, ECHO. The default " + "is ECHO. Multiple filters can be specified for each stream." + "\n\n" + "By default, the TCPProxy listens as an HTTP/HTTPS Proxy on " + "<localhost:localport>." + "\n\n" + "If either -remotehost or -remoteport is specified, the TCPProxy " + "acts a simple port forwarder between <localhost:localport> and " + "<remotehost:remoteport>. Specify -ssl for SSL support." + "\n\n" + "-http sets up request and response filters to produce a test script " + "suitable for use with the HTTP plugin. The keywords 'jython', or " + "'clojure' can be used to set the script language; or the filename of " + "of an alternative XSLT style sheet can be provided. The default is" + "'jython' which creates a Jython script." + "\n\n" + "-timeout is how long the TCPProxy will wait for a request " + "before timing out and freeing the local port. The TCPProxy will " + "not time out if there are active connections." + "\n\n" + "-console displays a simple control window that allows the TCPProxy " + "to be shutdown cleanly. This is needed because some shells, e.g. " + "Cygwin bash, do not allow Java processes to be interrupted cleanly, " + "so filters cannot rely on standard shutdown hooks. " + "\n\n" + "-httpproxy and -httpsproxy allow output to be directed through " + "another HTTP/HTTPS proxy; this may help you reach the Internet. " + "These options are not supported in port forwarding mode." + "\n\n" + "Typical usage: " + "\n  java " + TCPProxy.class + " -http -console > grinder.py" + "\n\n";
    private final DefaultPicoContainer m_filterContainer = new DefaultPicoContainer((ComponentFactory)new Caching());
    private final TCPProxyEngine m_proxyEngine;

    public static void main(String[] args) {
        Logger logger = LoggerFactory.getLogger((String)"tcpproxy");
        try {
            TCPProxy tcpProxy = new TCPProxy(args, logger);
            tcpProxy.run();
        }
        catch (AbstractMainClass.LoggedInitialisationException e) {
            System.exit(1);
        }
        catch (Throwable e) {
            logger.error("Could not initialise", e);
            System.exit(2);
        }
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TCPProxy(String[] args, Logger logger) throws Exception {
        super(logger, USAGE);
        PrintWriter output = new PrintWriter(System.out);
        this.m_filterContainer.addComponent((Object)output);
        this.m_filterContainer.addComponent((Object)logger);
        CommentSourceImplementation commentSource = new CommentSourceImplementation();
        this.m_filterContainer.addComponent((Object)commentSource);
        int localPort = 8001;
        String remoteHost = "localhost";
        String localHost = "localhost";
        int remotePort = 7001;
        boolean useSSLPortForwarding = false;
        File keyStoreFile = null;
        char[] keyStorePassword = null;
        String keyStoreType = null;
        boolean isHTTPProxy = true;
        boolean console = false;
        EndPoint chainedHTTPProxy = null;
        EndPoint chainedHTTPSProxy = null;
        int timeout = 0;
        boolean useColour = false;
        FilterChain requestFilterChain = new FilterChain("request");
        FilterChain responseFilterChain = new FilterChain("response");
        try {
            int i;
            for (i = 0; i < args.length; ++i) {
                if (!"-properties".equalsIgnoreCase(args[i])) continue;
                Properties properties = new Properties();
                FileInputStream in = new FileInputStream(new File(args[++i]));
                try {
                    properties.load(in);
                }
                finally {
                    in.close();
                }
                System.getProperties().putAll((Map<?, ?>)properties);
            }
            for (i = 0; i < args.length; ++i) {
                if ("-requestfilter".equalsIgnoreCase(args[i])) {
                    requestFilterChain.add(args[++i]);
                    continue;
                }
                if ("-responsefilter".equalsIgnoreCase(args[i])) {
                    responseFilterChain.add(args[++i]);
                    continue;
                }
                if ("-component".equalsIgnoreCase(args[i])) {
                    Class<?> componentClass;
                    try {
                        componentClass = Class.forName(args[++i]);
                    }
                    catch (ClassNotFoundException e) {
                        throw this.barfError("Class '" + args[i] + "' not found.");
                    }
                    this.m_filterContainer.addComponent(componentClass);
                    continue;
                }
                if ("-http".equalsIgnoreCase(args[i])) {
                    String s;
                    requestFilterChain.add(HTTPRequestFilter.class);
                    responseFilterChain.add(HTTPResponseFilter.class);
                    this.m_filterContainer.addComponent(AttributeStringParserImplementation.class);
                    this.m_filterContainer.addComponent(ConnectionCache.class);
                    this.m_filterContainer.addComponent(ConnectionHandlerFactoryImplementation.class);
                    this.m_filterContainer.addComponent(ParametersFromProperties.class);
                    this.m_filterContainer.addComponent(HTTPRecordingImplementation.class);
                    this.m_filterContainer.addComponent(ProcessHTTPRecordingWithXSLT.class);
                    this.m_filterContainer.addComponent(RegularExpressionsImplementation.class);
                    this.m_filterContainer.addComponent(URIParserImplementation.class);
                    this.m_filterContainer.addComponent(SimpleStringEscaper.class);
                    if (i + 1 >= args.length || args[i + 1].startsWith("-") || "jython".equals(s = args[++i])) continue;
                    if ("oldjython".equals(s)) {
                        this.m_filterContainer.addComponent((Object)ProcessHTTPRecordingWithXSLT.BuiltInStyleSheet.TraditionalJython);
                        continue;
                    }
                    if ("clojure".equals(s)) {
                        this.m_filterContainer.addComponent((Object)ProcessHTTPRecordingWithXSLT.BuiltInStyleSheet.Clojure);
                        continue;
                    }
                    this.m_filterContainer.addComponent((Object)new ProcessHTTPRecordingWithXSLT.StyleSheetFile(new File(s)));
                    continue;
                }
                if ("-localhost".equalsIgnoreCase(args[i])) {
                    localHost = args[++i];
                    continue;
                }
                if ("-localport".equalsIgnoreCase(args[i])) {
                    localPort = Integer.parseInt(args[++i]);
                    continue;
                }
                if ("-remotehost".equalsIgnoreCase(args[i])) {
                    remoteHost = args[++i];
                    isHTTPProxy = false;
                    continue;
                }
                if ("-remoteport".equalsIgnoreCase(args[i])) {
                    remotePort = Integer.parseInt(args[++i]);
                    isHTTPProxy = false;
                    continue;
                }
                if ("-ssl".equalsIgnoreCase(args[i])) {
                    useSSLPortForwarding = true;
                    continue;
                }
                if ("-keystore".equalsIgnoreCase(args[i])) {
                    keyStoreFile = new File(args[++i]);
                    continue;
                }
                if ("-keystorepassword".equalsIgnoreCase(args[i]) || "-storepass".equalsIgnoreCase(args[i])) {
                    keyStorePassword = args[++i].toCharArray();
                    continue;
                }
                if ("-keystoretype".equalsIgnoreCase(args[i]) || "-storetype".equalsIgnoreCase(args[i])) {
                    keyStoreType = args[++i];
                    continue;
                }
                if ("-timeout".equalsIgnoreCase(args[i])) {
                    timeout = Integer.parseInt(args[++i]) * 1000;
                    continue;
                }
                if ("-console".equalsIgnoreCase(args[i])) {
                    console = true;
                    continue;
                }
                if ("-colour".equalsIgnoreCase(args[i]) || "-color".equalsIgnoreCase(args[i])) {
                    useColour = true;
                    continue;
                }
                if ("-properties".equalsIgnoreCase(args[i])) {
                    ++i;
                    continue;
                }
                if ("-httpproxy".equalsIgnoreCase(args[i])) {
                    chainedHTTPProxy = new EndPoint(args[++i], Integer.parseInt(args[++i]));
                    continue;
                }
                if ("-httpsproxy".equalsIgnoreCase(args[i])) {
                    chainedHTTPSProxy = new EndPoint(args[++i], Integer.parseInt(args[++i]));
                    continue;
                }
                if ("-debug".equalsIgnoreCase(args[i])) {
                    this.m_filterContainer.changeMonitor((ComponentMonitor)new ConsoleComponentMonitor((OutputStream)System.err));
                    continue;
                }
                throw this.barfUsage();
            }
        }
        catch (FileNotFoundException fnfe) {
            throw this.barfError(fnfe.getMessage());
        }
        catch (IndexOutOfBoundsException e) {
            throw this.barfUsage();
        }
        catch (NumberFormatException e) {
            throw this.barfUsage();
        }
        if (timeout < 0) {
            throw this.barfError("Timeout must be non-negative.");
        }
        EndPoint localEndPoint = new EndPoint(localHost, localPort);
        EndPoint remoteEndPoint = new EndPoint(remoteHost, remotePort);
        if (chainedHTTPSProxy == null && chainedHTTPProxy != null) {
            chainedHTTPSProxy = chainedHTTPProxy;
        }
        if (chainedHTTPSProxy != null && !isHTTPProxy) {
            throw this.barfError("Routing through a HTTP/HTTPS proxy is not supported in port forwarding mode.");
        }
        TCPProxyFilter requestFilter = requestFilterChain.resolveFilter();
        TCPProxyFilter responseFilter = responseFilterChain.resolveFilter();
        StringBuilder startMessage = new StringBuilder();
        startMessage.append("Initialising as ");
        if (isHTTPProxy) {
            startMessage.append("an HTTP/HTTPS proxy");
        } else if (useSSLPortForwarding) {
            startMessage.append("an SSL port forwarder");
        } else {
            startMessage.append("a TCP port forwarder");
        }
        startMessage.append(" with the parameters:");
        startMessage.append("\n   Request filters:    ");
        startMessage.append(requestFilter);
        startMessage.append("\n   Response filters:   ");
        startMessage.append(responseFilter);
        startMessage.append("\n   Local address:      " + localEndPoint);
        if (!isHTTPProxy) {
            startMessage.append("\n   Remote address:     " + remoteEndPoint);
        }
        if (chainedHTTPProxy != null) {
            startMessage.append("\n   HTTP proxy:         " + chainedHTTPProxy);
        }
        if (chainedHTTPSProxy != null) {
            startMessage.append("\n   HTTPS proxy:        " + chainedHTTPSProxy);
        }
        if (keyStoreFile != null) {
            startMessage.append("\n   Key store:          ");
            startMessage.append(keyStoreFile.toString());
            if (keyStorePassword != null) {
                startMessage.append("\n   Key store password: ");
                for (int i = 0; i < keyStorePassword.length; ++i) {
                    startMessage.append('*');
                }
            }
            if (keyStoreType != null) {
                startMessage.append("\n   Key store type:     " + keyStoreType);
            }
        }
        logger.info(startMessage.toString());
        TCPProxySSLSocketFactoryImplementation sslSocketFactory = keyStoreFile != null ? new TCPProxySSLSocketFactoryImplementation(keyStoreFile, keyStorePassword, keyStoreType) : new TCPProxySSLSocketFactoryImplementation();
        this.m_filterContainer.start();
        this.m_proxyEngine = isHTTPProxy ? new HTTPProxyTCPProxyEngine(sslSocketFactory, requestFilter, responseFilter, output, logger, localEndPoint, useColour, timeout, chainedHTTPProxy, chainedHTTPSProxy) : (useSSLPortForwarding ? new PortForwarderTCPProxyEngine((TCPProxySocketFactory)sslSocketFactory, requestFilter, responseFilter, output, logger, new ConnectionDetails(localEndPoint, remoteEndPoint, true), useColour, timeout) : new PortForwarderTCPProxyEngine(requestFilter, responseFilter, output, logger, new ConnectionDetails(localEndPoint, remoteEndPoint, false), useColour, timeout));
        if (console) {
            new TCPProxyConsole(this.m_proxyEngine, commentSource);
        }
        logger.info("Engine initialised, listening on port " + localPort);
    }

    private void run() {
        Runnable shutdown = new Runnable(){
            private boolean m_stopped = false;

            @Override
            public synchronized void run() {
                if (!this.m_stopped) {
                    this.m_stopped = true;
                    TCPProxy.this.m_proxyEngine.stop();
                    TCPProxy.this.m_filterContainer.stop();
                    TCPProxy.this.m_filterContainer.dispose();
                }
            }
        };
        Runtime.getRuntime().addShutdownHook(new Thread(shutdown));
        this.m_proxyEngine.run();
        shutdown.run();
        this.getLogger().info("Engine exited");
    }

    PicoContainer getFilterContainer() {
        return this.m_filterContainer;
    }

    private final class FilterChain {
        private final String m_type;
        private final List<String> m_filterKeys = new ArrayList<String>();
        private int m_value;

        public FilterChain(String type) {
            this.m_type = type;
        }

        public void add(Class<? extends TCPProxyFilter> theClass) {
            String key = this.m_type + ++this.m_value;
            TCPProxy.this.m_filterContainer.addComponent((Object)key, theClass, new Parameter[0]);
            this.m_filterKeys.add(key);
        }

        public void add(String filterClassName) throws AbstractMainClass.LoggedInitialisationException {
            if ("NONE".equals(filterClassName)) {
                this.add(NullFilter.class);
            } else if ("ECHO".equals(filterClassName)) {
                this.add(EchoFilter.class);
            } else {
                Class<?> filterClass;
                try {
                    filterClass = Class.forName(filterClassName);
                }
                catch (ClassNotFoundException e) {
                    throw TCPProxy.this.barfError("Class '" + filterClassName + "' not found.");
                }
                if (!TCPProxyFilter.class.isAssignableFrom(filterClass)) {
                    throw TCPProxy.this.barfError("The class '" + filterClass.getName() + "' does not implement the interface: '" + TCPProxyFilter.class.getName() + "'.");
                }
                this.add(filterClass);
            }
        }

        public TCPProxyFilter resolveFilter() {
            if (this.m_filterKeys.size() == 0) {
                this.add(EchoFilter.class);
            }
            CompositeFilter result = new CompositeFilter();
            for (String key : this.m_filterKeys) {
                result.add((TCPProxyFilter)TCPProxy.this.m_filterContainer.getComponent((Object)key));
            }
            return result;
        }
    }
}

