/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.AuthorizationInfo;
import HTTPClient.CIHashtable;
import HTTPClient.Codecs;
import HTTPClient.GlobalConstants;
import HTTPClient.HTTPClientModule;
import HTTPClient.HTTPClientModuleConstants;
import HTTPClient.HTTPResponse;
import HTTPClient.HttpHeaderElement;
import HTTPClient.HttpOutputStream;
import HTTPClient.IdempotentSequence;
import HTTPClient.LinkedList;
import HTTPClient.Log;
import HTTPClient.ModuleException;
import HTTPClient.NVPair;
import HTTPClient.ParseException;
import HTTPClient.ProtocolNotSuppException;
import HTTPClient.Request;
import HTTPClient.Response;
import HTTPClient.SocksClient;
import HTTPClient.SocksException;
import HTTPClient.StreamDemultiplexor;
import HTTPClient.URI;
import HTTPClient.Util;
import java.applet.Applet;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.security.cert.X509Certificate;
import sun.security.x509.X500Name;

public class HTTPConnection
implements GlobalConstants,
HTTPClientModuleConstants {
    public static final String version = "RPT-HTTPClient/0.3-3E";
    private static final Object dflt_context;
    private Object Context = null;
    private int Protocol;
    int ServerProtocolVersion;
    boolean ServProtVersKnown;
    private String RequestProtocolVersion;
    private String Host;
    private int Port;
    private InetAddress LocalAddr;
    private int LocalPort;
    private String Proxy_Host = null;
    private int Proxy_Port;
    private static String Default_Proxy_Host;
    private static int Default_Proxy_Port;
    private static CIHashtable non_proxy_host_list;
    private static Vector non_proxy_dom_list;
    private static Vector non_proxy_addr_list;
    private static Vector non_proxy_mask_list;
    private SocksClient Socks_client = null;
    private static SocksClient Default_Socks_client;
    private StreamDemultiplexor input_demux = null;
    LinkedList DemuxList = new LinkedList();
    private LinkedList RequestList = new LinkedList();
    private boolean doesKeepAlive = false;
    private boolean keepAliveUnknown = true;
    private int keepAliveReqMax = -1;
    private int keepAliveReqLeft;
    private static boolean no_chunked;
    private static boolean force_1_0;
    private static boolean neverPipeline;
    private static boolean noKeepAlives;
    private static boolean haveMSLargeWritesBug;
    static boolean deferStreamed;
    private static boolean noTrailers;
    private AtomicLong DNS_time = new AtomicLong();
    private AtomicLong con_time = new AtomicLong();
    private AtomicLong connectionsEstablished = new AtomicLong();
    private static TimeAuthority standardTimeAuthority;
    private TimeAuthority timeAuthority = standardTimeAuthority;
    private static int DefaultTimeout;
    private int Timeout;
    private NVPair[] DefaultHeaders = new NVPair[0];
    private static Vector DefaultModuleList;
    private Vector ModuleList;
    private static boolean defaultAllowUI;
    private boolean allowUI;
    private static SSLSocketFactory defaultSSLFactory;
    private SSLSocketFactory sslFactory;
    private static final String[] sslCipherSuites;
    private static final String[] sslProtocols;
    private volatile Response early_stall = null;
    private volatile Response late_stall = null;
    private volatile Response prev_resp = null;
    private boolean output_finished = true;
    private boolean check_certificates = true;
    private boolean test_connnection_health_with_blocking_read = false;
    private static BandwidthLimiterFactory s_defaultBandwidthLimiterFactory;
    private BandwidthLimiterFactory m_bandwidthLimiterFactory = s_defaultBandwidthLimiterFactory;

    public void setTimeAuthority(TimeAuthority timeAuthority) {
        this.timeAuthority = timeAuthority;
    }

    public TimeAuthority getTimeAuthority() {
        return this.timeAuthority;
    }

    public static String[] getSSLCipherSuites() {
        return sslCipherSuites;
    }

    public static String[] getSSLProtocols() {
        return sslProtocols;
    }

    public HTTPConnection(Applet applet) throws ProtocolNotSuppException {
        this(applet.getCodeBase().getProtocol(), applet.getCodeBase().getHost(), applet.getCodeBase().getPort());
    }

    public HTTPConnection(String host) {
        this.Setup(0, host, 80, null, -1);
    }

    public HTTPConnection(String host, int port) {
        this.Setup(0, host, port, null, -1);
    }

    public HTTPConnection(String prot, String host, int port) throws ProtocolNotSuppException {
        this(prot, host, port, null, -1);
    }

    public HTTPConnection(String prot, String host, int port, InetAddress localAddr, int localPort) throws ProtocolNotSuppException {
        prot = prot.trim().toLowerCase();
        if (!prot.equals("http") && !prot.equals("https")) {
            throw new ProtocolNotSuppException("Unsupported protocol '" + prot + "'");
        }
        if (prot.equals("http")) {
            this.Setup(0, host, port, localAddr, localPort);
        } else if (prot.equals("https")) {
            this.Setup(1, host, port, localAddr, localPort);
        } else if (prot.equals("shttp")) {
            this.Setup(2, host, port, localAddr, localPort);
        } else if (prot.equals("http-ng")) {
            this.Setup(3, host, port, localAddr, localPort);
        }
    }

    public HTTPConnection(URL url) throws ProtocolNotSuppException {
        this(url.getProtocol(), url.getHost(), url.getPort());
    }

    public HTTPConnection(URI uri) throws ProtocolNotSuppException {
        this(uri.getScheme(), uri.getHost(), uri.getPort());
    }

    private void Setup(int prot, String host, int port, InetAddress localAddr, int localPort) {
        this.Protocol = prot;
        this.Host = host.trim().toLowerCase();
        this.Port = port;
        this.LocalAddr = localAddr;
        this.LocalPort = localPort;
        if (this.Port == -1) {
            this.Port = URI.defaultPort(this.getProtocol());
        }
        if (Default_Proxy_Host != null && !this.matchNonProxy(this.Host)) {
            this.setCurrentProxy(Default_Proxy_Host, Default_Proxy_Port);
        } else {
            this.setCurrentProxy(null, 0);
        }
        this.Socks_client = Default_Socks_client;
        this.Timeout = DefaultTimeout;
        this.ModuleList = (Vector)DefaultModuleList.clone();
        this.allowUI = defaultAllowUI;
        if (noKeepAlives) {
            this.setDefaultHeaders(new NVPair[]{new NVPair("Connection", "close")});
        }
        this.sslFactory = defaultSSLFactory;
    }

    private boolean matchNonProxy(String host) {
        InetAddress[] host_addr;
        if (non_proxy_host_list.get(host) != null) {
            return true;
        }
        for (int idx = 0; idx < non_proxy_dom_list.size(); ++idx) {
            if (!host.endsWith((String)non_proxy_dom_list.elementAt(idx))) continue;
            return true;
        }
        if (non_proxy_addr_list.size() == 0) {
            return false;
        }
        try {
            host_addr = InetAddress.getAllByName(host);
        }
        catch (UnknownHostException uhe) {
            return false;
        }
        for (int idx = 0; idx < non_proxy_addr_list.size(); ++idx) {
            byte[] addr = (byte[])non_proxy_addr_list.elementAt(idx);
            byte[] mask = (byte[])non_proxy_mask_list.elementAt(idx);
            block4: for (int idx2 = 0; idx2 < host_addr.length; ++idx2) {
                byte[] raw_addr = host_addr[idx2].getAddress();
                if (raw_addr.length != addr.length) continue;
                for (int idx3 = 0; idx3 < raw_addr.length; ++idx3) {
                    if ((raw_addr[idx3] & mask[idx3]) != (addr[idx3] & mask[idx3])) continue block4;
                }
                return true;
            }
        }
        return false;
    }

    public HTTPResponse Head(String file) throws IOException, ModuleException {
        return this.Head(file, (String)null, null);
    }

    public HTTPResponse Head(String file, NVPair[] form_data) throws IOException, ModuleException {
        return this.Head(file, form_data, null);
    }

    public HTTPResponse Head(String file, NVPair[] form_data, NVPair[] headers) throws IOException, ModuleException {
        String File2 = this.stripRef(file);
        String query = Codecs.nv2query(form_data);
        if (query != null && query.length() > 0) {
            File2 = File2 + "?" + query;
        }
        return this.setupRequest("HEAD", File2, headers, null, null);
    }

    public HTTPResponse Head(String file, String query) throws IOException, ModuleException {
        return this.Head(file, query, null);
    }

    public HTTPResponse Head(String file, String query, NVPair[] headers) throws IOException, ModuleException {
        String File2 = this.stripRef(file);
        if (query != null && query.length() > 0) {
            File2 = File2 + "?" + Codecs.URLEncode(query);
        }
        return this.setupRequest("HEAD", File2, headers, null, null);
    }

    public HTTPResponse Get(String file) throws IOException, ModuleException {
        return this.Get(file, (String)null, null);
    }

    public HTTPResponse Get(String file, NVPair[] form_data) throws IOException, ModuleException {
        return this.Get(file, form_data, null);
    }

    public HTTPResponse Get(String file, NVPair[] form_data, NVPair[] headers) throws IOException, ModuleException {
        String File2 = this.stripRef(file);
        String query = Codecs.nv2query(form_data);
        if (query != null && query.length() > 0) {
            File2 = File2 + "?" + query;
        }
        return this.setupRequest("GET", File2, headers, null, null);
    }

    public HTTPResponse Get(String file, String query) throws IOException, ModuleException {
        return this.Get(file, query, null);
    }

    public HTTPResponse Get(String file, String query, NVPair[] headers) throws IOException, ModuleException {
        String File2 = this.stripRef(file);
        if (query != null && query.length() > 0) {
            File2 = File2 + "?" + Codecs.URLEncode(query);
        }
        return this.setupRequest("GET", File2, headers, null, null);
    }

    public HTTPResponse Post(String file) throws IOException, ModuleException {
        return this.Post(file, (byte[])null, null);
    }

    public HTTPResponse Post(String file, NVPair[] form_data) throws IOException, ModuleException {
        NVPair[] headers = new NVPair[]{new NVPair("Content-Type", "application/x-www-form-urlencoded")};
        return this.Post(file, Codecs.nv2query(form_data), headers);
    }

    public HTTPResponse Post(String file, NVPair[] form_data, NVPair[] headers) throws IOException, ModuleException {
        int idx;
        for (idx = 0; !(idx >= headers.length || headers[idx] != null && headers[idx].getName().equalsIgnoreCase("Content-type")); ++idx) {
        }
        if (idx == headers.length) {
            headers = Util.resizeArray(headers, idx + 1);
            headers[idx] = new NVPair("Content-Type", "application/x-www-form-urlencoded");
        }
        return this.Post(file, Codecs.nv2query(form_data), headers);
    }

    public HTTPResponse Post(String file, String data) throws IOException, ModuleException {
        return this.Post(file, data, null);
    }

    public HTTPResponse Post(String file, String data, NVPair[] headers) throws IOException, ModuleException {
        byte[] tmp = null;
        if (data != null && data.length() > 0) {
            tmp = data.getBytes();
        }
        return this.Post(file, tmp, headers);
    }

    public HTTPResponse Post(String file, byte[] data) throws IOException, ModuleException {
        return this.Post(file, data, null);
    }

    public HTTPResponse Post(String file, byte[] data, NVPair[] headers) throws IOException, ModuleException {
        if (data == null) {
            data = new byte[]{};
        }
        return this.setupRequest("POST", this.stripRef(file), headers, data, null);
    }

    public HTTPResponse Post(String file, HttpOutputStream stream) throws IOException, ModuleException {
        return this.Post(file, stream, null);
    }

    public HTTPResponse Post(String file, HttpOutputStream stream, NVPair[] headers) throws IOException, ModuleException {
        return this.setupRequest("POST", this.stripRef(file), headers, null, stream);
    }

    public HTTPResponse Put(String file, String data) throws IOException, ModuleException {
        return this.Put(file, data, null);
    }

    public HTTPResponse Put(String file, String data, NVPair[] headers) throws IOException, ModuleException {
        byte[] tmp = null;
        if (data != null && data.length() > 0) {
            tmp = data.getBytes();
        }
        return this.Put(file, tmp, headers);
    }

    public HTTPResponse Put(String file, byte[] data) throws IOException, ModuleException {
        return this.Put(file, data, null);
    }

    public HTTPResponse Put(String file, byte[] data, NVPair[] headers) throws IOException, ModuleException {
        if (data == null) {
            data = new byte[]{};
        }
        return this.setupRequest("PUT", this.stripRef(file), headers, data, null);
    }

    public HTTPResponse Put(String file, HttpOutputStream stream) throws IOException, ModuleException {
        return this.Put(file, stream, null);
    }

    public HTTPResponse Put(String file, HttpOutputStream stream, NVPair[] headers) throws IOException, ModuleException {
        return this.setupRequest("PUT", this.stripRef(file), headers, null, stream);
    }

    public HTTPResponse Options(String file) throws IOException, ModuleException {
        return this.Options(file, null, (byte[])null);
    }

    public HTTPResponse Options(String file, NVPair[] headers) throws IOException, ModuleException {
        return this.Options(file, headers, (byte[])null);
    }

    public HTTPResponse Options(String file, NVPair[] headers, byte[] data) throws IOException, ModuleException {
        return this.setupRequest("OPTIONS", this.stripRef(file), headers, data, null);
    }

    public HTTPResponse Options(String file, NVPair[] headers, HttpOutputStream stream) throws IOException, ModuleException {
        return this.setupRequest("OPTIONS", this.stripRef(file), headers, null, stream);
    }

    public HTTPResponse Delete(String file) throws IOException, ModuleException {
        return this.Delete(file, null);
    }

    public HTTPResponse Delete(String file, NVPair[] headers) throws IOException, ModuleException {
        return this.setupRequest("DELETE", this.stripRef(file), headers, null, null);
    }

    public HTTPResponse Trace(String file, NVPair[] headers) throws IOException, ModuleException {
        return this.setupRequest("TRACE", this.stripRef(file), headers, null, null);
    }

    public HTTPResponse Trace(String file) throws IOException, ModuleException {
        return this.Trace(file, null);
    }

    public HTTPResponse ExtensionMethod(String method, String file, byte[] data, NVPair[] headers) throws IOException, ModuleException {
        return this.setupRequest(method.trim(), this.stripRef(file), headers, data, null);
    }

    public HTTPResponse ExtensionMethod(String method, String file, HttpOutputStream os, NVPair[] headers) throws IOException, ModuleException {
        return this.setupRequest(method.trim(), this.stripRef(file), headers, null, os);
    }

    public void stop() {
        Request req = (Request)this.RequestList.enumerate();
        while (req != null) {
            req.aborted = true;
            req = (Request)this.RequestList.next();
        }
        StreamDemultiplexor demux = (StreamDemultiplexor)this.DemuxList.enumerate();
        while (demux != null) {
            demux.abort();
            demux = (StreamDemultiplexor)this.DemuxList.next();
        }
    }

    public static void setDefaultSSLSocketFactory(SSLSocketFactory sslFactory) {
        defaultSSLFactory = sslFactory;
    }

    public static SSLSocketFactory getDefaultSSLSocketFactory() {
        return defaultSSLFactory;
    }

    public void setSSLSocketFactory(SSLSocketFactory sslFactory) {
        this.sslFactory = sslFactory;
    }

    public SSLSocketFactory getSSLSocketFactory() {
        return this.sslFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultHeaders(NVPair[] headers) {
        int length = headers == null ? 0 : headers.length;
        NVPair[] def_hdrs = new NVPair[length];
        int didx = 0;
        for (int sidx = 0; sidx < length; ++sidx) {
            String name;
            if (headers[sidx] == null || (name = headers[sidx].getName().trim()).equalsIgnoreCase("Content-length")) continue;
            def_hdrs[didx++] = headers[sidx];
        }
        if (didx < length) {
            def_hdrs = Util.resizeArray(def_hdrs, didx);
        }
        NVPair[] nVPairArray = this.DefaultHeaders;
        synchronized (this.DefaultHeaders) {
            this.DefaultHeaders = def_hdrs;
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NVPair[] getDefaultHeaders() {
        NVPair[] nVPairArray = this.DefaultHeaders;
        synchronized (this.DefaultHeaders) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return (NVPair[])this.DefaultHeaders.clone();
        }
    }

    public String getProtocol() {
        switch (this.Protocol) {
            case 0: {
                return "http";
            }
            case 1: {
                return "https";
            }
            case 2: {
                return "shttp";
            }
            case 3: {
                return "http-ng";
            }
        }
        throw new Error("HTTPClient Internal Error: invalid protocol " + this.Protocol);
    }

    public String getHost() {
        return this.Host;
    }

    public int getPort() {
        return this.Port;
    }

    public String getProxyHost() {
        return this.Proxy_Host;
    }

    public int getProxyPort() {
        return this.Proxy_Port;
    }

    public boolean isCompatibleWith(URI uri) {
        if (!uri.getScheme().equals(this.getProtocol()) || !uri.getHost().equalsIgnoreCase(this.Host)) {
            return false;
        }
        int port = uri.getPort();
        if (port == -1) {
            port = URI.defaultPort(uri.getScheme());
        }
        return port == this.Port;
    }

    public void setRawMode(boolean raw) {
        String[] modules = new String[]{"HTTPClient.CookieModule", "HTTPClient.RedirectionModule", "HTTPClient.AuthorizationModule", "HTTPClient.DefaultModule", "HTTPClient.TransferEncodingModule", "HTTPClient.ContentMD5Module", "HTTPClient.ContentEncodingModule"};
        for (int idx = 0; idx < modules.length; ++idx) {
            try {
                if (raw) {
                    this.removeModule(Class.forName(modules[idx]));
                    continue;
                }
                this.addModule(Class.forName(modules[idx]), -1);
                continue;
            }
            catch (ClassNotFoundException cnfe) {
                // empty catch block
            }
        }
    }

    public static void setDefaultTimeout(int time) {
        DefaultTimeout = time;
    }

    public static int getDefaultTimeout() {
        return DefaultTimeout;
    }

    public void setTimeout(int time) {
        this.Timeout = time;
    }

    public int getTimeout() {
        return this.Timeout;
    }

    public void setAllowUserInteraction(boolean allow) {
        this.allowUI = allow;
    }

    public boolean getAllowUserInteraction() {
        return this.allowUI;
    }

    public static void setDefaultAllowUserInteraction(boolean allow) {
        defaultAllowUI = allow;
    }

    public static boolean getDefaultAllowUserInteraction() {
        return defaultAllowUI;
    }

    public static Class[] getDefaultModules() {
        return HTTPConnection.getModules(DefaultModuleList);
    }

    public static boolean addDefaultModule(Class module, int pos) {
        return HTTPConnection.addModule(DefaultModuleList, module, pos);
    }

    public static boolean removeDefaultModule(Class module) {
        return HTTPConnection.removeModule(DefaultModuleList, module);
    }

    public Class[] getModules() {
        return HTTPConnection.getModules(this.ModuleList);
    }

    public boolean addModule(Class module, int pos) {
        return HTTPConnection.addModule(this.ModuleList, module, pos);
    }

    public boolean removeModule(Class module) {
        return HTTPConnection.removeModule(this.ModuleList, module);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Class[] getModules(Vector list) {
        Vector vector = list;
        synchronized (vector) {
            Object[] modules = new Class[list.size()];
            list.copyInto(modules);
            return modules;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean addModule(Vector list, Class module, int pos) {
        if (module == null) {
            return false;
        }
        try {
            HTTPClientModule tmp = (HTTPClientModule)module.newInstance();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
        Vector vector = list;
        synchronized (vector) {
            if (list.contains(module)) {
                return false;
            }
            if (pos < 0) {
                list.insertElementAt(module, DefaultModuleList.size() + pos + 1);
            } else {
                list.insertElementAt(module, pos);
            }
        }
        Log.write(1, "Conn:  Added module " + module.getName() + " to " + (list == DefaultModuleList ? "default " : "") + "list");
        return true;
    }

    private static final boolean removeModule(Vector list, Class module) {
        if (module == null) {
            return false;
        }
        boolean removed = list.removeElement(module);
        if (removed) {
            Log.write(1, "Conn:  Removed module " + module.getName() + " from " + (list == DefaultModuleList ? "default " : "") + "list");
        }
        return removed;
    }

    public void setContext(Object context) {
        if (context == null) {
            throw new IllegalArgumentException("Context must be non-null");
        }
        if (this.Context != null) {
            throw new IllegalStateException("Context already set");
        }
        this.Context = context;
    }

    public Object getContext() {
        if (this.Context != null) {
            return this.Context;
        }
        return dflt_context;
    }

    public static Object getDefaultContext() {
        return dflt_context;
    }

    public void addDigestAuthorization(String realm, String user, String passwd) {
        AuthorizationInfo.addDigestAuthorization(this.Host, this.Port, realm, user, passwd, this.getContext());
    }

    public void addBasicAuthorization(String realm, String user, String passwd) {
        AuthorizationInfo.addBasicAuthorization(this.Host, this.Port, realm, user, passwd, this.getContext());
    }

    public static void setProxyServer(String host, int port) {
        if (host == null || host.trim().length() == 0) {
            Default_Proxy_Host = null;
        } else {
            Default_Proxy_Host = host.trim().toLowerCase();
            Default_Proxy_Port = port;
        }
    }

    public synchronized void setCurrentProxy(String host, int port) {
        if (host == null || host.trim().length() == 0) {
            this.Proxy_Host = null;
        } else {
            this.Proxy_Host = host.trim().toLowerCase();
            this.Proxy_Port = port <= 0 ? 80 : port;
        }
        switch (this.Protocol) {
            case 0: 
            case 1: {
                if (force_1_0) {
                    this.ServerProtocolVersion = 65536;
                    this.ServProtVersKnown = true;
                    this.RequestProtocolVersion = "HTTP/1.0";
                    break;
                }
                this.ServerProtocolVersion = 65537;
                this.ServProtVersKnown = false;
                this.RequestProtocolVersion = "HTTP/1.1";
                break;
            }
            case 3: {
                this.ServerProtocolVersion = -1;
                this.ServProtVersKnown = false;
                this.RequestProtocolVersion = "";
                break;
            }
            case 2: {
                this.ServerProtocolVersion = -1;
                this.ServProtVersKnown = false;
                this.RequestProtocolVersion = "Secure-HTTP/1.3";
                break;
            }
            default: {
                throw new Error("HTTPClient Internal Error: invalid protocol " + this.Protocol);
            }
        }
        this.keepAliveUnknown = true;
        this.doesKeepAlive = false;
        this.input_demux = null;
        this.early_stall = null;
        this.late_stall = null;
        this.prev_resp = null;
    }

    public static void dontProxyFor(String host) throws ParseException {
        int idx;
        byte[] ip_mask;
        byte[] ip_addr;
        if ((host = host.trim().toLowerCase()).charAt(0) == '.') {
            if (!non_proxy_dom_list.contains(host)) {
                non_proxy_dom_list.addElement(host);
            }
            return;
        }
        for (int idx2 = 0; idx2 < host.length(); ++idx2) {
            if (Character.isDigit(host.charAt(idx2)) || host.charAt(idx2) == '.' || host.charAt(idx2) == '/') continue;
            non_proxy_host_list.put(host, "");
            return;
        }
        int slash = host.indexOf(47);
        if (slash != -1) {
            ip_addr = HTTPConnection.string2arr(host.substring(0, slash));
            if (ip_addr.length != (ip_mask = HTTPConnection.string2arr(host.substring(slash + 1))).length) {
                throw new ParseException("length of IP-address (" + ip_addr.length + ") != length of netmask (" + ip_mask.length + ")");
            }
        } else {
            ip_addr = HTTPConnection.string2arr(host);
            ip_mask = new byte[ip_addr.length];
            for (idx = 0; idx < ip_mask.length; ++idx) {
                ip_mask[idx] = -1;
            }
        }
        block2: for (idx = 0; idx < non_proxy_addr_list.size(); ++idx) {
            byte[] addr = (byte[])non_proxy_addr_list.elementAt(idx);
            byte[] mask = (byte[])non_proxy_mask_list.elementAt(idx);
            if (addr.length != ip_addr.length) continue;
            for (int idx2 = 0; idx2 < addr.length; ++idx2) {
                if ((ip_addr[idx2] & mask[idx2]) != (addr[idx2] & mask[idx2]) || mask[idx2] != ip_mask[idx2]) continue block2;
            }
            return;
        }
        non_proxy_addr_list.addElement(ip_addr);
        non_proxy_mask_list.addElement(ip_mask);
    }

    public static void dontProxyFor(String[] hosts) {
        if (hosts == null || hosts.length == 0) {
            return;
        }
        for (int idx = 0; idx < hosts.length; ++idx) {
            try {
                if (hosts[idx] == null) continue;
                HTTPConnection.dontProxyFor(hosts[idx]);
                continue;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
    }

    public static boolean doProxyFor(String host) throws ParseException {
        int idx;
        byte[] ip_mask;
        byte[] ip_addr;
        if ((host = host.trim().toLowerCase()).charAt(0) == '.') {
            return non_proxy_dom_list.removeElement(host);
        }
        for (int idx2 = 0; idx2 < host.length(); ++idx2) {
            if (Character.isDigit(host.charAt(idx2)) || host.charAt(idx2) == '.' || host.charAt(idx2) == '/') continue;
            return non_proxy_host_list.remove(host) != null;
        }
        int slash = host.indexOf(47);
        if (slash != -1) {
            ip_addr = HTTPConnection.string2arr(host.substring(0, slash));
            if (ip_addr.length != (ip_mask = HTTPConnection.string2arr(host.substring(slash + 1))).length) {
                throw new ParseException("length of IP-address (" + ip_addr.length + ") != length of netmask (" + ip_mask.length + ")");
            }
        } else {
            ip_addr = HTTPConnection.string2arr(host);
            ip_mask = new byte[ip_addr.length];
            for (idx = 0; idx < ip_mask.length; ++idx) {
                ip_mask[idx] = -1;
            }
        }
        block2: for (idx = 0; idx < non_proxy_addr_list.size(); ++idx) {
            byte[] addr = (byte[])non_proxy_addr_list.elementAt(idx);
            byte[] mask = (byte[])non_proxy_mask_list.elementAt(idx);
            if (addr.length != ip_addr.length) continue;
            for (int idx2 = 0; idx2 < addr.length; ++idx2) {
                if ((ip_addr[idx2] & mask[idx2]) != (addr[idx2] & mask[idx2]) || mask[idx2] != ip_mask[idx2]) continue block2;
            }
            non_proxy_addr_list.removeElementAt(idx);
            non_proxy_mask_list.removeElementAt(idx);
            return true;
        }
        return false;
    }

    private static byte[] string2arr(String ip) {
        char[] ip_char = new char[ip.length()];
        ip.getChars(0, ip_char.length, ip_char, 0);
        int cnt = 0;
        for (int idx = 0; idx < ip_char.length; ++idx) {
            if (ip_char[idx] != '.') continue;
            ++cnt;
        }
        byte[] arr = new byte[cnt + 1];
        cnt = 0;
        int pos = 0;
        for (int idx = 0; idx < ip_char.length; ++idx) {
            if (ip_char[idx] != '.') continue;
            arr[cnt] = (byte)Integer.parseInt(ip.substring(pos, idx));
            ++cnt;
            pos = idx + 1;
        }
        arr[cnt] = (byte)Integer.parseInt(ip.substring(pos));
        return arr;
    }

    public static void setSocksServer(String host) {
        HTTPConnection.setSocksServer(host, 1080);
    }

    public static void setSocksServer(String host, int port) {
        if (port <= 0) {
            port = 1080;
        }
        Default_Socks_client = host == null || host.length() == 0 ? null : new SocksClient(host, port);
    }

    public static void setSocksServer(String host, int port, int version) throws SocksException {
        if (port <= 0) {
            port = 1080;
        }
        Default_Socks_client = host == null || host.length() == 0 ? null : new SocksClient(host, port, version);
    }

    private final String stripRef(String file) {
        if (file == null) {
            return "";
        }
        int hash = file.indexOf(35);
        if (hash != -1) {
            file = file.substring(0, hash);
        }
        return file.trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final HTTPResponse setupRequest(String method, String resource, NVPair[] headers, byte[] entity, HttpOutputStream stream) throws IOException, ModuleException {
        Request req = new Request(this, method, resource, this.mergedHeaders(headers), entity, stream, this.allowUI);
        this.RequestList.addToEnd(req);
        try {
            HTTPResponse resp = new HTTPResponse(this.gen_mod_insts(), this.Timeout, req);
            this.handleRequest(req, resp, null, true);
            HTTPResponse hTTPResponse = resp;
            return hTTPResponse;
        }
        finally {
            this.RequestList.remove(req);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NVPair[] mergedHeaders(NVPair[] spec) {
        int spec_len = spec != null ? spec.length : 0;
        NVPair[] nVPairArray = this.DefaultHeaders;
        synchronized (this.DefaultHeaders) {
            int defs_len = this.DefaultHeaders != null ? this.DefaultHeaders.length : 0;
            NVPair[] merged = new NVPair[spec_len + defs_len];
            System.arraycopy(this.DefaultHeaders, 0, merged, 0, defs_len);
            // ** MonitorExit[var5_3] (shouldn't be in output)
            int didx = defs_len;
            for (int sidx = 0; sidx < spec_len; ++sidx) {
                int search;
                String s_name;
                if (spec[sidx] == null || (s_name = spec[sidx].getName().trim()).equalsIgnoreCase("Content-length")) continue;
                for (search = 0; search < didx && !merged[search].getName().trim().equalsIgnoreCase(s_name); ++search) {
                }
                merged[search] = spec[sidx];
                if (search != didx) continue;
                ++didx;
            }
            if (didx < merged.length) {
                merged = Util.resizeArray(merged, didx);
            }
            return merged;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HTTPClientModule[] gen_mod_insts() {
        Vector vector = this.ModuleList;
        synchronized (vector) {
            HTTPClientModule[] mod_insts = new HTTPClientModule[this.ModuleList.size()];
            for (int idx = 0; idx < this.ModuleList.size(); ++idx) {
                Class mod = (Class)this.ModuleList.elementAt(idx);
                try {
                    mod_insts[idx] = (HTTPClientModule)mod.newInstance();
                    continue;
                }
                catch (Exception e) {
                    throw new Error("HTTPClient Internal Error: could not create instance of " + mod.getName() + " -\n" + e);
                }
            }
            return mod_insts;
        }
    }

    void handleRequest(Request req, HTTPResponse http_resp, Response resp, boolean usemodules) throws IOException, ModuleException {
        int idx;
        Response[] rsp_arr = new Response[]{resp};
        HTTPClientModule[] modules = http_resp.getModules();
        if (usemodules) {
            block10: for (idx = 0; idx < modules.length; ++idx) {
                int sts = modules[idx].requestHandler(req, rsp_arr);
                switch (sts) {
                    case 0: {
                        continue block10;
                    }
                    case 1: {
                        idx = -1;
                        continue block10;
                    }
                    case 2: {
                        break block10;
                    }
                    case 3: 
                    case 4: {
                        if (rsp_arr[0] == null) {
                            throw new Error("HTTPClient Internal Error: no response returned by module " + modules[idx].getClass().getName());
                        }
                        http_resp.set(req, rsp_arr[0]);
                        if (req.getStream() != null) {
                            req.getStream().ignoreData(req);
                        }
                        if (req.internal_subrequest) {
                            return;
                        }
                        if (sts == 3) {
                            http_resp.handleResponse();
                        } else {
                            http_resp.init(rsp_arr[0]);
                        }
                        return;
                    }
                    case 5: {
                        if (req.internal_subrequest) {
                            return;
                        }
                        req.getConnection().handleRequest(req, http_resp, rsp_arr[0], true);
                        return;
                    }
                    case 6: {
                        if (req.internal_subrequest) {
                            return;
                        }
                        req.getConnection().handleRequest(req, http_resp, rsp_arr[0], false);
                        return;
                    }
                    default: {
                        throw new Error("HTTPClient Internal Error: invalid status " + sts + " returned by module " + modules[idx].getClass().getName());
                    }
                }
            }
        }
        if (req.internal_subrequest) {
            return;
        }
        if (req.getStream() != null && req.getStream().getLength() == -1L) {
            if (!this.ServProtVersKnown || this.ServerProtocolVersion < 65537 || no_chunked) {
                req.getStream().goAhead(req, null, http_resp.getTimeout());
                http_resp.set(req, req.getStream());
            } else {
                NVPair[] hdrs = req.getHeaders();
                for (idx = 0; idx < hdrs.length && !hdrs[idx].getName().equalsIgnoreCase("Transfer-Encoding"); ++idx) {
                }
                if (idx == hdrs.length) {
                    hdrs = Util.resizeArray(hdrs, idx + 1);
                    hdrs[idx] = new NVPair("Transfer-Encoding", "chunked");
                    req.setHeaders(hdrs);
                } else {
                    String v = hdrs[idx].getValue();
                    try {
                        if (!Util.hasToken(v, "chunked")) {
                            hdrs[idx] = new NVPair("Transfer-Encoding", v + ", chunked");
                        }
                    }
                    catch (ParseException pe) {
                        throw new IOException(pe.toString());
                    }
                }
                http_resp.set(req, this.sendRequest(req, http_resp.getTimeout()));
            }
        } else {
            http_resp.set(req, this.sendRequest(req, http_resp.getTimeout()));
        }
        if (req.aborted) {
            throw new IOException("Request aborted by user");
        }
    }

    public final void setCheckCertificates(boolean b) {
        this.check_certificates = b;
    }

    public final boolean getCheckCertificates() {
        return this.check_certificates;
    }

    public final void setTestConnectionHealthWithBlockingRead(boolean b) {
        this.test_connnection_health_with_blocking_read = b;
    }

    public final boolean getTestConnectionHealthWithBlockingRead() {
        return this.test_connnection_health_with_blocking_read;
    }

    public final void setLocalAddress(InetAddress localAddress, int localPort) {
        this.LocalAddr = localAddress;
        this.LocalPort = localPort;
    }

    final InetAddress getLocalAddress() {
        return this.LocalAddr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Response sendRequest(Request req, int con_timeout) throws IOException, ModuleException {
        boolean keep_alive;
        ByteArrayOutputStream hdr_buf = new ByteArrayOutputStream(600);
        Response resp = null;
        if (this.early_stall != null) {
            try {
                Log.write(1, "Conn:  Early-stalling Request: " + req.getMethod() + " " + req.getRequestURI());
                Response response = this.early_stall;
                synchronized (response) {
                    try {
                        this.early_stall.getVersion();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    this.early_stall = null;
                }
            }
            catch (NullPointerException npe) {
                // empty catch block
            }
        }
        String[] con_hdrs = this.assembleHeaders(req, hdr_buf);
        try {
            keep_alive = this.ServerProtocolVersion >= 65537 && !Util.hasToken(con_hdrs[0], "close") || this.ServerProtocolVersion == 65536 && Util.hasToken(con_hdrs[0], "keep-alive");
        }
        catch (ParseException pe) {
            throw new IOException(pe.toString());
        }
        HTTPConnection hTTPConnection = this;
        synchronized (hTTPConnection) {
            if (this.late_stall != null) {
                if (this.input_demux != null || this.keepAliveUnknown) {
                    Log.write(1, "Conn:  Stalling Request: " + req.getMethod() + " " + req.getRequestURI());
                    try {
                        this.late_stall.getVersion();
                        if (this.keepAliveUnknown) {
                            this.determineKeepAlive(this.late_stall);
                        }
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                }
                this.late_stall = null;
            }
            if ((req.getMethod().equals("POST") || req.dont_pipeline) && this.prev_resp != null && this.input_demux != null) {
                Log.write(1, "Conn:  Stalling Request: " + req.getMethod() + " " + req.getRequestURI());
                try {
                    this.prev_resp.getVersion();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
            if (!this.output_finished) {
                try {
                    this.wait();
                }
                catch (InterruptedException ie) {
                    throw new IOException(ie.toString());
                }
            }
            if (req.aborted) {
                throw new IOException("Request aborted by user");
            }
            int try_count = 3;
            while (try_count-- > 0) {
                try {
                    Socket sock;
                    if (this.input_demux == null || (sock = this.input_demux.getSocket()) == null) {
                        sock = this.getSocket(con_timeout);
                        if (this.Protocol == 1) {
                            if (this.Proxy_Host != null) {
                                Socket[] sarr = new Socket[]{sock};
                                resp = this.enableSSLTunneling(sarr, req, con_timeout);
                                if (resp != null) {
                                    resp.final_resp = true;
                                    return resp;
                                }
                                sock = sarr[0];
                            }
                            sock.setSoTimeout(con_timeout);
                            sock = this.sslFactory.createSocket(sock, this.Host, this.Port, true);
                            SSLSocket sslSocket = (SSLSocket)sock;
                            sslSocket.setEnabledCipherSuites(HTTPConnection.getSSLCipherSuites());
                            sslSocket.setEnabledProtocols(HTTPConnection.getSSLProtocols());
                            if (this.getCheckCertificates()) {
                                HTTPConnection.checkCert(((SSLSocket)sock).getSession().getPeerCertificateChain()[0], this.Host);
                            }
                        } else {
                            sock.setSoTimeout(con_timeout);
                        }
                        this.input_demux = new StreamDemultiplexor(this.Protocol, sock, this);
                        this.DemuxList.addToEnd(this.input_demux);
                        this.keepAliveReqLeft = this.keepAliveReqMax;
                    }
                    if (req.aborted) {
                        throw new IOException("Request aborted by user");
                    }
                    Log.write(1, "Conn:  Sending Request: ", hdr_buf);
                    OutputStream sock_out = sock.getOutputStream();
                    if (haveMSLargeWritesBug) {
                        sock_out = new MSLargeWritesBugStream(sock_out);
                    }
                    hdr_buf.writeTo(sock_out);
                    try {
                        if (this.ServProtVersKnown && this.ServerProtocolVersion >= 65537 && Util.hasToken(con_hdrs[1], "100-continue")) {
                            resp = new Response(req, this.Proxy_Host != null && this.Protocol != 1, this.input_demux);
                            resp.timeout = 60;
                            if (resp.getContinue() != 100) {
                                break;
                            }
                        }
                    }
                    catch (ParseException pe) {
                        throw new IOException(pe.toString());
                    }
                    catch (InterruptedIOException iioe) {
                    }
                    finally {
                        if (resp != null) {
                            resp.timeout = 0;
                        }
                    }
                    if (req.getData() != null && req.getData().length > 0) {
                        if (req.delay_entity > 0L) {
                            long num_units = req.delay_entity / 100L;
                            long one_unit = req.delay_entity / num_units;
                            int idx = 0;
                            while ((long)idx < num_units && this.input_demux.available(null) == 0) {
                                try {
                                    Thread.sleep(one_unit);
                                }
                                catch (InterruptedException ie) {
                                    // empty catch block
                                }
                                ++idx;
                            }
                            if (this.input_demux.available(null) == 0) {
                                this.writeData(sock_out, req.getData());
                            } else {
                                keep_alive = false;
                            }
                        } else {
                            this.writeData(sock_out, req.getData());
                        }
                    }
                    if (req.getStream() != null) {
                        req.getStream().goAhead(req, sock_out, 0);
                    } else {
                        sock_out.flush();
                    }
                    if (resp != null) break;
                    Response r = new Response(req, this.Proxy_Host != null && this.Protocol != 1, this.input_demux);
                    if (this.getTestConnectionHealthWithBlockingRead() && req.getStream() == null) {
                        r.getVersion();
                    }
                    resp = r;
                    break;
                }
                catch (IOException ioe) {
                    Log.write(1, "Conn:  ", ioe);
                    this.closeDemux(ioe, true);
                    if (try_count == 0 || ioe instanceof UnknownHostException || ioe instanceof ConnectException || ioe instanceof NoRouteToHostException || ioe instanceof InterruptedIOException || req.aborted) {
                        throw ioe;
                    }
                    Log.write(1, "Conn:  Retrying request");
                }
            }
            this.prev_resp = resp;
            if (!this.keepAliveUnknown && !this.doesKeepAlive || !keep_alive || this.keepAliveReqMax != -1 && this.keepAliveReqLeft-- == 0) {
                this.input_demux.markForClose(resp);
                this.input_demux = null;
            } else {
                this.input_demux.restartTimer();
            }
            if (this.keepAliveReqMax != -1) {
                Log.write(1, "Conn:  Number of requests left: " + this.keepAliveReqLeft);
            }
            if (!this.ServProtVersKnown) {
                this.early_stall = resp;
                resp.markAsFirstResponse(req);
            }
            if (this.keepAliveUnknown || !IdempotentSequence.methodIsIdempotent(req.getMethod()) || req.dont_pipeline || neverPipeline) {
                this.late_stall = resp;
            }
            if (req.getStream() != null) {
                this.output_finished = false;
            } else {
                this.output_finished = true;
                this.notify();
            }
            Log.write(1, "Conn:  Request sent");
        }
        return resp;
    }

    private void writeData(OutputStream out, byte[] buffer) throws IOException {
        int bytesToSend;
        BandwidthLimiter bandwidthLimiter = this.getBandwidthLimiterFactory().create();
        int position = 0;
        do {
            bytesToSend = Math.min(buffer.length - position, bandwidthLimiter.maximumBytes(position));
            out.write(buffer, position, bytesToSend);
        } while ((position += bytesToSend) < buffer.length);
    }

    private Socket getSocket(int con_timeout) throws IOException {
        int actual_port;
        String actual_host;
        Socket sock = null;
        if (this.Proxy_Host != null) {
            actual_host = this.Proxy_Host;
            actual_port = this.Proxy_Port;
        } else {
            actual_host = this.Host;
            actual_port = this.Port;
        }
        Log.write(1, "Conn:  Creating Socket: " + actual_host + ":" + actual_port);
        if (con_timeout == 0) {
            if (this.Socks_client != null) {
                sock = this.Socks_client.getSocket(actual_host, actual_port);
            } else {
                long startTime = this.getTimeAuthority().getTimeInMilliseconds();
                InetAddress[] addr_list = InetAddress.getAllByName(actual_host);
                this.DNS_time.set(Math.max(this.getTimeAuthority().getTimeInMilliseconds() - startTime, 0L));
                for (int idx = 0; idx < addr_list.length; ++idx) {
                    try {
                        sock = this.LocalAddr == null ? new Socket(addr_list[idx], actual_port) : new Socket(addr_list[idx], actual_port, this.LocalAddr, this.LocalPort);
                        sock.setSoLinger(true, 0);
                        sock.setKeepAlive(false);
                        this.con_time.set(Math.max(this.getTimeAuthority().getTimeInMilliseconds() - startTime, 0L));
                        this.connectionsEstablished.incrementAndGet();
                        break;
                    }
                    catch (SocketException se) {
                        if (idx != addr_list.length - 1) continue;
                        throw se;
                    }
                }
            }
        } else {
            EstablishConnection con = new EstablishConnection(actual_host, actual_port, this.Socks_client);
            con.start();
            try {
                con.join(con_timeout);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            if (con.getException() != null) {
                throw con.getException();
            }
            sock = con.getSocket();
            if (sock == null) {
                con.forget();
                sock = con.getSocket();
                if (sock == null) {
                    throw new InterruptedIOException("Connection establishment timed out");
                }
            }
        }
        return sock;
    }

    public long getDnsTime() {
        return this.DNS_time.get();
    }

    public long getConnectTime() {
        return this.con_time.get();
    }

    public long getConnectionsEstablished() {
        return this.connectionsEstablished.get();
    }

    private Response enableSSLTunneling(Socket[] sock, Request req, int timeout) throws IOException, ModuleException {
        Vector<NVPair> hdrs = new Vector<NVPair>();
        for (int idx = 0; idx < req.getHeaders().length; ++idx) {
            String name = req.getHeaders()[idx].getName();
            if (!name.equalsIgnoreCase("User-Agent") && !name.equalsIgnoreCase("Proxy-Authorization")) continue;
            hdrs.addElement(req.getHeaders()[idx]);
        }
        Object[] h = new NVPair[hdrs.size()];
        hdrs.copyInto(h);
        Request connect = new Request(this, "CONNECT", this.Host + ":" + this.Port, (NVPair[])h, null, null, req.allowUI());
        connect.internal_subrequest = true;
        ByteArrayOutputStream hdr_buf = new ByteArrayOutputStream(600);
        HTTPResponse r = new HTTPResponse(this.gen_mod_insts(), timeout, connect);
        Response resp = null;
        while (true) {
            this.handleRequest(connect, r, resp, true);
            hdr_buf.reset();
            this.assembleHeaders(connect, hdr_buf);
            Log.write(1, "Conn:  Sending SSL-Tunneling Subrequest: ", hdr_buf);
            hdr_buf.writeTo(sock[0].getOutputStream());
            resp = new Response(connect, sock[0].getInputStream());
            if (resp.getStatusCode() == 200) {
                return null;
            }
            try {
                resp.getData();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            try {
                sock[0].close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            r.set(connect, resp);
            if (!r.handleResponse()) {
                return resp;
            }
            sock[0] = this.getSocket(timeout);
        }
    }

    private static void checkCert(X509Certificate cert, String host) throws IOException {
        String name;
        try {
            name = ((X500Name)cert.getSubjectDN()).getCommonName().toLowerCase();
        }
        catch (Throwable t) {
            return;
        }
        if (Util.wildcardMatch(name, host)) {
            return;
        }
        throw new SSLException("Name in certificate `" + name + "' does not " + "match host name `" + host + "'");
    }

    /*
     * Unable to fully structure code
     */
    private String[] assembleHeaders(Request req, ByteArrayOutputStream hdr_buf) throws IOException {
        dataout = new DataOutputStream(hdr_buf);
        con_hdrs = new String[]{"", ""};
        hdrs = req.getHeaders();
        ho_idx = -1;
        ct_idx = -1;
        ua_idx = -1;
        co_idx = -1;
        pc_idx = -1;
        ka_idx = -1;
        ex_idx = -1;
        te_idx = -1;
        tc_idx = -1;
        ug_idx = -1;
        for (idx = 0; idx < hdrs.length; ++idx) {
            name = hdrs[idx].getName().trim().toLowerCase();
            if (name.equals("host")) {
                ho_idx = idx;
                continue;
            }
            if (name.equals("content-type")) {
                ct_idx = idx;
                continue;
            }
            if (name.equals("user-agent")) {
                ua_idx = idx;
                continue;
            }
            if (name.equals("connection")) {
                co_idx = idx;
                continue;
            }
            if (name.equals("proxy-connection")) {
                pc_idx = idx;
                continue;
            }
            if (name.equals("keep-alive")) {
                ka_idx = idx;
                continue;
            }
            if (name.equals("expect")) {
                ex_idx = idx;
                continue;
            }
            if (name.equals("te")) {
                te_idx = idx;
                continue;
            }
            if (name.equals("transfer-encoding")) {
                tc_idx = idx;
                continue;
            }
            if (!name.equals("upgrade")) continue;
            ug_idx = idx;
        }
        file = Util.escapeUnsafeChars(req.getRequestURI());
        if (this.Proxy_Host != null && this.Protocol != 1 && !file.equals("*")) {
            dataout.writeBytes(req.getMethod() + " http://" + this.Host + ":" + this.Port + file + " " + this.RequestProtocolVersion + "\r\n");
        } else {
            dataout.writeBytes(req.getMethod() + " " + file + " " + this.RequestProtocolVersion + "\r\n");
        }
        v0 = h_hdr = ho_idx >= 0 ? hdrs[ho_idx].getValue().trim() : this.Host;
        if (this.Port != URI.defaultPort(this.getProtocol())) {
            dataout.writeBytes("Host: " + h_hdr + ":" + this.Port + "\r\n");
        } else {
            dataout.writeBytes("Host: " + h_hdr + "\r\n");
        }
        co_hdr = null;
        if (!this.ServProtVersKnown || this.ServerProtocolVersion < 65537 || co_idx != -1) {
            if (co_idx == -1) {
                co_hdr = "Keep-Alive";
                con_hdrs[0] = "Keep-Alive";
            } else {
                con_hdrs[0] = hdrs[co_idx].getValue().trim();
                co_hdr = con_hdrs[0];
            }
            try {
                if (ka_idx != -1 && Util.hasToken(con_hdrs[0], "keep-alive")) {
                    dataout.writeBytes("Keep-Alive: " + hdrs[ka_idx].getValue().trim() + "\r\n");
                }
            }
            catch (ParseException pe) {
                throw new IOException(pe.toString());
            }
        }
        if (!(this.Proxy_Host == null || this.Protocol == 1 || this.ServProtVersKnown && this.ServerProtocolVersion >= 65537 || co_hdr == null)) {
            dataout.writeBytes("Proxy-Connection: ");
            dataout.writeBytes(co_hdr);
            dataout.writeBytes("\r\n");
            co_hdr = null;
        }
        if (!HTTPConnection.noTrailers) {
            if (co_hdr != null) {
                try {
                    if (Util.hasToken(co_hdr, "TE")) ** GOTO lbl84
                    co_hdr = co_hdr + ", TE";
                }
                catch (ParseException pe) {
                    throw new IOException(pe.toString());
                }
            } else {
                co_hdr = "TE";
            }
        }
lbl84:
        // 5 sources

        if (ug_idx != -1) {
            co_hdr = co_hdr + ", Upgrade";
        }
        if (co_hdr != null) {
            dataout.writeBytes("Connection: ");
            dataout.writeBytes(co_hdr);
            dataout.writeBytes("\r\n");
        }
        if (!HTTPConnection.noTrailers) {
            if (te_idx != -1) {
                dataout.writeBytes("TE: ");
                try {
                    pte = Util.parseHeader(hdrs[te_idx].getValue());
                }
                catch (ParseException pe) {
                    throw new IOException(pe.toString());
                }
                if (!pte.contains(new HttpHeaderElement("trailers"))) {
                    dataout.writeBytes("trailers, ");
                }
                dataout.writeBytes(hdrs[te_idx].getValue().trim() + "\r\n");
            } else {
                dataout.writeBytes("TE: trailers\r\n");
            }
        }
        if (ua_idx != -1) {
            dataout.writeBytes("User-Agent: " + hdrs[ua_idx].getValue().trim() + "\r\n");
        } else {
            dataout.writeBytes("User-Agent: RPT-HTTPClient/0.3-3E\r\n");
        }
        for (idx = 0; idx < hdrs.length; ++idx) {
            if (idx == ct_idx || idx == ua_idx || idx == co_idx || idx == pc_idx || idx == ka_idx || idx == ex_idx || idx == te_idx || idx == ho_idx) continue;
            dataout.writeBytes(hdrs[idx].getName().trim() + ": " + hdrs[idx].getValue().trim() + "\r\n");
        }
        if (req.getData() != null || req.getStream() != null) {
            dataout.writeBytes("Content-Type: ");
            if (ct_idx != -1) {
                dataout.writeBytes(hdrs[ct_idx].getValue().trim());
            } else {
                dataout.writeBytes("application/octet-stream");
            }
            dataout.writeBytes("\r\n");
            if (req.getData() != null) {
                dataout.writeBytes("Content-length: " + req.getData().length + "\r\n");
            } else if (req.getStream().getLength() != -1L && tc_idx == -1) {
                dataout.writeBytes("Content-length: " + req.getStream().getLength() + "\r\n");
            }
            if (ex_idx != -1) {
                con_hdrs[1] = hdrs[ex_idx].getValue().trim();
                dataout.writeBytes("Expect: " + con_hdrs[1] + "\r\n");
            }
        } else if (ex_idx != -1) {
            try {
                expect_tokens = Util.parseHeader(hdrs[ex_idx].getValue());
            }
            catch (ParseException pe) {
                throw new IOException(pe.toString());
            }
            cont = new HttpHeaderElement("100-continue");
            while (expect_tokens.removeElement(cont)) {
            }
            if (!expect_tokens.isEmpty()) {
                con_hdrs[1] = Util.assembleHeader(expect_tokens);
                dataout.writeBytes("Expect: " + con_hdrs[1] + "\r\n");
            }
        }
        dataout.writeBytes("\r\n");
        return con_hdrs;
    }

    boolean handleFirstRequest(Request req, Response resp) throws IOException {
        this.ServerProtocolVersion = HTTPConnection.String2ProtVers(resp.getVersion());
        this.ServProtVersKnown = true;
        int sts = resp.getStatusCode();
        if (this.Proxy_Host != null && this.Protocol != 1 && resp.getHeader("Via") == null && sts != 407 && sts != 502 && sts != 504) {
            this.ServerProtocolVersion = 65536;
        }
        Log.write(1, "Conn:  Protocol Version established: " + HTTPConnection.ProtVers2String(this.ServerProtocolVersion));
        if (this.ServerProtocolVersion == 65536 && (resp.getStatusCode() == 400 || resp.getStatusCode() == 500)) {
            if (this.input_demux != null) {
                this.input_demux.markForClose(resp);
            }
            this.input_demux = null;
            this.RequestProtocolVersion = "HTTP/1.0";
            return false;
        }
        return true;
    }

    private void determineKeepAlive(Response resp) throws IOException {
        try {
            HttpHeaderElement max;
            String con;
            if (this.ServerProtocolVersion >= 65537 || ((this.Proxy_Host == null || this.Protocol == 1) && (con = resp.getHeader("Connection")) != null || this.Proxy_Host != null && this.Protocol != 1 && (con = resp.getHeader("Proxy-Connection")) != null) && Util.hasToken(con, "keep-alive")) {
                this.doesKeepAlive = true;
                this.keepAliveUnknown = false;
                Log.write(1, "Conn:  Keep-Alive enabled");
            } else if (resp.getStatusCode() < 400) {
                this.keepAliveUnknown = false;
            }
            if (this.doesKeepAlive && this.ServerProtocolVersion == 65536 && (con = resp.getHeader("Keep-Alive")) != null && (max = Util.getElement(Util.parseHeader(con), "max")) != null && max.getValue() != null) {
                this.keepAliveReqLeft = this.keepAliveReqMax = Integer.parseInt(max.getValue());
                Log.write(1, "Conn:  Max Keep-Alive requests: " + this.keepAliveReqMax);
            }
        }
        catch (ParseException pe) {
        }
        catch (NumberFormatException nfe) {
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    synchronized void outputFinished() {
        this.output_finished = true;
        this.notify();
    }

    synchronized void closeDemux(IOException ioe, boolean was_reset) {
        if (this.input_demux != null) {
            this.input_demux.close(ioe, was_reset);
        }
        this.early_stall = null;
        this.late_stall = null;
        this.prev_resp = null;
    }

    static final String ProtVers2String(int prot_vers) {
        return "HTTP/" + (prot_vers >>> 16) + "." + (prot_vers & 0xFFFF);
    }

    static final int String2ProtVers(String prot_vers) {
        String vers = prot_vers.substring(5);
        int dot = vers.indexOf(46);
        return Integer.parseInt(vers.substring(0, dot)) << 16 | Integer.parseInt(vers.substring(dot + 1));
    }

    public String toString() {
        return this.getProtocol() + "://" + this.getHost() + (this.getPort() != URI.defaultPort(this.getProtocol()) ? ":" + this.getPort() : "");
    }

    public void setBufferGrowthStrategyFactory(BandwidthLimiterFactory f) {
        this.m_bandwidthLimiterFactory = f == null ? s_defaultBandwidthLimiterFactory : f;
    }

    BandwidthLimiterFactory getBandwidthLimiterFactory() {
        return this.m_bandwidthLimiterFactory;
    }

    static {
        String host;
        dflt_context = new Object();
        Default_Proxy_Host = null;
        non_proxy_host_list = new CIHashtable();
        non_proxy_dom_list = new Vector();
        non_proxy_addr_list = new Vector();
        non_proxy_mask_list = new Vector();
        Default_Socks_client = null;
        no_chunked = false;
        force_1_0 = false;
        neverPipeline = false;
        noKeepAlives = false;
        haveMSLargeWritesBug = false;
        deferStreamed = false;
        noTrailers = false;
        standardTimeAuthority = new TimeAuthority(){

            @Override
            public long getTimeInMilliseconds() {
                return System.currentTimeMillis();
            }
        };
        DefaultTimeout = 0;
        defaultAllowUI = true;
        defaultSSLFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        try {
            host = System.getProperty("http.proxyHost");
            if (host == null) {
                throw new Exception();
            }
            int port = Integer.getInteger("http.proxyPort", -1);
            Log.write(1, "Conn:  using proxy " + host + ":" + port);
            HTTPConnection.setProxyServer(host, port);
        }
        catch (Exception e) {
            try {
                if (Boolean.getBoolean("proxySet")) {
                    String host2 = System.getProperty("proxyHost");
                    int port = Integer.getInteger("proxyPort", -1);
                    Log.write(1, "Conn:  using proxy " + host2 + ":" + port);
                    HTTPConnection.setProxyServer(host2, port);
                }
            }
            catch (Exception ee) {
                Default_Proxy_Host = null;
            }
        }
        try {
            String hosts = System.getProperty("HTTPClient.nonProxyHosts");
            if (hosts == null) {
                hosts = System.getProperty("http.nonProxyHosts");
            }
            String[] list = Util.splitProperty(hosts);
            HTTPConnection.dontProxyFor(list);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            host = System.getProperty("HTTPClient.socksHost");
            if (host != null && host.length() > 0) {
                int port = Integer.getInteger("HTTPClient.socksPort", -1);
                int version = Integer.getInteger("HTTPClient.socksVersion", -1);
                Log.write(1, "Conn:  using SOCKS " + host + ":" + port);
                if (version == -1) {
                    HTTPConnection.setSocksServer(host, port);
                } else {
                    HTTPConnection.setSocksServer(host, port, version);
                }
            }
        }
        catch (Exception e) {
            Default_Socks_client = null;
        }
        String modules = "HTTPClient.RetryModule|HTTPClient.CookieModule|HTTPClient.RedirectionModule|HTTPClient.AuthorizationModule|HTTPClient.DefaultModule|HTTPClient.TransferEncodingModule|HTTPClient.ContentMD5Module|HTTPClient.ContentEncodingModule";
        boolean in_applet = false;
        try {
            modules = System.getProperty("HTTPClient.Modules", modules);
        }
        catch (SecurityException se) {
            in_applet = true;
        }
        DefaultModuleList = new Vector();
        String[] list = Util.splitProperty(modules);
        for (int idx = 0; idx < list.length; ++idx) {
            try {
                DefaultModuleList.addElement(Class.forName(list[idx]));
                Log.write(1, "Conn:  added module " + list[idx]);
                continue;
            }
            catch (ClassNotFoundException cnfe) {
                if (in_applet) continue;
                throw new NoClassDefFoundError(cnfe.getMessage());
            }
        }
        try {
            neverPipeline = Boolean.getBoolean("HTTPClient.disable_pipelining");
            if (neverPipeline) {
                Log.write(1, "Conn:  disabling pipelining");
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            noKeepAlives = Boolean.getBoolean("HTTPClient.disableKeepAlives");
            if (noKeepAlives) {
                Log.write(1, "Conn:  disabling keep-alives");
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            force_1_0 = Boolean.getBoolean("HTTPClient.forceHTTP_1.0");
            if (force_1_0) {
                Log.write(1, "Conn:  forcing HTTP/1.0 requests");
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            no_chunked = Boolean.getBoolean("HTTPClient.dontChunkRequests");
            if (no_chunked) {
                Log.write(1, "Conn:  never chunking requests");
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (System.getProperty("os.name").indexOf("Windows") >= 0 && System.getProperty("java.version").startsWith("1.1")) {
                haveMSLargeWritesBug = true;
            }
            if (haveMSLargeWritesBug) {
                Log.write(1, "Conn:  splitting large writes into 20K chunks (M$ bug)");
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            noTrailers = Boolean.getBoolean("HTTPClient.disableTrailers");
            if (noTrailers) {
                Log.write(1, "Conn:  disabling trailers");
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            deferStreamed = Boolean.getBoolean("HTTPClient.deferStreamed");
            if (deferStreamed) {
                Log.write(1, "Conn:  enabling defered handling of responses to streamed requests");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        String cipherSuiteProperty = System.getProperty("https.cipherSuites");
        sslCipherSuites = cipherSuiteProperty != null ? cipherSuiteProperty.split(",") : defaultSSLFactory.getSupportedCipherSuites();
        String protocolProperty = System.getProperty("https.protocols");
        if (protocolProperty != null) {
            sslProtocols = protocolProperty.split(",");
        } else {
            try {
                SSLSocket socket = (SSLSocket)defaultSSLFactory.createSocket();
                sslProtocols = socket.getSupportedProtocols();
                socket.close();
            }
            catch (IOException e) {
                throw new ExceptionInInitializerError(e);
            }
        }
        s_defaultBandwidthLimiterFactory = new DefaultBandwidthLimiterFactory();
    }

    private static final class DefaultBandwidthLimiterFactory
    implements BandwidthLimiterFactory {
        final BandwidthLimiter m_unlimitedBandwidthLimiter = new UnlimitedBandwidthLimiter();

        private DefaultBandwidthLimiterFactory() {
        }

        @Override
        public BandwidthLimiter create() {
            return this.m_unlimitedBandwidthLimiter;
        }
    }

    private static final class UnlimitedBandwidthLimiter
    implements BandwidthLimiter {
        private UnlimitedBandwidthLimiter() {
        }

        @Override
        public int maximumBytes(int position) {
            return Integer.MAX_VALUE;
        }
    }

    public static interface BandwidthLimiterFactory {
        public BandwidthLimiter create();
    }

    public static interface BandwidthLimiter {
        public int maximumBytes(int var1);
    }

    private class MSLargeWritesBugStream
    extends FilterOutputStream {
        private final int CHUNK_SIZE = 20000;

        MSLargeWritesBugStream(OutputStream os) {
            super(os);
            this.CHUNK_SIZE = 20000;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            while (len > 20000) {
                this.out.write(b, off, 20000);
                off += 20000;
                len -= 20000;
            }
            this.out.write(b, off, len);
        }
    }

    private class EstablishConnection
    extends Thread {
        String actual_host;
        int actual_port;
        IOException exception;
        Socket sock;
        SocksClient Socks_client;
        boolean close;

        EstablishConnection(String host, int port, SocksClient socks) {
            super("EstablishConnection (" + host + ":" + port + ")");
            try {
                this.setDaemon(true);
            }
            catch (SecurityException se) {
                // empty catch block
            }
            this.actual_host = host;
            this.actual_port = port;
            this.Socks_client = socks;
            this.exception = null;
            this.sock = null;
            this.close = false;
        }

        @Override
        public void run() {
            block9: {
                try {
                    if (this.Socks_client != null) {
                        this.sock = this.Socks_client.getSocket(this.actual_host, this.actual_port);
                        break block9;
                    }
                    long startTime = HTTPConnection.this.getTimeAuthority().getTimeInMilliseconds();
                    InetAddress[] addr_list = InetAddress.getAllByName(this.actual_host);
                    HTTPConnection.this.DNS_time.set(Math.max(HTTPConnection.this.getTimeAuthority().getTimeInMilliseconds() - startTime, 0L));
                    for (int idx = 0; idx < addr_list.length; ++idx) {
                        try {
                            this.sock = HTTPConnection.this.LocalAddr == null ? new Socket(addr_list[idx], this.actual_port) : new Socket(addr_list[idx], this.actual_port, HTTPConnection.this.LocalAddr, HTTPConnection.this.LocalPort);
                            this.sock.setSoLinger(true, 0);
                            this.sock.setKeepAlive(false);
                            HTTPConnection.this.con_time.set(Math.max(HTTPConnection.this.getTimeAuthority().getTimeInMilliseconds() - startTime, 0L));
                            break;
                        }
                        catch (SocketException se) {
                            if (idx != addr_list.length - 1 && !this.close) continue;
                            throw se;
                        }
                    }
                }
                catch (IOException ioe) {
                    this.exception = ioe;
                }
            }
            if (this.close && this.sock != null) {
                try {
                    this.sock.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.sock = null;
            }
        }

        IOException getException() {
            return this.exception;
        }

        Socket getSocket() {
            return this.sock;
        }

        void forget() {
            this.close = true;
        }
    }

    public static interface TimeAuthority {
        public long getTimeInMilliseconds();
    }
}

