/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.util.Collections;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.ScalarMapStep;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;

public final class SubstringGlobalStep<S, E>
extends ScalarMapStep<S, E> {
    private final Integer start;
    private final Integer end;

    public SubstringGlobalStep(Traversal.Admin traversal, Integer startIndex, Integer endIndex) {
        super(traversal);
        this.start = startIndex;
        this.end = endIndex;
    }

    public SubstringGlobalStep(Traversal.Admin traversal, Integer startIndex) {
        this(traversal, startIndex, null);
    }

    @Override
    protected E map(Traverser.Admin<S> traverser) {
        Object item = traverser.get();
        if (null != item && !(item instanceof String)) {
            throw new IllegalArgumentException(String.format("The substring() step can only take string as argument, encountered %s", item.getClass()));
        }
        String strItem = (String)item;
        if (null == strItem) {
            return null;
        }
        int newStart = this.processStringIndex(strItem.length(), this.start);
        if (null == this.end) {
            return (E)strItem.substring(newStart);
        }
        int newEnd = this.processStringIndex(strItem.length(), this.end);
        if (newEnd <= newStart) {
            return (E)"";
        }
        return (E)strItem.substring(newStart, newEnd);
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return Collections.singleton(TraverserRequirement.OBJECT);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.start.hashCode();
        result = 31 * result + (null != this.end ? this.end.hashCode() : 0);
        return result;
    }

    private int processStringIndex(int strLen, int index) {
        if (index < 0) {
            return Math.max(0, (strLen + index) % strLen);
        }
        return Math.min(index, strLen);
    }
}

