/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.ScalarMapStep;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;

public final class SplitGlobalStep<S, E>
extends ScalarMapStep<S, E>
implements TraversalParent {
    private final String separator;

    public SplitGlobalStep(Traversal.Admin traversal, String separator) {
        super(traversal);
        this.separator = separator;
    }

    @Override
    protected E map(Traverser.Admin<S> traverser) {
        Object item = traverser.get();
        if (null != item && !(item instanceof String)) {
            throw new IllegalArgumentException(String.format("The split() step can only take string as argument, encountered %s.", item.getClass()));
        }
        return (E)(null == item ? null : Arrays.asList(StringUtils.splitByWholeSeparator((String)((String)item), (String)this.separator)));
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return Collections.singleton(TraverserRequirement.OBJECT);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (null != this.separator ? this.separator.hashCode() : 0);
        return result;
    }
}

