/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.binary.types;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.tinkerpop.gremlin.structure.io.Buffer;
import org.apache.tinkerpop.gremlin.structure.io.binary.DataType;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.SimpleTypeSerializer;

public class ByteBufferSerializer
extends SimpleTypeSerializer<ByteBuffer> {
    public ByteBufferSerializer() {
        super(DataType.BYTEBUFFER);
    }

    @Override
    protected ByteBuffer readValue(Buffer buffer, GraphBinaryReader context) throws IOException {
        ByteBuffer bb = ByteBuffer.allocate(buffer.readInt());
        buffer.readBytes(bb);
        bb.rewind();
        return bb;
    }

    @Override
    protected void writeValue(ByteBuffer value, Buffer buffer, GraphBinaryWriter context) throws IOException {
        byte[] bytes = value.array();
        buffer.writeInt(bytes.length).writeBytes(bytes);
    }
}

