/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure;

import java.util.function.Consumer;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.structure.Graph;

public interface Transaction
extends AutoCloseable {
    public static final Transaction NO_OP = new Transaction(){

        @Override
        public void open() {
            throw new UnsupportedOperationException("This Transaction implementation is a no-op for all methods");
        }

        @Override
        public void commit() {
            throw new UnsupportedOperationException("This Transaction implementation is a no-op for all methods");
        }

        @Override
        public void rollback() {
            throw new UnsupportedOperationException("This Transaction implementation is a no-op for all methods");
        }

        public <C extends TraversalSource> C begin(Class<C> traversalSourceClass) {
            throw new UnsupportedOperationException("This Transaction implementation is a no-op for all methods");
        }

        @Override
        public boolean isOpen() {
            throw new UnsupportedOperationException("This Transaction implementation is a no-op for all methods");
        }

        @Override
        public void readWrite() {
            throw new UnsupportedOperationException("This Transaction implementation is a no-op for all methods");
        }

        @Override
        public void close() {
            throw new UnsupportedOperationException("This Transaction implementation is a no-op for all methods");
        }

        @Override
        public Transaction onReadWrite(Consumer<Transaction> consumer) {
            throw new UnsupportedOperationException("This Transaction implementation is a no-op for all methods");
        }

        @Override
        public Transaction onClose(Consumer<Transaction> consumer) {
            throw new UnsupportedOperationException("This Transaction implementation is a no-op for all methods");
        }

        @Override
        public void addTransactionListener(Consumer<Status> listener) {
            throw new UnsupportedOperationException("This Transaction implementation is a no-op for all methods");
        }

        @Override
        public void removeTransactionListener(Consumer<Status> listener) {
            throw new UnsupportedOperationException("This Transaction implementation is a no-op for all methods");
        }

        @Override
        public void clearTransactionListeners() {
            throw new UnsupportedOperationException("This Transaction implementation is a no-op for all methods");
        }
    };

    public void open();

    public void commit();

    public void rollback();

    default public <G extends Graph> G createThreadedTx() {
        throw Exceptions.threadedTransactionsNotSupported();
    }

    default public <T extends TraversalSource> T begin() {
        return (T)this.begin(GraphTraversalSource.class);
    }

    public <T extends TraversalSource> T begin(Class<T> var1);

    public boolean isOpen();

    public void readWrite();

    @Override
    public void close();

    public Transaction onReadWrite(Consumer<Transaction> var1);

    public Transaction onClose(Consumer<Transaction> var1);

    public void addTransactionListener(Consumer<Status> var1);

    public void removeTransactionListener(Consumer<Status> var1);

    public void clearTransactionListeners();

    public static enum READ_WRITE_BEHAVIOR implements Consumer<Transaction>
    {
        AUTO{

            @Override
            public void accept(Transaction transaction) {
                if (!transaction.isOpen()) {
                    transaction.open();
                }
            }
        }
        ,
        MANUAL{

            @Override
            public void accept(Transaction transaction) {
                if (!transaction.isOpen()) {
                    throw Exceptions.transactionMustBeOpenToReadWrite();
                }
            }
        };

    }

    public static enum CLOSE_BEHAVIOR implements Consumer<Transaction>
    {
        COMMIT{

            @Override
            public void accept(Transaction transaction) {
                if (transaction.isOpen()) {
                    transaction.commit();
                }
            }
        }
        ,
        ROLLBACK{

            @Override
            public void accept(Transaction transaction) {
                if (transaction.isOpen()) {
                    transaction.rollback();
                }
            }
        }
        ,
        MANUAL{

            @Override
            public void accept(Transaction transaction) {
                if (transaction.isOpen()) {
                    throw Exceptions.openTransactionsOnClose();
                }
            }
        };

    }

    public static class Exceptions {
        private Exceptions() {
        }

        public static IllegalStateException transactionAlreadyOpen() {
            return new IllegalStateException("Stop the current transaction before opening another");
        }

        public static IllegalStateException transactionMustBeOpenToReadWrite() {
            return new IllegalStateException("Open a transaction before attempting to read/write the transaction");
        }

        public static IllegalStateException openTransactionsOnClose() {
            return new IllegalStateException("Commit or rollback all outstanding transactions before closing the transaction");
        }

        public static UnsupportedOperationException threadedTransactionsNotSupported() {
            return new UnsupportedOperationException("Graph does not support threaded transactions");
        }

        public static IllegalArgumentException onCloseBehaviorCannotBeNull() {
            return new IllegalArgumentException("Transaction behavior for onClose cannot be null");
        }

        public static IllegalArgumentException onReadWriteBehaviorCannotBeNull() {
            return new IllegalArgumentException("Transaction behavior for onReadWrite cannot be null");
        }
    }

    public static enum Status {
        COMMIT,
        ROLLBACK;

    }
}

