"use strict";
/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.formatTraversal = void 0;
var recreateQueryOnelinerFromSyntaxTree_1 = require("../../recreateQueryOnelinerFromSyntaxTree");
var types_1 = require("../../types");
var utils_1 = require("../../utils");
var utils_2 = require("../utils");
var getStepGroups_1 = require("./getStepGroups");
var utils_3 = require("./getStepGroups/utils");
// Groups steps into step groups and adds a localIndentation property
var formatTraversal = function (formatSyntaxTree) { return function (config) { return function (syntaxTree) {
    var initialHorizontalPositionIndentationIncrease = syntaxTree.steps[0] && utils_3.isTraversalSource(syntaxTree.steps[0]) ? syntaxTree.initialHorizontalPosition : 0;
    var recreatedQuery = recreateQueryOnelinerFromSyntaxTree_1.default(config.localIndentation + initialHorizontalPositionIndentationIncrease)(syntaxTree);
    if (recreatedQuery.length <= config.maxLineLength) {
        return {
            type: types_1.TokenType.Traversal,
            steps: syntaxTree.steps,
            stepGroups: [
                {
                    steps: syntaxTree.steps.reduce(function (steps, step, stepIndex) {
                        var formattedStep = stepIndex === 0
                            ? formatSyntaxTree(config)(step)
                            : // Since the traversal's steps will be on the same line, their horizontal position is increased by the
                                // steps's width plus the width of the dots between them
                                formatSyntaxTree(utils_1.pipe(utils_2.withZeroIndentation, utils_2.withIncreasedHorizontalPosition(syntaxTree.initialHorizontalPosition +
                                    steps.map(function (_a) {
                                        var width = _a.width;
                                        return width;
                                    }).reduce(utils_1.sum, 0) +
                                    steps.length))(config))(step);
                        return __spreadArray(__spreadArray([], steps), [formattedStep]);
                    }, []),
                },
            ],
            initialHorizontalPosition: syntaxTree.initialHorizontalPosition,
            localIndentation: 0,
            width: recreatedQuery.trim().length,
        };
    }
    var stepGroups = getStepGroups_1.getStepGroups(formatSyntaxTree, syntaxTree.steps, config);
    var lastStepGroup = utils_1.last(stepGroups);
    var width = lastStepGroup
        ? lastStepGroup.steps.map(function (_a) {
            var width = _a.width;
            return width;
        }).reduce(utils_1.sum, 0) + stepGroups.length - 1
        : 0;
    return {
        type: types_1.TokenType.Traversal,
        steps: syntaxTree.steps,
        stepGroups: stepGroups,
        initialHorizontalPosition: syntaxTree.initialHorizontalPosition,
        localIndentation: 0,
        width: width,
    };
}; }; };
exports.formatTraversal = formatTraversal;
