"use strict";
/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.formatSyntaxTrees = void 0;
var types_1 = require("../types");
var formatClosure_1 = require("./formatClosure");
var formatMethod_1 = require("./formatMethod");
var formatNonGremlin_1 = require("./formatNonGremlin");
var formatString_1 = require("./formatString");
var formatTraversal_1 = require("./formatTraversal");
var formatWord_1 = require("./formatWord");
var formatSyntaxTree = function (config) { return function (syntaxTree) {
    switch (syntaxTree.type) {
        case types_1.TokenType.NonGremlinCode:
            return formatNonGremlin_1.formatNonGremlin(config)(syntaxTree);
        case types_1.TokenType.Traversal:
            return formatTraversal_1.formatTraversal(formatSyntaxTree)(config)(syntaxTree);
        case types_1.TokenType.Method:
            return formatMethod_1.formatMethod(formatSyntaxTree)(config)(syntaxTree);
        case types_1.TokenType.Closure:
            return formatClosure_1.formatClosure(formatSyntaxTree)(config)(syntaxTree);
        case types_1.TokenType.String:
            return formatString_1.formatString(config)(syntaxTree);
        case types_1.TokenType.Word:
            return formatWord_1.formatWord(config)(syntaxTree);
    }
}; };
var formatSyntaxTrees = function (config) { return function (syntaxTrees) {
    return syntaxTrees.map(formatSyntaxTree(config));
}; };
exports.formatSyntaxTrees = formatSyntaxTrees;
