export declare type GremlintUserConfig = {
    indentation: number;
    maxLineLength: number;
    shouldPlaceDotsAfterLineBreaks: boolean;
};
export declare type GremlintInternalConfig = {
    globalIndentation: number;
    localIndentation: number;
    maxLineLength: number;
    shouldPlaceDotsAfterLineBreaks: boolean;
    shouldStartWithDot: boolean;
    shouldEndWithDot: boolean;
    horizontalPosition: number;
};
export declare enum TokenType {
    NonGremlinCode = "NON_GREMLIN_CODE",
    Traversal = "TRAVERSAL",
    Method = "METHOD",
    Closure = "CLOSURE",
    String = "STRING",
    Word = "WORD"
}
export declare type UnformattedNonGremlinSyntaxTree = {
    type: TokenType.NonGremlinCode;
    code: string;
};
export declare type UnformattedTraversalSyntaxTree = {
    type: TokenType.Traversal;
    steps: UnformattedSyntaxTree[];
    initialHorizontalPosition: number;
};
export declare type UnformattedMethodSyntaxTree = {
    type: TokenType.Method;
    method: UnformattedSyntaxTree;
    arguments: UnformattedSyntaxTree[];
};
export declare type UnformattedClosureLineOfCode = {
    lineOfCode: string;
    relativeIndentation: number;
};
export declare type UnformattedClosureCodeBlock = UnformattedClosureLineOfCode[];
export declare type UnformattedClosureSyntaxTree = {
    type: TokenType.Closure;
    method: UnformattedSyntaxTree;
    closureCodeBlock: UnformattedClosureCodeBlock;
};
export declare type UnformattedStringSyntaxTree = {
    type: TokenType.String;
    string: string;
};
export declare type UnformattedWordSyntaxTree = {
    type: TokenType.Word;
    word: string;
};
export declare type UnformattedSyntaxTree = UnformattedMethodSyntaxTree | UnformattedClosureSyntaxTree | UnformattedStringSyntaxTree | UnformattedWordSyntaxTree | UnformattedTraversalSyntaxTree | UnformattedNonGremlinSyntaxTree;
export declare type FormattedNonGremlinSyntaxTree = UnformattedNonGremlinSyntaxTree & {
    width: number;
};
export declare type GremlinStepGroup = {
    steps: FormattedSyntaxTree[];
};
export declare type FormattedTraversalSyntaxTree = {
    type: TokenType.Traversal;
    steps: UnformattedSyntaxTree[];
    stepGroups: GremlinStepGroup[];
    initialHorizontalPosition: number;
    localIndentation: number;
    width: number;
};
export declare type FormattedMethodSyntaxTree = {
    type: TokenType.Method;
    method: FormattedSyntaxTree;
    arguments: UnformattedSyntaxTree[];
    argumentGroups: FormattedSyntaxTree[][];
    argumentsShouldStartOnNewLine: boolean;
    localIndentation: number;
    width: number;
    shouldStartWithDot: boolean;
    shouldEndWithDot: boolean;
};
declare type FormattedClosureLineOfCode = {
    lineOfCode: string;
    relativeIndentation: number;
    localIndentation: number;
};
declare type FormattedClosureCodeBlock = FormattedClosureLineOfCode[];
export declare type FormattedClosureSyntaxTree = {
    type: TokenType.Closure;
    method: FormattedSyntaxTree;
    closureCodeBlock: FormattedClosureCodeBlock;
    localIndentation: number;
    width: number;
    shouldStartWithDot: boolean;
    shouldEndWithDot: boolean;
};
export declare type FormattedStringSyntaxTree = {
    type: TokenType.String;
    string: string;
    width: number;
    localIndentation: number;
};
export declare type FormattedWordSyntaxTree = {
    type: TokenType.Word;
    word: string;
    localIndentation: number;
    width: number;
    shouldStartWithDot: boolean;
    shouldEndWithDot: boolean;
};
export declare type FormattedSyntaxTree = FormattedTraversalSyntaxTree | FormattedMethodSyntaxTree | FormattedClosureSyntaxTree | FormattedStringSyntaxTree | FormattedWordSyntaxTree | FormattedNonGremlinSyntaxTree;
export declare type GremlinSyntaxTreeFormatter = (config: GremlintInternalConfig) => (syntaxTree: UnformattedSyntaxTree) => FormattedSyntaxTree;
export {};
