/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.lambda;

import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.lambda.AbstractLambdaTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalUtil;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Property;

public final class ValueTraversal<T, V>
extends AbstractLambdaTraversal<T, V> {
    private final String propertyKey;
    private V value;
    private boolean noStarts = false;

    public ValueTraversal(String propertyKey) {
        this.propertyKey = propertyKey;
    }

    public ValueTraversal(String propertyKey, Traversal.Admin<T, V> bypassTraversal) {
        this.propertyKey = propertyKey;
        this.setBypassTraversal(bypassTraversal);
    }

    public V getValue() {
        return this.value;
    }

    public boolean isNoStarts() {
        return this.noStarts;
    }

    @Override
    public V next() {
        if (this.noStarts) {
            throw new NoSuchElementException(String.format("%s is empty", this.toString()));
        }
        return this.value;
    }

    @Override
    public boolean hasNext() {
        return !this.noStarts;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void addStart(Traverser.Admin<T> start) {
        if (null == this.bypassTraversal) {
            Object o = start.get();
            if (o instanceof Element) {
                Property p = ((Element)o).property(this.propertyKey);
                if (p.isPresent()) {
                    this.value = p.value();
                    return;
                } else {
                    this.noStarts = true;
                }
                return;
            } else {
                if (!(o instanceof Map)) throw new IllegalStateException(String.format("The by(\"%s\") modulator can only be applied to a traverser that is an Element or a Map - it is being applied to [%s] a %s class instead", this.propertyKey, o, o.getClass().getSimpleName()));
                this.value = ((Map)o).get(this.propertyKey);
            }
            return;
        } else {
            this.value = TraversalUtil.apply(start, this.bypassTraversal);
        }
    }

    public String getPropertyKey() {
        return this.propertyKey;
    }

    @Override
    public void reset() {
        super.reset();
        this.noStarts = false;
    }

    public String toString() {
        return "value(" + (null == this.bypassTraversal ? this.propertyKey : this.bypassTraversal) + ')';
    }

    @Override
    public int hashCode() {
        int hc = 19;
        hc = 43 * hc + super.hashCode();
        hc = 43 * hc + this.propertyKey.hashCode();
        return hc;
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof ValueTraversal && Objects.equals(((ValueTraversal)other).propertyKey, this.propertyKey);
    }
}

