/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.computer.traversal.strategy.optimization;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.computer.traversal.step.map.TraversalVertexProgramStep;
import org.apache.tinkerpop.gremlin.process.computer.util.EmptyMemory;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.DefaultGraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.process.traversal.step.Barrier;
import org.apache.tinkerpop.gremlin.process.traversal.step.LambdaHolder;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.branch.LocalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.DedupGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.FilterStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.CountGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.EdgeVertexStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.GraphStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.IdStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.TraversalFlatMapStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.TraversalMapStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.VertexStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.IdentityStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.ProfileSideEffectStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.SideEffectStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.EmptyStep;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.AbstractTraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.optimization.AdjacentToIncidentStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.optimization.FilterRankingStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.optimization.IncidentToAdjacentStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.optimization.InlineFilterStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.util.empty.EmptyGraph;

public final class MessagePassingReductionStrategy
extends AbstractTraversalStrategy<TraversalStrategy.OptimizationStrategy>
implements TraversalStrategy.OptimizationStrategy {
    private static final MessagePassingReductionStrategy INSTANCE = new MessagePassingReductionStrategy();
    private static final Set<Class<? extends TraversalStrategy.OptimizationStrategy>> PRIORS = new HashSet<Class>(Arrays.asList(IncidentToAdjacentStrategy.class, AdjacentToIncidentStrategy.class, FilterRankingStrategy.class, InlineFilterStrategy.class));

    private MessagePassingReductionStrategy() {
    }

    @Override
    public void apply(Traversal.Admin<?, ?> traversal) {
        TraversalHelper.getFirstStepOfAssignableClass(TraversalVertexProgramStep.class, traversal).ifPresent(step -> {
            Graph graph = traversal.getGraph().orElse(EmptyGraph.instance());
            Traversal.Admin<?, ?> compiledComputerTraversal = step.generateProgram(graph, EmptyMemory.instance()).getTraversal().get().clone();
            if (!compiledComputerTraversal.isLocked()) {
                compiledComputerTraversal.applyStrategies();
            }
            if (!(TraversalHelper.hasStepOfAssignableClassRecursively(Arrays.asList(LocalStep.class, LambdaHolder.class), compiledComputerTraversal) || compiledComputerTraversal.getTraverserRequirements().contains((Object)TraverserRequirement.PATH) || compiledComputerTraversal.getTraverserRequirements().contains((Object)TraverserRequirement.LABELED_PATH) || TraversalHelper.getStepsOfAssignableClass(TraversalParent.class, compiledComputerTraversal).stream().filter(parent -> !parent.getGlobalChildren().isEmpty()).findAny().isPresent())) {
                Traversal.Admin<?, ?> computerTraversal = step.computerTraversal.get().clone();
                List<TraversalStrategy<?>> strategies = step.getTraversal().getStrategies().toList();
                if (computerTraversal.getSteps().size() > 1 && !(computerTraversal.getStartStep().getNextStep() instanceof Barrier) && TraversalHelper.hasStepOfAssignableClassRecursively(Arrays.asList(VertexStep.class, EdgeVertexStep.class), computerTraversal) && TraversalHelper.isLocalStarGraph(computerTraversal)) {
                    ProfileSideEffectStep pses;
                    Step<?, Object> barrier = TraversalHelper.getFirstStepOfAssignableClass(Barrier.class, computerTraversal).orElse(null);
                    if (null == barrier && (pses = (ProfileSideEffectStep)TraversalHelper.getFirstStepOfAssignableClass(ProfileSideEffectStep.class, computerTraversal).orElse(null)) != null) {
                        barrier = pses.getPreviousStep();
                    }
                    if (barrier != null && barrier.getPreviousStep() instanceof ProfileSideEffectStep) {
                        barrier = barrier.getPreviousStep().getPreviousStep();
                    }
                    if (MessagePassingReductionStrategy.insertElementId(barrier)) {
                        TraversalHelper.insertBeforeStep(new IdStep(computerTraversal), barrier, computerTraversal);
                    }
                    if (!MessagePassingReductionStrategy.endsWithElement(null == barrier ? computerTraversal.getEndStep() : barrier)) {
                        DefaultGraphTraversal newChildTraversal = new DefaultGraphTraversal();
                        TraversalHelper.removeToTraversal(computerTraversal.getStartStep() instanceof GraphStep ? computerTraversal.getStartStep().getNextStep() : computerTraversal.getStartStep(), null == barrier ? EmptyStep.instance() : barrier, newChildTraversal);
                        Traversal.Admin admin = newChildTraversal = newChildTraversal.getSteps().size() > 1 ? (Traversal.Admin)((Object)__.local(newChildTraversal)) : newChildTraversal;
                        if (null == barrier) {
                            TraversalHelper.insertTraversal(0, newChildTraversal, computerTraversal);
                        } else {
                            TraversalHelper.insertTraversal(barrier.getPreviousStep(), newChildTraversal, computerTraversal);
                        }
                    }
                }
                step.setComputerTraversal(computerTraversal);
            }
        });
    }

    private static boolean insertElementId(Step<?, ?> barrier) {
        if (!(barrier instanceof Barrier)) {
            return false;
        }
        if (!MessagePassingReductionStrategy.endsWithElement(barrier.getPreviousStep())) {
            return false;
        }
        if (barrier instanceof CountGlobalStep) {
            return true;
        }
        return barrier instanceof DedupGlobalStep && ((DedupGlobalStep)barrier).getScopeKeys().isEmpty() && ((DedupGlobalStep)barrier).getLocalChildren().isEmpty() && barrier.getNextStep() instanceof CountGlobalStep;
    }

    public static final boolean endsWithElement(Step<?, ?> currentStep) {
        while (!(currentStep instanceof EmptyStep)) {
            if (currentStep instanceof VertexStep) {
                return ((VertexStep)currentStep).returnsVertex() || !((VertexStep)currentStep).getDirection().equals((Object)Direction.OUT);
            }
            if (currentStep instanceof EdgeVertexStep) {
                return true;
            }
            if (currentStep instanceof TraversalFlatMapStep || currentStep instanceof TraversalMapStep || currentStep instanceof LocalStep) {
                return MessagePassingReductionStrategy.endsWithElement(((TraversalParent)((Object)currentStep)).getLocalChildren().get(0).getEndStep());
            }
            if (!(currentStep instanceof FilterStep || currentStep instanceof SideEffectStep || currentStep instanceof IdentityStep || currentStep instanceof Barrier)) {
                return false;
            }
            currentStep = currentStep.getPreviousStep();
        }
        return false;
    }

    @Override
    public Set<Class<? extends TraversalStrategy.OptimizationStrategy>> applyPrior() {
        return PRIORS;
    }

    public static MessagePassingReductionStrategy instance() {
        return INSTANCE;
    }
}

