/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.language.grammar;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.tinkerpop.gremlin.language.grammar.GenericLiteralVisitor;
import org.apache.tinkerpop.gremlin.language.grammar.GremlinBaseVisitor;
import org.apache.tinkerpop.gremlin.language.grammar.GremlinParser;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.PartitionStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.SeedStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.SubgraphStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.optimization.ProductiveByStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.verification.EdgeLabelVerificationStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.verification.ReadOnlyStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.verification.ReservedKeysVerificationStrategy;

public class TraversalStrategyVisitor
extends GremlinBaseVisitor<TraversalStrategy> {
    protected final GremlinBaseVisitor<Traversal> tvisitor;

    public TraversalStrategyVisitor(GremlinBaseVisitor<Traversal> tvisitor) {
        this.tvisitor = tvisitor;
    }

    @Override
    public TraversalStrategy visitTraversalStrategy(GremlinParser.TraversalStrategyContext ctx) {
        if (ctx.getChildCount() == 1) {
            String strategyName = ctx.getChild(0).getText();
            if (strategyName.equals(ReadOnlyStrategy.class.getSimpleName())) {
                return ReadOnlyStrategy.instance();
            }
            if (strategyName.equals(ProductiveByStrategy.class.getSimpleName())) {
                return ProductiveByStrategy.instance();
            }
        } else if (ctx.getChild(0).getText().equals("new")) {
            String strategyName = ctx.getChild(1).getText();
            if (strategyName.equals(PartitionStrategy.class.getSimpleName())) {
                return TraversalStrategyVisitor.getPartitionStrategy(ctx.traversalStrategyArgs_PartitionStrategy());
            }
            if (strategyName.equals(ReservedKeysVerificationStrategy.class.getSimpleName())) {
                return TraversalStrategyVisitor.getReservedKeysVerificationStrategy(ctx.traversalStrategyArgs_ReservedKeysVerificationStrategy());
            }
            if (strategyName.equals(EdgeLabelVerificationStrategy.class.getSimpleName())) {
                return TraversalStrategyVisitor.getEdgeLabelVerificationStrategy(ctx.traversalStrategyArgs_EdgeLabelVerificationStrategy());
            }
            if (strategyName.equals(SubgraphStrategy.class.getSimpleName())) {
                return this.getSubgraphStrategy(ctx.traversalStrategyArgs_SubgraphStrategy());
            }
            if (strategyName.equals(SeedStrategy.class.getSimpleName())) {
                return new SeedStrategy(Long.parseLong(ctx.integerLiteral().getText()));
            }
            if (strategyName.equals(ProductiveByStrategy.class.getSimpleName())) {
                return TraversalStrategyVisitor.getProductiveByStrategy(ctx.traversalStrategyArgs_ProductiveByStrategy());
            }
        }
        throw new IllegalStateException("Unexpected TraversalStrategy specification - " + ctx.getText());
    }

    private static EdgeLabelVerificationStrategy getEdgeLabelVerificationStrategy(List<GremlinParser.TraversalStrategyArgs_EdgeLabelVerificationStrategyContext> ctxs) {
        if (null == ctxs || ctxs.isEmpty()) {
            return EdgeLabelVerificationStrategy.build().create();
        }
        EdgeLabelVerificationStrategy.Builder builder = EdgeLabelVerificationStrategy.build();
        ctxs.forEach(ctx -> {
            switch (ctx.getChild(0).getText()) {
                case "logWarning": {
                    builder.logWarning(GenericLiteralVisitor.getBooleanLiteral(ctx.booleanLiteral()));
                    break;
                }
                case "throwException": {
                    builder.throwException(GenericLiteralVisitor.getBooleanLiteral(ctx.booleanLiteral()));
                }
            }
        });
        return builder.create();
    }

    private static ReservedKeysVerificationStrategy getReservedKeysVerificationStrategy(List<GremlinParser.TraversalStrategyArgs_ReservedKeysVerificationStrategyContext> ctxs) {
        if (null == ctxs || ctxs.isEmpty()) {
            return ReservedKeysVerificationStrategy.build().create();
        }
        ReservedKeysVerificationStrategy.Builder builder = ReservedKeysVerificationStrategy.build();
        ctxs.forEach(ctx -> {
            switch (ctx.getChild(0).getText()) {
                case "logWarning": {
                    builder.logWarning(GenericLiteralVisitor.getBooleanLiteral(ctx.booleanLiteral()));
                    break;
                }
                case "throwException": {
                    builder.throwException(GenericLiteralVisitor.getBooleanLiteral(ctx.booleanLiteral()));
                    break;
                }
                case "keys": {
                    builder.reservedKeys(new HashSet<String>(Arrays.asList(GenericLiteralVisitor.getStringLiteralList(ctx.stringLiteralList()))));
                }
            }
        });
        return builder.create();
    }

    private static PartitionStrategy getPartitionStrategy(List<GremlinParser.TraversalStrategyArgs_PartitionStrategyContext> ctxs) {
        PartitionStrategy.Builder builder = PartitionStrategy.build();
        ctxs.forEach(ctx -> {
            switch (ctx.getChild(0).getText()) {
                case "includeMetaProperties": {
                    builder.includeMetaProperties(GenericLiteralVisitor.getBooleanLiteral(ctx.booleanLiteral()));
                    break;
                }
                case "readPartitions": {
                    builder.readPartitions(Arrays.asList(GenericLiteralVisitor.getStringLiteralList(ctx.stringLiteralList())));
                    break;
                }
                case "writePartition": {
                    builder.writePartition(GenericLiteralVisitor.getStringLiteral(ctx.stringLiteral()));
                    break;
                }
                case "partitionKey": {
                    builder.partitionKey(GenericLiteralVisitor.getStringLiteral(ctx.stringLiteral()));
                }
            }
        });
        return builder.create();
    }

    private SubgraphStrategy getSubgraphStrategy(List<GremlinParser.TraversalStrategyArgs_SubgraphStrategyContext> ctxs) {
        SubgraphStrategy.Builder builder = SubgraphStrategy.build();
        ctxs.forEach(ctx -> {
            switch (ctx.getChild(0).getText()) {
                case "vertices": {
                    builder.vertices(this.tvisitor.visitNestedTraversal(ctx.nestedTraversal()));
                    break;
                }
                case "edges": {
                    builder.edges(this.tvisitor.visitNestedTraversal(ctx.nestedTraversal()));
                    break;
                }
                case "vertexProperties": {
                    builder.vertexProperties(this.tvisitor.visitNestedTraversal(ctx.nestedTraversal()));
                    break;
                }
                case "checkAdjacentVertices": {
                    builder.checkAdjacentVertices(GenericLiteralVisitor.getBooleanLiteral(ctx.booleanLiteral()));
                }
            }
        });
        return builder.create();
    }

    private static ProductiveByStrategy getProductiveByStrategy(GremlinParser.TraversalStrategyArgs_ProductiveByStrategyContext ctx) {
        ProductiveByStrategy.Builder builder = ProductiveByStrategy.build();
        builder.productiveKeys(Arrays.asList(GenericLiteralVisitor.getStringLiteralList(ctx.stringLiteralList())));
        return builder.create();
    }
}

