"use strict";
/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.extractGremlinQueries = void 0;
var LEFT_WHITE_PARENTHESIS = '⦅';
var RIGHT_WHITE_PARENTHESIS = '⦆';
var LEFT_WHITE_SQUARE_BRACKET = '⟦';
var RIGHT_WHITE_SQUARE_BRACKET = '⟧';
var LEFT_WHITE_CURLY_BRACKET = '⦃';
var RIGHT_WHITE_CURLY_BRACKET = '⦄';
var WHITE_DOT = '。';
var encodeAllNestedBracketsAndDots = function (code) {
    var word = code.split('').reduce(function (state, char) {
        if (char === '.') {
            return __assign(__assign({}, state), { word: !state.isInsideSingleQuoteString &&
                    !state.parenthesesCount &&
                    !state.squareBracketsCount &&
                    !state.curlyBracketsCount
                    ? state.word + '.'
                    : state.word + WHITE_DOT });
        }
        if (char === '(') {
            return __assign(__assign({}, state), { parenthesesCount: state.parenthesesCount + (state.isInsideSingleQuoteString ? 0 : 1), word: !state.isInsideSingleQuoteString &&
                    !state.parenthesesCount &&
                    !state.squareBracketsCount &&
                    !state.curlyBracketsCount
                    ? state.word + '('
                    : state.word + LEFT_WHITE_PARENTHESIS });
        }
        if (char === '[') {
            return __assign(__assign({}, state), { squareBracketsCount: state.squareBracketsCount + (state.isInsideSingleQuoteString ? 0 : 1), word: !state.isInsideSingleQuoteString &&
                    !state.parenthesesCount &&
                    !state.squareBracketsCount &&
                    !state.curlyBracketsCount
                    ? state.word + '['
                    : state.word + LEFT_WHITE_SQUARE_BRACKET });
        }
        if (char === '{') {
            return __assign(__assign({}, state), { curlyBracketsCount: state.curlyBracketsCount + (state.isInsideSingleQuoteString ? 0 : 1), word: !state.isInsideSingleQuoteString &&
                    !state.parenthesesCount &&
                    !state.squareBracketsCount &&
                    !state.curlyBracketsCount
                    ? state.word + '{'
                    : state.word + LEFT_WHITE_CURLY_BRACKET });
        }
        if (char === ')') {
            return __assign(__assign({}, state), { parenthesesCount: state.parenthesesCount - (state.isInsideSingleQuoteString ? 0 : 1), word: !state.isInsideSingleQuoteString &&
                    state.parenthesesCount === 1 &&
                    !state.squareBracketsCount &&
                    !state.curlyBracketsCount
                    ? state.word + ')'
                    : state.word + RIGHT_WHITE_PARENTHESIS });
        }
        if (char === ']') {
            return __assign(__assign({}, state), { squareBracketsCount: state.squareBracketsCount - (state.isInsideSingleQuoteString ? 0 : 1), word: !state.isInsideSingleQuoteString &&
                    !state.parenthesesCount &&
                    state.squareBracketsCount === 1 &&
                    !state.curlyBracketsCount
                    ? state.word + ']'
                    : state.word + RIGHT_WHITE_SQUARE_BRACKET });
        }
        if (char === '}') {
            return __assign(__assign({}, state), { curlyBracketsCount: state.curlyBracketsCount - (state.isInsideSingleQuoteString ? 0 : 1), word: !state.isInsideSingleQuoteString &&
                    !state.parenthesesCount &&
                    !state.squareBracketsCount &&
                    state.curlyBracketsCount === 1
                    ? state.word + '}'
                    : state.word + RIGHT_WHITE_CURLY_BRACKET });
        }
        if (char === "'") {
            return __assign(__assign({}, state), { isInsideSingleQuoteString: !state.isInsideSingleQuoteString, word: state.word + "'" });
        }
        return __assign(__assign({}, state), { word: state.word + char });
    }, { word: '', parenthesesCount: 0, squareBracketsCount: 0, curlyBracketsCount: 0, isInsideSingleQuoteString: false }).word;
    return word;
};
var decodeEncodedBracketsAndDots = function (code) {
    return code
        .split(WHITE_DOT)
        .join('.')
        .split(LEFT_WHITE_PARENTHESIS)
        .join('(')
        .split(RIGHT_WHITE_PARENTHESIS)
        .join(')')
        .split(LEFT_WHITE_SQUARE_BRACKET)
        .join('[')
        .split(RIGHT_WHITE_SQUARE_BRACKET)
        .join(']')
        .split(LEFT_WHITE_CURLY_BRACKET)
        .join('{')
        .split(RIGHT_WHITE_CURLY_BRACKET)
        .join('}');
};
var SPACE = "\\s";
var HORIZONTAL_SPACE = "[^\\S\\r\\n]";
var DOT = "\\.";
var METHOD_STEP = "\\w+" + HORIZONTAL_SPACE + "*\\([^\\)]*\\)";
var CLOSURE_STEP = "\\w+" + HORIZONTAL_SPACE + "*\\{[^\\}]*\\}";
var WORD_STEP = "\\w+";
var GREMLIN_STEP = "(" + METHOD_STEP + "|" + CLOSURE_STEP + "|" + WORD_STEP + ")";
var STEP_CONNECTOR = "(" + SPACE + "*" + DOT + SPACE + "*)";
var GREMLIN_QUERY = "g(" + STEP_CONNECTOR + GREMLIN_STEP + ")+";
var gremlinQueryRegExp = new RegExp(GREMLIN_QUERY, 'g');
var extractGremlinQueries = function (code) {
    var encodedCode = encodeAllNestedBracketsAndDots(code);
    var gremlinQueries = encodedCode.match(gremlinQueryRegExp);
    if (!gremlinQueries)
        return [];
    return gremlinQueries.map(decodeEncodedBracketsAndDots);
};
exports.extractGremlinQueries = extractGremlinQueries;
