"use strict";
/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.formatQuery = void 0;
var formatSyntaxTrees_1 = require("./formatSyntaxTrees");
var parseToSyntaxTrees_1 = require("./parseToSyntaxTrees");
var recreateQueryStringFromFormattedSyntaxTrees_1 = require("./recreateQueryStringFromFormattedSyntaxTrees");
var utils_1 = require("./utils");
var withDefaults = function (config) { return (__assign({ indentation: 0, maxLineLength: 80, shouldPlaceDotsAfterLineBreaks: false }, config)); };
var getInternalGremlintConfig = function (_a) {
    var indentation = _a.indentation, maxLineLength = _a.maxLineLength, shouldPlaceDotsAfterLineBreaks = _a.shouldPlaceDotsAfterLineBreaks;
    return ({
        globalIndentation: indentation,
        localIndentation: 0,
        maxLineLength: maxLineLength - indentation,
        shouldPlaceDotsAfterLineBreaks: shouldPlaceDotsAfterLineBreaks,
        shouldStartWithDot: false,
        shouldEndWithDot: false,
        horizontalPosition: 0,
    });
};
var formatQuery = function (query, config) {
    var internalConfig = getInternalGremlintConfig(withDefaults(config !== null && config !== void 0 ? config : {}));
    return utils_1.pipe(parseToSyntaxTrees_1.parseToSyntaxTrees, formatSyntaxTrees_1.formatSyntaxTrees(internalConfig), recreateQueryStringFromFormattedSyntaxTrees_1.recreateQueryStringFromFormattedSyntaxTrees(internalConfig))(query);
};
exports.formatQuery = formatQuery;
