/*
* Licensed to the Apache Software Foundation (ASF) under one
* or more contributor license agreements.  See the NOTICE file
* distributed with this work for additional information
* regarding copyright ownership.  The ASF licenses this file
* to you under the Apache License, Version 2.0 (the
* "License"); you may not use this file except in compliance
* with the License.  You may obtain a copy of the License at
* 
* http://www.apache.org/licenses/LICENSE-2.0
* 
* Unless required by applicable law or agreed to in writing,
* software distributed under the License is distributed on an
* "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
* KIND, either express or implied.  See the License for the
* specific language governing permissions and limitations
* under the License.
*/



//********************************************************************************
//* Do NOT edit this file directly - generated by build/generate.groovy
//********************************************************************************


const graphTraversalModule = require('../../lib/process/graph-traversal');
const traversalModule = require('../../lib/process/traversal');
const { TraversalStrategies, VertexProgramStrategy, OptionsStrategy } = require('../../lib/process/traversal-strategy');
const __ = graphTraversalModule.statics;
const Barrier = traversalModule.barrier
const Cardinality = traversalModule.cardinality
const Column = traversalModule.column
const Direction = {
    BOTH: traversalModule.direction.both,
    IN: traversalModule.direction.in,
    OUT: traversalModule.direction.out
};
const P = traversalModule.P;
const Pick = traversalModule.pick
const Pop = traversalModule.pop
const Order = traversalModule.order
const Operator = traversalModule.operator
const Scope = traversalModule.scope
const T = traversalModule.t
const TextP = traversalModule.TextP
const WithOptions = traversalModule.withOptions

const gremlins = {
    g_V_branchXlabel_eq_person__a_bX_optionXa__ageX_optionXb__langX_optionXb__nameX: [function({g, l1}) { return g.V().branch(l1).option("a",__.values("age")).option("b",__.values("lang")).option("b",__.values("name")) }], 
    g_V_branchXlabel_isXpersonX_countX_optionX1__ageX_optionX0__langX_optionX0__nameX: [function({g, xx1, xx2}) { return g.V().branch(__.label().is("person").count()).option(xx1,__.values("age")).option(xx2,__.values("lang")).option(xx2,__.values("name")) }], 
    g_V_branchXlabel_isXpersonX_countX_optionX1__ageX_optionX0__langX_optionX0__nameX_optionXany__labelX: [function({g, xx1, xx2}) { return g.V().branch(__.label().is("person").count()).option(xx1,__.values("age")).option(xx2,__.values("lang")).option(xx2,__.values("name")).option(Pick.any,__.label()) }], 
    g_V_branchXageX_optionXltX30X__youngX_optionXgtX30X__oldX_optionXnone__on_the_edgeX: [function({g}) { return g.V().hasLabel("person").branch(__.values("age")).option(P.lt(30),__.constant("young")).option(P.gt(30),__.constant("old")).option(Pick.none,__.constant("on the edge")) }], 
    g_V_branchXidentityX_optionXhasLabelXsoftwareX__inXcreatedX_name_order_foldX_optionXhasXname_vadasX__ageX_optionXneqX123X__bothE_countX: [function({g}) { return g.V().branch(__.identity()).option(__.hasLabel("software"),__.in_("created").values("name").order().fold()).option(__.has("name","vadas"),__.values("age")).option(P.neq(123),__.bothE().count()) }], 
    g_V_chooseXout_countX_optionX2L_nameX_optionX3L_ageX: [function({g, xx1, xx2}) { return g.V().choose(__.out().count()).option(xx1,__.values("name")).option(xx2,__.values("age")) }], 
    g_V_chooseXlabel_eqXpersonX__outXknowsX__inXcreatedXX_name: [function({g, pred1}) { return g.V().choose(pred1,__.out("knows"),__.in_("created")).values("name") }], 
    g_V_chooseXhasLabelXpersonX_and_outXcreatedX__outXknowsX__identityX_name: [function({g}) { return g.V().choose(__.hasLabel("person").and().out("created"),__.out("knows"),__.identity()).values("name") }], 
    g_V_chooseXlabelX_optionXblah__outXknowsXX_optionXbleep__outXcreatedXX_optionXnone__identityX_name: [function({g}) { return g.V().choose(__.label()).option("blah",__.out("knows")).option("bleep",__.out("created")).option(Pick.none,__.identity()).values("name") }], 
    g_V_chooseXoutXknowsX_count_isXgtX0XX__outXknowsXX_name: [function({g}) { return g.V().choose(__.out("knows").count().is(P.gt(0)),__.out("knows")).values("name") }], 
    g_V_hasLabelXpersonX_asXp1X_chooseXoutEXknowsX__outXknowsXX_asXp2X_selectXp1_p2X_byXnameX: [function({g}) { return g.V().hasLabel("person").as("p1").choose(__.outE("knows"),__.out("knows")).as("p2").select("p1","p2").by("name") }], 
    g_V_hasLabelXpersonX_chooseXageX__optionX27L__constantXyoungXX_optionXnone__constantXoldXX_groupCount: [function({g, xx1}) { return g.V().hasLabel("person").choose(__.values("age")).option(xx1,__.constant("young")).option(Pick.none,__.constant("old")).groupCount() }], 
    g_injectX1X_chooseXisX1X__constantX10Xfold__foldX: [function({g, xx1, xx2}) { return g.inject(xx2).choose(__.is(xx2),__.constant(xx1).fold(),__.fold()) }], 
    g_injectX2X_chooseXisX1X__constantX10Xfold__foldX: [function({g, xx1, xx3, xx2}) { return g.inject(xx3).choose(__.is(xx2),__.constant(xx1).fold(),__.fold()) }], 
    g_V_localXpropertiesXlocationX_order_byXvalueX_limitX2XX_value: [function({g}) { return g.V().local(__.properties("location").order().by(T.value,Order.asc).range(0,2)).value() }], 
    g_V_hasXlabel_personX_asXaX_localXoutXcreatedX_asXbXX_selectXa_bX_byXnameX_byXidX: [function({g}) { return g.V().has(T.label,"person").as("a").local(__.out("created").as("b")).select("a","b").by("name").by(T.id) }], 
    g_V_localXoutE_countX: [function({g}) { return g.V().local(__.outE().count()) }], 
    g_VX1X_localXoutEXknowsX_limitX1XX_inV_name: [function({g, vid1}) { return g.V(vid1).local(__.outE("knows").limit(1)).inV().values("name") }], 
    g_V_localXbothEXcreatedX_limitX1XX_otherV_name: [function({g}) { return g.V().local(__.bothE("created").limit(1)).otherV().values("name") }], 
    g_VX4X_localXbothEX1_createdX_limitX1XX: [function({g, vid4}) { return g.V(vid4).local(__.bothE("created").limit(1)) }], 
    g_VX4X_localXbothEXknows_createdX_limitX1XX: [function({g, vid4}) { return g.V(vid4).local(__.bothE("knows","created").limit(1)) }], 
    g_VX4X_localXbothE_limitX1XX_otherV_name: [function({g, vid4}) { return g.V(vid4).local(__.bothE().limit(1)).otherV().values("name") }], 
    g_VX4X_localXbothE_limitX2XX_otherV_name: [function({g, vid4}) { return g.V(vid4).local(__.bothE().limit(2)).otherV().values("name") }], 
    g_V_localXinEXknowsX_limitX2XX_outV_name: [function({g}) { return g.V().local(__.inE("knows").limit(2)).outV().values("name") }], 
    g_V_localXmatchXproject__created_person__person_name_nameX_selectXname_projectX_by_byXnameX: [function({g}) { return g.V().local(__.match(__.as("project").in_("created").as("person"),__.as("person").values("name").as("name"))).select("name","project").by().by("name") }], 
    g_VX2X_optionalXoutXknowsXX: [function({g, vid2}) { return g.V(vid2).optional(__.out("knows")) }], 
    g_VX2X_optionalXinXknowsXX: [function({g, vid2}) { return g.V(vid2).optional(__.in_("knows")) }], 
    g_V_hasLabelXpersonX_optionalXoutXknowsX_optionalXoutXcreatedXXX_path: [function({g}) { return g.V().hasLabel("person").optional(__.out("knows").optional(__.out("created"))).path() }], 
    g_V_optionalXout_optionalXoutXX_path: [function({g}) { return g.V().optional(__.out().optional(__.out())).path() }], 
    g_VX1X_optionalXaddVXdogXX_label: [function({g, vid1}) { return g.addV("person").property(T.id,1).property("name","marko").property("age",29).as("marko").addV("person").property(T.id,2).property("name","vadas").property("age",27).as("vadas").addV("software").property(T.id,3).property("name","lop").property("lang","java").as("lop").addV("person").property(T.id,4).property("name","josh").property("age",32).as("josh").addV("software").property(T.id,5).property("name","ripple").property("lang","java").as("ripple").addV("person").property(T.id,6).property("name","peter").property("age",35).as("peter").addE("knows").from_("marko").to("vadas").property(T.id,7).property("weight",0.5).addE("knows").from_("marko").to("josh").property(T.id,8).property("weight",1.0).addE("created").from_("marko").to("lop").property(T.id,9).property("weight",0.4).addE("created").from_("josh").to("ripple").property(T.id,10).property("weight",1.0).addE("created").from_("josh").to("lop").property(T.id,11).property("weight",0.4).addE("created").from_("peter").to("lop").property(T.id,12).property("weight",0.2) }, function({g, vid1}) { return g.V(vid1).optional(__.addV("dog")).label() }, function({g, vid1}) { return g.V() }], 
    g_V_repeatXoutX_timesX2X_emit_path: [function({g}) { return g.V().repeat(__.out()).times(2).emit().path() }], 
    g_V_repeatXoutX_timesX2X_repeatXinX_timesX2X_name: [function({g}) { return g.V().repeat(__.out()).times(2).repeat(__.in_()).times(2).values("name") }], 
    g_V_repeatXoutX_timesX2X: [function({g}) { return g.V().repeat(__.out()).times(2) }], 
    g_V_repeatXoutX_timesX2X_emit: [function({g}) { return g.V().repeat(__.out()).times(2).emit() }], 
    g_VX1X_timesX2X_repeatXoutX_name: [function({g, vid1}) { return g.V(vid1).times(2).repeat(__.out()).values("name") }], 
    g_V_emit_timesX2X_repeatXoutX_path: [function({g}) { return g.V().emit().times(2).repeat(__.out()).path() }], 
    g_V_emit_repeatXoutX_timesX2X_path: [function({g}) { return g.V().emit().repeat(__.out()).times(2).path() }], 
    g_VX1X_emitXhasXlabel_personXX_repeatXoutX_name: [function({g, vid1}) { return g.V(vid1).emit(__.has(T.label,"person")).repeat(__.out()).values("name") }], 
    g_V_repeatXgroupCountXmX_byXnameX_outX_timesX2X_capXmX: [function({g}) { return g.V().repeat(__.groupCount("m").by("name").out()).times(2).cap("m") }], 
    g_VX1X_repeatXgroupCountXmX_byXloopsX_outX_timesX3X_capXmX: [function({g, vid1}) { return g.V(vid1).repeat(__.groupCount("m").by(__.loops()).out()).times(3).cap("m") }], 
    g_V_repeatXbothX_timesX10X_asXaX_out_asXbX_selectXa_bX: [function({g}) { return g.V().repeat(__.both()).times(10).as("a").out().as("b").select("a","b").count() }], 
    g_VX1X_repeatXoutX_untilXoutE_count_isX0XX_name: [function({g, vid1}) { return g.V(vid1).repeat(__.out()).until(__.outE().count().is(0)).values("name") }], 
    g_V_repeatXbothX_untilXname_eq_marko_or_loops_gt_1X_groupCount_byXnameX: [function({g, pred1}) { return g.V().repeat(__.both()).until(pred1).groupCount().by("name") }], 
    g_V_hasXname_markoX_repeatXoutE_inV_simplePathX_untilXhasXname_rippleXX_path_byXnameX_byXlabelX: [function({g}) { return g.V().has("name","marko").repeat(__.outE().inV().simplePath()).until(__.has("name","ripple")).path().by("name").by(T.label) }], 
    g_V_hasXloop_name_loopX_repeatXinX_timesX5X_path_by_name: [function({g}) { return g.V().has("loops","name","loop").repeat(__.in_()).times(5).path().by("name") }], 
    g_V_repeatXout_repeatXoutX_timesX1XX_timesX1X_limitX1X_path_by_name: [function({g}) { return g.V().repeat(__.out().repeat(__.out()).times(1)).times(1).limit(1).path().by("name") }], 
    g_V_repeatXoutXknowsXX_untilXrepeatXoutXcreatedXX_emitXhasXname_lopXXX_path_byXnameX: [function({g}) { return g.V().repeat(__.out("knows")).until(__.repeat(__.out("created")).emit(__.has("name","lop"))).path().by("name") }], 
    g_V_repeatXrepeatXout_createdXX_untilXhasXname_rippleXXXemit_lang: [function({g}) { return g.V().repeat(__.repeat(__.out("created")).until(__.has("name","ripple"))).emit().values("lang") }], 
    g_V_untilXconstantXtrueXX_repeatXrepeatXout_createdXX_untilXhasXname_rippleXXXemit_lang: [function({g}) { return g.V().until(__.constant(true)).repeat(__.repeat(__.out("created")).until(__.has("name","ripple"))).emit().values("lang") }], 
    g_V_emit_repeatXa_outXknows_filterXloops_isX0XX_lang: [function({g}) { return g.V().emit().repeat("a",__.out("knows").filter(__.loops("a").is(0))).values("lang") }], 
    g_VX3X_repeatXbothX_createdXX_untilXloops_is_40XXemit_repeatXin_knowsXX_emit_loopsXisX1Xdedup_values: [function({g, vid3}) { return g.V(vid3).repeat(__.both("created")).until(__.loops().is(40)).emit(__.repeat(__.in_("knows")).emit(__.loops().is(1))).dedup().values("name") }], 
    g_VX1X_repeatXrepeatXunionXout_uses_out_traversesXX_whereXloops_isX0X_timesX1X_timeX2X_name: [function({g, vid1}) { return g.V(vid1).repeat(__.repeat(__.union(__.out("uses"),__.out("traverses")).where(__.loops().is(0))).times(1)).times(2).values("name") }], 
    g_V_repeatXa_outXknows_repeatXb_outXcreatedX_filterXloops_isX0XX_emit_lang: [function({g}) { return g.V().repeat("a",__.out("knows").repeat("b",__.out("created").filter(__.loops("a").is(0))).emit()).emit().values("lang") }], 
    g_VX6X_repeatXa_bothXcreatedX_simplePathX_emitXrepeatXb_bothXknowsXX_untilXloopsXbX_asXb_whereXloopsXaX_asXbX_hasXname_vadasXX_dedup_name: [function({g, vid6}) { return g.V(vid6).repeat("a",__.both("created").simplePath()).emit(__.repeat("b",__.both("knows")).until(__.loops("b").as("b").where(__.loops("a").as("b"))).has("name","vadas")).dedup().values("name") }], 
    g_V_unionXout__inX_name: [function({g}) { return g.V().union(__.out(),__.in_()).values("name") }], 
    g_VX1X_unionXrepeatXoutX_timesX2X__outX_name: [function({g, vid1}) { return g.V(vid1).union(__.repeat(__.out()).times(2),__.out()).values("name") }], 
    g_V_chooseXlabel_is_person__unionX__out_lang__out_nameX__in_labelX: [function({g}) { return g.V().choose(__.label().is("person"),__.union(__.out().values("lang"),__.out().values("name")),__.in_().label()) }], 
    g_V_chooseXlabel_is_person__unionX__out_lang__out_nameX__in_labelX_groupCount: [function({g}) { return g.V().choose(__.label().is("person"),__.union(__.out().values("lang"),__.out().values("name")),__.in_().label()).groupCount() }], 
    g_V_unionXrepeatXunionXoutXcreatedX__inXcreatedXX_timesX2X__repeatXunionXinXcreatedX__outXcreatedXX_timesX2XX_label_groupCount: [function({g}) { return g.V().union(__.repeat(__.union(__.out("created"),__.in_("created"))).times(2),__.repeat(__.union(__.in_("created"),__.out("created"))).times(2)).label().groupCount() }], 
    g_VX1_2X_unionXoutE_count__inE_count__outE_weight_sumX: [function({g, vid2, vid1}) { return g.V(vid1,vid2).union(__.outE().count(),__.inE().count(),__.outE().values("weight").sum()) }], 
    g_VX1_2X_localXunionXoutE_count__inE_count__outE_weight_sumXX: [function({g, vid2, vid1}) { return g.V(vid1,vid2).local(__.union(__.outE().count(),__.inE().count(),__.outE().values("weight").sum())) }], 
    g_VX1_2X_localXunionXcountXX: [function({g, vid2, vid1}) { return g.V(vid1,vid2).local(__.union(__.count())) }], 
    g_V_andXhasXage_gt_27X__outE_count_gte_2X_name: [function({g}) { return g.V().and(__.has("age",P.gt(27)),__.outE().count().is(P.gte(2))).values("name") }], 
    g_V_andXoutE__hasXlabel_personX_and_hasXage_gte_32XX_name: [function({g}) { return g.V().and(__.outE(),__.has(T.label,"person").and().has("age",P.gte(32))).values("name") }], 
    g_V_asXaX_outXknowsX_and_outXcreatedX_inXcreatedX_asXaX_name: [function({g}) { return g.V().as("a").out("knows").and().out("created").in_("created").as("a").values("name") }], 
    g_V_asXaX_andXselectXaX_selectXaXX: [function({g}) { return g.V().as("a").and(__.select("a"),__.select("a")) }], 
    g_V_hasXname_markoX_and_hasXname_markoX_and_hasXname_markoX: [function({g}) { return g.V().has("name","marko").and().has("name","marko").and().has("name","marko") }], 
    g_V_coinX1X: [function({g}) { return g.V().coin(1.0) }], 
    g_V_coinX0X: [function({g}) { return g.V().coin(0.0) }], 
    g_VX1X_outXcreatedX_inXcreatedX_cyclicPath: [function({g, vid1}) { return g.V(vid1).out("created").in_("created").cyclicPath() }], 
    g_VX1X_outXcreatedX_inXcreatedX_cyclicPath_path: [function({g, vid1}) { return g.V(vid1).out("created").in_("created").cyclicPath().path() }], 
    g_VX1X_asXaX_outXcreatedX_asXbX_inXcreatedX_asXcX_cyclicPath_fromXaX_toXbX_path: [function({g, vid1}) { return g.V(vid1).as("a").out("created").as("b").in_("created").as("c").cyclicPath().from_("a").to("b").path() }], 
    g_V_out_in_valuesXnameX_fold_dedupXlocalX_unfold: [function({g}) { return g.V().out().in_().values("name").fold().dedup(Scope.local).unfold() }], 
    g_V_out_asXxX_in_asXyX_selectXx_yX_byXnameX_fold_dedupXlocal_x_yX_unfold: [function({g}) { return g.V().out().as("x").in_().as("y").select("x","y").by("name").fold().dedup(Scope.local,"x","y").unfold() }], 
    g_V_both_dedup_name: [function({g}) { return g.V().both().dedup().values("name") }], 
    g_V_both_hasXlabel_softwareX_dedup_byXlangX_name: [function({g}) { return g.V().both().has(T.label,"software").dedup().by("lang").values("name") }], 
    g_V_both_name_order_byXa_bX_dedup_value: [function({g, c1}) { return g.V().both().properties("name").order().by(c1).dedup().value() }], 
    g_V_both_both_name_dedup: [function({g}) { return g.V().both().both().values("name").dedup() }], 
    g_V_both_both_dedup: [function({g}) { return g.V().both().both().dedup() }], 
    g_V_both_both_dedup_byXlabelX: [function({g}) { return g.V().both().both().dedup().by(T.label) }], 
    g_V_group_byXlabelX_byXbothE_weight_dedup_foldX: [function({g}) { return g.V().group().by(T.label).by(__.bothE().values("weight").dedup().fold()) }], 
    g_V_asXaX_both_asXbX_dedupXa_bX_byXlabelX_selectXa_bX: [function({g}) { return g.V().as("a").both().as("b").dedup("a","b").by(T.label).select("a","b") }], 
    g_V_asXaX_outXcreatedX_asXbX_inXcreatedX_asXcX_dedupXa_bX_path: [function({g}) { return g.V().as("a").out("created").as("b").in_("created").as("c").dedup("a","b").path() }], 
    g_V_outE_asXeX_inV_asXvX_selectXeX_order_byXweight_ascX_selectXvX_valuesXnameX_dedup: [function({g}) { return g.V().outE().as("e").inV().as("v").select("e").order().by("weight",Order.asc).select("v").values("name").dedup() }], 
    g_V_both_both_dedup_byXoutE_countX_name: [function({g}) { return g.V().both().both().dedup().by(__.outE().count()).values("name") }], 
    g_V_groupCount_selectXvaluesX_unfold_dedup: [function({g}) { return g.V().groupCount().select(Column.values).unfold().dedup() }], 
    g_V_asXaX_repeatXbothX_timesX3X_emit_name_asXbX_group_byXselectXaXX_byXselectXbX_dedup_order_foldX_selectXvaluesX_unfold_dedup: [function({g}) { return g.V().as("a").repeat(__.both()).times(3).emit().values("name").as("b").group().by(__.select("a")).by(__.select("b").dedup().order().fold()).select(Column.values).unfold().dedup() }], 
    g_V_repeatXdedupX_timesX2X_count: [function({g}) { return g.V().repeat(__.dedup()).times(2).count() }], 
    g_V_both_group_by_byXout_dedup_foldX_unfold_selectXvaluesX_unfold_out_order_byXnameX_limitX1X_valuesXnameX: [function({g}) { return g.V().both().group().by().by(__.out().dedup().fold()).unfold().select(Column.values).unfold().out().order().by("name").limit(1).values("name") }], 
    g_V_bothE_properties_dedup_count: [function({g}) { return g.V().bothE().properties().dedup().count() }], 
    g_V_both_properties_dedup_count: [function({g}) { return g.V().both().properties().dedup().count() }], 
    g_V_both_properties_properties_dedup_count: [function({g}) { return g.V().both().properties().properties().dedup().count() }], 
    g_V_drop: [function({g}) { return g.addV().as("a").addV().as("b").addE("knows").to("a") }, function({g}) { return g.V().drop() }, function({g}) { return g.V() }, function({g}) { return g.E() }], 
    g_V_outE_drop: [function({g}) { return g.addV().as("a").addV().as("b").addE("knows").to("a") }, function({g}) { return g.V().outE().drop() }, function({g}) { return g.V() }, function({g}) { return g.E() }], 
    g_V_properties_drop: [function({g}) { return g.addV().property("name","bob").addV().property("name","alice") }, function({g}) { return g.V().properties().drop() }, function({g}) { return g.V() }, function({g}) { return g.V().properties() }], 
    g_E_propertiesXweightX_drop: [function({g}) { return g.addV("person").property(T.id,1).property("name","marko").property("age",29).as("marko").addV("person").property(T.id,2).property("name","vadas").property("age",27).as("vadas").addV("software").property(T.id,3).property("name","lop").property("lang","java").as("lop").addV("person").property(T.id,4).property("name","josh").property("age",32).as("josh").addV("software").property(T.id,5).property("name","ripple").property("lang","java").as("ripple").addV("person").property(T.id,6).property("name","peter").property("age",35).as("peter").addE("knows").from_("marko").to("vadas").property(T.id,7).property("weight",0.5).addE("knows").from_("marko").to("josh").property(T.id,8).property("weight",1.0).addE("created").from_("marko").to("lop").property(T.id,9).property("weight",0.4).addE("created").from_("josh").to("ripple").property(T.id,10).property("weight",1.0).addE("created").from_("josh").to("lop").property(T.id,11).property("weight",0.4).addE("created").from_("peter").to("lop").property(T.id,12).property("weight",0.2) }, function({g}) { return g.E().properties("weight").drop() }, function({g}) { return g.E().properties() }], 
    g_V_properties_propertiesXstartTimeX_drop: [function({g}) { return g.addV().property("name","bob").property(Cardinality.list,"location","ny","startTime",2014,"endTime",2016).property(Cardinality.list,"location","va","startTime",2016).addV().property("name","alice").property(Cardinality.list,"location","va","startTime",2014,"endTime",2016).property(Cardinality.list,"location","ny","startTime",2016) }, function({g}) { return g.V().properties().properties("startTime").drop() }, function({g}) { return g.V().properties().properties() }, function({g}) { return g.V().properties().properties("startTime") }], 
    g_V_filterXfalseX: [function({g, pred1}) { return g.V().filter(pred1) }], 
    g_V_filterXtrueX: [function({g, pred1}) { return g.V().filter(pred1) }], 
    g_V_filterXlang_eq_javaX: [function({g, pred1}) { return g.V().filter(pred1) }], 
    g_VX1X_filterXage_gt_30X: [function({g, vid1, pred1}) { return g.V(vid1).filter(pred1) }], 
    g_VX2X_filterXage_gt_30X: [function({g, vid2, pred1}) { return g.V(vid2).filter(pred1) }], 
    g_VX1X_out_filterXage_gt_30X: [function({g, vid1, pred1}) { return g.V(vid1).out().filter(pred1) }], 
    g_V_filterXname_startsWith_m_OR_name_startsWith_pX: [function({g, pred1}) { return g.V().filter(pred1) }], 
    g_E_filterXfalseX: [function({g, pred1}) { return g.E().filter(pred1) }], 
    g_E_filterXtrueX: [function({g, pred1}) { return g.E().filter(pred1) }], 
    g_V_outXcreatedX_hasXname__mapXlengthX_isXgtX3XXX_name: [function({g, l1}) { return g.V().out("created").has("name",__.map(l1).is(P.gt(3))).values("name") }], 
    g_VX1X_hasXnameX: [function({g, vid1}) { return g.V(vid1).has("name") }], 
    g_VX1X_hasXcircumferenceX: [function({g, vid1}) { return g.V(vid1).has("circumference") }], 
    g_VX1X_hasXname_markoX: [function({g, vid1}) { return g.V(vid1).has("name","marko") }], 
    g_VX2X_hasXname_markoX: [function({g, vid1}) { return g.V(vid1).has("name","marko") }], 
    g_V_hasXname_markoX: [function({g}) { return g.V().has("name","marko") }], 
    g_V_hasXname_blahX: [function({g}) { return g.V().has("name","blah") }], 
    g_V_hasXage_gt_30X: [function({g}) { return g.V().has("age",P.gt(30)) }], 
    g_V_hasXage_isXgt_30XX: [function({g}) { return g.V().has("age",__.is(P.gt(30))) }], 
    g_V_hasXlabel_isXsoftwareXX: [function({g}) { return g.V().has(T.label,__.is("software")) }], 
    g_VX1X_hasXage_gt_30X: [function({g, vid1}) { return g.V(vid1).has("age",P.gt(30)) }], 
    g_VX4X_hasXage_gt_30X: [function({g, vid4}) { return g.V(vid4).has("age",P.gt(30)) }], 
    g_VXv1X_hasXage_gt_30X: [function({g, v1}) { return g.V(v1).has("age",P.gt(30)) }], 
    g_VXv4X_hasXage_gt_30X: [function({g, v4}) { return g.V(v4).has("age",P.gt(30)) }], 
    g_VX1X_out_hasXid_lt_3X: [function({g, xx1, vid1}) { return g.V(vid1).out().has(T.id,xx1) }], 
    g_VX1AsStringX_out_hasXid_2AsStringX: [function({g, vid2, vid1}) { return g.V(vid1).out().hasId(vid2) }], 
    g_VX1X_out_hasXid_2X: [function({g, v2}) { return g.V(v2).has("age",P.gt(30)) }], 
    g_VX1X_out_hasIdX2X: [function({g, vid2, vid1}) { return g.V(vid1).out().hasId(vid2) }], 
    g_VX1X_out_hasXid_2_3X: [function({g, vid3, vid2, vid1}) { return g.V(vid1).out().hasId(vid2,vid3) }], 
    g_VX1X_out_hasXid_2AsString_3AsStringX: [function({g, vid3, vid2, vid1}) { return g.V(vid1).out().hasId(vid2,vid3) }], 
    g_V_hasXblahX: [function({g}) { return g.V().has("blah") }], 
    g_EX7X_hasXlabelXknowsX: [function({g, eid7}) { return g.E(eid7).hasLabel("knows") }], 
    g_E_hasXlabelXknowsX: [function({g}) { return g.E().hasLabel("knows") }], 
    g_E_hasLabelXuses_traversesX: [function({g}) { return g.E().hasLabel("uses","traverses") }], 
    g_V_hasLabelXperson_software_blahX: [function({g}) { return g.V().hasLabel("person","software","blah") }], 
    g_V_hasXperson_name_markoX_age: [function({g}) { return g.V().has("person","name","marko").values("age") }], 
    g_VX1X_outE_hasXweight_inside_0_06X_inV: [function({g, vid1}) { return g.V(vid1).outE().has("weight",P.gt(0.0).and(P.lt(0.6))).inV() }], 
    g_EX11X_outV_outE_hasXid_10X: [function({g, eid11, eid10}) { return g.E(eid11).outV().outE().has(T.id,eid10) }], 
    g_EX11X_outV_outE_hasXid_10AsStringX: [function({g, eid11, eid10}) { return g.E(eid11).outV().outE().has(T.id,eid10) }], 
    g_V_hasXlocationX: [function({g}) { return g.V().has("location") }], 
    g_V_hasLabelXpersonX_hasXage_notXlteX10X_andXnotXbetweenX11_20XXXX_andXltX29X_orXeqX35XXXX_name: [function({g}) { return g.V().hasLabel("person").has("age",P.gt(10).or(P.gte(11).and(P.lt(20))).and(P.lt(29).or(P.eq(35)))).values("name") }], 
    g_V_in_hasIdXneqX1XX: [function({g, xx1}) { return g.V().in_().hasId(xx1) }], 
    g_V_hasXage_withinX27X_count: [function({g}) { return g.V().has("age",P.within([27])).count() }], 
    g_V_hasXage_withinX27_29X_count: [function({g}) { return g.V().has("age",P.within([27, 29])).count() }], 
    g_V_hasXage_withoutX27X_count: [function({g}) { return g.V().has("age",P.without([27])).count() }], 
    g_V_hasXage_withoutX27_29X_count: [function({g}) { return g.V().has("age",P.without([27, 29])).count() }], 
    g_V_both_dedup_properties_hasKeyXageX_value: [function({g}) { return g.V().both().properties().dedup().hasKey("age").value() }], 
    g_V_both_dedup_properties_hasKeyXageX_hasValueXgtX30XX_value: [function({g}) { return g.V().both().properties().dedup().hasKey("age").hasValue(P.gt(30)).value() }], 
    g_V_bothE_properties_dedup_hasKeyXweightX_value: [function({g}) { return g.V().bothE().properties().dedup().hasKey("weight").value() }], 
    g_V_bothE_properties_dedup_hasKeyXweightX_hasValueXltX0d3XX_value: [function({g}) { return g.V().bothE().properties().dedup().hasKey("weight").hasValue(P.lt(0.3)).value() }], 
    g_V_hasNotXageX_name: [function({g}) { return g.V().hasNot("age").values("name") }], 
    g_V_hasIdX1X_hasIdX2X: [function({g, vid2, vid1}) { return g.V().hasId(vid1).hasId(vid2) }], 
    g_V_hasLabelXpersonX_hasLabelXsoftwareX: [function({g}) { return g.V().hasLabel("person").hasLabel("software") }], 
    g_V_hasIdXemptyX_count: [function({g, xx1}) { return g.V().hasId(xx1).count() }], 
    g_V_hasIdXwithinXemptyXX_count: [function({g, xx1}) { return g.V().hasId(xx1).count() }], 
    g_V_hasIdXwithoutXemptyXX_count: [function({g, xx1}) { return g.V().hasId(xx1).count() }], 
    g_V_notXhasIdXwithinXemptyXXX_count: [function({g, xx1}) { return g.V().not(__.hasId(xx1)).count() }], 
    g_V_hasXname_containingXarkXX: [function({g}) { return g.V().has("name",TextP.containing("ark")) }], 
    g_V_hasXname_startingWithXmarXX: [function({g}) { return g.V().has("name",TextP.startingWith("mar")) }], 
    g_V_hasXname_endingWithXasXX: [function({g}) { return g.V().has("name",TextP.endingWith("as")) }], 
    g_V_hasXperson_name_containingXoX_andXltXmXXX: [function({g}) { return g.V().has("person","name",TextP.containing("o").and(P.lt("m"))) }], 
    g_V_hasXname_gtXmX_andXcontainingXoXXX: [function({g}) { return g.V().has("name",P.gt("m").and(TextP.containing("o"))) }], 
    g_V_hasXname_not_containingXarkXX: [function({g}) { return g.V().has("name",TextP.notContaining("ark")) }], 
    g_V_hasXname_not_startingWithXmarXX: [function({g}) { return g.V().has("name",TextP.notStartingWith("mar")) }], 
    g_V_hasXname_not_endingWithXasXX: [function({g}) { return g.V().has("name",TextP.notEndingWith("as")) }], 
    g_V_hasXp_neqXvXX: [function({g}) { return g.V().has("p",P.neq("v")) }], 
    g_V_hasXage_gtX18X_andXltX30XXorXgtx35XXX: [function({g}) { return g.V().has("age",P.gt(18).and(P.lt(30)).or(P.gt(35))) }], 
    g_V_hasXage_gtX18X_andXltX30XXorXltx35XXX: [function({g}) { return g.V().has("age",P.gt(18).and(P.lt(30)).and(P.lt(35))) }], 
    g_V_hasXk_withinXcXX_valuesXkX: [function({g}) { return g.addV().property("k","\u8F49\u6CE8").addV().property("k","\u2726").addV().property("k","\u2660").addV().property("k","A") }, function({g}) { return g.V().has("k",P.within(["\u8F49\u6CE8", "\u2726", "\u2660"])).values("k") }], 
    g_V_valuesXageX_isX32X: [function({g}) { return g.V().values("age").is(32) }], 
    g_V_valuesXageX_isXlte_30X: [function({g}) { return g.V().values("age").is(P.lte(30)) }], 
    g_V_valuesXageX_isXgte_29X_isXlt_34X: [function({g}) { return g.V().values("age").is(P.gte(29)).is(P.lt(34)) }], 
    g_V_whereXinXcreatedX_count_isX1XX_valuesXnameX: [function({g}) { return g.V().where(__.in_("created").count().is(1)).values("name") }], 
    g_V_whereXinXcreatedX_count_isXgte_2XX_valuesXnameX: [function({g}) { return g.V().where(__.in_("created").count().is(P.gte(2))).values("name") }], 
    g_V_orXhasXage_gt_27X__outE_count_gte_2X_name: [function({g}) { return g.V().or(__.has("age",P.gt(27)),__.outE().count().is(P.gte(2))).values("name") }], 
    g_V_orXoutEXknowsX__hasXlabel_softwareX_or_hasXage_gte_35XX_name: [function({g}) { return g.V().or(__.outE("knows"),__.has(T.label,"software").or().has("age",P.gte(35))).values("name") }], 
    g_V_asXaX_orXselectXaX_selectXaXX: [function({g}) { return g.V().as("a").or(__.select("a"),__.select("a")) }], 
    g_VX1X_out_limitX2X: [function({g, vid1}) { return g.V(vid1).out().limit(2) }], 
    g_V_localXoutE_limitX1X_inVX_limitX3X: [function({g}) { return g.V().local(__.outE().limit(1)).inV().limit(3) }], 
    g_VX1X_outXknowsX_outEXcreatedX_rangeX0_1X_inV: [function({g, vid1}) { return g.V(vid1).out("knows").outE("created").range(0,1).inV() }], 
    g_VX1X_outXknowsX_outXcreatedX_rangeX0_1X: [function({g, vid1}) { return g.V(vid1).out("knows").out("created").range(0,1) }], 
    g_VX1X_outXcreatedX_inXcreatedX_rangeX1_3X: [function({g, vid1}) { return g.V(vid1).out("created").in_("created").range(1,3) }], 
    g_VX1X_outXcreatedX_inEXcreatedX_rangeX1_3X_outV: [function({g, vid1}) { return g.V(vid1).out("created").inE("created").range(1,3).outV() }], 
    g_V_repeatXbothX_timesX3X_rangeX5_11X: [function({g}) { return g.V().repeat(__.both()).times(3).range(5,11) }], 
    g_V_asXaX_in_asXbX_in_asXcX_selectXa_b_cX_byXnameX_limitXlocal_2X: [function({g}) { return g.V().as("a").in_().as("b").in_().as("c").select("a","b","c").by("name").limit(Scope.local,2) }], 
    g_V_asXaX_in_asXbX_in_asXcX_selectXa_b_cX_byXnameX_limitXlocal_1X: [function({g}) { return g.V().as("a").in_().as("b").in_().as("c").select("a","b","c").by("name").limit(Scope.local,1) }], 
    g_V_asXaX_out_asXbX_out_asXcX_selectXa_b_cX_byXnameX_rangeXlocal_1_3X: [function({g}) { return g.V().as("a").out().as("b").out().as("c").select("a","b","c").by("name").range(Scope.local,1,3) }], 
    g_V_asXaX_out_asXbX_out_asXcX_selectXa_b_cX_byXnameX_rangeXlocal_1_2X: [function({g}) { return g.V().as("a").out().as("b").out().as("c").select("a","b","c").by("name").range(Scope.local,1,2) }], 
    g_V_asXaX_out_asXaX_out_asXaX_selectXmixed_aX_byXunfold_valuesXnameX_foldX_rangeXlocal_1_3X: [function({g}) { return g.V().as("a").out().as("a").out().as("a").select(Pop.mixed,"a").by(__.unfold().values("name").fold()).range(Scope.local,1,3) }], 
    g_V_asXaX_out_asXaX_out_asXaX_selectXmixed_aX_byXunfold_valuesXnameX_foldX_rangeXlocal_1_2X: [function({g}) { return g.V().as("a").out().as("a").out().as("a").select(Pop.mixed,"a").by(__.unfold().values("name").fold()).range(Scope.local,1,2) }], 
    g_V_hasLabelXpersonX_order_byXageX_skipX1X_valuesXnameX: [function({g}) { return g.V().hasLabel("person").order().by("age").skip(1).values("name") }], 
    g_V_asXaX_out_asXaX_out_asXaX_selectXmixed_aX_byXunfold_valuesXnameX_foldX_rangeXlocal_4_5X: [function({g}) { return g.V().as("a").out().as("a").out().as("a").select(Pop.mixed,"a").by(__.unfold().values("name").fold()).range(Scope.local,4,5) }], 
    g_V_outE_valuesXweightX_fold_orderXlocalX_skipXlocal_2X: [function({g}) { return g.V().outE().values("weight").fold().order(Scope.local).skip(Scope.local,2) }], 
    g_V_asXaX_in_asXaX_in_asXaX_selectXmixed_aX_byXunfold_valuesXnameX_foldX_limitXlocal_1X: [function({g}) { return g.V().as("a").in_().as("a").in_().as("a").select(Pop.mixed,"a").by(__.unfold().values("name").fold()).limit(Scope.local,1) }], 
    g_V_asXaX_in_asXaX_in_asXaX_selectXmixed_aX_byXunfold_valuesXnameX_foldX_limitXlocal_2X: [function({g}) { return g.V().as("a").in_().as("a").in_().as("a").select(Pop.mixed,"a").by(__.unfold().values("name").fold()).limit(Scope.local,2) }], 
    g_V_hasLabelXpersonX_order_byXageX_valuesXnameX_skipX1X: [function({g}) { return g.V().hasLabel("person").order().by("age").values("name").skip(1) }], 
    g_E_sampleX1X: [function({g}) { return g.E().sample(1) }], 
    g_E_sampleX2X_byXweightX: [function({g}) { return g.E().sample(2).by("weight") }], 
    g_V_localXoutE_sampleX1X_byXweightXX: [function({g}) { return g.V().local(__.outE().sample(1).by("weight")) }], 
    g_V_group_byXlabelX_byXbothE_weight_sampleX2X_foldX: [function({g}) { return g.V().group().by(T.label).by(__.bothE().values("weight").sample(2).fold()) }], 
    g_V_group_byXlabelX_byXbothE_weight_fold_sampleXlocal_5XX: [function({g}) { return g.V().group().by(T.label).by(__.bothE().values("weight").fold().sample(Scope.local,5)) }], 
    g_VX1X_outXcreatedX_inXcreatedX_simplePath: [function({g, vid1}) { return g.V(vid1).out("created").in_("created").simplePath() }], 
    g_V_repeatXboth_simplePathX_timesX3X_path: [function({g}) { return g.V().repeat(__.both().simplePath()).times(3).path() }], 
    g_V_asXaX_out_asXbX_out_asXcX_simplePath_byXlabelX_fromXbX_toXcX_path_byXnameX: [function({g}) { return g.V().as("a").out().as("b").out().as("c").simplePath().by(T.label).from_("b").to("c").path().by("name") }], 
    g_V_valuesXnameX_order_tailXglobal_2X: [function({g}) { return g.V().values("name").order().tail(Scope.global,2) }], 
    g_V_valuesXnameX_order_tailX2X: [function({g}) { return g.V().values("name").order().tail(2) }], 
    g_V_valuesXnameX_order_tail: [function({g}) { return g.V().values("name").order().tail() }], 
    g_V_valuesXnameX_order_tailX7X: [function({g}) { return g.V().values("name").order().tail(7) }], 
    g_V_repeatXbothX_timesX3X_tailX7X: [function({g}) { return g.V().repeat(__.both()).times(3).tail(7) }], 
    g_V_repeatXin_outX_timesX3X_tailX7X_count: [function({g}) { return g.V().repeat(__.in_().out()).times(3).tail(7).count() }], 
    g_V_asXaX_out_asXaX_out_asXaX_selectXaX_byXunfold_valuesXnameX_foldX_tailXlocal_1X: [function({g}) { return g.V().as("a").out().as("a").out().as("a").select("a").by(__.unfold().values("name").fold()).tail(Scope.local,1) }], 
    g_V_asXaX_out_asXaX_out_asXaX_selectXaX_byXunfold_valuesXnameX_foldX_tailXlocalX: [function({g}) { return g.V().as("a").out().as("a").out().as("a").select("a").by(__.unfold().values("name").fold()).tail(Scope.local) }], 
    g_V_asXaX_out_asXbX_out_asXcX_selectXa_b_cX_byXnameX_tailXlocal_2X: [function({g}) { return g.V().as("a").out().as("b").out().as("c").select("a","b","c").by("name").tail(Scope.local,2) }], 
    g_V_asXaX_out_asXbX_out_asXcX_selectXa_b_cX_byXnameX_tailXlocal_1X: [function({g}) { return g.V().as("a").out().as("b").out().as("c").select("a","b","c").by("name").tail(Scope.local,1) }], 
    g_V_asXaX_out_asXaX_out_asXaX_selectXmixed_aX_byXunfold_valuesXnameX_foldX_tailXlocal_1X: [function({g}) { return g.V().as("a").out().as("a").out().as("a").select(Pop.mixed,"a").by(__.unfold().values("name").fold()).tail(Scope.local,1) }], 
    g_V_asXaX_out_asXaX_out_asXaX_selectXmixed_aX_byXunfold_valuesXnameX_foldX_tailXlocalX: [function({g}) { return g.V().as("a").out().as("a").out().as("a").select(Pop.mixed,"a").by(__.unfold().values("name").fold()).tail(Scope.local) }], 
    g_V_asXaX_out_asXaX_out_asXaX_selectXmixed_aX_byXlimitXlocal_0XX_tailXlocal_1X: [function({g}) { return g.V().as("a").out().as("a").out().as("a").select(Pop.mixed,"a").by(__.limit(Scope.local,0)).tail(Scope.local,1) }], 
    g_V_asXaX_out_asXaX_out_asXaX_selectXmixed_aX_byXunfold_valuesXnameX_foldX_tailXlocal_2X: [function({g}) { return g.V().as("a").out().as("a").out().as("a").select(Pop.mixed,"a").by(__.unfold().values("name").fold()).tail(Scope.local,2) }], 
    g_V_hasXageX_asXaX_out_in_hasXageX_asXbX_selectXa_bX_whereXa_eqXbXX: [function({g}) { return g.V().has("age").as("a").out().in_().has("age").as("b").select("a","b").where("a",P.eq("b")) }], 
    g_V_hasXageX_asXaX_out_in_hasXageX_asXbX_selectXa_bX_whereXa_neqXbXX: [function({g}) { return g.V().has("age").as("a").out().in_().has("age").as("b").select("a","b").where("a",P.neq("b")) }], 
    g_V_hasXageX_asXaX_out_in_hasXageX_asXbX_selectXa_bX_whereXb_hasXname_markoXX: [function({g}) { return g.V().has("age").as("a").out().in_().has("age").as("b").select("a","b").where(__.as("b").has("name","marko")) }], 
    g_V_hasXageX_asXaX_out_in_hasXageX_asXbX_selectXa_bX_whereXa_outXknowsX_bX: [function({g}) { return g.V().has("age").as("a").out().in_().has("age").as("b").select("a","b").where(__.as("a").out("knows").as("b")) }], 
    g_V_asXaX_outXcreatedX_whereXasXaX_name_isXjoshXX_inXcreatedX_name: [function({g}) { return g.V().as("a").out("created").where(__.as("a").values("name").is("josh")).in_("created").values("name") }], 
    g_withSideEffectXa_josh_peterX_VX1X_outXcreatedX_inXcreatedX_name_whereXwithinXaXX: [function({g, xx1, vid1}) { return g.withSideEffect("a",xx1).V(vid1).out("created").in_("created").values("name").where(P.within(["a"])) }], 
    g_VX1X_asXaX_outXcreatedX_inXcreatedX_asXbX_whereXa_neqXbXX_name: [function({g, vid1}) { return g.V(vid1).as("a").out("created").in_("created").as("b").where("a",P.neq("b")).values("name") }], 
    g_VX1X_asXaX_outXcreatedX_inXcreatedX_asXbX_whereXasXbX_outXcreatedX_hasXname_rippleXX_valuesXage_nameX: [function({g, vid1}) { return g.V(vid1).as("a").out("created").in_("created").as("b").where(__.as("b").out("created").has("name","ripple")).values("age","name") }], 
    g_VX1X_asXaX_outXcreatedX_inXcreatedX_whereXeqXaXX_name: [function({g, vid1}) { return g.V(vid1).as("a").out("created").in_("created").where(P.eq("a")).values("name") }], 
    g_VX1X_asXaX_outXcreatedX_inXcreatedX_whereXneqXaXX_name: [function({g, vid1}) { return g.V(vid1).as("a").out("created").in_("created").where(P.neq("a")).values("name") }], 
    g_VX1X_out_aggregateXxX_out_whereXnotXwithinXaXXX: [function({g, vid1}) { return g.V(vid1).out().aggregate("x").out().where(P.without(["x"])) }], 
    g_withSideEffectXa_g_VX2XX_VX1X_out_whereXneqXaXX: [function({g, vid1, v2}) { return g.withSideEffect("a",v2).V(vid1).out().where(P.neq("a")) }], 
    g_VX1X_repeatXbothEXcreatedX_whereXwithoutXeXX_aggregateXeX_otherVX_emit_path: [function({g, vid1}) { return g.V(vid1).repeat(__.bothE("created").where(P.without(["e"])).aggregate("e").otherV()).emit().path() }], 
    g_V_whereXnotXoutXcreatedXXX_name: [function({g}) { return g.V().where(__.not(__.out("created"))).values("name") }], 
    g_V_asXaX_out_asXbX_whereXandXasXaX_outXknowsX_asXbX__orXasXbX_outXcreatedX_hasXname_rippleX__asXbX_inXknowsX_count_isXnotXeqX0XXXXX_selectXa_bX: [function({g}) { return g.V().as("a").out().as("b").where(__.and(__.as("a").out("knows").as("b"),__.or(__.as("b").out("created").has("name","ripple"),__.as("b").in_("knows").count().is(P.neq(0))))).select("a","b") }], 
    g_V_whereXoutXcreatedX_and_outXknowsX_or_inXknowsXX_valuesXnameX: [function({g}) { return g.V().where(__.out("created").and().out("knows").or().in_("knows")).values("name") }], 
    g_V_asXaX_outXcreatedX_asXbX_whereXandXasXbX_in__notXasXaX_outXcreatedX_hasXname_rippleXXX_selectXa_bX: [function({g}) { return g.V().as("a").out("created").as("b").where(__.and(__.as("b").in_(),__.not(__.as("a").out("created").has("name","ripple")))).select("a","b") }], 
    g_V_asXaX_outXcreatedX_asXbX_inXcreatedX_asXcX_bothXknowsX_bothXknowsX_asXdX_whereXc__notXeqXaX_orXeqXdXXXX_selectXa_b_c_dX: [function({g}) { return g.V().as("a").out("created").as("b").in_("created").as("c").both("knows").both("knows").as("d").where("c",P.neq("a").and(P.neq("d"))).select("a","b","c","d") }], 
    g_V_asXaX_out_asXbX_whereXin_count_isXeqX3XX_or_whereXoutXcreatedX_and_hasXlabel_personXXX_selectXa_bX: [function({g}) { return g.V().as("a").out().as("b").where(__.as("b").in_().count().is(P.eq(3)).or().where(__.as("b").out("created").and().as("b").has(T.label,"person"))).select("a","b") }], 
    g_V_asXaX_outXcreatedX_inXcreatedX_asXbX_whereXa_gtXbXX_byXageX_selectXa_bX_byXnameX: [function({g}) { return g.V().as("a").out("created").in_("created").as("b").where("a",P.gt("b")).by("age").select("a","b").by("name") }], 
    g_V_asXaX_outEXcreatedX_asXbX_inV_asXcX_whereXa_gtXbX_orXeqXbXXX_byXageX_byXweightX_byXweightX_selectXa_cX_byXnameX: [function({g}) { return g.V().as("a").outE("created").as("b").inV().as("c").where("a",P.gt("b").or(P.eq("b"))).by("age").by("weight").by("weight").select("a","c").by("name") }], 
    g_V_asXaX_outEXcreatedX_asXbX_inV_asXcX_inXcreatedX_asXdX_whereXa_ltXbX_orXgtXcXX_andXneqXdXXX_byXageX_byXweightX_byXinXcreatedX_valuesXageX_minX_selectXa_c_dX: [function({g}) { return g.V().as("a").outE("created").as("b").inV().as("c").in_("created").as("d").where("a",P.lt("b").or(P.gt("c")).and(P.neq("d"))).by("age").by("weight").by(__.in_("created").values("age").min()).select("a","c","d").by("name") }], 
    g_VX1X_asXaX_out_hasXageX_whereXgtXaXX_byXageX_name: [function({g, vid1}) { return g.V(vid1).as("a").out().has("age").where(P.gt("a")).by("age").values("name") }], 
    g_VX1X_asXaX_outXcreatedX_addEXcreatedByX_toXaX: [function({g, vid1}) { return g.addV("person").property(T.id,1).property("name","marko").property("age",29).as("marko").addV("person").property(T.id,2).property("name","vadas").property("age",27).as("vadas").addV("software").property(T.id,3).property("name","lop").property("lang","java").as("lop").addV("person").property(T.id,4).property("name","josh").property("age",32).as("josh").addV("software").property(T.id,5).property("name","ripple").property("lang","java").as("ripple").addV("person").property(T.id,6).property("name","peter").property("age",35).as("peter").addE("knows").from_("marko").to("vadas").property(T.id,7).property("weight",0.5).addE("knows").from_("marko").to("josh").property(T.id,8).property("weight",1.0).addE("created").from_("marko").to("lop").property(T.id,9).property("weight",0.4).addE("created").from_("josh").to("ripple").property(T.id,10).property("weight",1.0).addE("created").from_("josh").to("lop").property(T.id,11).property("weight",0.4).addE("created").from_("peter").to("lop").property(T.id,12).property("weight",0.2) }, function({g, vid1}) { return g.V(vid1).as("a").out("created").addE("createdBy").to("a") }, function({g, vid1}) { return g.E() }, function({g, vid1}) { return g.V(vid1).inE() }], 
    g_VX1X_asXaX_outXcreatedX_addEXcreatedByX_toXaX_propertyXweight_2X: [function({g, vid1}) { return g.addV("person").property(T.id,1).property("name","marko").property("age",29).as("marko").addV("person").property(T.id,2).property("name","vadas").property("age",27).as("vadas").addV("software").property(T.id,3).property("name","lop").property("lang","java").as("lop").addV("person").property(T.id,4).property("name","josh").property("age",32).as("josh").addV("software").property(T.id,5).property("name","ripple").property("lang","java").as("ripple").addV("person").property(T.id,6).property("name","peter").property("age",35).as("peter").addE("knows").from_("marko").to("vadas").property(T.id,7).property("weight",0.5).addE("knows").from_("marko").to("josh").property(T.id,8).property("weight",1.0).addE("created").from_("marko").to("lop").property(T.id,9).property("weight",0.4).addE("created").from_("josh").to("ripple").property(T.id,10).property("weight",1.0).addE("created").from_("josh").to("lop").property(T.id,11).property("weight",0.4).addE("created").from_("peter").to("lop").property(T.id,12).property("weight",0.2) }, function({g, vid1}) { return g.V(vid1).as("a").out("created").addE("createdBy").to("a").property("weight",2.0) }, function({g, vid1}) { return g.E() }, function({g, vid1}) { return g.V(vid1).bothE() }, function({g, vid1}) { return g.V(vid1).inE().has("weight",2.0) }], 
    g_V_outE_propertyXweight_nullX: [function({g}) { return g.addV("person").property(T.id,1).property("name","marko").property("age",29).as("marko").addV("person").property(T.id,2).property("name","vadas").property("age",27).as("vadas").addV("software").property(T.id,3).property("name","lop").property("lang","java").as("lop").addV("person").property(T.id,4).property("name","josh").property("age",32).as("josh").addV("software").property(T.id,5).property("name","ripple").property("lang","java").as("ripple").addV("person").property(T.id,6).property("name","peter").property("age",35).as("peter").addE("knows").from_("marko").to("vadas").property(T.id,7).property("weight",0.5).addE("knows").from_("marko").to("josh").property(T.id,8).property("weight",1.0).addE("created").from_("marko").to("lop").property(T.id,9).property("weight",0.4).addE("created").from_("josh").to("ripple").property(T.id,10).property("weight",1.0).addE("created").from_("josh").to("lop").property(T.id,11).property("weight",0.4).addE("created").from_("peter").to("lop").property(T.id,12).property("weight",0.2) }, function({g}) { return g.V().outE().property("weight",null) }, function({g}) { return g.E().properties("weight") }], 
    g_V_aggregateXxX_asXaX_selectXxX_unfold_addEXexistsWithX_toXaX_propertyXtime_nowX: [function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.addV("person").property(T.id,1).property("name","marko").property("age",29).as("marko").addV("person").property(T.id,2).property("name","vadas").property("age",27).as("vadas").addV("software").property(T.id,3).property("name","lop").property("lang","java").as("lop").addV("person").property(T.id,4).property("name","josh").property("age",32).as("josh").addV("software").property(T.id,5).property("name","ripple").property("lang","java").as("ripple").addV("person").property(T.id,6).property("name","peter").property("age",35).as("peter").addE("knows").from_("marko").to("vadas").property(T.id,7).property("weight",0.5).addE("knows").from_("marko").to("josh").property(T.id,8).property("weight",1.0).addE("created").from_("marko").to("lop").property(T.id,9).property("weight",0.4).addE("created").from_("josh").to("ripple").property(T.id,10).property("weight",1.0).addE("created").from_("josh").to("lop").property(T.id,11).property("weight",0.4).addE("created").from_("peter").to("lop").property(T.id,12).property("weight",0.2) }, function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V().aggregate("x").as("a").select("x").unfold().addE("existsWith").to("a").property("time","now") }, function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.E() }, function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid1).bothE() }, function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid1).inE("existsWith") }, function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid1).outE("existsWith") }, function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid1).bothE("existsWith").has("time","now") }, function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid2).bothE() }, function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid2).inE("existsWith") }, function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid2).outE("existsWith") }, function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid2).bothE("existsWith").has("time","now") }, function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid3).bothE() }, function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid3).inE("existsWith") }, function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid3).outE("existsWith") }, function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid3).bothE("existsWith").has("time","now") }, function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid4).bothE() }, function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid4).inE("existsWith") }, function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid4).outE("existsWith") }, function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid4).bothE("existsWith").has("time","now") }, function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid5).bothE() }, function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid5).inE("existsWith") }, function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid5).outE("existsWith") }, function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid5).bothE("existsWith").has("time","now") }, function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid6).bothE() }, function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid6).inE("existsWith") }, function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid6).outE("existsWith") }, function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid6).bothE("existsWith").has("time","now") }], 
    g_V_asXaX_outXcreatedX_inXcreatedX_whereXneqXaXX_asXbX_addEXcodeveloperX_fromXaX_toXbX_propertyXyear_2009X: [function({g, vid1, vid2, vid4, vid6}) { return g.addV("person").property(T.id,1).property("name","marko").property("age",29).as("marko").addV("person").property(T.id,2).property("name","vadas").property("age",27).as("vadas").addV("software").property(T.id,3).property("name","lop").property("lang","java").as("lop").addV("person").property(T.id,4).property("name","josh").property("age",32).as("josh").addV("software").property(T.id,5).property("name","ripple").property("lang","java").as("ripple").addV("person").property(T.id,6).property("name","peter").property("age",35).as("peter").addE("knows").from_("marko").to("vadas").property(T.id,7).property("weight",0.5).addE("knows").from_("marko").to("josh").property(T.id,8).property("weight",1.0).addE("created").from_("marko").to("lop").property(T.id,9).property("weight",0.4).addE("created").from_("josh").to("ripple").property(T.id,10).property("weight",1.0).addE("created").from_("josh").to("lop").property(T.id,11).property("weight",0.4).addE("created").from_("peter").to("lop").property(T.id,12).property("weight",0.2) }, function({g, vid1, vid2, vid4, vid6}) { return g.V().as("a").out("created").in_("created").where(P.neq("a")).as("b").addE("codeveloper").from_("a").to("b").property("year",2009) }, function({g, vid1, vid2, vid4, vid6}) { return g.E() }, function({g, vid1, vid2, vid4, vid6}) { return g.V(vid1).bothE() }, function({g, vid1, vid2, vid4, vid6}) { return g.V(vid1).inE("codeveloper") }, function({g, vid1, vid2, vid4, vid6}) { return g.V(vid1).outE("codeveloper") }, function({g, vid1, vid2, vid4, vid6}) { return g.V(vid1).bothE("codeveloper").has("year",2009) }, function({g, vid1, vid2, vid4, vid6}) { return g.V(vid2).bothE() }, function({g, vid1, vid2, vid4, vid6}) { return g.V(vid4).bothE() }, function({g, vid1, vid2, vid4, vid6}) { return g.V(vid4).inE("codeveloper") }, function({g, vid1, vid2, vid4, vid6}) { return g.V(vid4).outE("codeveloper") }, function({g, vid1, vid2, vid4, vid6}) { return g.V(vid4).bothE("codeveloper").has("year",2009) }, function({g, vid1, vid2, vid4, vid6}) { return g.V(vid6).bothE() }, function({g, vid1, vid2, vid4, vid6}) { return g.V(vid6).inE("codeveloper") }, function({g, vid1, vid2, vid4, vid6}) { return g.V(vid6).outE("codeveloper") }, function({g, vid1, vid2, vid4, vid6}) { return g.V(vid6).bothE("codeveloper").has("year",2009) }], 
    g_V_asXaX_inXcreatedX_addEXcreatedByX_fromXaX_propertyXyear_2009X_propertyXacl_publicX: [function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.addV("person").property(T.id,1).property("name","marko").property("age",29).as("marko").addV("person").property(T.id,2).property("name","vadas").property("age",27).as("vadas").addV("software").property(T.id,3).property("name","lop").property("lang","java").as("lop").addV("person").property(T.id,4).property("name","josh").property("age",32).as("josh").addV("software").property(T.id,5).property("name","ripple").property("lang","java").as("ripple").addV("person").property(T.id,6).property("name","peter").property("age",35).as("peter").addE("knows").from_("marko").to("vadas").property(T.id,7).property("weight",0.5).addE("knows").from_("marko").to("josh").property(T.id,8).property("weight",1.0).addE("created").from_("marko").to("lop").property(T.id,9).property("weight",0.4).addE("created").from_("josh").to("ripple").property(T.id,10).property("weight",1.0).addE("created").from_("josh").to("lop").property(T.id,11).property("weight",0.4).addE("created").from_("peter").to("lop").property(T.id,12).property("weight",0.2) }, function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V().as("a").in_("created").addE("createdBy").from_("a").property("year",2009).property("acl","public") }, function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.E() }, function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid1).bothE() }, function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid1).inE("createdBy") }, function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid1).outE("createdBy") }, function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid1).bothE("createdBy").has("year",2009).has("acl","public") }, function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid2).bothE() }, function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid3).bothE() }, function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid3).inE("createdBy") }, function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid3).outE("createdBy") }, function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid3).bothE("createdBy").has("year",2009).has("acl","public") }, function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid4).bothE() }, function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid4).inE("createdBy") }, function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid4).outE("createdBy") }, function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid4).bothE("createdBy").has("year",2009).has("acl","public") }, function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid5).bothE() }, function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid5).inE("createdBy") }, function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid5).outE("createdBy") }, function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid5).bothE("createdBy").has("year",2009).has("acl","public") }, function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid6).bothE() }, function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid6).inE("createdBy") }, function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid6).outE("createdBy") }, function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid6).bothE("createdBy").has("year",2009).has("acl","public") }], 
    g_withSideEffectXb_bX_VXaX_addEXknowsX_toXbX_propertyXweight_0_5X: [function({g, v6, v1}) { return g.addV("person").property(T.id,1).property("name","marko").property("age",29).as("marko").addV("person").property(T.id,2).property("name","vadas").property("age",27).as("vadas").addV("software").property(T.id,3).property("name","lop").property("lang","java").as("lop").addV("person").property(T.id,4).property("name","josh").property("age",32).as("josh").addV("software").property(T.id,5).property("name","ripple").property("lang","java").as("ripple").addV("person").property(T.id,6).property("name","peter").property("age",35).as("peter").addE("knows").from_("marko").to("vadas").property(T.id,7).property("weight",0.5).addE("knows").from_("marko").to("josh").property(T.id,8).property("weight",1.0).addE("created").from_("marko").to("lop").property(T.id,9).property("weight",0.4).addE("created").from_("josh").to("ripple").property(T.id,10).property("weight",1.0).addE("created").from_("josh").to("lop").property(T.id,11).property("weight",0.4).addE("created").from_("peter").to("lop").property(T.id,12).property("weight",0.2) }, function({g, v6, v1}) { return g.withSideEffect("b",v6).V(v1).addE("knows").to("b").property("weight",0.5) }, function({g, v6, v1}) { return g.E() }, function({g, v6, v1}) { return g.V(v1).bothE() }, function({g, v6, v1}) { return g.V(v1).inE("knows") }, function({g, v6, v1}) { return g.V(v1).outE("knows") }, function({g, v6, v1}) { return g.V(v1).bothE("knows").has("weight",0.5) }, function({g, v6, v1}) { return g.V(v6).bothE() }, function({g, v6, v1}) { return g.V(v6).inE("knows") }, function({g, v6, v1}) { return g.V(v6).outE("knows") }, function({g, v6, v1}) { return g.V(v6).bothE("knows").has("weight",0.5) }], 
    g_addV_asXfirstX_repeatXaddEXnextX_toXaddVX_inVX_timesX5X_addEXnextX_toXselectXfirstXX: [function({g}) { return g.addV().as("first").repeat(__.addE("next").to(__.addV()).inV()).times(5).addE("next").to(__.select("first")) }, function({g}) { return g.V() }, function({g}) { return g.E() }, function({g}) { return g.E().hasLabel("next") }, function({g}) { return g.V().limit(1).bothE() }, function({g}) { return g.V().limit(1).inE() }, function({g}) { return g.V().limit(1).outE() }], 
    g_V_hasXname_markoX_asXaX_outEXcreatedX_asXbX_inV_addEXselectXbX_labelX_toXaX: [function({g, v1}) { return g.addV("person").property(T.id,1).property("name","marko").property("age",29).as("marko").addV("person").property(T.id,2).property("name","vadas").property("age",27).as("vadas").addV("software").property(T.id,3).property("name","lop").property("lang","java").as("lop").addV("person").property(T.id,4).property("name","josh").property("age",32).as("josh").addV("software").property(T.id,5).property("name","ripple").property("lang","java").as("ripple").addV("person").property(T.id,6).property("name","peter").property("age",35).as("peter").addE("knows").from_("marko").to("vadas").property(T.id,7).property("weight",0.5).addE("knows").from_("marko").to("josh").property(T.id,8).property("weight",1.0).addE("created").from_("marko").to("lop").property(T.id,9).property("weight",0.4).addE("created").from_("josh").to("ripple").property(T.id,10).property("weight",1.0).addE("created").from_("josh").to("lop").property(T.id,11).property("weight",0.4).addE("created").from_("peter").to("lop").property(T.id,12).property("weight",0.2) }, function({g, v1}) { return g.V().has("name","marko").as("a").outE("created").as("b").inV().addE(__.select("b").label()).to("a") }, function({g, v1}) { return g.E() }, function({g, v1}) { return g.V(v1).bothE() }, function({g, v1}) { return g.V(v1).inE("created") }, function({g, v1}) { return g.V(v1).in_("created").has("name","lop") }, function({g, v1}) { return g.V(v1).outE("created") }], 
    g_addEXV_outE_label_groupCount_orderXlocalX_byXvalues_descX_selectXkeysX_unfold_limitX1XX_fromXV_hasXname_vadasXX_toXV_hasXname_lopXX: [function({g, v2}) { return g.addV("person").property(T.id,1).property("name","marko").property("age",29).as("marko").addV("person").property(T.id,2).property("name","vadas").property("age",27).as("vadas").addV("software").property(T.id,3).property("name","lop").property("lang","java").as("lop").addV("person").property(T.id,4).property("name","josh").property("age",32).as("josh").addV("software").property(T.id,5).property("name","ripple").property("lang","java").as("ripple").addV("person").property(T.id,6).property("name","peter").property("age",35).as("peter").addE("knows").from_("marko").to("vadas").property(T.id,7).property("weight",0.5).addE("knows").from_("marko").to("josh").property(T.id,8).property("weight",1.0).addE("created").from_("marko").to("lop").property(T.id,9).property("weight",0.4).addE("created").from_("josh").to("ripple").property(T.id,10).property("weight",1.0).addE("created").from_("josh").to("lop").property(T.id,11).property("weight",0.4).addE("created").from_("peter").to("lop").property(T.id,12).property("weight",0.2) }, function({g, v2}) { return g.addE(__.V().outE().label().groupCount().order(Scope.local).by(Column.values,Order.desc).select(Column.keys).unfold().limit(1)).from_(__.V().has("name","vadas")).to(__.V().has("name","lop")) }, function({g, v2}) { return g.E() }, function({g, v2}) { return g.V(v2).bothE() }, function({g, v2}) { return g.V(v2).inE("knows") }, function({g, v2}) { return g.V(v2).outE("created") }, function({g, v2}) { return g.V(v2).out("created").has("name","lop") }], 
    g_addEXknowsX_fromXaX_toXbX_propertyXweight_0_1X: [function({g, v6, xx1, v1}) { return g.addV("person").property(T.id,1).property("name","marko").property("age",29).as("marko").addV("person").property(T.id,2).property("name","vadas").property("age",27).as("vadas").addV("software").property(T.id,3).property("name","lop").property("lang","java").as("lop").addV("person").property(T.id,4).property("name","josh").property("age",32).as("josh").addV("software").property(T.id,5).property("name","ripple").property("lang","java").as("ripple").addV("person").property(T.id,6).property("name","peter").property("age",35).as("peter").addE("knows").from_("marko").to("vadas").property(T.id,7).property("weight",0.5).addE("knows").from_("marko").to("josh").property(T.id,8).property("weight",1.0).addE("created").from_("marko").to("lop").property(T.id,9).property("weight",0.4).addE("created").from_("josh").to("ripple").property(T.id,10).property("weight",1.0).addE("created").from_("josh").to("lop").property(T.id,11).property("weight",0.4).addE("created").from_("peter").to("lop").property(T.id,12).property("weight",0.2) }, function({g, v6, xx1, v1}) { return g.addE("knows").from_(v1).to(v6).property("weight",xx1) }, function({g, v6, xx1, v1}) { return g.E() }, function({g, v6, xx1, v1}) { return g.V(v1).outE("knows") }, function({g, v6, xx1, v1}) { return g.V(v1).out("knows").has("name","peter") }], 
    g_VXaX_addEXknowsX_toXbX_propertyXweight_0_1X: [function({g, v6, xx1, v1}) { return g.addV("person").property(T.id,1).property("name","marko").property("age",29).as("marko").addV("person").property(T.id,2).property("name","vadas").property("age",27).as("vadas").addV("software").property(T.id,3).property("name","lop").property("lang","java").as("lop").addV("person").property(T.id,4).property("name","josh").property("age",32).as("josh").addV("software").property(T.id,5).property("name","ripple").property("lang","java").as("ripple").addV("person").property(T.id,6).property("name","peter").property("age",35).as("peter").addE("knows").from_("marko").to("vadas").property(T.id,7).property("weight",0.5).addE("knows").from_("marko").to("josh").property(T.id,8).property("weight",1.0).addE("created").from_("marko").to("lop").property(T.id,9).property("weight",0.4).addE("created").from_("josh").to("ripple").property(T.id,10).property("weight",1.0).addE("created").from_("josh").to("lop").property(T.id,11).property("weight",0.4).addE("created").from_("peter").to("lop").property(T.id,12).property("weight",0.2) }, function({g, v6, xx1, v1}) { return g.V(v1).addE("knows").to(v6).property("weight",xx1) }, function({g, v6, xx1, v1}) { return g.E() }, function({g, v6, xx1, v1}) { return g.V(v1).outE("knows") }, function({g, v6, xx1, v1}) { return g.V(v1).out("knows").has("name","peter") }], 
    g_VX1X_addVXanimalX_propertyXage_selectXaX_byXageXX_propertyXname_puppyX: [function({g, vid1}) { return g.addV("person").property(T.id,1).property("name","marko").property("age",29).as("marko").addV("person").property(T.id,2).property("name","vadas").property("age",27).as("vadas").addV("software").property(T.id,3).property("name","lop").property("lang","java").as("lop").addV("person").property(T.id,4).property("name","josh").property("age",32).as("josh").addV("software").property(T.id,5).property("name","ripple").property("lang","java").as("ripple").addV("person").property(T.id,6).property("name","peter").property("age",35).as("peter").addE("knows").from_("marko").to("vadas").property(T.id,7).property("weight",0.5).addE("knows").from_("marko").to("josh").property(T.id,8).property("weight",1.0).addE("created").from_("marko").to("lop").property(T.id,9).property("weight",0.4).addE("created").from_("josh").to("ripple").property(T.id,10).property("weight",1.0).addE("created").from_("josh").to("lop").property(T.id,11).property("weight",0.4).addE("created").from_("peter").to("lop").property(T.id,12).property("weight",0.2) }, function({g, vid1}) { return g.V(vid1).as("a").addV("animal").property("age",__.select("a").by("age")).property("name","puppy") }, function({g, vid1}) { return g.V().has("animal","age",29) }], 
    g_V_addVXanimalX_propertyXage_0X: [function({g}) { return g.addV("person").property(T.id,1).property("name","marko").property("age",29).as("marko").addV("person").property(T.id,2).property("name","vadas").property("age",27).as("vadas").addV("software").property(T.id,3).property("name","lop").property("lang","java").as("lop").addV("person").property(T.id,4).property("name","josh").property("age",32).as("josh").addV("software").property(T.id,5).property("name","ripple").property("lang","java").as("ripple").addV("person").property(T.id,6).property("name","peter").property("age",35).as("peter").addE("knows").from_("marko").to("vadas").property(T.id,7).property("weight",0.5).addE("knows").from_("marko").to("josh").property(T.id,8).property("weight",1.0).addE("created").from_("marko").to("lop").property(T.id,9).property("weight",0.4).addE("created").from_("josh").to("ripple").property(T.id,10).property("weight",1.0).addE("created").from_("josh").to("lop").property(T.id,11).property("weight",0.4).addE("created").from_("peter").to("lop").property(T.id,12).property("weight",0.2) }, function({g}) { return g.V().addV("animal").property("age",0) }, function({g}) { return g.V().has("animal","age",0) }], 
    g_addVXpersonX_propertyXname_stephenX: [function({g}) { return g.addV("person").property(T.id,1).property("name","marko").property("age",29).as("marko").addV("person").property(T.id,2).property("name","vadas").property("age",27).as("vadas").addV("software").property(T.id,3).property("name","lop").property("lang","java").as("lop").addV("person").property(T.id,4).property("name","josh").property("age",32).as("josh").addV("software").property(T.id,5).property("name","ripple").property("lang","java").as("ripple").addV("person").property(T.id,6).property("name","peter").property("age",35).as("peter").addE("knows").from_("marko").to("vadas").property(T.id,7).property("weight",0.5).addE("knows").from_("marko").to("josh").property(T.id,8).property("weight",1.0).addE("created").from_("marko").to("lop").property(T.id,9).property("weight",0.4).addE("created").from_("josh").to("ripple").property(T.id,10).property("weight",1.0).addE("created").from_("josh").to("lop").property(T.id,11).property("weight",0.4).addE("created").from_("peter").to("lop").property(T.id,12).property("weight",0.2) }, function({g}) { return g.addV("person").property("name","stephen") }, function({g}) { return g.V().has("person","name","stephen") }], 
    g_V_hasLabelXpersonX_propertyXname_nullX: [function({g}) { return g.addV("person").property(T.id,1).property("name","marko").property("age",29).as("marko").addV("person").property(T.id,2).property("name","vadas").property("age",27).as("vadas").addV("software").property(T.id,3).property("name","lop").property("lang","java").as("lop").addV("person").property(T.id,4).property("name","josh").property("age",32).as("josh").addV("software").property(T.id,5).property("name","ripple").property("lang","java").as("ripple").addV("person").property(T.id,6).property("name","peter").property("age",35).as("peter").addE("knows").from_("marko").to("vadas").property(T.id,7).property("weight",0.5).addE("knows").from_("marko").to("josh").property(T.id,8).property("weight",1.0).addE("created").from_("marko").to("lop").property(T.id,9).property("weight",0.4).addE("created").from_("josh").to("ripple").property(T.id,10).property("weight",1.0).addE("created").from_("josh").to("lop").property(T.id,11).property("weight",0.4).addE("created").from_("peter").to("lop").property(T.id,12).property("weight",0.2) }, function({g}) { return g.V().hasLabel("person").property("name",null) }, function({g}) { return g.V().properties("name") }], 
    g_addVXpersonX_propertyXsingle_name_stephenX_propertyXsingle_name_stephenmX: [function({g}) { return g.addV("person").property(T.id,1).property("name","marko").property("age",29).as("marko").addV("person").property(T.id,2).property("name","vadas").property("age",27).as("vadas").addV("software").property(T.id,3).property("name","lop").property("lang","java").as("lop").addV("person").property(T.id,4).property("name","josh").property("age",32).as("josh").addV("software").property(T.id,5).property("name","ripple").property("lang","java").as("ripple").addV("person").property(T.id,6).property("name","peter").property("age",35).as("peter").addE("knows").from_("marko").to("vadas").property(T.id,7).property("weight",0.5).addE("knows").from_("marko").to("josh").property(T.id,8).property("weight",1.0).addE("created").from_("marko").to("lop").property(T.id,9).property("weight",0.4).addE("created").from_("josh").to("ripple").property(T.id,10).property("weight",1.0).addE("created").from_("josh").to("lop").property(T.id,11).property("weight",0.4).addE("created").from_("peter").to("lop").property(T.id,12).property("weight",0.2) }, function({g}) { return g.addV("person").property(Cardinality.single,"name","stephen").property(Cardinality.single,"name","stephenm") }, function({g}) { return g.V().has("person","name","stephen") }, function({g}) { return g.V().has("person","name","stephenm") }], 
    get_g_addVXpersonX_propertyXsingle_name_stephenX_propertyXsingle_name_stephenm_since_2010X: [function({g}) { return g.addV("person").property(T.id,1).property("name","marko").property("age",29).as("marko").addV("person").property(T.id,2).property("name","vadas").property("age",27).as("vadas").addV("software").property(T.id,3).property("name","lop").property("lang","java").as("lop").addV("person").property(T.id,4).property("name","josh").property("age",32).as("josh").addV("software").property(T.id,5).property("name","ripple").property("lang","java").as("ripple").addV("person").property(T.id,6).property("name","peter").property("age",35).as("peter").addE("knows").from_("marko").to("vadas").property(T.id,7).property("weight",0.5).addE("knows").from_("marko").to("josh").property(T.id,8).property("weight",1.0).addE("created").from_("marko").to("lop").property(T.id,9).property("weight",0.4).addE("created").from_("josh").to("ripple").property(T.id,10).property("weight",1.0).addE("created").from_("josh").to("lop").property(T.id,11).property("weight",0.4).addE("created").from_("peter").to("lop").property(T.id,12).property("weight",0.2) }, function({g}) { return g.addV("person").property(Cardinality.single,"name","stephen").property(Cardinality.single,"name","stephenm","since",2010) }, function({g}) { return g.V().has("person","name","stephen") }, function({g}) { return g.V().has("person","name","stephenm") }, function({g}) { return g.V().has("person","name","stephenm").properties("name").has("since",2010) }], 
    g_V_hasXname_markoX_propertyXfriendWeight_outEXknowsX_weight_sum__acl_privateX: [function({g}) { return g.addV("person").property(T.id,1).property("name","marko").property("age",29).as("marko").addV("person").property(T.id,2).property("name","vadas").property("age",27).as("vadas").addV("software").property(T.id,3).property("name","lop").property("lang","java").as("lop").addV("person").property(T.id,4).property("name","josh").property("age",32).as("josh").addV("software").property(T.id,5).property("name","ripple").property("lang","java").as("ripple").addV("person").property(T.id,6).property("name","peter").property("age",35).as("peter").addE("knows").from_("marko").to("vadas").property(T.id,7).property("weight",0.5).addE("knows").from_("marko").to("josh").property(T.id,8).property("weight",1.0).addE("created").from_("marko").to("lop").property(T.id,9).property("weight",0.4).addE("created").from_("josh").to("ripple").property(T.id,10).property("weight",1.0).addE("created").from_("josh").to("lop").property(T.id,11).property("weight",0.4).addE("created").from_("peter").to("lop").property(T.id,12).property("weight",0.2) }, function({g}) { return g.V().has("name","marko").property("friendWeight",__.outE("knows").values("weight").sum(),"acl","private") }, function({g}) { return g.V().has("person","name","marko").has("friendWeight",1.5) }, function({g}) { return g.V().has("person","name","marko").properties("friendWeight").has("acl","private") }, function({g}) { return g.V().has("person","name","marko").properties("friendWeight").count() }], 
    g_addVXanimalX_propertyXname_mateoX_propertyXname_gateoX_propertyXname_cateoX_propertyXage_5X: [function({g}) { return g.addV("person").property(T.id,1).property("name","marko").property("age",29).as("marko").addV("person").property(T.id,2).property("name","vadas").property("age",27).as("vadas").addV("software").property(T.id,3).property("name","lop").property("lang","java").as("lop").addV("person").property(T.id,4).property("name","josh").property("age",32).as("josh").addV("software").property(T.id,5).property("name","ripple").property("lang","java").as("ripple").addV("person").property(T.id,6).property("name","peter").property("age",35).as("peter").addE("knows").from_("marko").to("vadas").property(T.id,7).property("weight",0.5).addE("knows").from_("marko").to("josh").property(T.id,8).property("weight",1.0).addE("created").from_("marko").to("lop").property(T.id,9).property("weight",0.4).addE("created").from_("josh").to("ripple").property(T.id,10).property("weight",1.0).addE("created").from_("josh").to("lop").property(T.id,11).property("weight",0.4).addE("created").from_("peter").to("lop").property(T.id,12).property("weight",0.2) }, function({g}) { return g.addV("animal").property("name","mateo").property("name","gateo").property("name","cateo").property("age",5) }, function({g}) { return g.V().hasLabel("animal").has("name","mateo").has("name","gateo").has("name","cateo").has("age",5) }], 
    g_withSideEffectXa_markoX_addV_propertyXname_selectXaXX_name: [function({g}) { return g.addV("person").property(T.id,1).property("name","marko").property("age",29).as("marko").addV("person").property(T.id,2).property("name","vadas").property("age",27).as("vadas").addV("software").property(T.id,3).property("name","lop").property("lang","java").as("lop").addV("person").property(T.id,4).property("name","josh").property("age",32).as("josh").addV("software").property(T.id,5).property("name","ripple").property("lang","java").as("ripple").addV("person").property(T.id,6).property("name","peter").property("age",35).as("peter").addE("knows").from_("marko").to("vadas").property(T.id,7).property("weight",0.5).addE("knows").from_("marko").to("josh").property(T.id,8).property("weight",1.0).addE("created").from_("marko").to("lop").property(T.id,9).property("weight",0.4).addE("created").from_("josh").to("ripple").property(T.id,10).property("weight",1.0).addE("created").from_("josh").to("lop").property(T.id,11).property("weight",0.4).addE("created").from_("peter").to("lop").property(T.id,12).property("weight",0.2) }, function({g}) { return g.withSideEffect("a","marko").addV().property("name",__.select("a")).values("name") }, function({g}) { return g.V().has("name","marko") }], 
    g_addVXpersonX_propertyXsingle_name_stephenX_propertyXsingle_name_stephenm_since_2010X: [function({g}) { return g.addV("person").property(T.id,1).property("name","marko").property("age",29).as("marko").addV("person").property(T.id,2).property("name","vadas").property("age",27).as("vadas").addV("software").property(T.id,3).property("name","lop").property("lang","java").as("lop").addV("person").property(T.id,4).property("name","josh").property("age",32).as("josh").addV("software").property(T.id,5).property("name","ripple").property("lang","java").as("ripple").addV("person").property(T.id,6).property("name","peter").property("age",35).as("peter").addE("knows").from_("marko").to("vadas").property(T.id,7).property("weight",0.5).addE("knows").from_("marko").to("josh").property(T.id,8).property("weight",1.0).addE("created").from_("marko").to("lop").property(T.id,9).property("weight",0.4).addE("created").from_("josh").to("ripple").property(T.id,10).property("weight",1.0).addE("created").from_("josh").to("lop").property(T.id,11).property("weight",0.4).addE("created").from_("peter").to("lop").property(T.id,12).property("weight",0.2) }, function({g}) { return g.addV("person").property(Cardinality.single,"name","stephen").property(Cardinality.single,"name","stephenm","since",2010) }, function({g}) { return g.V().has("name","stephen") }, function({g}) { return g.V().has("name","stephenm") }, function({g}) { return g.V().has("name","stephenm").properties("name").has("since",2010) }], 
    g_V_addVXanimalX_propertyXname_valuesXnameXX_propertyXname_an_animalX_propertyXvaluesXnameX_labelX: [function({g}) { return g.addV("person").property(T.id,1).property("name","marko").property("age",29).as("marko").addV("person").property(T.id,2).property("name","vadas").property("age",27).as("vadas").addV("software").property(T.id,3).property("name","lop").property("lang","java").as("lop").addV("person").property(T.id,4).property("name","josh").property("age",32).as("josh").addV("software").property(T.id,5).property("name","ripple").property("lang","java").as("ripple").addV("person").property(T.id,6).property("name","peter").property("age",35).as("peter").addE("knows").from_("marko").to("vadas").property(T.id,7).property("weight",0.5).addE("knows").from_("marko").to("josh").property(T.id,8).property("weight",1.0).addE("created").from_("marko").to("lop").property(T.id,9).property("weight",0.4).addE("created").from_("josh").to("ripple").property(T.id,10).property("weight",1.0).addE("created").from_("josh").to("lop").property(T.id,11).property("weight",0.4).addE("created").from_("peter").to("lop").property(T.id,12).property("weight",0.2) }, function({g}) { return g.V().addV("animal").property("name",__.values("name")).property("name","an animal").property(__.values("name"),__.label()) }, function({g}) { return g.V().hasLabel("animal").has("name","marko").has("name","an animal").has("marko","person") }, function({g}) { return g.V().hasLabel("animal").has("name","vadas").has("name","an animal").has("vadas","person") }, function({g}) { return g.V().hasLabel("animal").has("name","lop").has("name","an animal").has("lop","software") }, function({g}) { return g.V().hasLabel("animal").has("name","josh").has("name","an animal").has("josh","person") }, function({g}) { return g.V().hasLabel("animal").has("name","ripple").has("name","an animal").has("ripple","software") }, function({g}) { return g.V().hasLabel("animal").has("name","peter").has("name","an animal").has("peter","person") }], 
    g_withSideEffectXa_testX_V_hasLabelXsoftwareX_propertyXtemp_selectXaXX_valueMapXname_tempX: [function({g}) { return g.addV("person").property(T.id,1).property("name","marko").property("age",29).as("marko").addV("person").property(T.id,2).property("name","vadas").property("age",27).as("vadas").addV("software").property(T.id,3).property("name","lop").property("lang","java").as("lop").addV("person").property(T.id,4).property("name","josh").property("age",32).as("josh").addV("software").property(T.id,5).property("name","ripple").property("lang","java").as("ripple").addV("person").property(T.id,6).property("name","peter").property("age",35).as("peter").addE("knows").from_("marko").to("vadas").property(T.id,7).property("weight",0.5).addE("knows").from_("marko").to("josh").property(T.id,8).property("weight",1.0).addE("created").from_("marko").to("lop").property(T.id,9).property("weight",0.4).addE("created").from_("josh").to("ripple").property(T.id,10).property("weight",1.0).addE("created").from_("josh").to("lop").property(T.id,11).property("weight",0.4).addE("created").from_("peter").to("lop").property(T.id,12).property("weight",0.2) }, function({g}) { return g.withSideEffect("a","test").V().hasLabel("software").property("temp",__.select("a")).valueMap("name","temp") }], 
    g_withSideEffectXa_nameX_addV_propertyXselectXaX_markoX_name: [function({g}) { return g.addV("person").property(T.id,1).property("name","marko").property("age",29).as("marko").addV("person").property(T.id,2).property("name","vadas").property("age",27).as("vadas").addV("software").property(T.id,3).property("name","lop").property("lang","java").as("lop").addV("person").property(T.id,4).property("name","josh").property("age",32).as("josh").addV("software").property(T.id,5).property("name","ripple").property("lang","java").as("ripple").addV("person").property(T.id,6).property("name","peter").property("age",35).as("peter").addE("knows").from_("marko").to("vadas").property(T.id,7).property("weight",0.5).addE("knows").from_("marko").to("josh").property(T.id,8).property("weight",1.0).addE("created").from_("marko").to("lop").property(T.id,9).property("weight",0.4).addE("created").from_("josh").to("ripple").property(T.id,10).property("weight",1.0).addE("created").from_("josh").to("lop").property(T.id,11).property("weight",0.4).addE("created").from_("peter").to("lop").property(T.id,12).property("weight",0.2) }, function({g}) { return g.withSideEffect("a","name").addV().property(__.select("a"),"marko").values("name") }, function({g}) { return g.V().has("name","marko") }], 
    g_V_asXaX_hasXname_markoX_outXcreatedX_asXbX_addVXselectXaX_labelX_propertyXtest_selectXbX_labelX_valueMap_withXtokensX: [function({g}) { return g.addV("person").property(T.id,1).property("name","marko").property("age",29).as("marko").addV("person").property(T.id,2).property("name","vadas").property("age",27).as("vadas").addV("software").property(T.id,3).property("name","lop").property("lang","java").as("lop").addV("person").property(T.id,4).property("name","josh").property("age",32).as("josh").addV("software").property(T.id,5).property("name","ripple").property("lang","java").as("ripple").addV("person").property(T.id,6).property("name","peter").property("age",35).as("peter").addE("knows").from_("marko").to("vadas").property(T.id,7).property("weight",0.5).addE("knows").from_("marko").to("josh").property(T.id,8).property("weight",1.0).addE("created").from_("marko").to("lop").property(T.id,9).property("weight",0.4).addE("created").from_("josh").to("ripple").property(T.id,10).property("weight",1.0).addE("created").from_("josh").to("lop").property(T.id,11).property("weight",0.4).addE("created").from_("peter").to("lop").property(T.id,12).property("weight",0.2) }, function({g}) { return g.V().as("a").has("name","marko").out("created").as("b").addV(__.select("a").label()).property("test",__.select("b").label()).valueMap().with_("~tinkerpop.valueMap.tokens") }, function({g}) { return g.V().has("person","test","software") }], 
    g_addVXV_hasXname_markoX_propertiesXnameX_keyX_label: [function({g}) { return g.addV("person").property(T.id,1).property("name","marko").property("age",29).as("marko").addV("person").property(T.id,2).property("name","vadas").property("age",27).as("vadas").addV("software").property(T.id,3).property("name","lop").property("lang","java").as("lop").addV("person").property(T.id,4).property("name","josh").property("age",32).as("josh").addV("software").property(T.id,5).property("name","ripple").property("lang","java").as("ripple").addV("person").property(T.id,6).property("name","peter").property("age",35).as("peter").addE("knows").from_("marko").to("vadas").property(T.id,7).property("weight",0.5).addE("knows").from_("marko").to("josh").property(T.id,8).property("weight",1.0).addE("created").from_("marko").to("lop").property(T.id,9).property("weight",0.4).addE("created").from_("josh").to("ripple").property(T.id,10).property("weight",1.0).addE("created").from_("josh").to("lop").property(T.id,11).property("weight",0.4).addE("created").from_("peter").to("lop").property(T.id,12).property("weight",0.2) }, function({g}) { return g.addV(__.V().has("name","marko").properties("name").key()).label() }], 
    g_addVXnullX_propertyXid_nullX: [function({g}) { return g.addV(null).property(T.id,null) }, function({g}) { return g.V().hasLabel("vertex") }], 
    g_addV_propertyXlabel_personX: [function({g}) { return g.addV().property(T.label,"person") }, function({g}) { return g.V().hasLabel("person") }], 
    g_V_coalesceXoutXfooX_outXbarXX: [function({g}) { return g.V().coalesce(__.out("foo"),__.out("bar")) }], 
    g_VX1X_coalesceXoutXknowsX_outXcreatedXX_valuesXnameX: [function({g, vid1}) { return g.V(vid1).coalesce(__.out("knows"),__.out("created")).values("name") }], 
    g_VX1X_coalesceXoutXcreatedX_outXknowsXX_valuesXnameX: [function({g, vid1}) { return g.V(vid1).coalesce(__.out("created"),__.out("knows")).values("name") }], 
    g_V_coalesceXoutXlikesX_outXknowsX_inXcreatedXX_groupCount_byXnameX: [function({g}) { return g.V().coalesce(__.out("likes"),__.out("knows"),__.out("created")).groupCount().by("name") }], 
    g_V_coalesceXoutEXknowsX_outEXcreatedXX_otherV_path_byXnameX_byXlabelX: [function({g}) { return g.V().coalesce(__.outE("knows"),__.outE("created")).otherV().path().by("name").by(T.label) }], 
    g_V_outXcreatedX_order_byXnameX_coalesceXname_constantXxXX: [function({g}) { return g.V().out("created").order().by("name").coalesce(__.values("name"),__.constant("x")) }], 
    g_V_connectedComponent_hasXcomponentX: [function({g}) { return g.withStrategies(new VertexProgramStrategy(new Map([["graphComputer","org.apache.tinkerpop.gremlin.process.computer.GraphComputer"]]))).V().connectedComponent().has("gremlin.connectedComponentVertexProgram.component") }], 
    g_V_dedup_connectedComponent_hasXcomponentX: [function({g}) { return g.withStrategies(new VertexProgramStrategy(new Map([["graphComputer","org.apache.tinkerpop.gremlin.process.computer.GraphComputer"]]))).V().dedup().connectedComponent().has("gremlin.connectedComponentVertexProgram.component") }], 
    g_V_hasLabelXsoftwareX_connectedComponent_project_byXnameX_byXcomponentX: [function({g}) { return g.withStrategies(new VertexProgramStrategy(new Map([["graphComputer","org.apache.tinkerpop.gremlin.process.computer.GraphComputer"]]))).V().hasLabel("software").connectedComponent().project("name","component").by("name").by("gremlin.connectedComponentVertexProgram.component") }], 
    g_V_connectedComponent_withXEDGES_bothEXknowsXX_withXPROPERTY_NAME_clusterX_project_byXnameX_byXclusterX: [function({g}) { return g.withStrategies(new VertexProgramStrategy(new Map([["graphComputer","org.apache.tinkerpop.gremlin.process.computer.GraphComputer"]]))).V().hasLabel("person").connectedComponent().with_("~tinkerpop.connectedComponent.edges",__.bothE("knows")).with_("~tinkerpop.connectedComponent.propertyName","cluster").project("name","cluster").by("name").by("cluster") }], 
    g_V_constantX123X: [function({g}) { return g.V().constant(123) }], 
    g_V_constantXnullX: [function({g}) { return g.V().constant(null) }], 
    g_V_chooseXhasLabelXpersonX_valuesXnameX_constantXinhumanXX: [function({g}) { return g.V().choose(__.hasLabel("person"),__.values("name"),__.constant("inhuman")) }], 
    g_V_count: [function({g}) { return g.V().count() }], 
    g_V_out_count: [function({g}) { return g.V().out().count() }], 
    g_V_both_both_count: [function({g}) { return g.V().both().both().count() }], 
    g_V_fold_countXlocalX: [function({g}) { return g.V().fold().count(Scope.local) }], 
    g_V_hasXnoX_count: [function({g}) { return g.V().has("no").count() }], 
    g_V_whereXinXkknowsX_outXcreatedX_count_is_0XX_name: [function({g}) { return g.V().where(__.in_("knows").out("created").count().is(0)).values("name") }], 
    g_V_repeatXoutX_timesX8X_count: [function({g}) { return g.V().repeat(__.out()).times(8).count() }], 
    g_V_repeatXoutX_timesX5X_asXaX_outXwrittenByX_asXbX_selectXa_bX_count: [function({g}) { return g.V().repeat(__.out()).times(5).as("a").out("writtenBy").as("b").select("a","b").count() }], 
    g_V_repeatXoutX_timesX3X_count: [function({g}) { return g.V().repeat(__.out()).times(3).count() }], 
    g_V_elementMap: [function({g}) { return g.V().elementMap() }], 
    g_V_elementMapXname_ageX: [function({g}) { return g.V().elementMap("name","age") }], 
    g_EX11X_elementMap: [function({g, eid11}) { return g.E(eid11).elementMap() }], 
    g_V_asXaX_flatMapXselectXaXX: [function({g}) { return g.V().as("a").flatMap(__.select("a")) }], 
    g_V_fold: [function({g}) { return g.V().fold() }], 
    g_V_fold_unfold: [function({g}) { return g.V().fold().unfold() }], 
    g_V_age_foldX0_plusX: [function({g}) { return g.V().values("age").fold(0,Operator.sum) }], 
    g_VX1X_V_valuesXnameX: [function({g, vid1}) { return g.V(vid1).V().values("name") }], 
    g_V_outXknowsX_V_name: [function({g}) { return g.V().out("knows").V().values("name") }], 
    g_V_hasXname_GarciaX_inXsungByX_asXsongX_V_hasXname_Willie_DixonX_inXwrittenByX_whereXeqXsongXX_name: [function({g}) { return g.V().has("artist","name","Garcia").in_("sungBy").as("song").V().has("artist","name","Willie_Dixon").in_("writtenBy").where(P.eq("song")).values("name") }], 
    g_V_hasLabelXpersonX_asXpX_VXsoftwareX_addInEXuses_pX: [function({g, xx1, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.addV("person").property(T.id,1).property("name","marko").property("age",29).as("marko").addV("person").property(T.id,2).property("name","vadas").property("age",27).as("vadas").addV("software").property(T.id,3).property("name","lop").property("lang","java").as("lop").addV("person").property(T.id,4).property("name","josh").property("age",32).as("josh").addV("software").property(T.id,5).property("name","ripple").property("lang","java").as("ripple").addV("person").property(T.id,6).property("name","peter").property("age",35).as("peter").addE("knows").from_("marko").to("vadas").property(T.id,7).property("weight",0.5).addE("knows").from_("marko").to("josh").property(T.id,8).property("weight",1.0).addE("created").from_("marko").to("lop").property(T.id,9).property("weight",0.4).addE("created").from_("josh").to("ripple").property(T.id,10).property("weight",1.0).addE("created").from_("josh").to("lop").property(T.id,11).property("weight",0.4).addE("created").from_("peter").to("lop").property(T.id,12).property("weight",0.2) }, function({g, xx1, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V().hasLabel("person").as("p").V(xx1).addE("uses").from_("p") }, function({g, xx1, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.E().hasLabel("uses") }, function({g, xx1, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid1).outE("uses") }, function({g, xx1, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid2).outE("uses") }, function({g, xx1, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid3).inE("uses") }, function({g, xx1, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid4).outE("uses") }, function({g, xx1, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid5).inE("uses") }, function({g, xx1, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid6).outE("uses") }], 
    g_V_hasLabelXsoftwareX_index_unfold: [function({g}) { return g.V().hasLabel("software").index().unfold() }], 
    g_V_hasLabelXsoftwareX_order_byXnameX_index_withXmapX: [function({g}) { return g.V().hasLabel("software").order().by("name").index().with_("~tinkerpop.index.indexer",1) }], 
    g_V_hasLabelXsoftwareX_name_fold_orderXlocalX_index_unfold_order_byXtailXlocal_1XX: [function({g}) { return g.V().hasLabel("software").values("name").fold().order(Scope.local).index().unfold().order().by(__.tail(Scope.local,1)) }], 
    g_V_hasLabelXpersonX_name_fold_orderXlocalX_index_withXmapX: [function({g}) { return g.V().hasLabel("person").values("name").fold().order(Scope.local).index().with_("~tinkerpop.index.indexer",1) }], 
    g_VX1X_repeatXboth_simplePathX_untilXhasXname_peterX_or_loops_isX3XX_hasXname_peterX_path_byXnameX: [function({g, vid1}) { return g.V(vid1).repeat(__.both().simplePath()).until(__.has("name","peter").or().loops().is(3)).has("name","peter").path().by("name") }], 
    g_VX1X_repeatXboth_simplePathX_untilXhasXname_peterX_or_loops_isX2XX_hasXname_peterX_path_byXnameX: [function({g, vid1}) { return g.V(vid1).repeat(__.both().simplePath()).until(__.has("name","peter").or().loops().is(2)).has("name","peter").path().by("name") }], 
    g_VX1X_repeatXboth_simplePathX_untilXhasXname_peterX_and_loops_isX3XX_hasXname_peterX_path_byXnameX: [function({g, vid1}) { return g.V(vid1).repeat(__.both().simplePath()).until(__.has("name","peter").and().loops().is(3)).has("name","peter").path().by("name") }], 
    g_V_emitXhasXname_markoX_or_loops_isX2XX_repeatXoutX_valuesXnameX: [function({g}) { return g.V().emit(__.has("name","marko").or().loops().is(2)).repeat(__.out()).values("name") }], 
    g_VX1X_mapXnameX: [function({g, l1, vid1}) { return g.V(vid1).map(l1) }], 
    g_VX1X_outE_label_mapXlengthX: [function({g, l1, vid1}) { return g.V(vid1).outE().label().map(l1) }], 
    g_VX1X_out_mapXnameX_mapXlengthX: [function({g, l1, l2, vid1}) { return g.V(vid1).out().map(l1).map(l2) }], 
    g_VX1X_out_mapXlambdaXnameXX_mapXlambdaXlengthXX: [function({g, vid1}) { return g.V(vid1).out().map(() => "it.get().value(\'name\')").map(() => "it.get().toString().length()") }], 
    g_withPath_V_asXaX_out_mapXa_nameX: [function({g, l1}) { return g.withPath().V().as("a").out().map(l1) }], 
    g_withPath_V_asXaX_out_out_mapXa_name_it_nameX: [function({g, l1}) { return g.withPath().V().as("a").out().out().map(l1) }], 
    g_V_mapXselectXaXX: [function({g}) { return g.V().as("a").map(__.select("a")) }], 
    g_V_mapXconstantXnullXX: [function({g}) { return g.V().map(__.constant(null)) }], 
    g_V_valueMap_matchXa_selectXnameX_bX: [function({g}) { return g.V().valueMap().match(__.as("a").select("name").as("b")) }], 
    g_V_matchXa_out_bX: [function({g}) { return g.V().match(__.as("a").out().as("b")) }], 
    g_V_matchXa_out_bX_selectXb_idX: [function({g}) { return g.V().match(__.as("a").out().as("b")).select("b").by(T.id) }], 
    g_V_matchXa_knows_b__b_created_cX: [function({g}) { return g.V().match(__.as("a").out("knows").as("b"),__.as("b").out("created").as("c")) }], 
    g_V_matchXb_created_c__a_knows_bX: [function({g}) { return g.V().match(__.as("b").out("created").as("c"),__.as("a").out("knows").as("b")) }], 
    g_V_matchXa_created_b__b_0created_cX_whereXa_neq_cX_selectXa_cX: [function({g}) { return g.V().match(__.as("a").out("created").as("b"),__.as("b").in_("created").as("c")).where("a",P.neq("c")).select("a","c") }], 
    g_V_matchXd_0knows_a__d_hasXname_vadasX__a_knows_b__b_created_cX: [function({g}) { return g.V().match(__.as("d").in_("knows").as("a"),__.as("d").has("name","vadas"),__.as("a").out("knows").as("b"),__.as("b").out("created").as("c")) }], 
    g_V_matchXa_created_lop_b__b_0created_29_c__c_whereXrepeatXoutX_timesX2XXX: [function({g}) { return g.V().match(__.as("a").out("created").has("name","lop").as("b"),__.as("b").in_("created").has("age",29).as("c"),__.as("c").where(__.repeat(__.out()).times(2))) }], 
    g_V_asXaX_out_asXbX_matchXa_out_count_c__b_in_count_cX: [function({g}) { return g.V().as("a").out().as("b").match(__.as("a").out().count().as("c"),__.as("b").in_().count().as("c")) }], 
    g_V_matchXa__a_out_b__notXa_created_bXX: [function({g}) { return g.V().match(__.as("a").out().as("b"),__.not(__.as("a").out("created").as("b"))) }], 
    g_V_matchXa_created_lop_b__b_0created_29_cX_whereXc_repeatXoutX_timesX2XX_selectXa_b_cX: [function({g}) { return g.V().match(__.as("a").out("created").has("name","lop").as("b"),__.as("b").in_("created").has("age",29).as("c")).where(__.as("c").repeat(__.out()).times(2)).select("a","b","c") }], 
    g_V_out_out_matchXa_0created_b__b_0knows_cX_selectXcX_outXcreatedX_name: [function({g}) { return g.V().out().out().match(__.as("a").in_("created").as("b"),__.as("b").in_("knows").as("c")).select("c").out("created").values("name") }], 
    g_V_matchXa_knows_b__b_created_c__a_created_cX_dedupXa_b_cX_selectXaX_byXnameX: [function({g}) { return g.V().match(__.as("a").out("knows").as("b"),__.as("b").out("created").as("c"),__.as("a").out("created").as("c")).dedup("a","b","c").select("a").by("name") }], 
    g_V_matchXa_created_b__a_repeatXoutX_timesX2XX_selectXa_bX: [function({g}) { return g.V().match(__.as("a").out("created").as("b"),__.as("a").repeat(__.out()).times(2).as("b")).select("a","b") }], 
    g_V_notXmatchXa_age_b__a_name_cX_whereXb_eqXcXX_selectXaXX_name: [function({g}) { return g.V().not(__.match(__.as("a").values("age").as("b"),__.as("a").values("name").as("c")).where("b",P.eq("c")).select("a")).values("name") }], 
    g_V_matchXa_knows_b__andXa_created_c__b_created_c__andXb_created_count_d__a_knows_count_dXXX: [function({g}) { return g.V().match(__.as("a").out("knows").as("b"),__.and(__.as("a").out("created").as("c"),__.as("b").out("created").as("c"),__.and(__.as("b").out("created").count().as("d"),__.as("a").out("knows").count().as("d")))) }], 
    g_V_matchXa_whereXa_neqXcXX__a_created_b__orXa_knows_vadas__a_0knows_and_a_hasXlabel_personXX__b_0created_c__b_0created_count_isXgtX1XXX_selectXa_b_cX_byXidX: [function({g}) { return g.V().match(__.where("a",P.neq("c")),__.as("a").out("created").as("b"),__.or(__.as("a").out("knows").has("name","vadas"),__.as("a").in_("knows").and().as("a").has(T.label,"person")),__.as("b").in_("created").as("c"),__.as("b").in_("created").count().is(P.gt(1))).select("a","b","c").by(T.id) }], 
    g_V_matchXa__a_both_b__b_both_cX_dedupXa_bX: [function({g}) { return g.V().match(__.as("a").both().as("b"),__.as("b").both().as("c")).dedup("a","b") }], 
    g_V_matchXa_knows_b__b_created_lop__b_matchXb_created_d__d_0created_cX_selectXcX_cX_selectXa_b_cX: [function({g}) { return g.V().match(__.as("a").out("knows").as("b"),__.as("b").out("created").has("name","lop"),__.as("b").match(__.as("b").out("created").as("d"),__.as("d").in_("created").as("c")).select("c").as("c")).select("a","b","c") }], 
    g_V_matchXa_knows_b__a_created_cX: [function({g}) { return g.V().match(__.as("a").out("knows").as("b"),__.as("a").out("created").as("c")) }], 
    g_V_matchXwhereXandXa_created_b__b_0created_count_isXeqX3XXXX__a_both_b__whereXb_inXX: [function({g}) { return g.V().match(__.where(__.and(__.as("a").out("created").as("b"),__.as("b").in_("created").count().is(P.eq(3)))),__.as("a").both().as("b"),__.where(__.as("b").in_())) }], 
    g_V_matchXa_outEXcreatedX_order_byXweight_descX_limitX1X_inV_b__b_hasXlang_javaXX_selectXa_bX_byXnameX: [function({g}) { return g.V().match(__.as("a").outE("created").order().by("weight",Order.desc).limit(1).inV().as("b"),__.as("b").has("lang","java")).select("a","b").by("name") }], 
    g_V_matchXa_both_b__b_both_cX_dedupXa_bX_byXlabelX: [function({g}) { return g.V().match(__.as("a").both().as("b"),__.as("b").both().as("c")).dedup("a","b").by(T.label) }], 
    g_V_matchXa_created_b__b_0created_aX: [function({g}) { return g.V().match(__.as("a").out("created").as("b"),__.as("b").in_("created").as("a")) }], 
    g_V_asXaX_out_asXbX_matchXa_out_count_c__orXa_knows_b__b_in_count_c__and__c_isXgtX2XXXX: [function({g}) { return g.V().as("a").out().as("b").match(__.as("a").out().count().as("c"),__.or(__.as("a").out("knows").as("b"),__.as("b").in_().count().as("c").and().as("c").is(P.gt(2)))) }], 
    g_V_matchXa_knows_count_bX_selectXbX: [function({g}) { return g.V().match(__.as("a").out("knows").count().as("b")).select("b") }], 
    g_V_matchXa_0sungBy_b__a_0writtenBy_c__b_writtenBy_d__c_sungBy_d__d_hasXname_GarciaXX: [function({g}) { return g.V().match(__.as("a").in_("sungBy").as("b"),__.as("a").in_("writtenBy").as("c"),__.as("b").out("writtenBy").as("d"),__.as("c").out("sungBy").as("d"),__.as("d").has("name","Garcia")) }], 
    g_V_matchXa_hasXsong_name_sunshineX__a_mapX0followedBy_weight_meanX_b__a_0followedBy_c__c_filterXweight_whereXgteXbXXX_outV_dX_selectXdX_byXnameX: [function({g}) { return g.V().match(__.as("a").has("song","name","HERE COMES SUNSHINE"),__.as("a").map(__.inE("followedBy").values("weight").mean()).as("b"),__.as("a").inE("followedBy").as("c"),__.as("c").filter(__.values("weight").where(P.gte("b"))).outV().as("d")).select("d").by("name") }], 
    g_V_matchXa_0sungBy_b__a_0sungBy_c__b_writtenBy_d__c_writtenBy_e__d_hasXname_George_HarisonX__e_hasXname_Bob_MarleyXX: [function({g}) { return g.V().match(__.as("a").in_("sungBy").as("b"),__.as("a").in_("sungBy").as("c"),__.as("b").out("writtenBy").as("d"),__.as("c").out("writtenBy").as("e"),__.as("d").has("name","George_Harrison"),__.as("e").has("name","Bob_Marley")) }], 
    g_V_matchXa_hasXname_GarciaX__a_0writtenBy_b__a_0sungBy_bX: [function({g}) { return g.V().match(__.as("a").has("name","Garcia"),__.as("a").in_("writtenBy").as("b"),__.as("a").in_("sungBy").as("b")) }], 
    g_V_hasLabelXsongsX_matchXa_name_b__a_performances_cX_selectXb_cX_count: [function({g}) { return g.V().hasLabel("song").match(__.as("a").values("name").as("b"),__.as("a").values("performances").as("c")).select("b","c").count() }], 
    g_V_matchXa_followedBy_count_isXgtX10XX_b__a_0followedBy_count_isXgtX10XX_bX_count: [function({g}) { return g.V().match(__.as("a").out("followedBy").count().is(P.gt(10)).as("b"),__.as("a").in_("followedBy").count().is(P.gt(10)).as("b")).count() }], 
    g_V_matchXa_0sungBy_b__a_0writtenBy_c__b_writtenBy_dX_whereXc_sungBy_dX_whereXd_hasXname_GarciaXX: [function({g}) { return g.V().match(__.as("a").in_("sungBy").as("b"),__.as("a").in_("writtenBy").as("c"),__.as("b").out("writtenBy").as("d")).where(__.as("c").out("sungBy").as("d")).where(__.as("d").has("name","Garcia")) }], 
    g_V_matchXa_hasXname_GarciaX__a_0writtenBy_b__b_followedBy_c__c_writtenBy_d__whereXd_neqXaXXX: [function({g}) { return g.V().match(__.as("a").has("name","Garcia"),__.as("a").in_("writtenBy").as("b"),__.as("b").out("followedBy").as("c"),__.as("c").out("writtenBy").as("d"),__.where("d",P.neq("a"))) }], 
    g_V_matchXa_outXknowsX_name_bX_identity: [function({g}) { return g.V().match(__.as("a").out("knows").values("name").as("b")).identity() }], 
    g_V_outE_mathX0_minus_itX_byXweightX: [function({g}) { return g.V().outE().math("0-_").by("weight") }], 
    g_V_hasXageX_valueMap_mathXit_plus_itXbyXselectXageX_unfoldXX: [function({g}) { return g.V().has("age").valueMap().math("_+_").by(__.select("age").unfold()) }], 
    g_V_asXaX_outXknowsX_asXbX_mathXa_plus_bX_byXageX: [function({g}) { return g.V().as("a").out("knows").as("b").math("a + b").by("age") }], 
    g_withSideEffectXx_100X_V_age_mathX__plus_xX: [function({g, xx1}) { return g.withSideEffect("x",xx1).V().values("age").math("_ + x") }], 
    g_V_asXaX_outXcreatedX_asXbX_mathXb_plus_aX_byXinXcreatedX_countX_byXageX: [function({g}) { return g.V().as("a").out("created").as("b").math("b + a").by(__.in_("created").count()).by("age") }], 
    g_withSackX1X_injectX1X_repeatXsackXsumX_byXconstantX1XXX_timesX5X_emit_mathXsin__X_byXsackX: [function({g}) { return g.withSack(1).inject(1).repeat(__.sack(Operator.sum).by(__.constant(1))).times(5).emit().math("sin _").by(__.sack()) }], 
    g_V_projectXa_b_cX_byXbothE_weight_sumX_byXbothE_countX_byXnameX_order_byXmathXa_div_bX_descX_selectXcX: [function({g}) { return g.V().project("a","b","c").by(__.bothE().values("weight").sum()).by(__.bothE().count()).by("name").order().by(__.math("a / b"),Order.desc).select("c") }], 
    g_V_age_max: [function({g}) { return g.V().values("age").max() }], 
    g_V_foo_max: [function({g}) { return g.V().values("foo").max() }], 
    g_V_name_max: [function({g}) { return g.V().values("name").max() }], 
    g_V_age_fold_maxXlocalX: [function({g}) { return g.V().values("age").fold().max(Scope.local) }], 
    g_V_foo_fold_maxXlocalX: [function({g}) { return g.V().values("foo").fold().max(Scope.local) }], 
    g_V_name_fold_maxXlocalX: [function({g}) { return g.V().values("name").fold().max(Scope.local) }], 
    g_V_repeatXbothX_timesX5X_age_max: [function({g}) { return g.V().repeat(__.both()).times(5).values("age").max() }], 
    g_V_hasLabelXsoftwareX_group_byXnameX_byXbothE_weight_maxX: [function({g}) { return g.V().hasLabel("software").group().by("name").by(__.bothE().values("weight").max()) }], 
    g_V_age_mean: [function({g}) { return g.V().values("age").mean() }], 
    g_V_foo_mean: [function({g}) { return g.V().values("foo").mean() }], 
    g_V_age_fold_meanXlocalX: [function({g}) { return g.V().values("age").fold().mean(Scope.local) }], 
    g_V_foo_fold_meanXlocalX: [function({g}) { return g.V().values("foo").fold().mean(Scope.local) }], 
    g_V_hasLabelXsoftwareX_group_byXnameX_byXbothE_weight_meanX: [function({g}) { return g.V().hasLabel("software").group().by("name").by(__.bothE().values("weight").mean()) }], 
    g_V_age_min: [function({g}) { return g.V().values("age").min() }], 
    g_V_foo_min: [function({g}) { return g.V().values("foo").min() }], 
    g_V_name_min: [function({g}) { return g.V().values("name").min() }], 
    g_V_age_fold_minXlocalX: [function({g}) { return g.V().values("age").fold().min(Scope.local) }], 
    g_V_foo_fold_minXlocalX: [function({g}) { return g.V().values("foo").fold().min(Scope.local) }], 
    g_V_name_fold_minXlocalX: [function({g}) { return g.V().values("name").fold().min(Scope.local) }], 
    g_V_repeatXbothX_timesX5X_age_min: [function({g}) { return g.V().repeat(__.both()).times(5).values("age").min() }], 
    g_V_hasLabelXsoftwareX_group_byXnameX_byXbothE_weight_minX: [function({g}) { return g.V().hasLabel("software").group().by("name").by(__.bothE().values("weight").min()) }], 
    g_V_foo_injectX9999999999X_min: [function({g, xx1}) { return g.V().values("foo").inject(xx1).min() }], 
    g_V_name_order: [function({g}) { return g.V().values("name").order() }], 
    g_V_name_order_byXa1_b1X_byXb2_a2X: [function({g, c1, c2}) { return g.V().values("name").order().by(c1).by(c2) }], 
    g_V_order_byXname_ascX_name: [function({g}) { return g.V().order().by("name",Order.asc).values("name") }], 
    g_V_order_byXnameX_name: [function({g}) { return g.V().order().by("name").values("name") }], 
    g_V_outE_order_byXweight_descX_weight: [function({g}) { return g.V().outE().order().by("weight",Order.desc).values("weight") }], 
    g_V_order_byXname_a1_b1X_byXname_b2_a2X_name: [function({g, c1, c2}) { return g.V().order().by("name",c1).by("name",c2).values("name") }], 
    g_V_asXaX_outXcreatedX_asXbX_order_byXshuffleX_selectXa_bX: [function({g}) { return g.V().as("a").out("created").as("b").order().by(Order.shuffle).select("a","b") }], 
    g_V_both_hasLabelXpersonX_order_byXage_descX_limitX5X_name: [function({g}) { return g.V().both().hasLabel("person").order().by("age",Order.desc).limit(5).values("name") }], 
    g_V_properties_order_byXkey_descX_key: [function({g}) { return g.V().properties().order().by(T.key,Order.desc).key() }], 
    g_V_hasLabelXpersonX_order_byXvalueXageX_descX_name: [function({g, l1}) { return g.V().hasLabel("person").order().by(l1,Order.desc).values("name") }], 
    g_V_hasLabelXpersonX_group_byXnameX_byXoutE_weight_sumX_orderXlocalX_byXvaluesX: [function({g}) { return g.V().hasLabel("person").group().by("name").by(__.outE().values("weight").sum()).order(Scope.local).by(Column.values) }], 
    g_V_mapXbothE_weight_foldX_order_byXsumXlocalX_descX: [function({g}) { return g.V().map(__.bothE().values("weight").fold()).order().by(__.sum(Scope.local),Order.desc) }], 
    g_V_group_byXlabelX_byXname_order_byXdescX_foldX: [function({g}) { return g.V().group().by(T.label).by(__.values("name").order().by(Order.desc).fold()) }], 
    g_V_hasLabelXpersonX_group_byXnameX_byXoutE_weight_sumX_unfold_order_byXvalues_descX: [function({g}) { return g.V().hasLabel("person").group().by("name").by(__.outE().values("weight").sum()).unfold().order().by(Column.values,Order.desc) }], 
    g_V_asXvX_mapXbothE_weight_foldX_sumXlocalX_asXsX_selectXv_sX_order_byXselectXsX_descX: [function({g}) { return g.V().as("v").map(__.bothE().values("weight").fold()).sum(Scope.local).as("s").select("v","s").order().by(__.select("s"),Order.desc) }], 
    g_V_hasLabelXpersonX_fold_orderXlocalX_byXageX: [function({g}) { return g.V().hasLabel("person").fold().order(Scope.local).by("age") }], 
    g_V_both_hasLabelXpersonX_order_byXage_descX_name: [function({g}) { return g.V().both().hasLabel("person").order().by("age",Order.desc).values("name") }], 
    g_V_order_byXoutE_count_descX: [function({g}) { return g.V().order().by(__.outE().count(),Order.desc) }], 
    g_V_hasLabelXpersonX_order_byXageX: [function({g}) { return g.V().hasLabel("person").order().by("age") }], 
    g_VX1X_hasXlabel_personX_mapXmapXint_ageXX_orderXlocalX_byXvalues_descX_byXkeys_ascX: [function({g, l1, v1}) { return g.V(v1).hasLabel("person").map(l1).order(Scope.local).by(Column.values,Order.desc).by(Column.keys,Order.asc) }], 
    g_VX1X_elementMap_orderXlocalX_byXkeys_descXunfold: [function({g, vid1}) { return g.V(vid1).elementMap().order(Scope.local).by(Column.keys,Order.desc).unfold() }], 
    g_V_pageRank_hasXpageRankX: [function({g}) { return g.withStrategies(new VertexProgramStrategy(new Map([["graphComputer","org.apache.tinkerpop.gremlin.process.computer.GraphComputer"]]))).V().pageRank().has("gremlin.pageRankVertexProgram.pageRank") }, function({g}) { return g.withStrategies(new VertexProgramStrategy(new Map([["graphComputer","org.apache.tinkerpop.gremlin.process.computer.GraphComputer"]]))).V().pageRank().has("gremlin.pageRankVertexProgram.pageRank") }], 
    g_V_outXcreatedX_pageRank_withXedges_bothEX_withXpropertyName_projectRankX_withXtimes_0X_valueMapXname_projectRankX: [function({g}) { return g.withStrategies(new VertexProgramStrategy(new Map([["graphComputer","org.apache.tinkerpop.gremlin.process.computer.GraphComputer"]]))).V().out("created").pageRank().with_("~tinkerpop.pageRank.edges",__.bothE()).with_("~tinkerpop.pageRank.propertyName","projectRank").with_("~tinkerpop.pageRank.times",0).valueMap("name","projectRank") }], 
    g_V_pageRank_order_byXpageRank_descX_byXnameX_name: [function({g}) { return g.withStrategies(new VertexProgramStrategy(new Map([["graphComputer","org.apache.tinkerpop.gremlin.process.computer.GraphComputer"]]))).V().pageRank().order().by("gremlin.pageRankVertexProgram.pageRank",Order.desc).by("name").values("name") }], 
    g_V_pageRank_order_byXpageRank_descX_name_limitX2X: [function({g}) { return g.withStrategies(new VertexProgramStrategy(new Map([["graphComputer","org.apache.tinkerpop.gremlin.process.computer.GraphComputer"]]))).V().pageRank().order().by("gremlin.pageRankVertexProgram.pageRank",Order.desc).values("name").limit(2) }], 
    g_V_pageRank_withXedges_outEXknowsXX_withXpropertyName_friendRankX_project_byXnameX_byXvaluesXfriendRankX_mathX: [function({g}) { return g.withStrategies(new VertexProgramStrategy(new Map([["graphComputer","org.apache.tinkerpop.gremlin.process.computer.GraphComputer"]]))).V().pageRank().with_("~tinkerpop.pageRank.edges",__.outE("knows")).with_("~tinkerpop.pageRank.propertyName","friendRank").project("name","friendRank").by("name").by(__.values("friendRank").math("ceil(_ * 100)")) }], 
    g_V_hasLabelXpersonX_pageRank_withXpropertyName_kpageRankX_project_byXnameX_byXvaluesXpageRankX_mathX: [function({g}) { return g.withStrategies(new VertexProgramStrategy(new Map([["graphComputer","org.apache.tinkerpop.gremlin.process.computer.GraphComputer"]]))).V().hasLabel("person").pageRank().with_("~tinkerpop.pageRank.propertyName","pageRank").project("name","pageRank").by("name").by(__.values("pageRank").math("ceil(_ * 100)")) }], 
    g_V_pageRank_withXpropertyName_pageRankX_asXaX_outXknowsX_pageRank_asXbX_selectXa_bX_by_byXmathX: [function({g}) { return g.withStrategies(new VertexProgramStrategy(new Map([["graphComputer","org.apache.tinkerpop.gremlin.process.computer.GraphComputer"]]))).V().pageRank().with_("~tinkerpop.pageRank.propertyName","pageRank").as("a").out("knows").values("pageRank").as("b").select("a","b").by().by(__.math("ceil(_ * 100)")) }], 
    g_V_hasLabelXsoftwareX_hasXname_rippleX_pageRankX1X_withXedges_inEXcreatedX_withXtimes_1X_withXpropertyName_priorsX_inXcreatedX_unionXboth__identityX_valueMapXname_priorsX: [function({g}) { return g.withStrategies(new VertexProgramStrategy(new Map([["graphComputer","org.apache.tinkerpop.gremlin.process.computer.GraphComputer"]]))).V().hasLabel("software").has("name","ripple").pageRank(1.0).with_("~tinkerpop.pageRank.edges",__.inE("created")).with_("~tinkerpop.pageRank.times",1).with_("~tinkerpop.pageRank.propertyName","priors").in_("created").union(__.both(),__.identity()).valueMap("name","priors") }], 
    g_V_outXcreatedX_groupXmX_byXlabelX_pageRankX1X_withXpropertyName_pageRankX_withXedges_inEX_withXtimes_1X_inXcreatedX_groupXmX_byXpageRankX_capXmX: [function({g}) { return g.withStrategies(new VertexProgramStrategy(new Map([["graphComputer","org.apache.tinkerpop.gremlin.process.computer.GraphComputer"]]))).V().out("created").group("m").by(T.label).pageRank(1.0).with_("~tinkerpop.pageRank.propertyName","pageRank").with_("~tinkerpop.pageRank.edges",__.inE()).with_("~tinkerpop.pageRank.times",1).in_("created").group("m").by("pageRank").cap("m") }], 
    g_VX1X_name_path: [function({g, vid1}) { return g.V(vid1).values("name").path() }], 
    g_VX1X_out_path_byXageX_byXnameX: [function({g, vid1}) { return g.V(vid1).out().path().by("age").by("name") }], 
    g_V_repeatXoutX_timesX2X_path_byXitX_byXnameX_byXlangX: [function({g}) { return g.V().repeat(__.out()).times(2).path().by().by("name").by("lang") }], 
    g_V_out_out_path_byXnameX_byXageX: [function({g}) { return g.V().out().out().path().by("name").by("age") }], 
    g_V_asXaX_hasXname_markoX_asXbX_hasXage_29X_asXcX_path: [function({g}) { return g.V().as("a").has("name","marko").as("b").has("age",29).as("c").path() }], 
    g_VX1X_outEXcreatedX_inV_inE_outV_path: [function({g, vid1}) { return g.V(vid1).outE("created").inV().inE().outV().path() }], 
    g_V_asXaX_out_asXbX_out_asXcX_path_fromXbX_toXcX_byXnameX: [function({g}) { return g.V().as("a").out().as("b").out().as("c").path().from_("b").to("c").by("name") }], 
    g_V_peerPressure_hasXclusterX: [function({g}) { return g.withStrategies(new VertexProgramStrategy(new Map([["graphComputer","org.apache.tinkerpop.gremlin.process.computer.GraphComputer"]]))).V().peerPressure().has("gremlin.peerPressureVertexProgram.cluster") }, function({g}) { return g.withStrategies(new VertexProgramStrategy(new Map([["graphComputer","org.apache.tinkerpop.gremlin.process.computer.GraphComputer"]]))).V().peerPressure().has("gremlin.peerPressureVertexProgram.cluster") }], 
    g_V_peerPressure_withXpropertyName_clusterX_withXedges_outEXknowsXX_pageRankX1X_byXrankX_withXedges_outEXknowsX_withXtimes_2X_group_byXclusterX_byXrank_sumX_limitX100X: [function({g}) { return g.withStrategies(new VertexProgramStrategy(new Map([["graphComputer","org.apache.tinkerpop.gremlin.process.computer.GraphComputer"]]))).V().peerPressure().with_("~tinkerpop.peerPressure.propertyName","cluster").with_("~tinkerpop.peerPressure.edges",__.outE("knows")).pageRank(1.0).with_("~tinkerpop.pageRank.propertyName","rank").with_("~tinkerpop.pageRank.edges",__.outE("knows")).with_("~tinkerpop.pageRank.times",1).group().by("cluster").by(__.values("rank").sum()).limit(100) }], 
    g_V_hasXname_rippleX_inXcreatedX_peerPressure_withXedges_outEX_withyXpropertyName_clusterX_repeatXunionXidentity__bothX_timesX2X_dedup_valueMapXname_clusterX: [function({g}) { return g.withStrategies(new VertexProgramStrategy(new Map([["graphComputer","org.apache.tinkerpop.gremlin.process.computer.GraphComputer"]]))).V().has("name","ripple").in_("created").peerPressure().with_("~tinkerpop.peerPressure.edges",__.outE()).with_("~tinkerpop.peerPressure.propertyName","cluster").repeat(__.union(__.identity(),__.both())).times(2).dedup().valueMap("name","cluster") }], 
    g_V_hasLabelXpersonX_projectXa_bX_byXoutE_countX_byXageX: [function({g}) { return g.V().hasLabel("person").project("a","b").by(__.outE().count()).by("age") }], 
    g_V_outXcreatedX_projectXa_bX_byXnameX_byXinXcreatedX_countX_order_byXselectXbX__descX_selectXaX: [function({g}) { return g.V().out("created").project("a","b").by("name").by(__.in_("created").count()).order().by(__.select("b"),Order.desc).select("a") }], 
    g_V_valueMap_projectXxX_byXselectXnameXX: [function({g}) { return g.V().valueMap().project("x").by(__.select("name")) }], 
    g_V_hasXageX_propertiesXnameX: [function({g}) { return g.V().has("age").properties("name").value() }], 
    g_V_hasXageX_propertiesXname_ageX_value: [function({g}) { return g.V().has("age").properties("name","age").value() }], 
    g_V_hasXageX_propertiesXage_nameX_value: [function({g}) { return g.V().has("age").properties("age","name").value() }], 
    get_g_VX1X_asXaX_outXknowsX_asXbX_selectXa_bX: [function({g, vid1}) { return g.V(vid1).as("a").out("knows").as("b").select("a","b") }], 
    g_VX1X_asXaX_outXknowsX_asXbX_selectXa_bX_byXnameX: [function({g, vid1}) { return g.V(vid1).as("a").out("knows").as("b").select("a","b").by("name") }], 
    g_VX1X_asXaX_outXknowsX_asXbX_selectXaX: [function({g, vid1}) { return g.V(vid1).as("a").out("knows").as("b").select("a") }], 
    g_VX1X_asXaX_outXknowsX_asXbX_selectXaX_byXnameX: [function({g, vid1}) { return g.V(vid1).as("a").out("knows").as("b").select("a").by("name") }], 
    g_V_asXaX_out_asXbX_selectXa_bX_byXnameX: [function({g}) { return g.V().as("a").out().as("b").select("a","b").by("name") }], 
    g_V_asXaX_out_aggregateXxX_asXbX_selectXa_bX_byXnameX: [function({g}) { return g.V().as("a").out().aggregate("x").as("b").select("a","b").by("name") }], 
    g_V_asXaX_name_order_asXbX_selectXa_bX_byXnameX_by_XitX: [function({g}) { return g.V().as("a").values("name").order().as("b").select("a","b").by("name").by() }], 
    g_V_hasXname_gremlinX_inEXusesX_order_byXskill_ascX_asXaX_outV_asXbX_selectXa_bX_byXskillX_byXnameX: [function({g}) { return g.V().has("name","gremlin").inE("uses").order().by("skill",Order.asc).as("a").outV().as("b").select("a","b").by("skill").by("name") }], 
    g_V_hasXname_isXmarkoXX_asXaX_selectXaX: [function({g}) { return g.V().has("name",__.is("marko")).as("a").select("a") }], 
    g_V_label_groupCount_asXxX_selectXxX: [function({g}) { return g.V().label().groupCount().as("x").select("x") }], 
    g_V_hasLabelXpersonX_asXpX_mapXbothE_label_groupCountX_asXrX_selectXp_rX: [function({g}) { return g.V().hasLabel("person").as("p").map(__.bothE().label().groupCount()).as("r").select("p","r") }], 
    g_V_chooseXoutE_count_isX0X__asXaX__asXbXX_chooseXselectXaX__selectXaX__selectXbXX: [function({g, xx1}) { return g.V().choose(__.outE().count().is(xx1),__.as("a"),__.as("b")).choose(__.select("a"),__.select("a"),__.select("b")) }], 
    g_VX1X_groupXaX_byXconstantXaXX_byXnameX_selectXaX_selectXaX: [function({g, vid1}) { return g.V(vid1).group("a").by(__.constant("a")).by(__.values("name")).barrier().select("a").select("a") }], 
    g_VX1X_asXhereX_out_selectXhereX: [function({g, vid1}) { return g.V(vid1).as("here").out().select("here") }], 
    g_VX4X_out_asXhereX_hasXlang_javaX_selectXhereX: [function({g, vid4}) { return g.V(vid4).as("here").out().select("here") }], 
    g_VX4X_out_asXhereX_hasXlang_javaX_selectXhereX_name: [function({g, vid4}) { return g.V(vid4).out().as("here").has("lang","java").select("here").values("name") }], 
    g_VX1X_outE_asXhereX_inV_hasXname_vadasX_selectXhereX: [function({g, vid1}) { return g.V(vid1).outE().as("here").inV().has("name","vadas").select("here") }], 
    g_VX1X_outEXknowsX_hasXweight_1X_asXhereX_inV_hasXname_joshX_selectXhereX: [function({g, vid1}) { return g.V(vid1).outE("knows").has("weight",1.0).as("here").inV().has("name","josh").select("here") }], 
    g_VX1X_outEXknowsX_asXhereX_hasXweight_1X_asXfakeX_inV_hasXname_joshX_selectXhereX: [function({g, vid1}) { return g.V(vid1).outE("knows").as("here").has("weight",1.0).as("fake").inV().has("name","josh").select("here") }], 
    g_V_asXhereXout_name_selectXhereX: [function({g}) { return g.V().as("here").out().values("name").select("here") }], 
    g_V_outXcreatedX_unionXasXprojectX_inXcreatedX_hasXname_markoX_selectXprojectX__asXprojectX_inXcreatedX_inXknowsX_hasXname_markoX_selectXprojectXX_groupCount_byXnameX: [function({g}) { return g.V().out("created").union(__.as("project").in_("created").has("name","marko").select("project"),__.as("project").in_("created").in_("knows").has("name","marko").select("project")).groupCount().by("name") }], 
    g_V_untilXout_outX_repeatXin_asXaXX_selectXaX_byXtailXlocalX_nameX: [function({g}) { return g.V().until(__.out().out()).repeat(__.in_().as("a")).select("a").by(__.tail(Scope.local).values("name")) }], 
    g_V_outE_weight_groupCount_selectXkeysX_unfold: [function({g}) { return g.V().outE().values("weight").groupCount().select(Column.keys).unfold() }], 
    g_V_hasLabelXsoftwareX_asXnameX_asXlanguageX_asXcreatorsX_selectXname_language_creatorsX_byXnameX_byXlangX_byXinXcreatedX_name_fold_orderXlocalXX: [function({g}) { return g.V().hasLabel("software").as("name").as("language").as("creators").select("name","language","creators").by("name").by("lang").by(__.in_("created").values("name").fold().order(Scope.local)) }], 
    g_V_outE_weight_groupCount_unfold_selectXkeysX_unfold: [function({g}) { return g.V().outE().values("weight").groupCount().unfold().select(Column.keys).unfold() }], 
    g_V_outE_weight_groupCount_unfold_selectXvaluesX_unfold: [function({g}) { return g.V().outE().values("weight").groupCount().unfold().select(Column.values).unfold() }], 
    g_V_untilXout_outX_repeatXin_asXaX_in_asXbXX_selectXa_bX_byXnameX: [function({g}) { return g.V().until(__.out().out()).repeat(__.in_().as("a").in_().as("b")).select("a","b").by("name") }], 
    g_V_outE_weight_groupCount_selectXvaluesX_unfold: [function({g}) { return g.V().outE().values("weight").groupCount().select(Column.values).unfold() }], 
    g_VX1X_asXaX_outXknowsX_asXbX_selectXa_bX: [function({g, vid1}) { return g.V(vid1).as("a").out("knows").as("b").select("a","b") }], 
    g_V_asXaX_whereXoutXknowsXX_selectXaX: [function({g}) { return g.V().as("a").where(__.out("knows")).select("a") }], 
    g_VX1X_asXaX_repeatXout_asXaXX_timesX2X_selectXfirst_aX: [function({g, vid1}) { return g.V(vid1).as("a").repeat(__.out().as("a")).times(2).select(Pop.first,"a") }], 
    g_V_asXaX_outXknowsX_asXbX_localXselectXa_bX_byXnameXX: [function({g}) { return g.V().as("a").out("knows").as("b").local(__.select("a","b").by("name")) }], 
    g_VX1X_asXaX_repeatXout_asXaXX_timesX2X_selectXlast_aX: [function({g, vid1}) { return g.V(vid1).as("a").repeat(__.out().as("a")).times(2).select(Pop.last,"a") }], 
    g_VX1X_outEXknowsX_asXhereX_hasXweight_1X_inV_hasXname_joshX_selectXhereX: [function({g, vid1}) { return g.V(vid1).outE("knows").as("here").has("weight",1.0).inV().has("name","josh").select("here") }], 
    g_V_asXaX_hasXname_markoX_asXbX_asXcX_selectXa_b_cX_by_byXnameX_byXageX: [function({g}) { return g.V().as("a").has("name","marko").as("b").as("c").select("a","b","c").by().by("name").by("age") }], 
    g_V_outE_weight_groupCount_selectXvaluesX_unfold_groupCount_selectXvaluesX_unfold: [function({g}) { return g.V().outE().values("weight").groupCount().select(Column.values).unfold().groupCount().select(Column.values).unfold() }], 
    g_V_asXaX_groupXmX_by_byXbothE_countX_barrier_selectXmX_selectXselectXaXX: [function({g}) { return g.V().as("a").group("m").by().by(__.bothE().count()).barrier().select("m").select(__.select("a")) }], 
    g_V_asXaX_groupXmX_by_byXbothE_countX_barrier_selectXmX_selectXselectXaXX_byXmathX_plus_XX: [function({g}) { return g.V().as("a").group("m").by().by(__.bothE().count()).barrier().select("m").select(__.select("a")).by(__.math("_+_")) }], 
    g_V_asXaX_outXknowsX_asXaX_selectXall_constantXaXX: [function({g}) { return g.V().as("a").out("knows").as("a").select(Pop.all,__.constant("a")) }], 
    g_V_selectXaX: [function({g}) { return g.V().select("a") }], 
    g_V_selectXaX_count: [function({g}) { return g.V().select("a").count() }], 
    g_V_selectXa_bX: [function({g}) { return g.V().select("a","b") }], 
    g_V_valueMap_selectXaX: [function({g}) { return g.V().valueMap().select("a") }], 
    g_V_valueMap_selectXa_bX: [function({g}) { return g.V().valueMap().select("a","b") }], 
    g_V_selectXfirst_aX: [function({g}) { return g.V().select(Pop.first,"a") }], 
    g_V_selectXfirst_a_bX: [function({g}) { return g.V().select(Pop.first,"a","b") }], 
    g_V_valueMap_selectXfirst_aX: [function({g}) { return g.V().valueMap().select(Pop.first,"a") }], 
    g_V_valueMap_selectXfirst_a_bX: [function({g}) { return g.V().valueMap().select(Pop.first,"a","b") }], 
    g_V_selectXlast_aX: [function({g}) { return g.V().select(Pop.last,"a") }], 
    g_V_selectXlast_a_bX: [function({g}) { return g.V().select(Pop.last,"a","b") }], 
    g_V_valueMap_selectXlast_aX: [function({g}) { return g.V().valueMap().select(Pop.last,"a") }], 
    g_V_valueMap_selectXlast_a_bX: [function({g}) { return g.V().valueMap().select(Pop.last,"a","b") }], 
    g_V_selectXall_aX: [function({g}) { return g.V().select(Pop.all,"a") }], 
    g_V_selectXall_a_bX: [function({g}) { return g.V().select(Pop.all,"a","b") }], 
    g_V_valueMap_selectXall_aX: [function({g}) { return g.V().valueMap().select(Pop.all,"a") }], 
    g_V_valueMap_selectXall_a_bX: [function({g}) { return g.V().valueMap().select(Pop.all,"a","b") }], 
    g_V_asXa_bX_out_asXcX_path_selectXkeysX: [function({g}) { return g.V().as("a","b").out().as("c").path().select(Column.keys) }, function({g}) { return g.V().as("a","b").out().as("c").path().select(Column.keys) }], 
    g_V_hasXperson_name_markoX_barrier_asXaX_outXknows_selectXaX: [function({g}) { return g.V().has("person","name","marko").barrier().as("a").out("knows").select("a") }], 
    g_V_hasXperson_name_markoX_elementMapXnameX_asXaX_unionXidentity_identityX_selectXaX_selectXnameX: [function({g}) { return g.V().has("person","name","marko").elementMap("name").as("a").union(__.identity(),__.identity()).select("a").select("name") }], 
    g_V_hasXperson_name_markoX_count_asXaX_unionXidentity_identityX_selectXaX: [function({g}) { return g.V().has("person","name","marko").count().as("a").union(__.identity(),__.identity()).select("a") }], 
    g_V_hasXperson_name_markoX_path_asXaX_unionXidentity_identityX_selectXaX_unfold: [function({g}) { return g.V().has("person","name","marko").path().as("a").union(__.identity(),__.identity()).select("a").unfold() }], 
    g_EX11X_propertiesXweightX_asXaX_selectXaX_byXkeyX: [function({g, eid11}) { return g.E(eid11).properties("weight").as("a").select("a").by(T.key) }], 
    g_EX11X_propertiesXweightX_asXaX_selectXaX_byXvalueX: [function({g, eid11}) { return g.E(eid11).properties("weight").as("a").select("a").by(T.value) }], 
    g_V_shortestPath: [function({g}) { return g.withStrategies(new VertexProgramStrategy(new Map([["graphComputer","org.apache.tinkerpop.gremlin.process.computer.GraphComputer"]]))).V().identity().shortestPath() }], 
    g_V_both_dedup_shortestPath: [function({g}) { return g.withStrategies(new VertexProgramStrategy(new Map([["graphComputer","org.apache.tinkerpop.gremlin.process.computer.GraphComputer"]]))).V().both().dedup().shortestPath() }], 
    g_V_shortestPath_edgesIncluded: [function({g}) { return g.withStrategies(new VertexProgramStrategy(new Map([["graphComputer","org.apache.tinkerpop.gremlin.process.computer.GraphComputer"]]))).V().identity().shortestPath().with_("~tinkerpop.shortestPath.includeEdges") }], 
    g_V_shortestPath_directionXINX: [function({g}) { return g.withStrategies(new VertexProgramStrategy(new Map([["graphComputer","org.apache.tinkerpop.gremlin.process.computer.GraphComputer"]]))).V().identity().shortestPath().with_("~tinkerpop.shortestPath.edges",Direction.IN) }], 
    g_V_shortestPath_edgesXoutEX: [function({g}) { return g.withStrategies(new VertexProgramStrategy(new Map([["graphComputer","org.apache.tinkerpop.gremlin.process.computer.GraphComputer"]]))).V().identity().shortestPath().with_("~tinkerpop.shortestPath.edges",__.outE()) }], 
    g_V_shortestPath_edgesIncluded_edgesXoutEX: [function({g}) { return g.withStrategies(new VertexProgramStrategy(new Map([["graphComputer","org.apache.tinkerpop.gremlin.process.computer.GraphComputer"]]))).V().identity().shortestPath().with_("~tinkerpop.shortestPath.includeEdges").with_("~tinkerpop.shortestPath.edges",__.outE()) }], 
    g_V_hasXname_markoX_shortestPath: [function({g}) { return g.withStrategies(new VertexProgramStrategy(new Map([["graphComputer","org.apache.tinkerpop.gremlin.process.computer.GraphComputer"]]))).V().has("name","marko").shortestPath() }], 
    g_V_shortestPath_targetXhasXname_markoXX: [function({g}) { return g.withStrategies(new VertexProgramStrategy(new Map([["graphComputer","org.apache.tinkerpop.gremlin.process.computer.GraphComputer"]]))).V().identity().shortestPath().with_("~tinkerpop.shortestPath.target",__.has("name","marko")) }], 
    g_V_shortestPath_targetXvaluesXnameX_isXmarkoXX: [function({g}) { return g.withStrategies(new VertexProgramStrategy(new Map([["graphComputer","org.apache.tinkerpop.gremlin.process.computer.GraphComputer"]]))).V().identity().shortestPath().with_("~tinkerpop.shortestPath.target",__.values("name").is("marko")) }], 
    g_V_hasXname_markoX_shortestPath_targetXhasLabelXsoftwareXX: [function({g}) { return g.withStrategies(new VertexProgramStrategy(new Map([["graphComputer","org.apache.tinkerpop.gremlin.process.computer.GraphComputer"]]))).V().has("name","marko").shortestPath().with_("~tinkerpop.shortestPath.target",__.hasLabel("software")) }], 
    g_V_hasXname_markoX_shortestPath_targetXhasXname_joshXX_distanceXweightX: [function({g}) { return g.withStrategies(new VertexProgramStrategy(new Map([["graphComputer","org.apache.tinkerpop.gremlin.process.computer.GraphComputer"]]))).V().has("name","marko").shortestPath().with_("~tinkerpop.shortestPath.target",__.has("name","josh")).with_("~tinkerpop.shortestPath.distance","weight") }], 
    g_V_hasXname_danielX_shortestPath_targetXhasXname_stephenXX_edgesXbothEXusesXX: [function({g}) { return g.withStrategies(new VertexProgramStrategy(new Map([["graphComputer","org.apache.tinkerpop.gremlin.process.computer.GraphComputer"]]))).V().has("name","daniel").shortestPath().with_("~tinkerpop.shortestPath.target",__.has("name","stephen")).with_("~tinkerpop.shortestPath.edges",__.bothE("uses")) }], 
    g_V_hasXsong_name_MIGHT_AS_WELLX_shortestPath_targetXhasXsong_name_MAYBE_YOU_KNOW_HOW_I_FEELXX_edgesXoutEXfollowedByXX_distanceXweightX: [function({g}) { return g.withStrategies(new VertexProgramStrategy(new Map([["graphComputer","org.apache.tinkerpop.gremlin.process.computer.GraphComputer"]]))).V().has("song","name","MIGHT AS WELL").shortestPath().with_("~tinkerpop.shortestPath.target",__.has("song","name","MAYBE YOU KNOW HOW I FEEL")).with_("~tinkerpop.shortestPath.edges",__.outE("followedBy")).with_("~tinkerpop.shortestPath.distance","weight") }], 
    g_V_hasXname_markoX_shortestPath_maxDistanceX1X: [function({g}) { return g.withStrategies(new VertexProgramStrategy(new Map([["graphComputer","org.apache.tinkerpop.gremlin.process.computer.GraphComputer"]]))).V().has("name","marko").shortestPath().with_("~tinkerpop.shortestPath.maxDistance",1) }], 
    g_V_hasXname_vadasX_shortestPath_distanceXweightX_maxDistanceX1_3X: [function({g}) { return g.withStrategies(new VertexProgramStrategy(new Map([["graphComputer","org.apache.tinkerpop.gremlin.process.computer.GraphComputer"]]))).V().has("name","vadas").shortestPath().with_("~tinkerpop.shortestPath.distance","weight").with_("~tinkerpop.shortestPath.maxDistance",1.3) }], 
    g_V_age_sum: [function({g}) { return g.V().values("age").sum() }], 
    g_V_foo_sum: [function({g}) { return g.V().values("foo").sum() }], 
    g_V_age_fold_sumXlocalX: [function({g}) { return g.V().values("age").fold().sum(Scope.local) }], 
    g_V_foo_fold_sumXlocalX: [function({g}) { return g.V().values("foo").fold().sum(Scope.local) }], 
    g_V_hasLabelXsoftwareX_group_byXnameX_byXbothE_weight_sumX: [function({g}) { return g.V().hasLabel("software").group().by("name").by(__.bothE().values("weight").sum()) }], 
    g_V_localXoutE_foldX_unfold: [function({g}) { return g.V().local(__.outE().fold()).unfold() }], 
    g_V_valueMap_unfold_mapXkeyX: [function({g, l1}) { return g.V().valueMap().unfold().map(l1) }], 
    g_VX1X_repeatXboth_simplePathX_untilXhasIdX6XX_path_byXnameX_unfold: [function({g, vid6, vid1}) { return g.V(vid1).repeat(__.both().simplePath()).until(__.hasId(vid6)).path().by("name").unfold() }], 
    g_V_valueMap: [function({g}) { return g.V().valueMap() }], 
    g_V_valueMapXtrueX: [function({g}) { return g.V().valueMap(true) }], 
    g_V_valueMap_withXtokensX: [function({g}) { return g.V().valueMap().with_("~tinkerpop.valueMap.tokens") }], 
    g_V_valueMapXname_ageX: [function({g}) { return g.V().valueMap("name","age") }], 
    g_V_valueMapXtrue_name_ageX: [function({g}) { return g.V().valueMap(true,"name","age") }], 
    g_V_valueMapXname_ageX_withXtokensX: [function({g}) { return g.V().valueMap("name","age").with_("~tinkerpop.valueMap.tokens") }], 
    g_V_valueMapXname_ageX_withXtokens_labelsX_byXunfoldX: [function({g}) { return g.V().valueMap("name","age").with_("~tinkerpop.valueMap.tokens",2).by(__.unfold()) }], 
    g_V_valueMapXname_ageX_withXtokens_idsX_byXunfoldX: [function({g}) { return g.V().valueMap("name","age").with_("~tinkerpop.valueMap.tokens",1).by(__.unfold()) }], 
    g_VX1X_outXcreatedX_valueMap: [function({g, vid1}) { return g.V(vid1).out("created").valueMap() }], 
    g_V_hasLabelXpersonX_filterXoutEXcreatedXX_valueMapXtrueX: [function({g}) { return g.V().hasLabel("person").filter(__.outE("created")).valueMap(true) }], 
    g_V_hasLabelXpersonX_filterXoutEXcreatedXX_valueMap_withXtokensX: [function({g}) { return g.V().hasLabel("person").filter(__.outE("created")).valueMap().with_("~tinkerpop.valueMap.tokens") }], 
    g_VX1X_valueMapXname_locationX_byXunfoldX_by: [function({g, vid1}) { return g.V(vid1).valueMap("name","location").by(__.unfold()).by() }], 
    g_VXlistX1_2_3XX_name: [function({g, xx1}) { return g.V(xx1).values("name") }], 
    g_VXlistXv1_v2_v3XX_name: [function({g, xx1}) { return g.V(xx1).values("name") }], 
    g_V: [function({g}) { return g.V() }], 
    g_VXv1X_out: [function({g, v1}) { return g.V(v1).out() }], 
    g_VX1X_out: [function({g, vid1}) { return g.V(vid1).out() }], 
    g_VX2X_in: [function({g, vid2}) { return g.V(vid2).in_() }], 
    g_VX4X_both: [function({g, vid4}) { return g.V(vid4).both() }], 
    g_E: [function({g}) { return g.E() }], 
    g_EX11X: [function({g, eid11}) { return g.E(eid11) }], 
    g_EX11AsStringX: [function({g, eid11}) { return g.E(eid11) }], 
    g_EXe11X: [function({g, e11}) { return g.E(e11) }], 
    g_EXe7_e11X: [function({g, e7, e11}) { return g.E(e7,e11) }], 
    g_EXlistXe7_e11XX: [function({g, xx1}) { return g.E(xx1) }], 
    g_VX1X_outE: [function({g, vid1}) { return g.V(vid1).outE() }], 
    g_VX2X_outE: [function({g, vid2}) { return g.V(vid2).inE() }], 
    g_VX4X_bothEXcreatedX: [function({g, vid4}) { return g.V(vid4).bothE("created") }], 
    g_VX4X_bothE: [function({g, vid4}) { return g.V(vid4).bothE() }], 
    g_VX1X_outE_inV: [function({g, vid1}) { return g.V(vid1).both() }], 
    g_VX2X_inE_outV: [function({g, vid2}) { return g.V(vid2).inE().outV() }], 
    g_V_outE_hasXweight_1X_outV: [function({g}) { return g.V().outE().has("weight",1.0).outV() }], 
    g_V_out_outE_inV_inE_inV_both_name: [function({g}) { return g.V().out().outE().inV().inE().inV().both().values("name") }], 
    g_VX1X_outEXknowsX_bothV_name: [function({g, vid1}) { return g.V(vid1).outE("knows").bothV().values("name") }], 
    g_VX1X_outE_otherV: [function({g, vid1}) { return g.V(vid1).outE().otherV() }], 
    g_VX4X_bothE_otherV: [function({g, vid4}) { return g.V(vid4).bothE().otherV() }], 
    g_VX4X_bothE_hasXweight_lt_1X_otherV: [function({g, vid4}) { return g.V(vid4).bothE().has("weight",P.lt(1.0)).otherV() }], 
    g_VX2X_inE: [function({g, vid2}) { return g.V(vid2).bothE() }], 
    get_g_VX1X_outE_otherV: [function({g, vid1}) { return g.V(vid1).outE().otherV() }], 
    g_VX1X_outXknowsX: [function({g, vid1}) { return g.V(vid1).out("knows") }], 
    g_VX1AsStringX_outXknowsX: [function({g, vid1}) { return g.V(vid1).out("knows") }], 
    g_VX1X_outXknows_createdX: [function({g, vid1}) { return g.V(vid1).out("knows","created") }], 
    g_VX1X_outEXknowsX_inV: [function({g, vid1}) { return g.V(vid1).outE("knows").inV() }], 
    g_VX1X_outEXknows_createdX_inV: [function({g, vid1}) { return g.V(vid1).outE("knows","created").inV() }], 
    g_V_out_out: [function({g}) { return g.V().out().out() }], 
    g_VX1X_out_out_out: [function({g, vid1}) { return g.V(vid1).out().out().out() }], 
    g_VX1X_out_name: [function({g, vid1}) { return g.V(vid1).out().values("name") }], 
    g_VX1X_to_XOUT_knowsX: [function({g, vid1}) { return g.V(vid1).to(Direction.OUT,"knows") }], 
    g_VX1_2_3_4X_name: [function({g, vid4, vid3, vid2, vid1}) { return g.V(vid1,vid2,vid3,vid4).values("name") }], 
    g_V_hasLabelXpersonX_V_hasLabelXsoftwareX_name: [function({g}) { return g.V().hasLabel("person").V().hasLabel("software").values("name") }], 
    g_V_hasLabelXloopsX_bothEXselfX: [function({g}) { return g.V().hasLabel("loops").bothE("self") }], 
    g_V_hasLabelXloopsX_bothXselfX: [function({g}) { return g.V().hasLabel("loops").both("self") }], 
    g_V_valueXnameX_aggregateXxX_capXxX: [function({g}) { return g.V().values("name").aggregate("x").cap("x") }], 
    g_V_valueXnameX_aggregateXglobal_xX_capXxX: [function({g}) { return g.V().values("name").aggregate(Scope.global,"x").cap("x") }], 
    g_V_aggregateXxX_byXnameX_capXxX: [function({g}) { return g.V().aggregate("x").by("name").cap("x") }], 
    g_V_out_aggregateXaX_path: [function({g}) { return g.V().out().aggregate("a").path() }], 
    g_V_hasLabelXpersonX_aggregateXxX_byXageX_capXxX_asXyX_selectXyX: [function({g}) { return g.V().hasLabel("person").aggregate("x").by("age").cap("x").as("y").select("y") }], 
    g_V_aggregateXlocal_a_nameX_out_capXaX: [function({g}) { return g.V().aggregate(Scope.local,"a").by("name").out().cap("a") }], 
    g_VX1X_aggregateXlocal_aX_byXnameX_out_aggregateXlocal_aX_byXnameX_name_capXaX: [function({g, vid1}) { return g.V(vid1).aggregate(Scope.local,"a").by("name").out().aggregate(Scope.local,"a").by("name").values("name").cap("a") }], 
    g_withSideEffectXa_setX_V_both_name_aggregateXlocal_aX_capXaX: [function({g, xx1}) { return g.withSideEffect("a",xx1).V().both().values("name").aggregate(Scope.local,"a").cap("a") }], 
    g_V_aggregateXlocal_aX_byXoutEXcreatedX_countX_out_out_aggregateXlocal_aX_byXinEXcreatedX_weight_sumX: [function({g}) { return g.V().aggregate(Scope.local,"a").by(__.outE("created").count()).out().out().aggregate(Scope.local,"a").by(__.inE("created").values("weight").sum()).cap("a") }], 
    g_V_group_byXnameX: [function({g}) { return g.V().group().by("name") }], 
    g_V_group_byXageX: [function({g}) { return g.V().group().by("age") }], 
    g_V_group_byXnameX_by: [function({g}) { return g.V().group().by("name").by() }], 
    g_V_groupXaX_byXnameX_capXaX: [function({g}) { return g.V().group("a").by("name").cap("a") }], 
    g_V_hasXlangX_groupXaX_byXlangX_byXnameX_out_capXaX: [function({g}) { return g.V().has("lang").group("a").by("lang").by("name").out().cap("a") }], 
    g_V_hasXlangX_group_byXlangX_byXcountX: [function({g}) { return g.V().has("lang").group().by("lang").by(__.count()) }], 
    g_V_repeatXout_groupXaX_byXnameX_byXcountX_timesX2X_capXaX: [function({g}) { return g.V().repeat(__.out().group("a").by("name").by(__.count())).times(2).cap("a") }], 
    g_V_group_byXoutE_countX_byXnameX: [function({g}) { return g.V().group().by(__.outE().count()).by("name") }], 
    g_V_groupXaX_byXlabelX_byXoutE_weight_sumX_capXaX: [function({g}) { return g.V().group("a").by(T.label).by(__.outE().values("weight").sum()).cap("a") }], 
    g_V_repeatXbothXfollowedByXX_timesX2X_group_byXsongTypeX_byXcountX: [function({g}) { return g.V().repeat(__.both("followedBy")).times(2).group().by("songType").by(__.count()) }], 
    g_V_repeatXbothXfollowedByXX_timesX2X_groupXaX_byXsongTypeX_byXcountX_capXaX: [function({g}) { return g.V().repeat(__.both("followedBy")).times(2).group("a").by("songType").by(__.count()).cap("a") }], 
    g_V_group_byXname_substring_1X_byXconstantX1XX: [function({g, l1}) { return g.V().group().by(l1).by(__.constant(1)) }], 
    g_V_groupXaX_byXname_substring_1X_byXconstantX1XX_capXaX: [function({g, l1}) { return g.V().group("a").by(l1).by(__.constant(1)).cap("a") }], 
    g_V_out_group_byXlabelX_selectXpersonX_unfold_outXcreatedX_name_limitX2X: [function({g}) { return g.V().out().group().by(T.label).select("person").unfold().out("created").values("name").limit(2) }], 
    g_V_hasLabelXsongX_group_byXnameX_byXproperties_groupCount_byXlabelXX: [function({g}) { return g.V().hasLabel("song").group().by("name").by(__.properties().groupCount().by(T.label)) }], 
    g_V_hasLabelXsongX_groupXaX_byXnameX_byXproperties_groupCount_byXlabelXX_out_capXaX: [function({g}) { return g.V().hasLabel("song").group("a").by("name").by(__.properties().groupCount().by(T.label)).out().cap("a") }], 
    g_V_outXfollowedByX_group_byXsongTypeX_byXbothE_group_byXlabelX_byXweight_sumXX: [function({g}) { return g.V().out("followedBy").group().by("songType").by(__.bothE().group().by(T.label).by(__.values("weight").sum())) }], 
    g_V_groupXmX_byXnameX_byXinXknowsX_nameX_capXmX: [function({g}) { return g.V().group("m").by("name").by(__.in_("knows").values("name")).cap("m") }], 
    g_V_group_byXlabelX_byXbothE_groupXaX_byXlabelX_byXweight_sumX_weight_sumX: [function({g}) { return g.V().group().by(T.label).by(__.bothE().group("a").by(T.label).by(__.values("weight").sum()).values("weight").sum()) }], 
    g_withSideEffectXa__marko_666_noone_blahX_V_groupXaX_byXnameX_byXoutE_label_foldX_capXaX: [function({g, xx1}) { return g.withSideEffect("a",xx1).V().group("a").by("name").by(__.outE().label().fold()).cap("a") }], 
    g_V_hasLabelXpersonX_asXpX_outXcreatedX_group_byXnameX_byXselectXpX_valuesXageX_sumX: [function({g}) { return g.V().hasLabel("person").as("p").out("created").group().by("name").by(__.select("p").values("age").sum()) }], 
    g_V_hasLabelXpersonX_asXpX_outXcreatedX_groupXaX_byXnameX_byXselectXpX_valuesXageX_sumX_capXaX: [function({g}) { return g.V().hasLabel("person").as("p").out("created").group("a").by("name").by(__.select("p").values("age").sum()).cap("a") }], 
    g_V_group_byXlabelX_byXlabel_countX: [function({g}) { return g.V().group().by(__.label()).by(__.label().count()) }], 
    g_V_groupXmX_byXlabelX_byXlabel_countX_capXmX: [function({g}) { return g.V().group("m").by(__.label()).by(__.label().count()).cap("m") }], 
    g_V_outXcreatedX_groupCount_byXnameX: [function({g}) { return g.V().out("created").groupCount().by("name") }], 
    g_V_outXcreatedX_name_groupCount: [function({g}) { return g.V().out("created").values("name").groupCount() }], 
    g_V_outXcreatedX_groupCountXaX_byXnameX_capXaX: [function({g}) { return g.V().out("created").groupCount("a").by("name").cap("a") }], 
    g_V_outXcreatedX_name_groupCountXaX_capXaX: [function({g}) { return g.V().out("created").values("name").groupCount("a").cap("a") }], 
    g_V_repeatXout_groupCountXaX_byXnameXX_timesX2X_capXaX: [function({g}) { return g.V().repeat(__.out().groupCount("a").by("name")).times(2).cap("a") }], 
    g_V_both_groupCountXaX_byXlabelX_asXbX_barrier_whereXselectXaX_selectXsoftwareX_isXgtX2XXX_selectXbX_name: [function({g}) { return g.V().both().groupCount("a").by(T.label).as("b").barrier().where(__.select("a").select("software").is(P.gt(2))).select("b").values("name") }], 
    g_V_unionXoutXknowsX__outXcreatedX_inXcreatedXX_groupCount_selectXvaluesX_unfold_sum: [function({g}) { return g.V().union(__.out("knows"),__.out("created").in_("created")).groupCount().select(Column.values).unfold().sum() }], 
    g_V_hasXnoX_groupCount: [function({g}) { return g.V().has("no").groupCount() }], 
    g_V_hasXnoX_groupCountXaX_capXaX: [function({g}) { return g.V().has("no").groupCount("a").cap("a") }], 
    g_V_unionXrepeatXoutX_timesX2X_groupCountXmX_byXlangXX__repeatXinX_timesX2X_groupCountXmX_byXnameXX_capXmX: [function({g}) { return g.V().union(__.repeat(__.out()).times(2).groupCount("m").by("lang"),__.repeat(__.in_()).times(2).groupCount("m").by("name")).cap("m") }], 
    g_V_outXcreatedX_groupCountXxX_capXxX: [function({g}) { return g.V().out("created").groupCount("x").cap("x") }], 
    g_V_groupCount_byXbothE_countX: [function({g}) { return g.V().groupCount().by(__.bothE().count()) }], 
    g_V_both_groupCountXaX_out_capXaX_selectXkeysX_unfold_both_groupCountXaX_capXaX: [function({g}) { return g.V().both().groupCount("a").out().cap("a").select(Column.keys).unfold().both().groupCount("a").cap("a") }], 
    g_V_hasXperson_name_markoX_bothXknowsX_groupCount_byXvaluesXnameX_foldX: [function({g}) { return g.V().has("person","name","marko").both("knows").groupCount().by(__.values("name").fold()) }], 
    g_VX1X_out_injectXv2X_name: [function({g, vid1, v2}) { return g.V(vid1).out().inject(v2).values("name") }], 
    g_VX1X_out_name_injectXdanielX_asXaX_mapXlengthX_path: [function({g, l1, vid1}) { return g.V(vid1).out().values("name").inject("daniel").as("a").map(l1).path() }], 
    g_VX1X_injectXg_VX4XX_out_name: [function({g, vid1, v4}) { return g.V(vid1).inject(v4).out().values("name") }], 
    g_injectXnull_1_3_nullX: [function({g}) { return g.inject(null,1,3,null) }], 
    g_injectX10_20_null_20_10_10X_groupCountXxX_dedup_asXyX_projectXa_bX_by_byXselectXxX_selectXselectXyXXX: [function({g}) { return g.inject(10,20,null,20,10,10).groupCount("x").dedup().as("y").project("a","b").by().by(__.select("x").select(__.select("y"))) }], 
    g_injectXname_marko_age_nullX_selectXname_ageX: [function({g, xx1}) { return g.inject(xx1).select("name","age") }], 
    g_io_readXkryoX: [function({g}) { return g.io("data/tinkerpop-modern.kryo").read() }, function({g}) { return g.V() }, function({g}) { return g.E() }], 
    g_io_read_withXreader_gryoX: [function({g}) { return g.io("data/tinkerpop-modern.kryo").with_("~tinkerpop.io.reader","gryo").read() }, function({g}) { return g.V() }, function({g}) { return g.E() }], 
    g_io_readXgraphsonX: [function({g}) { return g.io("data/tinkerpop-modern.json").read() }, function({g}) { return g.V() }, function({g}) { return g.E() }], 
    g_io_read_withXreader_graphsonX: [function({g}) { return g.io("data/tinkerpop-modern.json").with_("~tinkerpop.io.reader","graphson").read() }, function({g}) { return g.V() }, function({g}) { return g.E() }], 
    g_io_readXgraphmlX: [function({g}) { return g.io("data/tinkerpop-modern.xml").read() }, function({g}) { return g.V() }, function({g}) { return g.E() }], 
    g_io_read_withXreader_graphmlX: [function({g}) { return g.io("data/tinkerpop-modern.xml").with_("~tinkerpop.io.reader","graphml").read() }, function({g}) { return g.V() }, function({g}) { return g.E() }], 
    g_withSackXhelloX_V_outE_sackXassignX_byXlabelX_inV_sack: [function({g}) { return g.withSack("hello").V().outE().sack(Operator.assign).by(T.label).inV().sack() }], 
    g_withSackX0X_V_outE_sackXsumX_byXweightX_inV_sack_sum: [function({g}) { return g.withSack(0.0).V().outE().sack(Operator.sum).by("weight").inV().sack().sum() }], 
    g_withSackX0X_V_repeatXoutE_sackXsumX_byXweightX_inVX_timesX2X_sack: [function({g}) { return g.withSack(0.0).V().repeat(__.outE().sack(Operator.sum).by("weight").inV()).times(2).sack() }], 
    g_withBulkXfalseX_withSackX1_sumX_VX1X_localXoutEXknowsX_barrierXnormSackX_inVX_inXknowsX_barrier_sack: [function({g, vid1}) { return g.withBulk(false).withSack(1.0,Operator.sum).V(vid1).local(__.outE("knows").barrier(Barrier.normSack).inV()).in_("knows").barrier().sack() }], 
    g_withBulkXfalseX_withSackX1_sumX_V_out_barrier_sack: [function({g}) { return g.withBulk(false).withSack(1,Operator.sum).V().out().barrier().sack() }], 
    g_withSackX1_sumX_VX1X_localXoutXknowsX_barrierXnormSackXX_inXknowsX_barrier_sack: [function({g, vid1}) { return g.withSack(1.0,Operator.sum).V(vid1).local(__.out("knows").barrier(Barrier.normSack)).in_("knows").barrier().sack() }], 
    g_V_hasXageX_groupCountXaX_byXnameX_out_capXaX: [function({g}) { return g.V().has("age").groupCount("a").by("name").out().cap("a") }], 
    g_V_storeXa_nameX_out_capXaX: [function({g}) { return g.V().store("a").by("name").out().cap("a") }], 
    g_VX1X_storeXaX_byXnameX_out_storeXaX_byXnameX_name_capXaX: [function({g, vid1}) { return g.V(vid1).store("a").by("name").out().store("a").by("name").values("name").cap("a") }], 
    g_withSideEffectXa_setX_V_both_name_storeXaX_capXaX: [function({g, xx1}) { return g.withSideEffect("a",xx1).V().both().values("name").store("a").cap("a") }], 
    g_V_storeXaX_byXoutEXcreatedX_countX_out_out_storeXaX_byXinEXcreatedX_weight_sumX: [function({g}) { return g.V().store("a").by(__.outE("created").count()).out().out().store("a").by(__.inE("created").values("weight").sum()).cap("a") }], 
}

exports.gremlin = gremlins
