/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.server.util;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.script.Bindings;
import javax.script.SimpleBindings;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalSource;
import org.apache.tinkerpop.gremlin.server.GraphManager;
import org.apache.tinkerpop.gremlin.server.GremlinServer;
import org.apache.tinkerpop.gremlin.server.Settings;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Transaction;
import org.apache.tinkerpop.gremlin.structure.util.GraphFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultGraphManager
implements GraphManager {
    private static final Logger logger = LoggerFactory.getLogger(GremlinServer.class);
    private final Map<String, Graph> graphs = new ConcurrentHashMap<String, Graph>();
    private final Map<String, TraversalSource> traversalSources = new ConcurrentHashMap<String, TraversalSource>();

    public DefaultGraphManager(Settings settings) {
        settings.graphs.entrySet().forEach(e -> {
            block2: {
                try {
                    Graph newGraph = GraphFactory.open((String)((String)e.getValue()));
                    this.graphs.put((String)e.getKey(), newGraph);
                    logger.info("Graph [{}] was successfully configured via [{}].", e.getKey(), e.getValue());
                }
                catch (RuntimeException re) {
                    logger.warn(String.format("Graph [%s] configured at [%s] could not be instantiated and will not be available in Gremlin Server.  GraphFactory message: %s", e.getKey(), e.getValue(), re.getMessage()), (Throwable)re);
                    if (re.getCause() == null) break block2;
                    logger.debug("GraphFactory exception", re.getCause());
                }
            }
        });
    }

    @Override
    public final Set<String> getGraphNames() {
        return this.graphs.keySet();
    }

    @Override
    public final Graph getGraph(String graphName) {
        return this.graphs.get(graphName);
    }

    @Override
    public final void putGraph(String graphName, Graph g) {
        this.graphs.put(graphName, g);
    }

    @Override
    public final Set<String> getTraversalSourceNames() {
        return this.traversalSources.keySet();
    }

    @Override
    public final TraversalSource getTraversalSource(String traversalSourceName) {
        return this.traversalSources.get(traversalSourceName);
    }

    @Override
    public final void putTraversalSource(String tsName, TraversalSource ts) {
        this.traversalSources.put(tsName, ts);
    }

    @Override
    public final TraversalSource removeTraversalSource(String tsName) {
        return this.traversalSources.remove(tsName);
    }

    @Override
    public final Bindings getAsBindings() {
        SimpleBindings bindings = new SimpleBindings();
        this.graphs.forEach(bindings::put);
        this.traversalSources.forEach(bindings::put);
        return bindings;
    }

    @Override
    public final void rollbackAll() {
        this.graphs.entrySet().forEach(e -> {
            Graph graph = (Graph)e.getValue();
            if (graph.features().graph().supportsTransactions() && graph.tx().isOpen()) {
                graph.tx().rollback();
            }
        });
    }

    @Override
    public final void rollback(Set<String> graphSourceNamesToCloseTxOn) {
        this.closeTx(graphSourceNamesToCloseTxOn, Transaction.Status.ROLLBACK);
    }

    @Override
    public final void commitAll() {
        this.graphs.entrySet().forEach(e -> {
            Graph graph = (Graph)e.getValue();
            if (graph.features().graph().supportsTransactions() && graph.tx().isOpen()) {
                graph.tx().commit();
            }
        });
    }

    @Override
    public final void commit(Set<String> graphSourceNamesToCloseTxOn) {
        this.closeTx(graphSourceNamesToCloseTxOn, Transaction.Status.COMMIT);
    }

    @Override
    public final Graph openGraph(String graphName, Function<String, Graph> supplier) {
        Graph graph = this.graphs.get(graphName);
        if (null != graph) {
            return graph;
        }
        Graph newGraph = supplier.apply(graphName);
        this.putGraph(graphName, newGraph);
        return newGraph;
    }

    @Override
    public final Graph removeGraph(String graphName) throws Exception {
        Graph graph = this.graphs.remove(graphName);
        graph.close();
        return graph;
    }

    private void closeTx(Set<String> graphSourceNamesToCloseTxOn, Transaction.Status tx) {
        HashSet graphsToCloseTxOn = new HashSet();
        graphSourceNamesToCloseTxOn.forEach(r -> {
            if (this.graphs.containsKey(r)) {
                graphsToCloseTxOn.add(this.graphs.get(r));
            } else {
                graphsToCloseTxOn.add(this.traversalSources.get(r).getGraph());
            }
        });
        graphsToCloseTxOn.forEach(graph -> {
            if (graph.features().graph().supportsTransactions() && graph.tx().isOpen()) {
                if (tx == Transaction.Status.COMMIT) {
                    graph.tx().commit();
                } else {
                    graph.tx().rollback();
                }
            }
        });
    }
}

