/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.simple;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.io.IOException;
import java.net.URI;
import org.apache.tinkerpop.gremlin.driver.handler.NioGremlinRequestEncoder;
import org.apache.tinkerpop.gremlin.driver.handler.NioGremlinResponseDecoder;
import org.apache.tinkerpop.gremlin.driver.message.RequestMessage;
import org.apache.tinkerpop.gremlin.driver.ser.GryoMessageSerializerV3d0;
import org.apache.tinkerpop.gremlin.driver.simple.AbstractClient;

public class NioClient
extends AbstractClient {
    private final Channel channel;

    public NioClient() {
        this(URI.create("gs://localhost:8182"));
    }

    public NioClient(URI uri) {
        super("nio-client-%d");
        Bootstrap b = (Bootstrap)new Bootstrap().group(this.group);
        b.option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT);
        try {
            final GryoMessageSerializerV3d0 serializer = new GryoMessageSerializerV3d0();
            ((Bootstrap)b.channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) {
                    ChannelPipeline p = ch.pipeline();
                    p.addLast(new ChannelHandler[]{new NioGremlinResponseDecoder(serializer), new NioGremlinRequestEncoder(true, serializer), NioClient.this.callbackResponseHandler});
                }
            });
            this.channel = b.connect(uri.getHost(), uri.getPort()).sync().channel();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void writeAndFlush(RequestMessage requestMessage) throws Exception {
        this.channel.writeAndFlush((Object)requestMessage).get();
    }

    @Override
    public void close() throws IOException {
        try {
            this.channel.close().get();
        }
        catch (Exception exception) {
        }
        finally {
            this.group.shutdownGracefully().awaitUninterruptibly();
        }
    }
}

