/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.ser.binary.types;

import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import org.apache.tinkerpop.gremlin.driver.ser.binary.DataType;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.SimpleTypeSerializer;

public class StringSerializer
extends SimpleTypeSerializer<String> {
    public StringSerializer() {
        super(DataType.STRING);
    }

    @Override
    protected String readValue(ByteBuf buffer, GraphBinaryReader context) {
        byte[] bytes = new byte[buffer.readInt()];
        buffer.readBytes(bytes);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    @Override
    protected void writeValue(String value, ByteBuf buffer, GraphBinaryWriter context) {
        byte[] stringBytes = value.getBytes(StandardCharsets.UTF_8);
        buffer.writeInt(stringBytes.length).writeBytes(stringBytes);
    }
}

